import { type Firmware, RFRegion } from "@zwave-js/core";
import { ObjectKeyMap } from "@zwave-js/shared";
import type { FirmwareUpdateDeviceID, FirmwareUpdateFileInfo, FirmwareUpdateInfo } from "./_Types.js";
export interface GetAvailableFirmwareUpdateOptions {
    userAgent: string;
    apiKey?: string;
}
export interface GetAvailableFirmwareUpdateBulkOptions extends GetAvailableFirmwareUpdateOptions {
    rfRegion?: RFRegion;
}
/**
 * Retrieves the available firmware updates for multiple devices in a single request.
 * Returns a map of device keys to their respective firmware update information.
 * Devices missing from the returned map are not known to the firmware update service.
 */
export declare function getAvailableFirmwareUpdatesBulk(deviceIds: FirmwareUpdateDeviceID[], options: GetAvailableFirmwareUpdateBulkOptions): Promise<ObjectKeyMap<FirmwareUpdateDeviceID, FirmwareUpdateInfo[]>>;
/**
 * Retrieves the available firmware updates for the node with the given fingerprint.
 * Return an empty array if no updates are available or the device is not known to the firmware update service.
 */
export declare function getAvailableFirmwareUpdates(deviceId: FirmwareUpdateDeviceID, options: GetAvailableFirmwareUpdateOptions): Promise<FirmwareUpdateInfo[]>;
export declare function downloadFirmwareUpdate(file: FirmwareUpdateFileInfo): Promise<Firmware>;
//# sourceMappingURL=FirmwareUpdateService.d.ts.map