"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var MockControllerBehaviors_exports = {};
__export(MockControllerBehaviors_exports, {
  createDefaultBehaviors: () => createDefaultBehaviors
});
module.exports = __toCommonJS(MockControllerBehaviors_exports);
var import_cc = require("@zwave-js/cc");
var import_ZWaveProtocolCC = require("@zwave-js/cc/ZWaveProtocolCC");
var import_core = require("@zwave-js/core");
var import_serialapi = require("@zwave-js/serial/serialapi");
var import_testing = require("@zwave-js/testing");
var import_async = require("alcalzone-shared/async");
var import_Testing = require("../../Testing.js");
var import_MockControllerState = require("./MockControllerState.js");
var import_NodeInformationFrame = require("./NodeInformationFrame.js");
function createLazySendDataPayload(controller, node, msg) {
  return async () => {
    try {
      const cmd = await import_cc.CommandClass.parse(msg.serializedCC, {
        sourceNodeId: controller.ownNodeId,
        __internalIsMockNode: true,
        ...node.encodingContext,
        ...node.securityManagers,
        // The frame type is always singlecast because the controller sends it to the node
        frameType: "singlecast"
      });
      msg.command = cmd;
      return cmd;
    } catch (e) {
      if ((0, import_core.isZWaveError)(e)) {
        if (e.code === import_core.ZWaveErrorCodes.CC_NotImplemented) {
          try {
            const cmd = new import_cc.CommandClass({
              nodeId: controller.ownNodeId,
              ccId: msg.payload[0],
              ccCommand: msg.payload[1],
              payload: msg.payload.subarray(2)
            });
            msg.command = cmd;
            return cmd;
          } catch (e2) {
            console.error(e2.message);
            throw e2;
          }
        } else if (e.code === import_core.ZWaveErrorCodes.Deserialization_NotImplemented) {
          console.error(e.message);
          throw e;
        }
      }
      console.error(e);
      throw e;
    }
  };
}
__name(createLazySendDataPayload, "createLazySendDataPayload");
const respondToGetControllerId = {
  async onHostMessage(controller, msg) {
    if (msg instanceof import_serialapi.GetControllerIdRequest) {
      const ret = new import_serialapi.GetControllerIdResponse({
        homeId: controller.homeId,
        ownNodeId: controller.ownNodeId
      });
      await controller.sendMessageToHost(ret);
      return true;
    }
  }
};
const respondToGetSerialApiCapabilities = {
  async onHostMessage(controller, msg) {
    if (msg instanceof import_serialapi.GetSerialApiCapabilitiesRequest) {
      const ret = new import_serialapi.GetSerialApiCapabilitiesResponse({
        ...controller.capabilities
      });
      await controller.sendMessageToHost(ret);
      return true;
    }
  }
};
const respondToGetControllerVersion = {
  async onHostMessage(controller, msg) {
    if (msg instanceof import_serialapi.GetControllerVersionRequest) {
      const ret = new import_serialapi.GetControllerVersionResponse({
        ...controller.capabilities
      });
      await controller.sendMessageToHost(ret);
      return true;
    }
  }
};
const respondToGetControllerCapabilities = {
  async onHostMessage(controller, msg) {
    if (msg instanceof import_serialapi.GetControllerCapabilitiesRequest) {
      const ret = new import_serialapi.GetControllerCapabilitiesResponse({
        ...controller.capabilities
      });
      await controller.sendMessageToHost(ret);
      return true;
    }
  }
};
const respondToGetSUCNodeId = {
  async onHostMessage(controller, msg) {
    if (msg instanceof import_serialapi.GetSUCNodeIdRequest) {
      const sucNodeId = controller.capabilities.isStaticUpdateController ? controller.ownNodeId : controller.capabilities.sucNodeId;
      const ret = new import_serialapi.GetSUCNodeIdResponse({
        sucNodeId
      });
      await controller.sendMessageToHost(ret);
      return true;
    }
  }
};
const respondToGetSerialApiInitData = {
  async onHostMessage(controller, msg) {
    if (msg instanceof import_serialapi.GetSerialApiInitDataRequest) {
      const nodeIds = new Set(controller.nodes.keys());
      nodeIds.add(controller.ownNodeId);
      const ret = new import_serialapi.GetSerialApiInitDataResponse({
        zwaveApiVersion: controller.capabilities.zwaveApiVersion,
        isPrimary: !controller.capabilities.isSecondary,
        nodeType: import_core.NodeType.Controller,
        supportsTimers: controller.capabilities.supportsTimers,
        isSIS: controller.capabilities.isSISPresent && controller.capabilities.isStaticUpdateController,
        nodeIds: [...nodeIds],
        zwaveChipType: controller.capabilities.zwaveChipType
      });
      await controller.sendMessageToHost(ret);
      return true;
    }
  }
};
const respondToSoftReset = {
  onHostMessage(controller, msg) {
    if (msg instanceof import_serialapi.SoftResetRequest) {
      const ret = new import_serialapi.SerialAPIStartedRequest({
        wakeUpReason: import_serialapi.SerialAPIWakeUpReason.SoftwareReset,
        watchdogEnabled: controller.capabilities.watchdogEnabled,
        isListening: true,
        ...(0, import_NodeInformationFrame.determineNIF)(),
        supportsLongRange: controller.capabilities.supportsLongRange
      });
      setImmediate(async () => {
        await controller.sendMessageToHost(ret);
      });
      return true;
    }
  }
};
const respondToGetNodeProtocolInfo = {
  async onHostMessage(controller, msg) {
    if (msg instanceof import_serialapi.GetNodeProtocolInfoRequest) {
      if (msg.requestedNodeId === controller.ownNodeId) {
        const ret = new import_serialapi.GetNodeProtocolInfoResponse({
          ...(0, import_NodeInformationFrame.determineNIF)(),
          nodeType: import_core.NodeType.Controller,
          isListening: true,
          isFrequentListening: false,
          isRouting: true,
          supportsSecurity: false,
          supportsBeaming: true,
          supportedDataRates: [9600, 4e4, 1e5],
          optionalFunctionality: true,
          protocolVersion: 3
        });
        await controller.sendMessageToHost(ret);
        return true;
      } else if (controller.nodes.has(msg.requestedNodeId)) {
        const nodeCaps = controller.nodes.get(msg.requestedNodeId).capabilities;
        const ret = new import_serialapi.GetNodeProtocolInfoResponse({
          ...nodeCaps
        });
        await controller.sendMessageToHost(ret);
        return true;
      }
    }
  }
};
const handleSendData = {
  async onHostMessage(controller, msg) {
    if (msg instanceof import_serialapi.SendDataRequest) {
      const state = controller.state.get(import_MockControllerState.MockControllerStateKeys.CommunicationState);
      if (state != void 0 && state !== import_MockControllerState.MockControllerCommunicationState.Idle) {
        throw new Error("Received SendDataRequest while not idle");
      }
      controller.state.set(import_MockControllerState.MockControllerStateKeys.CommunicationState, import_MockControllerState.MockControllerCommunicationState.Sending);
      const res = new import_serialapi.SendDataResponse({
        wasSent: true
      });
      await controller.sendMessageToHost(res);
      const node = controller.nodes.get(msg.getNodeId());
      const lazyPayload = createLazySendDataPayload(controller, node, msg);
      const ackRequested = !!(msg.transmitOptions & import_core.TransmitOptions.ACK);
      const lazyFrame = (0, import_testing.createMockZWaveRequestFrame)(lazyPayload, {
        ackRequested
      });
      const ackPromise = controller.sendToNode(node, lazyFrame);
      if (msg.callbackId !== 0) {
        controller.state.set(import_MockControllerState.MockControllerStateKeys.CommunicationState, import_MockControllerState.MockControllerCommunicationState.WaitingForNode);
        let ack = true;
        if (ackRequested) {
          try {
            const ackResult = await ackPromise;
            ack = !!ackResult?.ack;
          } catch (e) {
            if ((0, import_core.isZWaveError)(e) && e.code === import_core.ZWaveErrorCodes.Deserialization_NotImplemented) {
              console.error(e.message);
              throw e;
            }
            ack = false;
          }
        }
        controller.state.set(import_MockControllerState.MockControllerStateKeys.CommunicationState, import_MockControllerState.MockControllerCommunicationState.Idle);
        const cb = new import_serialapi.SendDataRequestTransmitReport({
          callbackId: msg.callbackId,
          transmitStatus: ack ? import_core.TransmitStatus.OK : import_core.TransmitStatus.NoAck
        });
        await controller.sendMessageToHost(cb);
      } else {
        controller.state.set(import_MockControllerState.MockControllerStateKeys.CommunicationState, import_MockControllerState.MockControllerCommunicationState.Idle);
      }
      return true;
    }
  }
};
const handleSendDataMulticast = {
  async onHostMessage(controller, msg) {
    if (msg instanceof import_serialapi.SendDataMulticastRequest) {
      const state = controller.state.get(import_MockControllerState.MockControllerStateKeys.CommunicationState);
      if (state != void 0 && state !== import_MockControllerState.MockControllerCommunicationState.Idle) {
        throw new Error("Received SendDataMulticastRequest while not idle");
      }
      controller.state.set(import_MockControllerState.MockControllerStateKeys.CommunicationState, import_MockControllerState.MockControllerCommunicationState.Sending);
      const res = new import_serialapi.SendDataMulticastResponse({
        wasSent: true
      });
      await controller.sendMessageToHost(res);
      const nodeIds = msg.nodeIds;
      const ackRequested = !!(msg.transmitOptions & import_core.TransmitOptions.ACK);
      const ackPromises = nodeIds.map((nodeId) => {
        const node = controller.nodes.get(nodeId);
        const lazyPayload = createLazySendDataPayload(controller, node, msg);
        const lazyFrame = (0, import_testing.createMockZWaveRequestFrame)(lazyPayload, {
          ackRequested
        });
        const ackPromise = controller.sendToNode(node, lazyFrame);
        return ackPromise;
      });
      if (msg.callbackId !== 0) {
        controller.state.set(import_MockControllerState.MockControllerStateKeys.CommunicationState, import_MockControllerState.MockControllerCommunicationState.WaitingForNode);
        let ack = true;
        if (ackRequested) {
          try {
            const ackResults = await Promise.all(ackPromises);
            ack = ackResults.every((result) => !!result?.ack);
          } catch (e) {
            if ((0, import_core.isZWaveError)(e) && e.code === import_core.ZWaveErrorCodes.Deserialization_NotImplemented) {
              console.error(e.message);
              throw e;
            }
            ack = false;
          }
        }
        controller.state.set(import_MockControllerState.MockControllerStateKeys.CommunicationState, import_MockControllerState.MockControllerCommunicationState.Idle);
        const cb = new import_serialapi.SendDataMulticastRequestTransmitReport({
          callbackId: msg.callbackId,
          transmitStatus: ack ? import_core.TransmitStatus.OK : import_core.TransmitStatus.NoAck
        });
        await controller.sendMessageToHost(cb);
      } else {
        controller.state.set(import_MockControllerState.MockControllerStateKeys.CommunicationState, import_MockControllerState.MockControllerCommunicationState.Idle);
      }
      return true;
    }
  }
};
const handleSendDataBridge = {
  async onHostMessage(controller, msg) {
    if (msg instanceof import_serialapi.SendDataBridgeRequest) {
      const state = controller.state.get(import_MockControllerState.MockControllerStateKeys.CommunicationState);
      if (state != void 0 && state !== import_MockControllerState.MockControllerCommunicationState.Idle) {
        throw new Error("Received SendDataBridgeRequest while not idle");
      }
      controller.state.set(import_MockControllerState.MockControllerStateKeys.CommunicationState, import_MockControllerState.MockControllerCommunicationState.Sending);
      const res = new import_serialapi.SendDataBridgeResponse({
        wasSent: true
      });
      await controller.sendMessageToHost(res);
      const node = controller.nodes.get(msg.getNodeId());
      const lazyPayload = createLazySendDataPayload(controller, node, msg);
      const ackRequested = !!(msg.transmitOptions & import_core.TransmitOptions.ACK);
      const lazyFrame = (0, import_testing.createMockZWaveRequestFrame)(lazyPayload, {
        ackRequested
      });
      const ackPromise = controller.sendToNode(node, lazyFrame);
      if (msg.callbackId !== 0) {
        controller.state.set(import_MockControllerState.MockControllerStateKeys.CommunicationState, import_MockControllerState.MockControllerCommunicationState.WaitingForNode);
        let ack = true;
        if (ackRequested) {
          try {
            const ackResult = await ackPromise;
            ack = !!ackResult?.ack;
          } catch (e) {
            if ((0, import_core.isZWaveError)(e) && e.code === import_core.ZWaveErrorCodes.Deserialization_NotImplemented) {
              console.error(e.message);
              throw e;
            }
            ack = false;
          }
        }
        controller.state.set(import_MockControllerState.MockControllerStateKeys.CommunicationState, import_MockControllerState.MockControllerCommunicationState.Idle);
        const cb = new import_serialapi.SendDataBridgeRequestTransmitReport({
          callbackId: msg.callbackId,
          transmitStatus: ack ? import_core.TransmitStatus.OK : import_core.TransmitStatus.NoAck
        });
        await controller.sendMessageToHost(cb);
      } else {
        controller.state.set(import_MockControllerState.MockControllerStateKeys.CommunicationState, import_MockControllerState.MockControllerCommunicationState.Idle);
      }
      return true;
    }
  }
};
const handleSendDataMulticastBridge = {
  async onHostMessage(controller, msg) {
    if (msg instanceof import_serialapi.SendDataMulticastBridgeRequest) {
      const state = controller.state.get(import_MockControllerState.MockControllerStateKeys.CommunicationState);
      if (state != void 0 && state !== import_MockControllerState.MockControllerCommunicationState.Idle) {
        throw new Error("Received SendDataMulticastBridgeRequest while not idle");
      }
      controller.state.set(import_MockControllerState.MockControllerStateKeys.CommunicationState, import_MockControllerState.MockControllerCommunicationState.Sending);
      const res = new import_serialapi.SendDataMulticastBridgeResponse({
        wasSent: true
      });
      await controller.sendMessageToHost(res);
      const nodeIds = msg.nodeIds;
      const ackRequested = !!(msg.transmitOptions & import_core.TransmitOptions.ACK);
      const ackPromises = nodeIds.map((nodeId) => {
        const node = controller.nodes.get(nodeId);
        const lazyPayload = createLazySendDataPayload(controller, node, msg);
        const lazyFrame = (0, import_testing.createMockZWaveRequestFrame)(lazyPayload, {
          ackRequested
        });
        const ackPromise = controller.sendToNode(node, lazyFrame);
        return ackPromise;
      });
      if (msg.callbackId !== 0) {
        controller.state.set(import_MockControllerState.MockControllerStateKeys.CommunicationState, import_MockControllerState.MockControllerCommunicationState.WaitingForNode);
        let ack = true;
        if (ackRequested) {
          try {
            const ackResults = await Promise.all(ackPromises);
            ack = ackResults.every((result) => !!result?.ack);
          } catch (e) {
            if ((0, import_core.isZWaveError)(e) && e.code === import_core.ZWaveErrorCodes.Deserialization_NotImplemented) {
              console.error(e.message);
              throw e;
            }
            ack = false;
          }
        }
        controller.state.set(import_MockControllerState.MockControllerStateKeys.CommunicationState, import_MockControllerState.MockControllerCommunicationState.Idle);
        const cb = new import_serialapi.SendDataMulticastBridgeRequestTransmitReport({
          callbackId: msg.callbackId,
          transmitStatus: ack ? import_core.TransmitStatus.OK : import_core.TransmitStatus.NoAck
        });
        await controller.sendMessageToHost(cb);
      } else {
        controller.state.set(import_MockControllerState.MockControllerStateKeys.CommunicationState, import_MockControllerState.MockControllerCommunicationState.Idle);
      }
      return true;
    }
  }
};
const handleRequestNodeInfo = {
  async onHostMessage(controller, msg) {
    if (msg instanceof import_serialapi.RequestNodeInfoRequest) {
      const state = controller.state.get(import_MockControllerState.MockControllerStateKeys.CommunicationState);
      if (state != void 0 && state !== import_MockControllerState.MockControllerCommunicationState.Idle) {
        throw new Error("Received RequestNodeInfoRequest while not idle");
      }
      controller.state.set(import_MockControllerState.MockControllerStateKeys.CommunicationState, import_MockControllerState.MockControllerCommunicationState.Sending);
      const node = controller.nodes.get(msg.getNodeId());
      const command = new import_ZWaveProtocolCC.ZWaveProtocolCCRequestNodeInformationFrame({
        nodeId: controller.ownNodeId
      });
      const frame = (0, import_testing.createMockZWaveRequestFrame)(command, {
        ackRequested: false
      });
      void controller.sendToNode(node, frame);
      const nodeInfoPromise = controller.expectNodeCC(node, (cc) => cc instanceof import_ZWaveProtocolCC.ZWaveProtocolCCNodeInformationFrame, {
        timeout: import_testing.MOCK_FRAME_ACK_TIMEOUT,
        // Prevent forwarding the NIF to the host. Otherwise it will mess with
        // the state tracking in the MockController.
        preventDefault: true
      });
      const res = new import_serialapi.RequestNodeInfoResponse({
        wasSent: true
      });
      await controller.sendMessageToHost(res);
      controller.state.set(import_MockControllerState.MockControllerStateKeys.CommunicationState, import_MockControllerState.MockControllerCommunicationState.WaitingForNode);
      let cb;
      try {
        const nodeInfo = await nodeInfoPromise;
        cb = new import_serialapi.ApplicationUpdateRequestNodeInfoReceived({
          nodeInformation: {
            ...nodeInfo,
            nodeId: nodeInfo.nodeId
          }
        });
      } catch {
        cb = new import_serialapi.ApplicationUpdateRequestNodeInfoRequestFailed();
      }
      controller.state.set(import_MockControllerState.MockControllerStateKeys.CommunicationState, import_MockControllerState.MockControllerCommunicationState.Idle);
      await controller.sendMessageToHost(cb);
      return true;
    }
  }
};
async function transmitSUCReturnRoute(controller, node, callbackId, options) {
  const expectCallback = callbackId !== 0;
  const command = new import_ZWaveProtocolCC.ZWaveProtocolCCAssignSUCReturnRoute({
    nodeId: node.id,
    destinationNodeId: controller.ownNodeId,
    routeIndex: 0,
    // don't care
    ...options
  });
  const frame = (0, import_testing.createMockZWaveRequestFrame)(command, {
    ackRequested: expectCallback
  });
  const ackPromise = controller.sendToNode(node, frame);
  let ack = false;
  if (expectCallback) {
    controller.state.set(import_MockControllerState.MockControllerStateKeys.CommunicationState, import_MockControllerState.MockControllerCommunicationState.WaitingForNode);
    try {
      const ackResult = await ackPromise;
      ack = !!ackResult?.ack;
    } catch {
    }
  }
  controller.state.set(import_MockControllerState.MockControllerStateKeys.CommunicationState, import_MockControllerState.MockControllerCommunicationState.Idle);
  return ack;
}
__name(transmitSUCReturnRoute, "transmitSUCReturnRoute");
const handleDeleteSUCReturnRoute = {
  async onHostMessage(controller, msg) {
    if (msg instanceof import_serialapi.DeleteSUCReturnRouteRequest) {
      const state = controller.state.get(import_MockControllerState.MockControllerStateKeys.CommunicationState);
      if (state != void 0 && state !== import_MockControllerState.MockControllerCommunicationState.Idle) {
        throw new Error("Received DeleteSUCReturnRouteRequest while not idle");
      }
      controller.state.set(import_MockControllerState.MockControllerStateKeys.CommunicationState, import_MockControllerState.MockControllerCommunicationState.Sending);
      const expectCallback = msg.callbackId !== 0;
      const node = controller.nodes.get(msg.getNodeId());
      const response = new import_serialapi.DeleteSUCReturnRouteResponse({
        wasExecuted: true
      });
      await controller.sendMessageToHost(response);
      const ack = await transmitSUCReturnRoute(
        controller,
        node,
        msg.callbackId ?? 0,
        // Set the empty route
        {
          destinationSpeed: import_core.ZWaveDataRate["9k6"],
          destinationWakeUp: import_cc.WakeUpTime.None,
          repeaters: []
        }
      );
      if (expectCallback) {
        const transmitReport = new import_serialapi.DeleteSUCReturnRouteRequestTransmitReport({
          callbackId: msg.callbackId,
          transmitStatus: ack ? import_core.TransmitStatus.OK : import_core.TransmitStatus.NoAck
        });
        await controller.sendMessageToHost(transmitReport);
      }
      return true;
    }
  }
};
const handleAssignSUCReturnRoute = {
  async onHostMessage(controller, msg) {
    if (msg instanceof import_serialapi.AssignSUCReturnRouteRequest) {
      const state = controller.state.get(import_MockControllerState.MockControllerStateKeys.CommunicationState);
      if (state != void 0 && state !== import_MockControllerState.MockControllerCommunicationState.Idle) {
        throw new Error("Received AssignSUCReturnRouteRequest while not idle");
      }
      controller.state.set(import_MockControllerState.MockControllerStateKeys.CommunicationState, import_MockControllerState.MockControllerCommunicationState.Sending);
      const expectCallback = msg.callbackId !== 0;
      const node = controller.nodes.get(msg.getNodeId());
      const res = new import_serialapi.AssignSUCReturnRouteResponse({
        wasExecuted: true
      });
      await controller.sendMessageToHost(res);
      const ack = await transmitSUCReturnRoute(
        controller,
        node,
        msg.callbackId ?? 0,
        // Don't care about the actual settings here
        {
          destinationSpeed: import_core.ZWaveDataRate["100k"],
          destinationWakeUp: import_cc.WakeUpTime.None,
          repeaters: []
        }
      );
      if (expectCallback) {
        const cb = new import_serialapi.AssignSUCReturnRouteRequestTransmitReport({
          callbackId: msg.callbackId,
          transmitStatus: ack ? import_core.TransmitStatus.OK : import_core.TransmitStatus.NoAck
        });
        await controller.sendMessageToHost(cb);
      }
      return true;
    }
  }
};
const handleAddNode = {
  async onHostMessage(controller, msg) {
    if (msg instanceof import_serialapi.AddNodeToNetworkRequest) {
      const state = controller.state.get(import_MockControllerState.MockControllerStateKeys.InclusionState);
      const expectCallback = msg.callbackId !== 0;
      let cb;
      if (state === import_MockControllerState.MockControllerInclusionState.AddingNode) {
        if (msg.addNodeType === import_serialapi.AddNodeType.Stop) {
          controller.state.set(import_MockControllerState.MockControllerStateKeys.InclusionState, import_MockControllerState.MockControllerInclusionState.Idle);
          const pendingNode = controller.nodePendingInclusion;
          if (pendingNode) {
            cb = new import_serialapi.AddNodeToNetworkRequestStatusReport({
              callbackId: msg.callbackId,
              status: import_serialapi.AddNodeStatus.Done,
              nodeId: pendingNode.id
            });
            controller.nodePendingInclusion = void 0;
          } else {
            cb = new import_serialapi.AddNodeToNetworkRequestStatusReport({
              callbackId: msg.callbackId,
              status: import_serialapi.AddNodeStatus.Failed
            });
          }
        } else {
          cb = new import_serialapi.AddNodeToNetworkRequestStatusReport({
            callbackId: msg.callbackId,
            status: import_serialapi.AddNodeStatus.Failed
          });
        }
      } else if (state === import_MockControllerState.MockControllerInclusionState.RemovingNode) {
        cb = new import_serialapi.AddNodeToNetworkRequestStatusReport({
          callbackId: msg.callbackId,
          status: import_serialapi.AddNodeStatus.Failed
        });
      } else {
        controller.state.set(import_MockControllerState.MockControllerStateKeys.InclusionState, import_MockControllerState.MockControllerInclusionState.AddingNode);
        cb = new import_serialapi.AddNodeToNetworkRequestStatusReport({
          callbackId: msg.callbackId,
          status: import_serialapi.AddNodeStatus.Ready
        });
        if (controller.nodePendingInclusion) {
          const { setup: testSpecificSetup, ...nodeOptions } = controller.nodePendingInclusion;
          const node = await import_testing.MockNode.create({
            controller,
            ...nodeOptions
          });
          node.defineBehavior(...(0, import_Testing.createDefaultMockNodeBehaviors)());
          testSpecificSetup?.(node);
          const supportedCCs = [...node.implementedCCs].filter(([, info]) => info.isSupported && info.version > 0).map(([cc]) => cc);
          const nodeInfo = {
            nodeId: node.id,
            basicDeviceClass: node.capabilities.basicDeviceClass,
            genericDeviceClass: node.capabilities.genericDeviceClass,
            specificDeviceClass: node.capabilities.specificDeviceClass,
            supportedCCs
          };
          void (async () => {
            await (0, import_async.wait)(10);
            const nodeFoundMsg = new import_serialapi.AddNodeToNetworkRequestStatusReport({
              callbackId: msg.callbackId,
              status: import_serialapi.AddNodeStatus.NodeFound
            });
            await controller.sendMessageToHost(nodeFoundMsg);
            await (0, import_async.wait)(10);
            const addingSlaveMsg = new import_serialapi.AddNodeToNetworkRequestStatusReport({
              callbackId: msg.callbackId,
              status: import_serialapi.AddNodeStatus.AddingSlave,
              nodeInfo
            });
            await controller.sendMessageToHost(addingSlaveMsg);
            await (0, import_async.wait)(10);
            controller.addNode(node);
            const protocolDoneMsg = new import_serialapi.AddNodeToNetworkRequestStatusReport({
              callbackId: msg.callbackId,
              status: import_serialapi.AddNodeStatus.ProtocolDone
            });
            await controller.sendMessageToHost(protocolDoneMsg);
          })();
        }
      }
      if (expectCallback && cb) {
        await controller.sendMessageToHost(cb);
      }
      return true;
    }
  }
};
const handleRemoveNode = {
  async onHostMessage(controller, msg) {
    if (msg instanceof import_serialapi.RemoveNodeFromNetworkRequest) {
      const state = controller.state.get(import_MockControllerState.MockControllerStateKeys.InclusionState);
      const expectCallback = msg.callbackId !== 0;
      let cb;
      if (state === import_MockControllerState.MockControllerInclusionState.RemovingNode) {
        if (msg.removeNodeType === import_serialapi.RemoveNodeType.Stop) {
          controller.state.set(import_MockControllerState.MockControllerStateKeys.InclusionState, import_MockControllerState.MockControllerInclusionState.Idle);
          cb = new import_serialapi.RemoveNodeFromNetworkRequestStatusReport({
            callbackId: msg.callbackId,
            status: import_serialapi.RemoveNodeStatus.Failed
          });
        } else {
          cb = new import_serialapi.RemoveNodeFromNetworkRequestStatusReport({
            callbackId: msg.callbackId,
            status: import_serialapi.RemoveNodeStatus.Failed
          });
        }
      } else if (state === import_MockControllerState.MockControllerInclusionState.AddingNode) {
        cb = new import_serialapi.RemoveNodeFromNetworkRequestStatusReport({
          callbackId: msg.callbackId,
          status: import_serialapi.RemoveNodeStatus.Failed
        });
      } else {
        controller.state.set(import_MockControllerState.MockControllerStateKeys.InclusionState, import_MockControllerState.MockControllerInclusionState.RemovingNode);
        cb = new import_serialapi.RemoveNodeFromNetworkRequestStatusReport({
          callbackId: msg.callbackId,
          status: import_serialapi.RemoveNodeStatus.Ready
        });
      }
      if (expectCallback && cb) {
        await controller.sendMessageToHost(cb);
      }
      return true;
    }
  }
};
const forwardCommandClassesToHost = {
  async onNodeFrame(controller, node, frame) {
    if (frame.type === import_testing.MockZWaveFrameType.Request && frame.payload instanceof import_cc.CommandClass && !(frame.payload instanceof import_ZWaveProtocolCC.ZWaveProtocolCC)) {
      const msg = new import_serialapi.ApplicationCommandRequest({
        command: frame.payload
      });
      msg.getNodeId = () => node.id;
      await controller.sendMessageToHost(msg, node);
      return true;
    }
  }
};
const forwardUnsolicitedNIF = {
  async onNodeFrame(controller, node, frame) {
    if (frame.type === import_testing.MockZWaveFrameType.Request && frame.payload instanceof import_ZWaveProtocolCC.ZWaveProtocolCCNodeInformationFrame) {
      const updateRequest = new import_serialapi.ApplicationUpdateRequestNodeInfoReceived({
        nodeInformation: {
          ...frame.payload,
          nodeId: frame.payload.nodeId
        }
      });
      await controller.sendMessageToHost(updateRequest, node);
      return true;
    }
  }
};
function createDefaultBehaviors() {
  return [
    respondToGetControllerId,
    respondToGetSerialApiCapabilities,
    respondToGetControllerVersion,
    respondToGetControllerCapabilities,
    respondToGetSUCNodeId,
    respondToGetSerialApiInitData,
    respondToSoftReset,
    respondToGetNodeProtocolInfo,
    handleSendData,
    handleSendDataMulticast,
    handleSendDataBridge,
    handleSendDataMulticastBridge,
    handleRequestNodeInfo,
    handleDeleteSUCReturnRoute,
    handleAssignSUCReturnRoute,
    handleAddNode,
    handleRemoveNode,
    forwardCommandClassesToHost,
    forwardUnsolicitedNIF
  ];
}
__name(createDefaultBehaviors, "createDefaultBehaviors");
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  createDefaultBehaviors
});
//# sourceMappingURL=MockControllerBehaviors.js.map
