"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to2, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to2, key) && key !== except)
        __defProp(to2, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to2;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var ProxyInclusionMachine_exports = {};
__export(ProxyInclusionMachine_exports, {
  createProxyInclusionMachine: () => createProxyInclusionMachine
});
module.exports = __toCommonJS(ProxyInclusionMachine_exports);
var import_core = require("@zwave-js/core");
function to(state) {
  return { newState: state };
}
__name(to, "to");
function createProxyInclusionMachine() {
  const initialState = {
    value: "initial"
  };
  const transitions = /* @__PURE__ */ __name((state) => (input) => {
    switch (state.value) {
      case "initial": {
        switch (input.value) {
          case "NIF": {
            return to({
              value: "hasNIF",
              nodeInfo: input.nodeInfo,
              newNode: input.newNode
            });
          }
          case "INITIATE": {
            return to({
              value: "hasInitiate",
              inclusionControllerNodeId: input.inclusionControllerNodeId,
              step: input.step,
              includedNodeId: input.includedNodeId
            });
          }
        }
        break;
      }
      case "hasNIF": {
        switch (input.value) {
          case "INITIATE": {
            if (input.includedNodeId === state.newNode.id) {
              return to({
                value: "bootstrapping",
                inclusionControllerNodeId: input.inclusionControllerNodeId,
                includedNodeId: input.includedNodeId,
                nodeInfo: state.nodeInfo,
                newNode: state.newNode,
                step: input.step,
                done: true
              });
            }
            break;
          }
          case "INITIATE_TIMEOUT": {
            return to({
              value: "interview",
              newNode: state.newNode,
              done: true
            });
          }
        }
        break;
      }
      case "hasInitiate": {
        switch (input.value) {
          case "NIF": {
            if (input.newNode.id === state.includedNodeId) {
              return to({
                value: "bootstrapping",
                inclusionControllerNodeId: state.inclusionControllerNodeId,
                includedNodeId: state.includedNodeId,
                step: state.step,
                nodeInfo: input.nodeInfo,
                newNode: input.newNode,
                done: true
              });
            }
            break;
          }
          case "NIF_TIMEOUT": {
            return to({
              value: "bootstrapping",
              inclusionControllerNodeId: state.inclusionControllerNodeId,
              includedNodeId: state.includedNodeId,
              step: state.step,
              done: true
            });
          }
        }
      }
    }
  }, "transitions");
  return new import_core.StateMachine(initialState, transitions);
}
__name(createProxyInclusionMachine, "createProxyInclusionMachine");
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  createProxyInclusionMachine
});
//# sourceMappingURL=ProxyInclusionMachine.js.map
