"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var Driver_exports = {};
__export(Driver_exports, {
  Driver: () => Driver,
  libName: () => libName,
  libVersion: () => libVersion
});
module.exports = __toCommonJS(Driver_exports);
var import_cc = require("@zwave-js/cc");
var import_config = require("@zwave-js/config");
var import_core = require("@zwave-js/core");
var import_serial = require("@zwave-js/serial");
var import_serialapi = require("@zwave-js/serial/serialapi");
var import_shared = require("@zwave-js/shared");
var import_arrays = require("alcalzone-shared/arrays");
var import_async = require("alcalzone-shared/async");
var import_deferred_promise = require("alcalzone-shared/deferred-promise");
var import_math = require("alcalzone-shared/math");
var import_typeguards = require("alcalzone-shared/typeguards");
var import_pathe = __toESM(require("pathe"), 1);
var import_version = require("../_version.js");
var import_Controller = require("../controller/Controller.js");
var import_FirmwareUpdateService = require("../controller/FirmwareUpdateService.js");
var import_Inclusion = require("../controller/Inclusion.js");
var import_NodeInformationFrame = require("../controller/NodeInformationFrame.js");
var import_Types = require("../controller/_Types.js");
var import_Driver = require("../log/Driver.js");
var import_Types2 = require("../node/_Types.js");
var import_deviceConfig = require("../telemetry/deviceConfig.js");
var import_statistics = require("../telemetry/statistics.js");
var import_Bootloader = require("./Bootloader.js");
var import_DriverMode = require("./DriverMode.js");
var import_EndDeviceCLI = require("./EndDeviceCLI.js");
var import_MessageGenerators = require("./MessageGenerators.js");
var import_NetworkCache = require("./NetworkCache.js");
var import_Queue = require("./Queue.js");
var import_SerialAPICommandMachine = require("./SerialAPICommandMachine.js");
var import_StateMachineShared = require("./StateMachineShared.js");
var import_Task = require("./Task.js");
var import_ThrottlePresets = require("./ThrottlePresets.js");
var import_Transaction = require("./Transaction.js");
var import_TransportServiceMachine = require("./TransportServiceMachine.js");
var import_UpdateConfig = require("./UpdateConfig.js");
var import_UserAgent = require("./UserAgent.js");
var import_Types3 = require("./_Types.js");
var import_mDNSDiscovery = require("./mDNSDiscovery.js");
(0, import_cc.registerCCs)();
const libVersion = import_version.PACKAGE_VERSION;
const libName = import_version.PACKAGE_NAME;
const libNameString = `
\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2557        \u2588\u2588\u2557    \u2588\u2588\u2557  \u2588\u2588\u2588\u2588\u2588\u2557  \u2588\u2588\u2557   \u2588\u2588\u2557 \u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2557          \u2588\u2588\u2557 \u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2557
\u255A\u2550\u2550\u2588\u2588\u2588\u2554\u255D        \u2588\u2588\u2551    \u2588\u2588\u2551 \u2588\u2588\u2554\u2550\u2550\u2588\u2588\u2557 \u2588\u2588\u2551   \u2588\u2588\u2551 \u2588\u2588\u2554\u2550\u2550\u2550\u2550\u255D          \u2588\u2588\u2551 \u2588\u2588\u2554\u2550\u2550\u2550\u2550\u255D
  \u2588\u2588\u2588\u2554\u255D  \u2588\u2588\u2588\u2588\u2588\u2557 \u2588\u2588\u2551 \u2588\u2557 \u2588\u2588\u2551 \u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2551 \u2588\u2588\u2551   \u2588\u2588\u2551 \u2588\u2588\u2588\u2588\u2588\u2557            \u2588\u2588\u2551 \u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2557
 \u2588\u2588\u2588\u2554\u255D   \u255A\u2550\u2550\u2550\u2550\u255D \u2588\u2588\u2551\u2588\u2588\u2588\u2557\u2588\u2588\u2551 \u2588\u2588\u2554\u2550\u2550\u2588\u2588\u2551 \u255A\u2588\u2588\u2557 \u2588\u2588\u2554\u255D \u2588\u2588\u2554\u2550\u2550\u255D       \u2588\u2588   \u2588\u2588\u2551 \u255A\u2550\u2550\u2550\u2550\u2588\u2588\u2551
\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2557        \u255A\u2588\u2588\u2588\u2554\u2588\u2588\u2588\u2554\u255D \u2588\u2588\u2551  \u2588\u2588\u2551  \u255A\u2588\u2588\u2588\u2588\u2554\u255D  \u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2557     \u255A\u2588\u2588\u2588\u2588\u2588\u2554\u255D \u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2551
\u255A\u2550\u2550\u2550\u2550\u2550\u2550\u255D         \u255A\u2550\u2550\u255D\u255A\u2550\u2550\u255D  \u255A\u2550\u255D  \u255A\u2550\u255D   \u255A\u2550\u2550\u2550\u255D   \u255A\u2550\u2550\u2550\u2550\u2550\u2550\u255D      \u255A\u2550\u2550\u2550\u2550\u255D  \u255A\u2550\u2550\u2550\u2550\u2550\u2550\u255D
`;
const defaultOptions = {
  timeouts: {
    ack: 1600,
    // A sending interface MUST wait for 1600ms or more for an ACK Frame after transmitting a Data Frame.
    byte: 150,
    // Ideally we'd want to have this as low as possible, but some
    // 500 series controllers can take several seconds to respond sometimes.
    response: 1e4,
    report: 1e3,
    // ReportTime timeout SHOULD be set to CommandTime + 1 second
    nonce: 5e3,
    sendDataAbort: 2e4,
    // If a controller takes over 20 seconds to reach a node, it's probably not going to happen
    sendDataCallback: 3e4,
    // INS13954 defines this to be 65000 ms, but waiting that long causes issues with reporting devices
    sendToSleep: 250,
    // The default should be enough time for applications to react to devices waking up
    retryJammed: 1e3,
    refreshValue: 5e3,
    // Default should handle most slow devices until we have a better solution
    refreshValueAfterTransition: 1e3,
    // To account for delays in the device
    serialAPIStarted: 5e3
  },
  attempts: {
    openSerialPort: 10,
    controller: 3,
    sendData: 3,
    sendDataJammed: 5,
    nodeInterview: 5,
    smartStartInclusion: 5,
    firmwareUpdateOTW: 3
  },
  disableOptimisticValueUpdate: false,
  features: {
    // By default enable soft reset unless the env variable is set
    softReset: !(0, import_shared.getenv)("ZWAVEJS_DISABLE_SOFT_RESET"),
    // By default enable the unresponsive controller recovery unless the env variable is set
    unresponsiveControllerRecovery: !(0, import_shared.getenv)("ZWAVEJS_DISABLE_UNRESPONSIVE_CONTROLLER_RECOVERY"),
    // By default disable the watchdog
    watchdog: false,
    // Support all CCs unless specified otherwise
    disableCommandClasses: []
  },
  // By default, try to recover from bootloader mode
  bootloaderMode: "recover",
  interview: {
    queryAllUserCodes: false,
    applyRecommendedConfigParamValues: false
  },
  storage: {
    cacheDir: typeof process !== "undefined" ? import_pathe.default.join(process.cwd(), "cache") : "/cache",
    lockDir: (0, import_shared.getenv)("ZWAVEJS_LOCK_DIRECTORY"),
    throttle: "normal"
  },
  preferences: {
    scales: {}
  }
};
function checkOptions(options) {
  if (options.timeouts.ack < 1) {
    throw new import_core.ZWaveError(`The ACK timeout must be positive!`, import_core.ZWaveErrorCodes.Driver_InvalidOptions);
  }
  if (options.timeouts.byte < 1) {
    throw new import_core.ZWaveError(`The BYTE timeout must be positive!`, import_core.ZWaveErrorCodes.Driver_InvalidOptions);
  }
  if (options.timeouts.response < 500 || options.timeouts.response > 6e4) {
    throw new import_core.ZWaveError(`The Response timeout must be between 500 and 60000 milliseconds!`, import_core.ZWaveErrorCodes.Driver_InvalidOptions);
  }
  if (options.timeouts.report < 500 || options.timeouts.report > 1e4) {
    throw new import_core.ZWaveError(`The Report timeout must be between 500 and 10000 milliseconds!`, import_core.ZWaveErrorCodes.Driver_InvalidOptions);
  }
  if (options.timeouts.nonce < 3e3 || options.timeouts.nonce > 2e4) {
    throw new import_core.ZWaveError(`The Nonce timeout must be between 3000 and 20000 milliseconds!`, import_core.ZWaveErrorCodes.Driver_InvalidOptions);
  }
  if (options.timeouts.retryJammed < 10 || options.timeouts.retryJammed > 5e3) {
    throw new import_core.ZWaveError(`The timeout for retrying while jammed must be between 10 and 5000 milliseconds!`, import_core.ZWaveErrorCodes.Driver_InvalidOptions);
  }
  if (options.timeouts.sendToSleep < 10 || options.timeouts.sendToSleep > 5e3) {
    throw new import_core.ZWaveError(`The Send To Sleep timeout must be between 10 and 5000 milliseconds!`, import_core.ZWaveErrorCodes.Driver_InvalidOptions);
  }
  if (options.timeouts.sendDataCallback < 1e4) {
    throw new import_core.ZWaveError(`The Send Data Callback timeout must be at least 10000 milliseconds!`, import_core.ZWaveErrorCodes.Driver_InvalidOptions);
  }
  if (options.timeouts.sendDataAbort < 5e3 || options.timeouts.sendDataAbort > options.timeouts.sendDataCallback - 5e3) {
    throw new import_core.ZWaveError(`The Send Data Abort Callback timeout must be between 5000 and ${options.timeouts.sendDataCallback - 5e3} milliseconds!`, import_core.ZWaveErrorCodes.Driver_InvalidOptions);
  }
  if (options.timeouts.serialAPIStarted < 1e3 || options.timeouts.serialAPIStarted > 3e4) {
    throw new import_core.ZWaveError(`The Serial API started timeout must be between 1000 and 30000 milliseconds!`, import_core.ZWaveErrorCodes.Driver_InvalidOptions);
  }
  if (options.securityKeys != void 0) {
    const keys = Object.entries(options.securityKeys);
    for (let i = 0; i < keys.length; i++) {
      const [secClass, key] = keys[i];
      if (key.length !== 16) {
        throw new import_core.ZWaveError(`The security key for class ${secClass} must be a buffer with length 16!`, import_core.ZWaveErrorCodes.Driver_InvalidOptions);
      }
      if (keys.findIndex(([, k]) => (0, import_shared.areUint8ArraysEqual)(k, key)) !== i) {
        throw new import_core.ZWaveError(`The security key for class ${secClass} was used multiple times!`, import_core.ZWaveErrorCodes.Driver_InvalidOptions);
      }
    }
  }
  if (options.attempts.controller < 1 || options.attempts.controller > 3) {
    throw new import_core.ZWaveError(`The Controller attempts must be between 1 and 3!`, import_core.ZWaveErrorCodes.Driver_InvalidOptions);
  }
  if (options.attempts.sendData < 1 || options.attempts.sendData > import_serialapi.MAX_SEND_ATTEMPTS) {
    throw new import_core.ZWaveError(`The SendData attempts must be between 1 and ${import_serialapi.MAX_SEND_ATTEMPTS}!`, import_core.ZWaveErrorCodes.Driver_InvalidOptions);
  }
  if (options.attempts.sendDataJammed < 1 || options.attempts.sendDataJammed > 10) {
    throw new import_core.ZWaveError(`The SendData attempts while jammed must be between 1 and 10!`, import_core.ZWaveErrorCodes.Driver_InvalidOptions);
  }
  if (options.attempts.nodeInterview < 1 || options.attempts.nodeInterview > 10) {
    throw new import_core.ZWaveError(`The Node interview attempts must be between 1 and 10!`, import_core.ZWaveErrorCodes.Driver_InvalidOptions);
  }
  if (options.attempts.smartStartInclusion < 1 || options.attempts.smartStartInclusion > 25) {
    throw new import_core.ZWaveError(`The SmartStart inclusion attempts must be between 1 and 25!`, import_core.ZWaveErrorCodes.Driver_InvalidOptions);
  }
  if (options.attempts.firmwareUpdateOTW < 1 || options.attempts.firmwareUpdateOTW > 5) {
    throw new import_core.ZWaveError(`The OTW firmware update attempts must be between 1 and 5!`, import_core.ZWaveErrorCodes.Driver_InvalidOptions);
  }
  if (options.inclusionUserCallbacks) {
    if (!(0, import_typeguards.isObject)(options.inclusionUserCallbacks)) {
      throw new import_core.ZWaveError(`The inclusionUserCallbacks must be an object!`, import_core.ZWaveErrorCodes.Driver_InvalidOptions);
    } else if (typeof options.inclusionUserCallbacks.grantSecurityClasses !== "function" || typeof options.inclusionUserCallbacks.validateDSKAndEnterPIN !== "function" || typeof options.inclusionUserCallbacks.abort !== "function") {
      throw new import_core.ZWaveError(`The inclusionUserCallbacks must contain the following functions: grantSecurityClasses, validateDSKAndEnterPIN, abort!`, import_core.ZWaveErrorCodes.Driver_InvalidOptions);
    }
  }
  if (options.joinNetworkUserCallbacks) {
    if (!(0, import_typeguards.isObject)(options.joinNetworkUserCallbacks)) {
      throw new import_core.ZWaveError(`The joinNetworkUserCallbacks must be an object!`, import_core.ZWaveErrorCodes.Driver_InvalidOptions);
    } else if (typeof options.joinNetworkUserCallbacks.showDSK !== "function" || typeof options.joinNetworkUserCallbacks.done !== "function") {
      throw new import_core.ZWaveError(`The joinNetworkUserCallbacks must contain the following functions: showDSK, done!`, import_core.ZWaveErrorCodes.Driver_InvalidOptions);
    }
  }
  if (options.rf != void 0) {
    if (options.rf.region != void 0) {
      if (typeof options.rf.region !== "number" || !(options.rf.region in import_core.RFRegion) || options.rf.region === import_core.RFRegion.Unknown) {
        throw new import_core.ZWaveError(`${options.rf.region} is not a valid RF region!`, import_core.ZWaveErrorCodes.Driver_InvalidOptions);
      }
    }
    if (options.rf.txPower != void 0) {
      if (!(0, import_typeguards.isObject)(options.rf.txPower)) {
        throw new import_core.ZWaveError(`rf.txPower must be an object!`, import_core.ZWaveErrorCodes.Driver_InvalidOptions);
      }
      if (typeof options.rf.txPower.powerlevel !== "number" && options.rf.txPower.powerlevel !== "auto") {
        throw new import_core.ZWaveError(`rf.txPower.powerlevel must be a number or "auto"!`, import_core.ZWaveErrorCodes.Driver_InvalidOptions);
      }
      if (options.rf.txPower.measured0dBm != void 0 && typeof options.rf.txPower.measured0dBm !== "number") {
        throw new import_core.ZWaveError(`rf.txPower.measured0dBm must be a number!`, import_core.ZWaveErrorCodes.Driver_InvalidOptions);
      }
    }
    if (options.features.disableCommandClasses?.length) {
      const mandatory = /* @__PURE__ */ new Set([
        // Encapsulation CCs are always supported
        ...import_core.encapsulationCCs,
        // All Root Devices or nodes MUST support
        import_core.CommandClasses.Association,
        import_core.CommandClasses["Association Group Information"],
        import_core.CommandClasses["Device Reset Locally"],
        import_core.CommandClasses["Firmware Update Meta Data"],
        import_core.CommandClasses.Indicator,
        import_core.CommandClasses["Manufacturer Specific"],
        import_core.CommandClasses["Multi Channel Association"],
        import_core.CommandClasses.Powerlevel,
        import_core.CommandClasses.Version,
        import_core.CommandClasses["Z-Wave Plus Info"]
      ]);
      const mandatoryDisabled = options.features.disableCommandClasses.filter((cc) => mandatory.has(cc));
      if (mandatoryDisabled.length > 0) {
        throw new import_core.ZWaveError(`The following CCs are mandatory and cannot be disabled using features.disableCommandClasses: ${mandatoryDisabled.map((cc) => (0, import_core.getCCName)(cc)).join(", ")}!`, import_core.ZWaveErrorCodes.Driver_InvalidOptions);
      }
    }
  }
}
__name(checkOptions, "checkOptions");
function messageIsPing(msg) {
  return (0, import_serialapi.containsCC)(msg) && msg.command instanceof import_cc.NoOperationCC;
}
__name(messageIsPing, "messageIsPing");
function assertValidCCs(container) {
  if (container.command instanceof import_cc.InvalidCC) {
    if (typeof container.command.reason === "number") {
      throw new import_core.ZWaveError("The message payload failed validation!", container.command.reason);
    } else {
      throw new import_core.ZWaveError("The message payload is invalid!", import_core.ZWaveErrorCodes.PacketFormat_InvalidPayload, container.command.reason);
    }
  } else if ((0, import_serialapi.containsCC)(container.command)) {
    assertValidCCs(container.command);
  }
}
__name(assertValidCCs, "assertValidCCs");
function wrapLegacyFSDriverForCacheMigrationOnly(legacy) {
  return {
    async readFile(path2) {
      const text = await legacy.readFile(path2, "utf8");
      return import_shared.Bytes.from(text, "utf8");
    },
    async stat(path2) {
      if (await legacy.pathExists(path2)) {
        return {
          isDirectory() {
            return false;
          },
          isFile() {
            return true;
          },
          mtime: /* @__PURE__ */ new Date(),
          size: 0
        };
      } else {
        throw new Error("File not found");
      }
    },
    readDir(_path) {
      return Promise.reject(new Error("Not implemented for the legacy FS driver"));
    }
  };
}
__name(wrapLegacyFSDriverForCacheMigrationOnly, "wrapLegacyFSDriverForCacheMigrationOnly");
class Driver extends import_shared.TypedEventTarget {
  static {
    __name(this, "Driver");
  }
  port;
  constructor(port, ...optionsAndPresets) {
    super();
    this.port = port;
    if (typeof port !== "string" && !(0, import_serial.isZWaveSerialPortImplementation)(port) && !(0, import_serial.isZWaveSerialBindingFactory)(port)) {
      throw new import_core.ZWaveError(`The port must be a string or a valid custom serial port implementation!`, import_core.ZWaveErrorCodes.Driver_InvalidOptions);
    }
    const definedOptionsAndPresets = optionsAndPresets.filter((o) => !!o);
    let mergedOptions = {};
    for (const preset of definedOptionsAndPresets) {
      mergedOptions = (0, import_shared.mergeDeep)(mergedOptions, preset, true);
    }
    this._options = (0, import_shared.mergeDeep)(mergedOptions, (0, import_shared.cloneDeep)(defaultOptions));
    checkOptions(this._options);
    if (this._options.userAgent) {
      if (!(0, import_typeguards.isObject)(this._options.userAgent)) {
        throw new import_core.ZWaveError(`The userAgent property must be an object!`, import_core.ZWaveErrorCodes.Driver_InvalidOptions);
      }
      this.updateUserAgent(this._options.userAgent);
    }
    this.cacheDir = this._options.storage.cacheDir;
    const self = this;
    this.messageEncodingContext = {
      getHighestSecurityClass: /* @__PURE__ */ __name((nodeId) => this.getHighestSecurityClass(nodeId), "getHighestSecurityClass"),
      hasSecurityClass: /* @__PURE__ */ __name((nodeId, securityClass) => this.hasSecurityClass(nodeId, securityClass), "hasSecurityClass"),
      setSecurityClass: /* @__PURE__ */ __name((nodeId, securityClass, granted) => this.setSecurityClass(nodeId, securityClass, granted), "setSecurityClass"),
      getDeviceConfig: /* @__PURE__ */ __name((nodeId) => this.getDeviceConfig(nodeId), "getDeviceConfig"),
      // These are evaluated lazily, so we cannot spread messageParsingContext unfortunately
      get securityManager() {
        return self.securityManager;
      },
      get securityManager2() {
        return self.securityManager2;
      },
      get securityManagerLR() {
        return self.securityManagerLR;
      },
      getSupportedCCVersion: /* @__PURE__ */ __name((cc, nodeId, endpointIndex) => this.getSupportedCCVersion(cc, nodeId, endpointIndex), "getSupportedCCVersion")
    };
    this._scheduler = new import_Task.TaskScheduler(() => {
      return new import_core.ZWaveError("Task was removed", import_core.ZWaveErrorCodes.Driver_TaskRemoved);
    });
  }
  serialFactory;
  /** The serial port instance */
  serial;
  messageEncodingContext;
  getEncodingContext() {
    return {
      ...this.messageEncodingContext,
      ownNodeId: this.controller.ownNodeId,
      homeId: this.controller.homeId,
      nodeIdType: this._controller?.nodeIdType ?? import_core.NodeIDType.Short
    };
  }
  getMessageParsingContext() {
    return {
      getDeviceConfig: /* @__PURE__ */ __name((nodeId) => this.getDeviceConfig(nodeId), "getDeviceConfig"),
      sdkVersion: this._controller?.sdkVersion,
      requestStorage: this._requestStorage,
      ownNodeId: this._controller?.ownNodeId ?? 0,
      // Unspecified node ID
      homeId: this._controller?.homeId ?? 1431655765,
      // Invalid home ID
      nodeIdType: this._controller?.nodeIdType ?? import_core.NodeIDType.Short
    };
  }
  getCCParsingContext() {
    return {
      ...this.messageEncodingContext,
      ownNodeId: this.controller.ownNodeId,
      homeId: this.controller.homeId
    };
  }
  // We have multiple queues to achieve multiple "layers" of communication priority:
  // The default queue for most messages
  queue;
  // Is initialized in initTransactionQueues()
  // An immediate queue for handling queries that need to be handled ASAP, e.g. Nonce Get
  immediateQueue;
  // Is initialized in initTransactionQueues()
  // And all of them feed into the serial API queue, which contains commands that will be sent ASAP
  serialAPIQueue;
  // Is initialized in initControllerAndNodes()
  // Timers for delayed transaction re-queuing
  requeueTimers = /* @__PURE__ */ new Map();
  /** Gives access to the transaction queues, ordered by priority */
  get queues() {
    return [this.immediateQueue, this.queue];
  }
  initTransactionQueues() {
    this.immediateQueue = new import_Queue.TransactionQueue({
      name: "immediate",
      mayStartNextTransaction: /* @__PURE__ */ __name((t) => {
        if (this.controller.status === import_core.ControllerStatus.Unresponsive) {
          return t.message instanceof import_serialapi.SoftResetRequest || t.message instanceof import_serialapi.GetControllerVersionRequest;
        }
        if (this.controller.status === import_core.ControllerStatus.Jammed) {
          return t.message instanceof import_serialapi.SoftResetRequest;
        }
        return !this.queuePaused && this.controller.status === import_core.ControllerStatus.Ready;
      }, "mayStartNextTransaction")
    });
    this.queue = new import_Queue.TransactionQueue({
      name: "normal",
      mayStartNextTransaction: /* @__PURE__ */ __name((t) => this.mayStartTransaction(t), "mayStartNextTransaction")
    });
    this._queueIdle = false;
    for (const queue of this.queues) {
      void this.drainTransactionQueue(queue);
    }
  }
  async destroyTransactionQueues(reason, errorCode) {
    for (const set of this.requeueTimers.values()) {
      for (const timer of set) {
        timer.clear();
      }
    }
    this.requeueTimers.clear();
    for (const queue of this.queues) {
      if (!queue)
        return;
    }
    if ((0, import_shared.getenv)("NODE_ENV") !== "test") {
      await this.rejectTransactions((_t) => true, reason, errorCode ?? import_core.ZWaveErrorCodes.Driver_TaskRemoved);
    }
    for (const queue of this.queues) {
      queue.abort();
    }
  }
  _scheduler;
  get scheduler() {
    return this._scheduler;
  }
  queuePaused = false;
  /** Used to immediately abort ongoing Serial API commands */
  abortSerialAPICommand;
  initSerialAPIQueue() {
    this.serialAPIQueue = new import_shared.AsyncQueue();
    void this.drainSerialAPIQueue();
  }
  destroySerialAPIQueue(reason, errorCode) {
    if (!this.serialAPIQueue)
      return;
    this.serialAPIQueue.abort();
    this.abortSerialAPICommand?.reject(new import_core.ZWaveError(reason, errorCode ?? import_core.ZWaveErrorCodes.Driver_Destroyed));
  }
  // Keep track of which queues are currently busy
  _queuesBusyFlags = 0;
  _queueIdle = false;
  /** Whether the queue is currently idle */
  get queueIdle() {
    return this._queueIdle;
  }
  set queueIdle(value) {
    if (this._queueIdle !== value) {
      this.driverLog.print(value ? "all queues idle" : "one or more queues busy");
      this._queueIdle = value;
      this.handleQueueIdleChange(value);
    }
  }
  /** A map of handlers for all sorts of requests */
  requestHandlers = /* @__PURE__ */ new Map();
  /** A list of awaited message headers */
  awaitedMessageHeaders = [];
  /** A list of awaited messages */
  awaitedMessages = [];
  /** A list of awaited commands */
  awaitedCommands = [];
  /** A list of awaited chunks from the bootloader */
  awaitedBootloaderChunks = [];
  /** A list of awaited chunks from the end device CLI */
  awaitedCLIChunks = [];
  /** A list of promises waiting for the queues to become idle */
  awaitedIdle = [];
  /** A map of Node ID -> ongoing sessions */
  nodeSessions = /* @__PURE__ */ new Map();
  ensureNodeSessions(nodeId) {
    if (!this.nodeSessions.has(nodeId)) {
      this.nodeSessions.set(nodeId, {
        transportService: /* @__PURE__ */ new Map(),
        supervision: /* @__PURE__ */ new Map()
      });
    }
    return this.nodeSessions.get(nodeId);
  }
  _requestStorage = /* @__PURE__ */ new Map();
  /**
   * @internal
   * Stores data from Serial API command requests to be used by their responses
   */
  get requestStorage() {
    return this._requestStorage;
  }
  cacheDir;
  _valueDB;
  /** @internal */
  get valueDB() {
    return this._valueDB;
  }
  _metadataDB;
  /** @internal */
  get metadataDB() {
    return this._metadataDB;
  }
  _networkCache;
  /** @internal */
  get networkCache() {
    if (this._networkCache == void 0) {
      throw new import_core.ZWaveError("The network cache was not yet initialized!", import_core.ZWaveErrorCodes.Driver_NotReady);
    }
    return this._networkCache;
  }
  // This is set during `start()` and should not be accessed before
  _configManager;
  get configManager() {
    return this._configManager;
  }
  get configVersion() {
    return this.configManager?.configVersion ?? require("zwave-js/package.json")?.dependencies?.["@zwave-js/config"] ?? libVersion;
  }
  // This is set during `start()` and should not be accessed before
  _logContainer;
  // This is set during `start()` and should not be accessed before
  _driverLog;
  /** @internal */
  get driverLog() {
    return this._driverLog;
  }
  // This is set during `start()` and should not be accessed before
  _controllerLog;
  /** @internal */
  get controllerLog() {
    return this._controllerLog;
  }
  logNode(...args) {
    this._controllerLog.logNode(...args);
  }
  _controller;
  /** Encapsulates information about the Z-Wave controller and provides access to its nodes */
  get controller() {
    if (this._controller == void 0) {
      throw new import_core.ZWaveError("The controller is not yet ready!", import_core.ZWaveErrorCodes.Driver_NotReady);
    }
    return this._controller;
  }
  /** While in bootloader mode, this encapsulates information about the bootloader and its state */
  _bootloader;
  get bootloader() {
    if (this._bootloader == void 0) {
      throw new import_core.ZWaveError("The controller is not in bootloader mode!", import_core.ZWaveErrorCodes.Driver_NotReady);
    }
    return this._bootloader;
  }
  _cli;
  /** While in end device CLI mode, this encapsulates information about the CLI and its state */
  get cli() {
    if (this._cli == void 0) {
      throw new import_core.ZWaveError("The Z-Wave module is not in CLI mode!", import_core.ZWaveErrorCodes.Driver_NotReady);
    }
    return this._cli;
  }
  /** Determines which kind of Z-Wave application the driver is currently communicating with */
  get mode() {
    if (this._bootloader)
      return import_DriverMode.DriverMode.Bootloader;
    if (this._cli)
      return import_DriverMode.DriverMode.CLI;
    if (this._controller)
      return import_DriverMode.DriverMode.SerialAPI;
    return import_DriverMode.DriverMode.Unknown;
  }
  _recoveryPhase = 0;
  _securityManager;
  /**
   * **!!! INTERNAL !!!**
   *
   * Not intended to be used by applications
   */
  get securityManager() {
    return this._securityManager;
  }
  _securityManager2;
  /**
   * **!!! INTERNAL !!!**
   *
   * Not intended to be used by applications
   */
  get securityManager2() {
    return this._securityManager2;
  }
  _securityManagerLR;
  /**
   * **!!! INTERNAL !!!**
   *
   * Not intended to be used by applications
   */
  get securityManagerLR() {
    return this._securityManagerLR;
  }
  /** @internal */
  getSecurityManager2(destination) {
    const nodeId = (0, import_typeguards.isArray)(destination) ? destination[0] : destination;
    const isLongRange = (0, import_core.isLongRangeNodeId)(nodeId);
    return isLongRange ? this.securityManagerLR : this.securityManager2;
  }
  _learnModeAuthenticatedKeyPair;
  /** @internal */
  async getLearnModeAuthenticatedKeyPair() {
    if (this._learnModeAuthenticatedKeyPair == void 0) {
      const privateKey = this.cacheGet(import_NetworkCache.cacheKeys.controller.privateKey);
      if (privateKey) {
        this._learnModeAuthenticatedKeyPair = await (0, import_core.keyPairFromRawECDHPrivateKey)(privateKey);
      } else {
        this._learnModeAuthenticatedKeyPair = await (0, import_core.generateECDHKeyPair)();
        this.cacheSet(import_NetworkCache.cacheKeys.controller.privateKey, this._learnModeAuthenticatedKeyPair.privateKey);
      }
    }
    return this._learnModeAuthenticatedKeyPair;
  }
  /**
   * **!!! INTERNAL !!!**
   *
   * Not intended to be used by applications. Use `controller.homeId` instead!
   */
  get homeId() {
    return this.controller.homeId;
  }
  /**
   * **!!! INTERNAL !!!**
   *
   * Not intended to be used by applications. Use `controller.ownNodeId` instead!
   */
  get ownNodeId() {
    return this.controller.ownNodeId;
  }
  /** @internal Used for compatibility with the CCAPIHost interface */
  getNode(nodeId) {
    return this.controller.nodes.get(nodeId);
  }
  /** @internal Used for compatibility with the CCAPIHost interface */
  getNodeOrThrow(nodeId) {
    return this.controller.nodes.getOrThrow(nodeId);
  }
  /** @internal Used for compatibility with the CCAPIHost interface */
  getAllNodes() {
    return [...this.controller.nodes.values()];
  }
  tryGetNode(msg) {
    const nodeId = msg.getNodeId();
    if (nodeId != void 0)
      return this.controller.nodes.get(nodeId);
  }
  tryGetEndpoint(cc) {
    if (cc.isSinglecast()) {
      return this.controller.nodes.get(cc.nodeId)?.getEndpoint(cc.endpointIndex);
    }
  }
  /**
   * **!!! INTERNAL !!!**
   *
   * Not intended to be used by applications
   */
  getValueDB(nodeId) {
    const node = this.controller.nodes.getOrThrow(nodeId);
    return node.valueDB;
  }
  /**
   * **!!! INTERNAL !!!**
   *
   * Not intended to be used by applications
   */
  tryGetValueDB(nodeId) {
    const node = this.controller.nodes.get(nodeId);
    return node?.valueDB;
  }
  getDeviceConfig(nodeId) {
    return this.controller.nodes.get(nodeId)?.deviceConfig;
  }
  lookupManufacturer(manufacturerId) {
    return this.configManager.lookupManufacturer(manufacturerId);
  }
  getHighestSecurityClass(nodeId) {
    const node = this.controller.nodes.getOrThrow(nodeId);
    return node.getHighestSecurityClass();
  }
  hasSecurityClass(nodeId, securityClass) {
    const node = this.controller.nodes.getOrThrow(nodeId);
    return node.hasSecurityClass(securityClass);
  }
  /**
   * **!!! INTERNAL !!!**
   *
   * Not intended to be used by applications
   */
  setSecurityClass(nodeId, securityClass, granted) {
    const node = this.controller.nodes.getOrThrow(nodeId);
    node.setSecurityClass(securityClass, granted);
  }
  /** Updates the logging configuration without having to restart the driver. */
  updateLogConfig(config) {
    this._logContainer.updateConfiguration(config);
  }
  /** Returns the current logging configuration. */
  getLogConfig() {
    return this._logContainer.getConfiguration();
  }
  /** Updates the preferred sensor scales to use for node queries */
  setPreferredScales(scales) {
    this._options.preferences.scales = (0, import_shared.mergeDeep)(defaultOptions.preferences.scales, scales);
  }
  /**
   * **!!! INTERNAL !!!**
   *
   * Not intended to be used by applications
   */
  getUserPreferences() {
    return this._options.preferences;
  }
  /**
   * **!!! INTERNAL !!!**
   *
   * Not intended to be used by applications
   */
  getInterviewOptions() {
    return this._options.interview;
  }
  /**
   * **!!! INTERNAL !!!**
   *
   * Not intended to be used by applications
   */
  getRefreshValueTimeouts() {
    return {
      refreshValue: this._options.timeouts.refreshValue,
      refreshValueAfterTransition: this._options.timeouts.refreshValueAfterTransition
    };
  }
  /**
   * Enumerates all existing serial ports.
   * @param local Whether to include local serial ports
   * @param remote Whether to discover remote serial ports using an mDNS query for the `_zwave._tcp` domain
   */
  static async enumerateSerialPorts({ local = true, remote = true } = {}) {
    const ret = [];
    const bindings = (
      // eslint-disable-next-line @typescript-eslint/ban-ts-comment
      // @ts-ignore - For some reason, VSCode does not like this import, although tsc is fine with it
      (await import("#default_bindings/serial")).serial
    );
    if (local && typeof bindings.list === "function") {
      for (const port of await bindings.list()) {
        if (port.type === "custom")
          continue;
        ret.push(port);
      }
    }
    if (remote) {
      const ports = await (0, import_mDNSDiscovery.discoverRemoteSerialPorts)();
      if (ports) {
        ret.push(...ports.map((p) => ({
          type: "socket",
          path: p.port
        })));
      }
    }
    const portOrder = ["link", "socket", "tty"];
    ret.sort((a, b) => {
      const typeA = portOrder.indexOf(a.type);
      const typeB = portOrder.indexOf(b.type);
      if (typeA !== typeB)
        return typeA - typeB;
      return a.path.localeCompare(b.path);
    });
    return (0, import_arrays.distinct)(ret.map((p) => p.path));
  }
  /** Updates a subset of the driver options on the fly */
  updateOptions(options) {
    const safeOptions = (0, import_shared.pick)(options, [
      "attempts",
      "disableOptimisticValueUpdate",
      "emitValueUpdateAfterSetValue",
      "inclusionUserCallbacks",
      "joinNetworkUserCallbacks",
      "interview",
      "preferences",
      "vendor"
    ]);
    const { logConfig, host, ...rest } = this._options;
    const newOptions = (0, import_shared.mergeDeep)((0, import_shared.cloneDeep)(rest), safeOptions, true);
    newOptions.logConfig = logConfig;
    newOptions.host = host;
    checkOptions(newOptions);
    if (options.userAgent && !(0, import_typeguards.isObject)(options.userAgent)) {
      throw new import_core.ZWaveError(`The userAgent property must be an object!`, import_core.ZWaveErrorCodes.Driver_InvalidOptions);
    }
    this._options = newOptions;
    if (options.logConfig) {
      this.updateLogConfig(options.logConfig);
    }
    if (options.userAgent) {
      this.updateUserAgent(options.userAgent);
    }
  }
  _options;
  get options() {
    return this._options;
  }
  /**
   * The host bindings used to access file system etc.
   */
  // This is set during `start()` and should not be accessed before
  bindings;
  _wasStarted = false;
  _isOpen = false;
  /** Start the driver */
  async start() {
    if (this.wasDestroyed) {
      throw new import_core.ZWaveError("The driver was destroyed. Create a new instance and start that one.", import_core.ZWaveErrorCodes.Driver_Destroyed);
    }
    if (this._wasStarted)
      return Promise.resolve();
    this._wasStarted = true;
    this.bindings = {
      fs: this._options.host?.fs ?? (await import("#default_bindings/fs")).fs,
      serial: this._options.host?.serial ?? (await import("#default_bindings/serial")).serial,
      db: this._options.host?.db ?? (await import("#default_bindings/db")).db,
      log: this._options.host?.log ?? (await import("#default_bindings/log")).log
    };
    this._logContainer = this.bindings.log(this._options.logConfig);
    this._driverLog = new import_Driver.DriverLogger(this, this._logContainer);
    this._controllerLog = new import_core.ControllerLogger(this._logContainer);
    this._configManager = new import_config.ConfigManager({
      bindings: this.bindings.fs,
      logContainer: this._logContainer,
      deviceConfigPriorityDir: this._options.storage.deviceConfigPriorityDir,
      deviceConfigExternalDir: this._options.storage.deviceConfigExternalDir
    });
    const spOpenPromise = (0, import_deferred_promise.createDeferredPromise)();
    if (this._options.logConfig?.showLogo !== false) {
      this.driverLog.print(libNameString, "info");
    }
    this.driverLog.print(`version ${libVersion}`, "info");
    this.driverLog.print("", "info");
    this.driverLog.print("starting driver...");
    let binding;
    if (typeof this.port === "string") {
      if (typeof this.bindings.serial.createFactoryByPath === "function") {
        this.driverLog.print(`opening serial port ${this.port}`);
        binding = await this.bindings.serial.createFactoryByPath(this.port);
      } else {
        spOpenPromise.reject(new import_core.ZWaveError("This platform does not support creating a serial connection by path", import_core.ZWaveErrorCodes.Driver_Failed));
        void this.destroy();
        return;
      }
    } else if ((0, import_serial.isZWaveSerialPortImplementation)(this.port)) {
      this.driverLog.print("opening serial port using the provided custom implementation");
      this.driverLog.print("This is deprecated! Switch to the factory pattern instead.", "warn");
      binding = (0, import_serial.wrapLegacySerialBinding)(this.port);
    } else {
      this.driverLog.print("opening serial port using the provided custom factory");
      binding = this.port;
    }
    this.serialFactory = new import_serial.ZWaveSerialStreamFactory(binding, this._logContainer);
    setImmediate(async () => {
      try {
        await this.openSerialport();
      } catch (e) {
        spOpenPromise.reject(e);
        void this.destroy();
        return;
      }
      this.driverLog.print("serial port opened");
      this._isOpen = true;
      spOpenPromise.resolve();
      this._scheduler.start();
      if (typeof this._options.testingHooks?.onSerialPortOpen === "function") {
        await this._options.testingHooks.onSerialPortOpen(this.serial);
      }
      if (this._options.testingHooks?.skipFirmwareIdentification) {
        await this.writeHeader(import_serial.MessageHeaders.NAK);
        if ((0, import_shared.getenv)("NODE_ENV") !== "test") {
          await (0, import_async.wait)(1e3);
        }
      } else {
        const mode = await this.detectMode();
        if (mode === import_DriverMode.DriverMode.CLI) {
          this.emit("cli ready");
          return;
        }
        if (mode === import_DriverMode.DriverMode.Bootloader) {
          if (this._options.bootloaderMode === "stay") {
            this.driverLog.print("Controller is in bootloader mode. Staying in bootloader as requested.", "warn");
            this.emit("bootloader ready");
            return;
          }
          this.driverLog.print("Controller is in bootloader, attempting to recover...", "warn");
          await this.leaveBootloaderInternal();
          await (0, import_async.wait)(1e3);
          if (this._bootloader) {
            if (this._options.bootloaderMode === "allow") {
              this.driverLog.print("Failed to recover from bootloader. Staying in bootloader mode as requested.", "warn");
              this.emit("bootloader ready");
            } else {
              void this.destroyWithMessage("Failed to recover from bootloader. Please flash a new firmware to continue...");
            }
            return;
          }
        }
      }
      try {
        if (this._options.storage.driver) {
          await this._options.storage.driver.ensureDir(this.cacheDir);
        } else {
          await this.bindings.fs.ensureDir(this.cacheDir);
        }
      } catch (e) {
        let message;
        if (/\.yarn[/\\]cache[/\\]zwave-js/i.test((0, import_shared.getErrorMessage)(e, true))) {
          message = `Failed to create the cache directory ${this.cacheDir}. When using Yarn PnP, you need to change the location with the "storage.cacheDir" driver option.`;
        } else {
          message = `Failed to create the cache directory ${this.cacheDir}. Please make sure that it is writable or change the location with the "storage.cacheDir" driver option.`;
        }
        void this.destroyWithMessage(message);
        return;
      }
      if (this._options.testingHooks?.loadConfiguration !== false) {
        this.driverLog.print("loading configuration...");
        try {
          await this.configManager.loadAll();
        } catch (e) {
          const message = `Failed to load the configuration: ${(0, import_shared.getErrorMessage)(e)}`;
          void this.destroyWithMessage(message);
          return;
        }
      }
      this.driverLog.print("beginning interview...");
      try {
        await this.initializeControllerAndNodes();
      } catch (e) {
        let message;
        if ((0, import_core.isZWaveError)(e) && e.code === import_core.ZWaveErrorCodes.Controller_MessageDropped) {
          message = `Failed to initialize the driver, no response from the controller. Are you sure this is a Z-Wave controller?`;
        } else {
          message = `Failed to initialize the driver: ${(0, import_shared.getErrorMessage)(e, true)}`;
        }
        this.driverLog.print(message, "error");
        this.emit("error", new import_core.ZWaveError(message, import_core.ZWaveErrorCodes.Driver_Failed));
        void this.destroy();
        return;
      }
    });
    return spOpenPromise;
  }
  async detectMode() {
    const incomingNAK = this.waitForMessageHeader((h) => h === import_serial.MessageHeaders.NAK, 500).then(() => true).catch(() => false);
    await this.writeHeader(import_serial.MessageHeaders.NAK);
    if (await incomingNAK) {
      await this.writeSerial(import_shared.Bytes.from("\n", "ascii"));
    }
    await (0, import_async.wait)(500);
    if (this._cli)
      return import_DriverMode.DriverMode.CLI;
    if (this._bootloader)
      return import_DriverMode.DriverMode.Bootloader;
    return import_DriverMode.DriverMode.SerialAPI;
  }
  _controllerInterviewed = false;
  _nodesReady = /* @__PURE__ */ new Set();
  _nodesReadyEventEmitted = false;
  _isOpeningSerialPort = false;
  async openSerialport() {
    let lastError;
    this._isOpeningSerialPort = true;
    for (let attempt = 1; attempt <= this._options.attempts.openSerialPort; attempt++) {
      try {
        this.serial = await this.serialFactory.createStream();
        void this.handleSerialData(this.serial);
        if ((0, import_shared.getenv)("NODE_ENV") !== "test") {
          await (0, import_async.wait)(250);
        }
        if (this.serial.isOpen) {
          this._isOpeningSerialPort = false;
          return;
        }
      } catch (e) {
        lastError = e;
      }
      if (attempt < this._options.attempts.openSerialPort) {
        await (0, import_async.wait)(1e3);
      }
    }
    this._isOpeningSerialPort = false;
    const message = `Failed to open the serial port: ${(0, import_shared.getErrorMessage)(lastError)}`;
    this.driverLog.print(message, "error");
    throw new import_core.ZWaveError(message, import_core.ZWaveErrorCodes.Driver_Failed);
  }
  /** Indicates whether all nodes are ready, i.e. the "all nodes ready" event has been emitted */
  get allNodesReady() {
    return this._nodesReadyEventEmitted;
  }
  getJsonlDBOptions() {
    const options = {
      ignoreReadErrors: true,
      ...import_ThrottlePresets.throttlePresets[this._options.storage.throttle]
    };
    if (this._options.storage.lockDir) {
      options.lockfile = {
        directory: this._options.storage.lockDir
      };
    }
    return options;
  }
  async initNetworkCache(homeId) {
    const options = this.getJsonlDBOptions();
    const networkCacheFile = import_pathe.default.join(this.cacheDir, `${homeId.toString(16)}.jsonl`);
    this._networkCache = this.bindings.db.createInstance(networkCacheFile, {
      ...options,
      serializer: import_NetworkCache.serializeNetworkCacheValue,
      reviver: import_NetworkCache.deserializeNetworkCacheValue
    });
    await this._networkCache.open();
    if ((0, import_shared.getenv)("NO_CACHE") === "true") {
      this._networkCache.clear();
    }
  }
  async initValueDBs(homeId) {
    const options = this.getJsonlDBOptions();
    const valueDBFile = import_pathe.default.join(this.cacheDir, `${homeId.toString(16)}.values.jsonl`);
    this._valueDB = this.bindings.db.createInstance(valueDBFile, {
      ...options,
      enableTimestamps: true,
      reviver: /* @__PURE__ */ __name((_key, value) => (0, import_core.deserializeCacheValue)(value), "reviver"),
      serializer: /* @__PURE__ */ __name((_key, value) => (0, import_core.serializeCacheValue)(value), "serializer")
    });
    await this._valueDB.open();
    const metadataDBFile = import_pathe.default.join(this.cacheDir, `${homeId.toString(16)}.metadata.jsonl`);
    this._metadataDB = this.bindings.db.createInstance(metadataDBFile, options);
    await this._metadataDB.open();
    if ((0, import_shared.getenv)("NO_CACHE") === "true") {
      this._valueDB.clear();
      this._metadataDB.clear();
    }
  }
  async performCacheMigration() {
    if (!this._controller || !this.controller.homeId || !this._networkCache || !this._valueDB) {
      return;
    }
    if (this._networkCache.size === 0) {
      this._networkCache.set("cacheFormat", 1);
      try {
        await (0, import_NetworkCache.migrateLegacyNetworkCache)(
          this.controller.homeId,
          this._networkCache,
          this._valueDB,
          // eslint-disable-next-line @typescript-eslint/no-deprecated
          this._options.storage.driver ? wrapLegacyFSDriverForCacheMigrationOnly(
            // eslint-disable-next-line @typescript-eslint/no-deprecated
            this._options.storage.driver
          ) : this.bindings.fs,
          this.cacheDir
        );
        for (const key of this._valueDB.keys()) {
          if (-1 === key.indexOf(`,"commandClass":-1,`)) {
            continue;
          }
          this._valueDB.delete(key);
        }
      } catch (e) {
        const message = `Migrating the legacy cache file to jsonl failed: ${(0, import_shared.getErrorMessage)(e, true)}`;
        this.driverLog.print(message, "error");
      }
    }
    if (this._networkCache.get("cacheFormat") === 1) {
      for (const key of this._valueDB.keys()) {
        if (-1 !== key.indexOf(`,"commandClass":128,`) && -1 !== key.indexOf(`,"property":"isLow"`)) {
          this._valueDB.delete(key);
          this._metadataDB?.delete(key);
        }
      }
      this._networkCache.set("cacheFormat", 2);
    }
  }
  /**
   * Initializes the variables for controller and nodes,
   * adds event handlers and starts the interview process.
   */
  async initializeControllerAndNodes() {
    if (this._controller) {
      throw new import_core.ZWaveError("The controller was already initialized!", import_core.ZWaveErrorCodes.Driver_Failed);
    }
    this._controller = new import_Controller.ZWaveController(this);
    this._controller.on("node found", this.onNodeFound.bind(this)).on("node added", this.onNodeAdded.bind(this)).on("node removed", this.onNodeRemoved.bind(this)).on("status changed", this.onControllerStatusChanged.bind(this)).on("network found", this.onNetworkFound.bind(this)).on("network joined", this.onNetworkJoined.bind(this)).on("network left", this.onNetworkLeft.bind(this));
    this.initTransactionQueues();
    this.initSerialAPIQueue();
    if (!this._options.testingHooks?.skipControllerIdentification) {
      const { nodeIds } = await this.controller.queryCapabilities();
      await this.controller.queryAndConfigureRF();
      const maySoftReset = this.maySoftReset();
      if (this._options.features.softReset && !maySoftReset) {
        this.driverLog.print(`Soft reset is enabled through config, but this stick does not support it.`, "warn");
        this._options.features.softReset = false;
      }
      if (maySoftReset) {
        await this.softResetInternal(false);
      }
      let lrNodeIds;
      if (this.controller.supportsLongRange) {
        lrNodeIds = (await this.controller.queryLongRangeCapabilities()).lrNodeIds;
      }
      await this.controller.trySetNodeIDType(this.controller.supportsLongRange ? import_core.NodeIDType.Long : import_core.NodeIDType.Short);
      await this.controller.identify();
      await this.controller.configure();
      await this.initNetworkCache(this.controller.homeId);
      await this.initValueDBs(this.controller.homeId);
      await this.performCacheMigration();
      await this.controller.initNodes(nodeIds, lrNodeIds ?? [], async () => {
        if ((0, import_shared.getenv)("NO_CACHE") !== "true") {
          await this.restoreNetworkStructureFromCache();
        }
      });
      await this.controller.interviewProprietary();
      this.controllerLog.print("Interview completed");
      if (this.controller.role === import_core.ControllerRole.Primary) {
        this.controller.autoProvisionSmartStart();
      }
    } else {
      this.controller["_wasRealPrimary"] = true;
      this.controller["_isSUC"] = true;
      this.controller["_isSISPresent"] = true;
      this.controller["_sucNodeId"] = 1;
    }
    if (this.controller.role === import_core.ControllerRole.Primary) {
      const S0Key = this._options.securityKeys?.S0_Legacy;
      if (S0Key) {
        this.driverLog.print("Network key for S0 configured, enabling S0 security manager...");
        this._securityManager = new import_core.SecurityManager({
          networkKey: S0Key,
          ownNodeId: this._controller.ownNodeId,
          nonceTimeout: this._options.timeouts.nonce
        });
      } else {
        this.driverLog.print("No network key for S0 configured, communication with secure (S0) devices won't work!", "warn");
      }
      if (this._options.securityKeys && Object.keys(this._options.securityKeys).some((key) => key.startsWith("S2_") && key in import_core.SecurityClass && (0, import_core.securityClassIsS2)(import_core.SecurityClass[key]))) {
        this.driverLog.print("At least one network key for S2 configured, enabling S2 security manager...");
        this._securityManager2 = await import_core.SecurityManager2.create();
        for (const secClass of [
          "S2_Unauthenticated",
          "S2_Authenticated",
          "S2_AccessControl",
          "S0_Legacy"
        ]) {
          const key = this._options.securityKeys[secClass];
          if (key) {
            await this._securityManager2.setKey(import_core.SecurityClass[secClass], key);
          }
        }
      } else {
        this.driverLog.print("No network key for S2 configured, communication with secure (S2) devices won't work!", "warn");
      }
      if (this._options.securityKeysLongRange?.S2_AccessControl || this._options.securityKeysLongRange?.S2_Authenticated) {
        this.driverLog.print("At least one network key for Z-Wave Long Range configured, enabling security manager...");
        this._securityManagerLR = await import_core.SecurityManager2.create();
        if (this._options.securityKeysLongRange?.S2_AccessControl) {
          await this._securityManagerLR.setKey(import_core.SecurityClass.S2_AccessControl, this._options.securityKeysLongRange.S2_AccessControl);
        }
        if (this._options.securityKeysLongRange?.S2_Authenticated) {
          await this._securityManagerLR.setKey(import_core.SecurityClass.S2_Authenticated, this._options.securityKeysLongRange.S2_Authenticated);
        }
      } else {
        this.driverLog.print("No network key for Z-Wave Long Range configured, communication won't work!", "warn");
      }
    } else {
      if ((0, import_core.isLongRangeNodeId)(this.controller.ownNodeId)) {
        const securityKeysLongRange = [
          import_core.SecurityClass.S2_AccessControl,
          import_core.SecurityClass.S2_Authenticated
        ].map((sc) => [
          sc,
          this.cacheGet(import_NetworkCache.cacheKeys.controller.securityKeysLongRange(sc))
        ]).filter((v) => v[1] != void 0);
        if (securityKeysLongRange.length) {
          this.driverLog.print("At least one network key for Z-Wave Long Range found in cache, enabling security manager...");
          this._securityManagerLR = await import_core.SecurityManager2.create();
          for (const [sc, key] of securityKeysLongRange) {
            await this._securityManagerLR.setKey(sc, key);
          }
        } else if (this._options.securityKeysLongRange?.S2_AccessControl || this._options.securityKeysLongRange?.S2_Authenticated) {
          this.driverLog.print("Fallback to configured network keys for Z-Wave Long Range, enabling security manager...");
          this._securityManagerLR = await import_core.SecurityManager2.create();
          if (this._options.securityKeysLongRange?.S2_AccessControl) {
            await this._securityManagerLR.setKey(import_core.SecurityClass.S2_AccessControl, this._options.securityKeysLongRange.S2_AccessControl);
          }
          if (this._options.securityKeysLongRange?.S2_Authenticated) {
            await this._securityManagerLR.setKey(import_core.SecurityClass.S2_Authenticated, this._options.securityKeysLongRange.S2_Authenticated);
          }
        } else {
          this.driverLog.print("No network key for Z-Wave Long Range configured, communication won't work!", "warn");
        }
      } else {
        const s0Key = this.cacheGet(import_NetworkCache.cacheKeys.controller.securityKeys(import_core.SecurityClass.S0_Legacy));
        if (s0Key) {
          this.driverLog.print("Network key for S0 found in cache, enabling S0 security manager...");
          this._securityManager = new import_core.SecurityManager({
            networkKey: s0Key,
            ownNodeId: this._controller.ownNodeId,
            nonceTimeout: this._options.timeouts.nonce
          });
        } else if (this._options.securityKeys?.S0_Legacy) {
          this.driverLog.print("Fallback to configured S0 network key, enabling S0 security manager...");
          this._securityManager = new import_core.SecurityManager({
            networkKey: this._options.securityKeys.S0_Legacy,
            ownNodeId: this._controller.ownNodeId,
            nonceTimeout: this._options.timeouts.nonce
          });
        } else {
          this.driverLog.print("No network key for S0 found in cache, communication with secure (S0) devices won't work!", "warn");
        }
        const securityKeys = import_core.securityClassOrder.map((sc) => [
          sc,
          this.cacheGet(import_NetworkCache.cacheKeys.controller.securityKeys(sc))
        ]).filter((v) => v[1] != void 0);
        if (securityKeys.length) {
          this.driverLog.print("At least one network key for S2 found in cache, enabling S2 security manager...");
          this._securityManager2 = await import_core.SecurityManager2.create();
          for (const [sc, key] of securityKeys) {
            await this._securityManager2.setKey(sc, key);
          }
        } else if (this._options.securityKeys && Object.keys(this._options.securityKeys).some((key) => key.startsWith("S2_") && key in import_core.SecurityClass && (0, import_core.securityClassIsS2)(import_core.SecurityClass[key]))) {
          this.driverLog.print("Fallback to configured network keys for S2, enabling S2 security manager...");
          this._securityManager2 = await import_core.SecurityManager2.create();
          for (const secClass of [
            "S2_Unauthenticated",
            "S2_Authenticated",
            "S2_AccessControl",
            "S0_Legacy"
          ]) {
            const key = this._options.securityKeys[secClass];
            if (key) {
              await this._securityManager2.setKey(import_core.SecurityClass[secClass], key);
            }
          }
        } else {
          this.driverLog.print("No network key for S2 found in cache, communication with secure (S2) devices won't work!", "warn");
        }
      }
    }
    this._controllerInterviewed = true;
    this.driverLog.print("driver ready");
    this.emit("driver ready");
    for (const node of this._controller.nodes.values()) {
      this.addNodeEventHandlers(node);
    }
    if (this.controller.role === import_core.ControllerRole.Primary) {
      this._nodesReady.clear();
      this._nodesReadyEventEmitted = false;
      if (!this._options.testingHooks?.skipNodeInterview) {
        const controllerNode = this._controller.nodes.get(this._controller.ownNodeId);
        await this.interviewNodeInternal(controllerNode);
        controllerNode.markAsAlive();
        const nodeInterviewOrder = [...this._controller.nodes.values()].filter((n) => n.id !== this._controller.ownNodeId).toSorted((a, b) => (
          // Fully-interviewed devices first (need the least amount of communication now)
          b.interviewStage - a.interviewStage || (b.isListening ? 2 : b.isFrequentListening ? 1 : 0) - (a.isListening ? 2 : a.isFrequentListening ? 1 : 0) || (b.lastSeen?.getTime() ?? 0) - (a.lastSeen?.getTime() ?? 0) || a.id - b.id
        ));
        if (nodeInterviewOrder.length) {
          this.controllerLog.print(`Interviewing nodes and/or determining their status: ${nodeInterviewOrder.map((n) => n.id).join(", ")}`);
          for (const node of nodeInterviewOrder) {
            if (node.canSleep) {
              node.markAsAsleep();
            }
            void (async () => {
              if (node.interviewStage < import_Types2.InterviewStage.Complete) {
                await this.interviewNodeInternal(node);
              } else if (node.isListening || node.isFrequentListening) {
                await node.ping();
              }
            })();
          }
        }
      }
    } else {
      if (!this._options.testingHooks?.skipNodeInterview) {
        const controllerNode = this._controller.nodes.get(this._controller.ownNodeId);
        await this.interviewNodeInternal(controllerNode);
        controllerNode.markAsAlive();
        for (const node of this._controller.nodes.values()) {
          if (node.isControllerNode)
            continue;
          if (node.interviewStage === import_Types2.InterviewStage.Complete) {
            if (node.canSleep)
              node.markAsAsleep();
            continue;
          }
          await node["queryProtocolInfo"]();
        }
        const nodeInterviewOrder = [...this._controller.nodes.values()].filter((n) => n.id !== this._controller.ownNodeId).filter((n) => n.isListening || n.isFrequentListening).toSorted((a, b) => (
          // Always listening -> FLiRS
          (b.isListening ? 1 : 0) - (a.isListening ? 1 : 0) || (b.lastSeen?.getTime() ?? 0) - (a.lastSeen?.getTime() ?? 0) || a.id - b.id
        ));
        if (nodeInterviewOrder.length) {
          this.controllerLog.print(`Determining node status: ${nodeInterviewOrder.map((n) => n.id).join(", ")}`);
          for (const node of nodeInterviewOrder) {
            void node.ping();
          }
        }
      }
    }
    this.handleQueueIdleChange(this.queueIdle);
  }
  autoRefreshNodeValueTimers = /* @__PURE__ */ new Map();
  retryNodeInterviewTimeouts = /* @__PURE__ */ new Map();
  /**
   * @internal
   * Starts or resumes the interview of a Z-Wave node. It is advised to NOT
   * await this method as it can take a very long time (minutes to hours)!
   *
   * WARNING: Do not call this method from application code. To refresh the information
   * for a specific node, use `node.refreshInfo()` instead
   */
  async interviewNodeInternal(node) {
    if (node.interviewStage === import_Types2.InterviewStage.Complete) {
      return;
    }
    if (node.failedS2Bootstrapping) {
      this.controllerLog.logNode(node.id, "has failed S2 bootstrapping and cannot be interviewed", "warn");
      return;
    }
    if (this.retryNodeInterviewTimeouts.has(node.id)) {
      this.retryNodeInterviewTimeouts.get(node.id)?.clear();
      this.retryNodeInterviewTimeouts.delete(node.id);
    }
    await this.rejectTransactions((t) => t.message.getNodeId() === node.id && (t.priority === import_core.MessagePriority.NodeQuery || t.tag === "interview"), "The interview was restarted", import_core.ZWaveErrorCodes.Controller_InterviewRestarted);
    const maxInterviewAttempts = this._options.attempts.nodeInterview;
    try {
      if (!await node.interviewInternal()) {
        if (node.status === import_Types2.NodeStatus.Dead) {
          this.controllerLog.logNode(node.id, `Interview attempt (${node.interviewAttempts}/${maxInterviewAttempts}) failed, node is dead.`, "warn");
          node.emit("interview failed", node, {
            errorMessage: "The node is dead",
            isFinal: true
          });
        } else if (node.interviewAttempts < maxInterviewAttempts) {
          const retryTimeout = Math.min(3e4, node.interviewAttempts * 5e3);
          this.controllerLog.logNode(node.id, `Interview attempt ${node.interviewAttempts}/${maxInterviewAttempts} failed, retrying in ${retryTimeout} ms...`, "warn");
          node.emit("interview failed", node, {
            errorMessage: `Attempt ${node.interviewAttempts}/${maxInterviewAttempts} failed`,
            isFinal: false,
            attempt: node.interviewAttempts,
            maxAttempts: maxInterviewAttempts
          });
          this.retryNodeInterviewTimeouts.set(node.id, (0, import_shared.setTimer)(() => {
            this.retryNodeInterviewTimeouts.delete(node.id);
            void this.interviewNodeInternal(node);
          }, retryTimeout).unref());
        } else {
          this.controllerLog.logNode(node.id, `Failed all interview attempts, giving up.`, "warn");
          node.emit("interview failed", node, {
            errorMessage: `Maximum interview attempts reached`,
            isFinal: true,
            attempt: maxInterviewAttempts,
            maxAttempts: maxInterviewAttempts
          });
        }
      } else if (node.manufacturerId != void 0 && node.productType != void 0 && node.productId != void 0 && node.firmwareVersion != void 0 && !node.deviceConfig && process.env.NODE_ENV !== "test") {
        void (0, import_deviceConfig.reportMissingDeviceConfig)(this, node).catch(import_shared.noop);
      }
    } catch (e) {
      if ((0, import_core.isZWaveError)(e)) {
        if (e.code === import_core.ZWaveErrorCodes.Driver_NotReady || e.code === import_core.ZWaveErrorCodes.Controller_NodeRemoved) {
          return;
        } else if (e.code === import_core.ZWaveErrorCodes.Controller_InterviewRestarted) {
          return;
        }
        this.controllerLog.logNode(node.id, `Error during node interview: ${e.message}`, "error");
      } else {
        throw e;
      }
    }
  }
  /** Adds the necessary event handlers for a node instance */
  addNodeEventHandlers(node) {
    node.on("wake up", this.onNodeWakeUp.bind(this)).on("sleep", this.onNodeSleep.bind(this)).on("alive", this.onNodeAlive.bind(this)).on("dead", this.onNodeDead.bind(this)).on("interview completed", this.onNodeInterviewCompleted.bind(this)).on("ready", this.onNodeReady.bind(this)).on("firmware update finished", this.onNodeFirmwareUpdated.bind(this)).on("notification", this.onNodeNotification.bind(this));
    for (const event of import_Types2.zWaveNodeEvents) {
      node.on(event, (...args) => {
        this.emit(`node ${event}`, ...args);
      });
    }
  }
  /** Removes a node's event handlers that were added with addNodeEventHandlers */
  removeNodeEventHandlers(node) {
    node.removeAllListeners();
  }
  /** Is called when a node wakes up */
  onNodeWakeUp(node, oldStatus) {
    this.controllerLog.logNode(node.id, `The node is ${oldStatus === import_Types2.NodeStatus.Unknown ? "" : "now "}awake.`);
    if (oldStatus === import_Types2.NodeStatus.Asleep) {
      void this.reduceQueues(({ message }) => {
        if (message.getNodeId() !== node.id)
          return { type: "keep" };
        if (messageIsPing(message)) {
          return { type: "resolve", message: void 0 };
        }
        return { type: "requeue" };
      });
    }
    this.debounceSendNodeToSleep(node);
  }
  /** Is called when a node goes to sleep */
  onNodeSleep(node, oldStatus) {
    this.controllerLog.logNode(node.id, `The node is ${oldStatus === import_Types2.NodeStatus.Unknown ? "" : "now "}asleep.`);
    this.moveMessagesToWakeupQueue(node.id);
  }
  /** Is called when a previously dead node starts communicating again */
  onNodeAlive(node, oldStatus) {
    this.controllerLog.logNode(node.id, `The node is ${oldStatus === import_Types2.NodeStatus.Unknown ? "" : "now "}alive.`);
    if (oldStatus === import_Types2.NodeStatus.Dead && node.interviewStage !== import_Types2.InterviewStage.Complete && !this._options.testingHooks?.skipNodeInterview) {
      void this.interviewNodeInternal(node);
    }
  }
  /** Is called when a node is marked as dead */
  onNodeDead(node, oldStatus) {
    this.controllerLog.logNode(node.id, `The node is ${oldStatus === import_Types2.NodeStatus.Unknown ? "" : "now "}dead.`);
    this.checkAllNodesReady();
  }
  /** Is called when a node is ready to be used */
  onNodeReady(node) {
    this._nodesReady.add(node.id);
    this.controllerLog.logNode(node.id, "The node is ready to be used");
    if (this.autoRefreshNodeValueTimers.has(node.id)) {
      this.autoRefreshNodeValueTimers.get(node.id)?.clear();
      this.autoRefreshNodeValueTimers.delete(node.id);
    }
    if (!node.canSleep) {
      const intervalMinutes = 50 + Math.random() * 20;
      this.autoRefreshNodeValueTimers.set(node.id, (0, import_shared.setInterval)(() => {
        void node.autoRefreshValues().catch(() => {
        });
      }, import_core.timespan.minutes(intervalMinutes)).unref());
    }
    this.checkAllNodesReady();
  }
  /** Checks if all nodes are ready and emits the "all nodes ready" event if they are */
  checkAllNodesReady() {
    if (this._nodesReadyEventEmitted)
      return;
    for (const [id, node] of this.controller.nodes) {
      if (node.status === import_Types2.NodeStatus.Dead)
        continue;
      if (!this._nodesReady.has(id))
        return;
    }
    this.controllerLog.print("All nodes are ready to be used");
    this.emit("all nodes ready");
    this._nodesReadyEventEmitted = true;
    void this.compileAndSendStatistics().catch(() => {
    });
  }
  _statisticsEnabled = false;
  /** Whether reporting usage statistics is currently enabled */
  get statisticsEnabled() {
    return this._statisticsEnabled;
  }
  statisticsAppInfo;
  userAgentComponents = /* @__PURE__ */ new Map();
  /**
   * Updates individual components of the user agent. Versions for individual applications can be added or removed.
   * @param components An object with application/module/component names and their versions. Set a version to `null` or `undefined` explicitly to remove it from the user agent.
   */
  updateUserAgent(components) {
    this.userAgentComponents = (0, import_UserAgent.mergeUserAgent)(this.userAgentComponents, components);
    this._userAgent = this.getEffectiveUserAgentString(this.userAgentComponents);
  }
  /**
   * Returns the effective user agent string for the given components.
   * The driver name and version is automatically prepended and the statisticsAppInfo data is automatically appended if no components were given.
   */
  getEffectiveUserAgentString(components) {
    const effectiveComponents = new Map([
      [libName, libVersion],
      ...components
    ]);
    if (effectiveComponents.size === 1 && this.statisticsAppInfo && this.statisticsAppInfo.applicationName !== "node-zwave-js" && this.statisticsAppInfo.applicationName !== "zwave-js") {
      effectiveComponents.set(this.statisticsAppInfo.applicationName, this.statisticsAppInfo.applicationVersion);
    }
    return (0, import_UserAgent.userAgentComponentsToString)(effectiveComponents);
  }
  _userAgent = `zwave-js/${libVersion}`;
  /** Returns the user agent string used for service requests */
  get userAgent() {
    return this._userAgent;
  }
  /** Returns the user agent string combined with the additional components (if given) */
  getUserAgentStringWithComponents(components) {
    if (!components || Object.keys(components).length === 0) {
      return this._userAgent;
    }
    const merged = (0, import_UserAgent.mergeUserAgent)(this.userAgentComponents, components, false);
    return this.getEffectiveUserAgentString(merged);
  }
  /**
   * Enable sending usage statistics. Although this does not include any sensitive information, we expect that you
   * inform your users before enabling statistics.
   */
  enableStatistics(appInfo) {
    if (this._statisticsEnabled)
      return;
    if (!(0, import_typeguards.isObject)(appInfo) || typeof appInfo.applicationName !== "string" || typeof appInfo.applicationVersion !== "string") {
      throw new import_core.ZWaveError(`The application statistics must be an object with two string properties "applicationName" and "applicationVersion"!`, import_core.ZWaveErrorCodes.Driver_InvalidOptions);
    } else if (appInfo.applicationName.length > 100) {
      throw new import_core.ZWaveError(`The applicationName for statistics must be maximum 100 characters long!`, import_core.ZWaveErrorCodes.Driver_InvalidOptions);
    } else if (appInfo.applicationVersion.length > 100) {
      throw new import_core.ZWaveError(`The applicationVersion for statistics must be maximum 100 characters long!`, import_core.ZWaveErrorCodes.Driver_InvalidOptions);
    }
    this._statisticsEnabled = true;
    this.statisticsAppInfo = appInfo;
    if (this._nodesReadyEventEmitted) {
      void this.compileAndSendStatistics().catch(() => {
      });
    }
  }
  /**
   * Disable sending usage statistics
   */
  disableStatistics() {
    this._statisticsEnabled = false;
    this.statisticsAppInfo = void 0;
    this.statisticsTimeout?.clear();
    this.statisticsTimeout = void 0;
  }
  /** @internal */
  // eslint-disable-next-line @typescript-eslint/require-await
  async getUUID() {
    if (!this._valueDB.has("uuid")) {
      this._valueDB.set("uuid", import_shared.Bytes.view((0, import_core.randomBytes)(32)).toString("hex"));
    }
    const ret = this._valueDB.get("uuid");
    return ret;
  }
  statisticsTimeout;
  async compileAndSendStatistics() {
    if (!this.statisticsEnabled || !this.statisticsAppInfo)
      return;
    this.statisticsTimeout?.clear();
    this.statisticsTimeout = void 0;
    let success = false;
    try {
      const statistics = await (0, import_statistics.compileStatistics)(this, {
        driverVersion: libVersion,
        ...this.statisticsAppInfo,
        nodeVersion: process.versions.node,
        os: process.platform,
        arch: process.arch
      });
      success = await (0, import_statistics.sendStatistics)(statistics);
    } catch {
      success = false;
    } finally {
      if (typeof success === "number") {
        this.driverLog.print(`Sending usage statistics was rate limited - next attempt scheduled in ${success} seconds.`, "verbose");
        const retryMs = Math.max(import_core.timespan.minutes(1), Math.min(success * 1e3, import_core.timespan.hours(6)));
        this.statisticsTimeout = (0, import_shared.setTimer)(() => {
          void this.compileAndSendStatistics();
        }, retryMs).unref();
      } else {
        this.driverLog.print(success ? `Usage statistics sent - next transmission scheduled in 23 hours.` : `Failed to send usage statistics - next transmission scheduled in 6 hours.`, "verbose");
        this.statisticsTimeout = (0, import_shared.setTimer)(() => {
          void this.compileAndSendStatistics();
        }, import_core.timespan.hours(success ? 23 : 6)).unref();
      }
    }
  }
  /** Is called when a node interview is completed */
  onNodeInterviewCompleted(node) {
    this.debounceSendNodeToSleep(node);
  }
  /** This is called when a new node was found and is being added to the network */
  onNodeFound(node) {
    const prefix = `{"nodeId":${node.id},`;
    for (const key of this.valueDB.keys()) {
      if (key.startsWith(prefix)) {
        this.valueDB.delete(key);
      }
    }
    for (const key of this.metadataDB.keys()) {
      if (key.startsWith(prefix)) {
        this.metadataDB.delete(key);
      }
    }
    this.cachePurge(
      import_NetworkCache.cacheKeys.node(node.id)._baseKey,
      // Preserve the device class though - this is set during the initial inclusion
      // https://github.com/zwave-js/zwave-js/issues/8346
      (key) => key === import_NetworkCache.cacheKeys.node(node.id).deviceClass
    );
  }
  /** This is called when a new node has been added to the network */
  onNodeAdded(node) {
    this.addNodeEventHandlers(node);
    if (this._options.interview?.disableOnNodeAdded)
      return;
    if (this._options.testingHooks?.skipNodeInterview)
      return;
    void this.interviewNodeInternal(node);
  }
  /** This is called when a node was removed from the network */
  onNodeRemoved(node, reason) {
    this.removeNodeEventHandlers(node);
    if (this.sendNodeToSleepTimers.has(node.id)) {
      this.sendNodeToSleepTimers.get(node.id)?.clear();
      this.sendNodeToSleepTimers.delete(node.id);
    }
    if (this.retryNodeInterviewTimeouts.has(node.id)) {
      this.retryNodeInterviewTimeouts.get(node.id)?.clear();
      this.retryNodeInterviewTimeouts.delete(node.id);
    }
    if (this.autoRefreshNodeValueTimers.has(node.id)) {
      this.autoRefreshNodeValueTimers.get(node.id)?.clear();
      this.autoRefreshNodeValueTimers.delete(node.id);
    }
    if (this.requeueTimers.has(node.id)) {
      for (const timer of this.requeueTimers.get(node.id)) {
        timer.clear();
      }
      this.requeueTimers.delete(node.id);
    }
    node.valueDB.clear();
    this.cachePurge(import_NetworkCache.cacheKeys.node(node.id)._baseKey);
    this.securityManager?.deleteAllNoncesForReceiver(node.id);
    this.securityManager2?.deleteNonce(node.id);
    this.securityManagerLR?.deleteNonce(node.id);
    void this.rejectAllTransactionsForNode(node.id, "The node was removed from the network", import_core.ZWaveErrorCodes.Controller_NodeRemoved);
    const replaced = reason === import_Inclusion.RemoveNodeReason.Replaced || reason === import_Inclusion.RemoveNodeReason.ProxyReplaced;
    if (!replaced) {
      this.controller.removeNodeFromAllAssociations(node.id).catch((err) => {
        this.driverLog.print(`Failed to remove node ${node.id} from all associations: ${err.message}`, "error");
      });
    }
    node.destroy();
    this.checkAllNodesReady();
  }
  onControllerStatusChanged(_status) {
    this.triggerQueues();
  }
  async onNetworkFound(homeId, _ownNodeId) {
    try {
      this.driverLog.print(`Joined network with home ID ${(0, import_shared.num2hex)(homeId)}, switching to new network cache...`);
      await this.recreateNetworkCacheAndValueDBs();
    } catch (e) {
      this.driverLog.print(`Recreating the network cache and value DBs failed: ${(0, import_shared.getErrorMessage)(e)}`, "error");
    }
  }
  onNetworkJoined() {
    this.driverLog.print(`Finished joining network`);
  }
  async onNetworkLeft() {
    try {
      this.driverLog.print(`Left the previous network, switching network cache to new home ID ${(0, import_shared.num2hex)(this.controller.homeId)}...`);
      await this.recreateNetworkCacheAndValueDBs();
    } catch (e) {
      this.driverLog.print(`Recreating the network cache and value DBs failed: ${(0, import_shared.getErrorMessage)(e)}`, "error");
    }
  }
  async recreateNetworkCacheAndValueDBs() {
    await this._networkCache?.close();
    await this._valueDB?.close();
    await this._metadataDB?.close();
    await this.initNetworkCache(this.controller.homeId);
    await this.initValueDBs(this.controller.homeId);
    await this.performCacheMigration();
  }
  /**
   * Returns the time in seconds to actually wait after a firmware upgrade, depending on what the device said.
   * This number will always be a bit greater than the advertised duration, because devices have been found to take longer to actually reboot.
   */
  getConservativeWaitTimeAfterFirmwareUpdate(advertisedWaitTime) {
    if (!advertisedWaitTime) {
      return 5;
    } else if (advertisedWaitTime < 20) {
      return advertisedWaitTime + 5;
    } else if (advertisedWaitTime < 60) {
      return advertisedWaitTime + 10;
    } else {
      return advertisedWaitTime + 30;
    }
  }
  /** This is called when the firmware on one of a node's firmware targets was updated */
  async onNodeFirmwareUpdated(node, result) {
    const { success, reInterview } = result;
    if (!success)
      return;
    this.securityManager?.deleteAllNoncesForReceiver(node.id);
    this.securityManager2?.deleteNonce(node.id);
    this.securityManagerLR?.deleteNonce(node.id);
    const waitTime = result.waitTime ?? 5;
    if (reInterview) {
      this.controllerLog.logNode(node.id, `Firmware updated, scheduling interview in ${waitTime} seconds...`);
      this.retryNodeInterviewTimeouts.set(node.id, (0, import_shared.setTimer)(() => {
        this.retryNodeInterviewTimeouts.delete(node.id);
        void node.refreshInfo({
          // After a firmware update, we need to refresh the node info
          waitForWakeup: false
        });
      }, waitTime * 1e3).unref());
    } else {
      this.controllerLog.logNode(node.id, `Firmware updated. No restart or re-interview required. Refreshing version information in ${waitTime} seconds...`);
      await (0, import_async.wait)(waitTime * 1e3, true);
      try {
        const versionAPI = node.commandClasses.Version;
        await versionAPI.get();
        if (versionAPI.supportsCommand(import_cc.VersionCommand.CapabilitiesGet)) {
          await versionAPI.getCapabilities();
        }
        if (versionAPI.supportsCommand(import_cc.VersionCommand.ZWaveSoftwareGet)) {
          await versionAPI.getZWaveSoftware();
        }
      } catch {
      }
      node.keepAwake = false;
      this.debounceSendNodeToSleep(node);
    }
  }
  /** This is called when a node emits a `"notification"` event */
  onNodeNotification = /* @__PURE__ */ __name((endpoint, ccId, ccArgs) => {
    let prefix;
    let details;
    if (ccId === import_core.CommandClasses.Notification) {
      const msg = {
        type: ccArgs.label,
        event: ccArgs.eventLabel
      };
      if (ccArgs.parameters) {
        if ((0, import_shared.isUint8Array)(ccArgs.parameters)) {
          msg.parameters = (0, import_shared.buffer2hex)(ccArgs.parameters);
        } else if (ccArgs.parameters instanceof import_core.Duration) {
          msg.duration = ccArgs.parameters.toString();
        } else if ((0, import_typeguards.isObject)(ccArgs.parameters)) {
          Object.assign(msg, ccArgs.parameters);
        }
      }
      prefix = "[Notification]";
      details = (0, import_core.messageRecordToLines)(msg);
    } else if (ccId === import_core.CommandClasses["Entry Control"]) {
      prefix = "[Notification] Entry Control";
      details = (0, import_core.messageRecordToLines)({
        "event type": ccArgs.eventTypeLabel,
        "data type": ccArgs.dataTypeLabel
      });
    } else if (ccId === import_core.CommandClasses["Multilevel Switch"]) {
      prefix = "[Notification] Multilevel Switch";
      details = (0, import_core.messageRecordToLines)((0, import_core.stripUndefined)({
        "event type": ccArgs.eventTypeLabel,
        direction: ccArgs.direction
      }));
    } else {
      return;
    }
    this.controllerLog.logNode(endpoint.nodeId, {
      endpoint: endpoint.index,
      message: [prefix, ...details.map((d) => `  ${d}`)].join("\n")
    });
  }, "onNodeNotification");
  /** Checks if there are any pending messages for the given node */
  hasPendingMessages(node) {
    if (this.hasPendingTransactions((t) => t.message.getNodeId() === node.id)) {
      return true;
    }
    return node.hasScheduledPolls();
  }
  /** Checks if there are any pending transactions that match the given predicate */
  hasPendingTransactions(predicate) {
    if (!!this.queue.find((t) => predicate(t)))
      return true;
    return this.queues.some((q) => q.currentTransaction && predicate(q.currentTransaction));
  }
  /**
   * Retrieves the maximum version of a command class the given endpoint supports.
   * Returns 0 when the CC is not supported. Also returns 0 when the node was not found.
   * Falls back to querying the root endpoint if an endpoint was not found on the node
   *
   * @param cc The command class whose version should be retrieved
   * @param nodeId The node for which the CC version should be retrieved
   * @param endpointIndex The endpoint in question
   */
  getSupportedCCVersion(cc, nodeId, endpointIndex = 0) {
    if (!this._controller?.nodes.has(nodeId)) {
      return 0;
    }
    const node = this.controller.nodes.get(nodeId);
    const endpoint = node.getEndpoint(endpointIndex);
    if (endpoint)
      return endpoint.getCCVersion(cc);
    return node.getCCVersion(cc);
  }
  /**
   * Retrieves the maximum version of a command class that can be used to communicate with a node.
   * Returns the highest implemented version if the node's CC version is unknown.
   * Returns `undefined` for CCs that are not implemented in this library yet.
   *
   * @param cc The command class whose version should be retrieved
   * @param nodeId The node for which the CC version should be retrieved
   * @param endpointIndex The endpoint for which the CC version should be retrieved
   */
  getSafeCCVersion(cc, nodeId, endpointIndex = 0) {
    const implementedVersion = (0, import_cc.getImplementedVersion)(cc);
    if (implementedVersion === 0 || implementedVersion === Number.POSITIVE_INFINITY) {
      return void 0;
    }
    const supportedVersion = this.getSupportedCCVersion(cc, nodeId, endpointIndex);
    if (supportedVersion === 0) {
      return implementedVersion;
    }
    return Math.min(supportedVersion, implementedVersion);
  }
  /**
   * Determines whether a CC must be secure for a given node and endpoint.
   *
   * @param ccId The command class in question
   * @param nodeId The node for which the CC security should be determined
   * @param endpointIndex The endpoint for which the CC security should be determined
   */
  isCCSecure(ccId, nodeId, endpointIndex = 0) {
    if (ccId === import_core.CommandClasses.Security || ccId === import_core.CommandClasses["Security 2"]) {
      return true;
    }
    const node = this.controller.nodes.get(nodeId);
    if (!node)
      return false;
    const endpoint = node.getEndpoint(endpointIndex);
    const securityClass = node.getHighestSecurityClass();
    if (securityClass === void 0 || securityClass === import_core.SecurityClass.None) {
      return false;
    }
    const isBasicCC = ccId === import_core.CommandClasses.Basic;
    if ((0, import_core.securityClassIsS2)(securityClass)) {
      return !!this.getSecurityManager2(nodeId) && (isBasicCC || (endpoint ?? node).supportsCC(ccId));
    }
    if (securityClass === import_core.SecurityClass.S0_Legacy) {
      return !!this.securityManager && (isBasicCC || (endpoint ?? node).isCCSecure(ccId));
    }
    return false;
  }
  /**
   * **!!! INTERNAL !!!**
   *
   * Not intended to be used by applications.
   * Needed for compatibility with CCAPIHost
   */
  schedulePoll(nodeId, valueId, options) {
    const node = this.controller.nodes.getOrThrow(nodeId);
    return node.schedulePoll(valueId, options);
  }
  isSoftResetting = false;
  maySoftReset() {
    if (this._controller?.sdkVersionGt("7.0"))
      return true;
    const { manufacturerId, productType, productId } = this.controller;
    if (manufacturerId === 277 && productType === 0 && productId === 0) {
      return false;
    }
    if (manufacturerId === 277 && productType === 1024 && productId === 1) {
      return false;
    }
    if (manufacturerId === 265 && productType === 4097 && productId === 513) {
      return false;
    }
    return !!this._options.features.softReset;
  }
  /**
   * Soft-resets the controller if the feature is enabled
   */
  async trySoftReset() {
    if (this.maySoftReset()) {
      await this.softReset();
    } else {
      const message = `The controller should not or cannot be soft reset, skipping API call.`;
      this.controllerLog.print(message, "warn");
    }
  }
  /**
   * Instruct the controller to soft-reset.
   *
   * **Warning:** USB modules will reconnect, meaning that they might get a new address.
   *
   * **Warning:** This call will throw if soft-reset is not enabled.
   */
  async softReset() {
    if (!this.maySoftReset()) {
      const message = `The controller does not support soft reset or the soft reset feature has been disabled with a config option or the ZWAVEJS_DISABLE_SOFT_RESET environment variable.`;
      this.controllerLog.print(message, "error");
      throw new import_core.ZWaveError(message, import_core.ZWaveErrorCodes.Driver_FeatureDisabled);
    }
    if (this._controller?.isAnyOTAFirmwareUpdateInProgress()) {
      const message = `Failed to soft reset controller: A firmware update is in progress on this network.`;
      this.controllerLog.print(message, "error");
      throw new import_core.ZWaveError(message, import_core.ZWaveErrorCodes.FirmwareUpdateCC_NetworkBusy);
    }
    return this.softResetInternal(true);
  }
  async softResetInternal(destroyOnError) {
    this.controllerLog.print("Performing soft reset...");
    try {
      this.isSoftResetting = true;
      await this.sendMessage(new import_serialapi.SoftResetRequest(), {
        supportCheck: false,
        pauseSendThread: true
      });
    } catch (e) {
      this.controllerLog.print(`Soft reset failed: ${(0, import_shared.getErrorMessage)(e)}`, "error");
      if ((0, import_core.isMissingControllerACK)(e)) {
        this.isSoftResetting = false;
        throw e;
      }
    }
    if (this._controller) {
      this._controller["_nodeIdType"] = import_core.NodeIDType.Short;
      this._controller.setInclusionState(import_Inclusion.InclusionState.Idle);
    }
    if (!await this.ensureSerialAPI()) {
      if (destroyOnError) {
        await this.destroy();
      } else {
        throw new import_core.ZWaveError("The Serial API did not respond after soft-reset", import_core.ZWaveErrorCodes.Driver_Failed);
      }
    }
    this.isSoftResetting = false;
    if (!this._enteringBootloader) {
      if (this.options.features.watchdog) {
        void this._controller?.startWatchdog();
      }
      void this._controller?.trySetNodeIDType(import_core.NodeIDType.Long);
      this.unpauseSendQueue();
    }
  }
  /** Soft-reset the Z-Wave module and restart the driver instance */
  async softResetAndRestart() {
    this.controllerLog.print("Performing soft reset...");
    try {
      this.isSoftResetting = true;
      await this.sendMessage(new import_serialapi.SoftResetRequest(), {
        supportCheck: false,
        pauseSendThread: true
      });
    } catch (e) {
      this.controllerLog.print(`Soft reset failed: ${(0, import_shared.getErrorMessage)(e)}`, "error");
    }
    if (!await this.ensureSerialAPI()) {
      await this.destroyWithMessage("The Serial API did not respond after soft-reset");
    }
    this.isSoftResetting = false;
    await this.destroyController();
    void this.initializeControllerAndNodes();
  }
  /**
   * Checks whether recovering an unresponsive controller is enabled
   * and whether the driver is in a state where it makes sense.
   */
  mayRecoverUnresponsiveController() {
    if (!this._options.features.unresponsiveControllerRecovery) {
      return false;
    }
    return this._controllerInterviewed;
  }
  async ensureSerialAPI() {
    this.controllerLog.print("Waiting for the controller to reconnect...");
    let waitResult = await this.waitForMessage((msg) => msg.functionType === import_serial.FunctionType.SerialAPIStarted, 1500).catch(() => false);
    if (waitResult) {
      this.controllerLog.print("reconnected and restarted");
      if (this._controller) {
        this._controller["_supportsLongRange"] = waitResult.supportsLongRange;
      }
      return true;
    }
    if (!this.serial.isOpen) {
      this.controllerLog.print("Re-opening serial port...");
      try {
        await this.openSerialport();
      } catch {
        return false;
      }
    }
    this.controllerLog.print("Waiting for the Serial API to start...");
    waitResult = await this.waitForMessage((msg) => {
      return msg.functionType === import_serial.FunctionType.SerialAPIStarted;
    }, this._options.timeouts.serialAPIStarted).catch(() => false);
    if (waitResult) {
      this.controllerLog.print("Serial API started");
      if (this._controller) {
        this._controller["_supportsLongRange"] = waitResult.supportsLongRange;
      }
      return true;
    }
    this.controllerLog.print("Did not receive notification that Serial API has started, checking if it responds...");
    const pollController = /* @__PURE__ */ __name(async () => {
      try {
        this.unpauseSendQueue();
        await this.sendMessage(new import_serialapi.GetControllerVersionRequest(), {
          supportCheck: false,
          priority: import_core.MessagePriority.ControllerImmediate
        });
        this.pauseSendQueue();
        this.controllerLog.print("Serial API responded");
        return true;
      } catch {
        return false;
      }
    }, "pollController");
    if (await pollController())
      return true;
    for (const backoff of [2, 5, 10, 15]) {
      this.controllerLog.print(`Serial API did not respond, trying again in ${backoff} seconds...`);
      await (0, import_async.wait)(backoff * 1e3);
      if (await pollController())
        return true;
    }
    this.controllerLog.print("Serial API did not respond, giving up", "error");
    return false;
  }
  _ensureCLIReadyPromise;
  async ensureCLIReady() {
    if (this._ensureCLIReadyPromise)
      return this._ensureCLIReadyPromise;
    this._ensureCLIReadyPromise = (0, import_deferred_promise.createDeferredPromise)();
    this.controllerLog.print("Waiting for the CLI to be ready...");
    await (0, import_async.wait)(250);
    for (let i = 0; ; i++) {
      try {
        await this.cli.detectCommands();
        this.controllerLog.print("CLI started");
        this._ensureCLIReadyPromise?.resolve(true);
        this._ensureCLIReadyPromise = void 0;
        return true;
      } catch {
        if (i === 2) {
          this.controllerLog.print("CLI did not respond, giving up", "error");
          this._ensureCLIReadyPromise?.resolve(false);
          this._ensureCLIReadyPromise = void 0;
          return false;
        }
        await (0, import_async.wait)(1e3);
      }
    }
  }
  /**
   * Performs a hard reset on the controller. This wipes out all configuration!
   *
   * The returned Promise resolves when the hard reset has been performed.
   * It does not wait for the initialization process which is started afterwards.
   */
  async hardReset() {
    this.ensureReady(true);
    if (this.controller.isAnyOTAFirmwareUpdateInProgress()) {
      const message = `Failed to hard reset controller: A firmware update is in progress on this network.`;
      this.controllerLog.print(message, "error");
      throw new import_core.ZWaveError(message, import_core.ZWaveErrorCodes.FirmwareUpdateCC_NetworkBusy);
    }
    const oldPrivateKey = this.cacheGet(import_NetworkCache.cacheKeys.controller.privateKey);
    await this.scheduler.removeTasks(() => true, new import_core.ZWaveError("The controller is being hard-reset", import_core.ZWaveErrorCodes.Driver_TaskRemoved));
    await this.controller.setControllerNIF();
    await this.controller.hardReset();
    await this.destroyController();
    void this.initializeControllerAndNodes();
    if (oldPrivateKey) {
      this.once("driver ready", () => {
        this.cacheSet(import_NetworkCache.cacheKeys.controller.privateKey, oldPrivateKey);
      });
    }
  }
  /**
   * Instructs the Z-Wave API to shut down in order to safely remove the power.
   * This will destroy the driver instance if it succeeds.
   */
  async shutdown() {
    this.ensureReady(true);
    if (this.controller.isAnyOTAFirmwareUpdateInProgress()) {
      const message = `Failed to shut down controller: A firmware update is in progress on this network.`;
      this.controllerLog.print(message, "error");
      throw new import_core.ZWaveError(message, import_core.ZWaveErrorCodes.FirmwareUpdateCC_NetworkBusy);
    }
    const result = await this.controller.shutdown();
    try {
      if (result)
        await this.destroy();
    } finally {
      return result;
    }
  }
  _destroyPromise;
  get wasDestroyed() {
    return !!this._destroyPromise;
  }
  /**
   * Ensures that the driver is ready to communicate (serial port open and not destroyed).
   * If desired, also checks that the controller interview has been completed.
   */
  ensureReady(includingController = false) {
    if (!this._wasStarted || !this._isOpen || this.wasDestroyed) {
      throw new import_core.ZWaveError("The driver is not ready or has been destroyed", import_core.ZWaveErrorCodes.Driver_NotReady);
    }
    if (includingController && !this._controllerInterviewed) {
      throw new import_core.ZWaveError("The controller is not ready yet", import_core.ZWaveErrorCodes.Driver_NotReady);
    }
    if (this._bootloader) {
      throw new import_core.ZWaveError("Cannot do this while in bootloader mode", import_core.ZWaveErrorCodes.Driver_NotReady);
    }
  }
  /** Indicates whether the driver is ready, i.e. the "driver ready" event was emitted */
  get ready() {
    return this._wasStarted && this._isOpen && !this.wasDestroyed && this._controllerInterviewed;
  }
  async destroyWithMessage(message) {
    this.driverLog.print(message, "error");
    const error = new import_core.ZWaveError(message, import_core.ZWaveErrorCodes.Driver_Failed);
    this.emit("error", error);
    await this.destroy();
  }
  /**
   * Terminates the driver instance and closes the underlying serial connection.
   * Must be called under any circumstances.
   */
  async destroy() {
    if (this._destroyPromise)
      return this._destroyPromise;
    this._destroyPromise = (0, import_deferred_promise.createDeferredPromise)();
    this.driverLog.print("destroying driver instance...");
    await this._scheduler.stop();
    await this.destroyTransactionQueues("driver instance destroyed", import_core.ZWaveErrorCodes.Driver_Destroyed);
    this.destroySerialAPIQueue("driver instance destroyed", import_core.ZWaveErrorCodes.Driver_Destroyed);
    if (this.serial != void 0) {
      if (this.serial.isOpen)
        await this.serial.close();
      this.serial = void 0;
    }
    await this.destroyController();
    this.driverLog.print(`driver instance destroyed`);
    this._logContainer.destroy();
    this._destroyPromise.resolve();
  }
  /** Cleanly destroy the controller instance, but not the entire driver */
  // FIXME: Too much overlap with destroy()
  async destroyController() {
    await this.scheduler.removeTasks(() => true, new import_core.ZWaveError("The controller instance is being destroyed", import_core.ZWaveErrorCodes.Driver_TaskRemoved));
    await this.destroyTransactionQueues("The controller instance is being destroyed", import_core.ZWaveErrorCodes.Driver_TaskRemoved);
    this.destroySerialAPIQueue("The controller instance is being destroyed", import_core.ZWaveErrorCodes.Driver_TaskRemoved);
    this.requestHandlers.clear();
    await this.closeDatabases();
    this.clearAllTimeouts();
    if (this._controller) {
      this._controller.destroy();
      this._controller = void 0;
    }
    this._controllerInterviewed = false;
    this._nodesReady.clear();
    this._nodesReadyEventEmitted = false;
  }
  async closeDatabases() {
    try {
      await this._valueDB?.close();
    } catch (e) {
      this.driverLog.print(`Closing the value DB failed: ${(0, import_shared.getErrorMessage)(e)}`, "error");
    }
    try {
      await this._metadataDB?.close();
    } catch (e) {
      this.driverLog.print(`Closing the metadata DB failed: ${(0, import_shared.getErrorMessage)(e)}`, "error");
    }
    try {
      await this._networkCache?.close();
    } catch (e) {
      this.driverLog.print(`Closing the network cache failed: ${(0, import_shared.getErrorMessage)(e)}`, "error");
    }
  }
  clearAllTimeouts() {
    for (const timeout of [
      this._powerlevelTestNodeContext?.timeout
    ]) {
      if (timeout)
        clearTimeout(timeout);
    }
    for (const timeout of [
      ...this.retryNodeInterviewTimeouts.values(),
      ...this.autoRefreshNodeValueTimers.values(),
      this.statisticsTimeout,
      this.pollBackgroundRSSITimer,
      ...this.sendNodeToSleepTimers.values(),
      ...this.awaitedCommands.map((c) => c.timeout),
      ...this.awaitedMessages.map((m) => m.timeout),
      ...this.awaitedMessageHeaders.map((h) => h.timeout),
      ...this.awaitedBootloaderChunks.map((b) => b.timeout),
      ...this.awaitedCLIChunks.map((c) => c.timeout),
      ...[...this.requeueTimers.values()].flatMap((t) => [...t.values()])
    ]) {
      timeout?.clear();
    }
  }
  async handleSerialData(serial) {
    try {
      for await (const frame of serial.readable) {
        setImmediate(() => {
          if (frame.type === import_serial.ZWaveSerialFrameType.SerialAPI) {
            void this.serialport_onData(frame.data);
          } else if (frame.type === import_serial.ZWaveSerialFrameType.Bootloader) {
            void this.serialport_onBootloaderData(frame.data);
          } else if (frame.type === import_serial.ZWaveSerialFrameType.CLI) {
            void this.serialport_onCLIData(frame.data);
          } else {
          }
        });
      }
    } catch (e) {
      if ((0, import_shared.isAbortError)(e))
        return;
      if ((0, import_core.isZWaveError)(e) && e.code === import_core.ZWaveErrorCodes.Driver_SerialPortClosed) {
        if (this.isSoftResetting || this._isOpeningSerialPort)
          return;
        void this.handleSerialPortClosedUnexpectedly();
        return;
      }
      throw e;
    }
  }
  async handleSerialPortClosedUnexpectedly() {
    this.driverLog.print("Serial port closed unexpectedly, attempting to reopen...", "warn");
    await (0, import_async.wait)(1e3);
    try {
      await this.openSerialport();
    } catch (ee) {
      void this.destroyWithMessage((0, import_shared.getErrorMessage)(ee));
      return;
    }
    this.driverLog.print("Serial port reopened", "warn");
  }
  /**
   * Is called when the serial port has received a single-byte message or a complete message buffer
   */
  async serialport_onData(data) {
    if (typeof data === "number") {
      switch (data) {
        case import_serial.MessageHeaders.ACK:
        case import_serial.MessageHeaders.NAK:
        case import_serial.MessageHeaders.CAN: {
          for (const entry of this.awaitedMessageHeaders) {
            if (entry.predicate(data)) {
              entry.handler(data);
              break;
            }
          }
          return;
        }
      }
    }
    this._cli = void 0;
    this._bootloader = void 0;
    let msg;
    try {
      msg = import_serial.Message.parse(data, this.getMessageParsingContext());
      if ((0, import_serialapi.isCommandRequest)(msg) && (0, import_serialapi.containsSerializedCC)(msg)) {
        msg.command = await import_cc.CommandClass.parse(msg.serializedCC, {
          ...this.getCCParsingContext(),
          sourceNodeId: msg.getNodeId(),
          frameType: msg.frameType
        });
        const node = this.tryGetNode(msg);
        if (node)
          node.lastSeen = /* @__PURE__ */ new Date();
        assertValidCCs(msg);
      }
      if (!!this._controller) {
        if ((0, import_serialapi.containsCC)(msg)) {
          this.tryGetNode(msg)?.incrementStatistics("commandsRX");
        } else {
          this._controller.incrementStatistics("messagesRX");
        }
      }
      await this.writeHeader(import_serial.MessageHeaders.ACK);
    } catch (e) {
      try {
        if (await this.handleSecurityS2DecodeError(e, msg)) {
        } else {
          const response = this.handleDecodeError(e, data, msg);
          if (response)
            await this.writeHeader(response);
          if (!!this._controller) {
            if ((0, import_serialapi.containsCC)(msg)) {
              this.tryGetNode(msg)?.incrementStatistics("commandsDroppedRX");
              const supervisionSessionId = import_cc.SupervisionCC.getSessionId(msg.command);
              if (supervisionSessionId !== void 0 && msg.command instanceof import_cc.InvalidCC) {
                const node = this.tryGetNode(msg);
                if (node) {
                  const endpoint = node.getEndpoint(msg.command.endpointIndex) ?? node;
                  const encapsulationFlags = msg.command.encapsulationFlags;
                  await endpoint.createAPI(import_core.CommandClasses.Supervision, false).sendReport({
                    sessionId: supervisionSessionId,
                    moreUpdatesFollow: false,
                    status: import_core.SupervisionStatus.NoSupport,
                    requestWakeUpOnDemand: this.shouldRequestWakeupOnDemand(node),
                    encapsulationFlags,
                    lowPriority: this.shouldUseLowPriorityForSupervisionReport(node, encapsulationFlags)
                  });
                }
                return;
              }
            } else {
              this._controller.incrementStatistics("messagesDroppedRX");
            }
          }
        }
      } catch (ee) {
        if (ee instanceof Error) {
          if (/serial port is not open/.test(ee.message)) {
            this.emit("error", ee);
            void this.destroy();
            return;
          }
          this._driverLog.print(ee.stack ?? ee.message, "error");
        }
      }
      msg = void 0;
    }
    if (!this._controller && (0, import_serialapi.containsCC)(msg))
      return;
    if (msg) {
      let wasMessageLogged = false;
      if ((0, import_serialapi.isCommandRequest)(msg) && (0, import_serialapi.containsCC)(msg)) {
        if (msg.command instanceof import_cc.SecurityCCCommandEncapsulationNonceGet) {
          const node = this.tryGetNode(msg);
          if (node) {
            void this.handleSecurityNonceGet(node);
          }
        }
        if ((0, import_cc.isTransportServiceEncapsulation)(msg.command)) {
          this.driverLog.logMessage(msg, {
            secondaryTags: ["partial"],
            direction: "inbound"
          });
          wasMessageLogged = true;
          void this.handleTransportServiceCommand(msg.command).catch(() => {
          });
        }
        if (!await this.assemblePartialCCs(msg)) {
          for (const entry of this.awaitedMessages) {
            if (entry.refreshPredicate?.(msg)) {
              entry.timeout?.refresh();
            }
          }
          return;
        }
        if (this.isSecurityLevelTooLow(msg.command) || this.shouldDiscardCC(msg.command)) {
          if (!wasMessageLogged) {
            this.driverLog.logMessage(msg, {
              direction: "inbound",
              secondaryTags: ["discarded"]
            });
          }
          return;
        }
        try {
          this.persistCCValues(msg.command);
        } catch (e) {
          if ((0, import_core.isZWaveError)(e) && e.code === import_core.ZWaveErrorCodes.PacketFormat_InvalidPayload) {
            this.driverLog.print(`dropping CC with invalid values${typeof e.context === "string" ? ` (Reason: ${e.context})` : ""}`, "warn");
            return;
          } else {
            throw e;
          }
        }
        if ((0, import_cc.isTransportServiceEncapsulation)(msg.command)) {
          msg.command = msg.command.encapsulated;
          wasMessageLogged = false;
        }
      }
      if (!wasMessageLogged) {
        try {
          this.driverLog.logMessage(msg, {
            direction: "inbound"
          });
        } catch (e) {
          this.driverLog.print(`Logging a message failed: ${(0, import_shared.getErrorMessage)(e)}`);
        }
      }
      void this.handleUnsolicitedMessage(msg);
    }
  }
  /** Handles a decoding error and returns the desired reply to the stick */
  handleDecodeError(e, data, msg) {
    if ((0, import_core.isZWaveError)(e)) {
      switch (e.code) {
        case import_core.ZWaveErrorCodes.PacketFormat_Invalid:
        case import_core.ZWaveErrorCodes.PacketFormat_Checksum:
        case import_core.ZWaveErrorCodes.PacketFormat_Truncated:
          this.driverLog.print(`Dropping message because it contains invalid data`, "warn");
          return import_serial.MessageHeaders.NAK;
        case import_core.ZWaveErrorCodes.Deserialization_NotImplemented:
        case import_core.ZWaveErrorCodes.CC_NotImplemented:
          this.driverLog.print(`Dropping message because it could not be deserialized: ${e.message}`, "warn");
          return import_serial.MessageHeaders.ACK;
        case import_core.ZWaveErrorCodes.Driver_NotReady:
          this.driverLog.print(`Dropping message because the driver is not ready to handle it yet.`, "warn");
          return import_serial.MessageHeaders.ACK;
        case import_core.ZWaveErrorCodes.PacketFormat_InvalidPayload:
          if (msg) {
            this.driverLog.print(`Dropping message with invalid payload`, "warn");
            try {
              this.driverLog.logMessage(msg, {
                direction: "inbound"
              });
            } catch (e2) {
              this.driverLog.print(`Logging a message failed: ${(0, import_shared.getErrorMessage)(e2)}`);
            }
          } else {
            this.driverLog.print(`Dropping message with invalid payload${typeof e.context === "string" ? ` (Reason: ${e.context})` : ""}:
${(0, import_shared.buffer2hex)(data)}`, "warn");
          }
          return import_serial.MessageHeaders.ACK;
        case import_core.ZWaveErrorCodes.Driver_NoSecurity:
        case import_core.ZWaveErrorCodes.Security2CC_NotInitialized:
          this.driverLog.print(`Dropping message because network keys are not set or the driver is not yet ready to receive secure messages.`, "warn");
          return import_serial.MessageHeaders.ACK;
        case import_core.ZWaveErrorCodes.Controller_NodeNotFound:
          this.driverLog.print(`Dropping message because ${typeof e.context === "number" ? `node ${e.context}` : "the node"} does not exist.`, "warn");
          return import_serial.MessageHeaders.ACK;
      }
    } else {
      if (/database is not open/.test(e.message)) {
        this.driverLog.print(`Dropping message because the driver is not ready to handle it yet.`, "warn");
        return import_serial.MessageHeaders.ACK;
      }
    }
    throw e;
  }
  mustReplyWithSecurityS2MOS(msg) {
    if (msg.frameType !== "singlecast")
      return false;
    const encapS2 = msg.command.getEncapsulatingCC(import_core.CommandClasses["Security 2"], import_cc.Security2Command.MessageEncapsulation);
    if (!encapS2)
      return false;
    const node = this.tryGetNode(msg);
    if (!node)
      return false;
    const groupId = encapS2.getMulticastGroupId();
    if (groupId == void 0)
      return false;
    const securityManager = this.getSecurityManager2(node.id);
    if (
      // but where we don't have an MPAN stored
      securityManager?.getPeerMPAN(msg.command.nodeId, groupId).type !== import_core.MPANState.MPAN
    ) {
      return true;
    }
    return false;
  }
  async handleSecurityS2DecodeError(e, msg) {
    if (!(0, import_core.isZWaveError)(e))
      return false;
    if ((e.code === import_core.ZWaveErrorCodes.Security2CC_NoSPAN || e.code === import_core.ZWaveErrorCodes.Security2CC_CannotDecode) && (0, import_serialapi.containsCC)(msg)) {
      const nodeId = msg.getNodeId();
      const node = this._controller?.nodes.get(nodeId);
      if (!node)
        return false;
      await this.writeHeader(import_serial.MessageHeaders.ACK);
      this.driverLog.logMessage(msg, { direction: "inbound" });
      node.incrementStatistics("commandsDroppedRX");
      if (node.interviewStage < import_Types2.InterviewStage.NodeInfo) {
        node.addCC(import_core.CommandClasses["Security 2"], {
          isSupported: true,
          version: 1
        });
      }
      const isS2NonceReport = /* @__PURE__ */ __name((t) => t.message.getNodeId() === nodeId && (0, import_serialapi.containsCC)(t.message) && t.message.command instanceof import_cc.Security2CCNonceReport, "isS2NonceReport");
      const message = e.code === import_core.ZWaveErrorCodes.Security2CC_CannotDecode ? "Message authentication failed" : "No SPAN is established yet";
      if (this.controller.bootstrappingS2NodeId === nodeId) {
        const securityManager = this.getSecurityManager2(nodeId);
        if (securityManager?.tempKeys.has(nodeId)) {
          if (securityManager.getSPANState(nodeId).type === import_core.SPANState.None) {
            this.controllerLog.logNode(nodeId, {
              message: `${message}, cannot decode command. Requesting a nonce...`,
              level: "verbose",
              direction: "outbound"
            });
            node.commandClasses["Security 2"].sendNonce().catch(() => {
            });
          } else {
            this.controllerLog.logNode(nodeId, {
              message: `${message}, cannot decode command. Aborting the S2 bootstrapping process...`,
              level: "error",
              direction: "inbound"
            });
            this.controller.cancelSecureBootstrapS2(import_cc.KEXFailType.BootstrappingCanceled);
          }
        } else {
          this.controllerLog.logNode(nodeId, {
            message: `Ignoring KEXSet because the DSK has not been verified yet`,
            level: "verbose",
            direction: "inbound"
          });
        }
      } else if (!this.hasPendingTransactions(isS2NonceReport)) {
        this.controllerLog.logNode(nodeId, {
          message: `${message}, cannot decode command. Requesting a nonce...`,
          level: "verbose",
          direction: "outbound"
        });
        const s2MulticastOutOfSync = (0, import_serialapi.isCommandRequest)(msg) && this.mustReplyWithSecurityS2MOS(msg);
        node.commandClasses["Security 2"].withOptions({ s2MulticastOutOfSync }).sendNonce().catch(() => {
        });
      } else {
        this.controllerLog.logNode(nodeId, {
          message: `${message}, cannot decode command.`,
          level: "verbose",
          direction: "none"
        });
      }
      return true;
    } else if ((e.code === import_core.ZWaveErrorCodes.Security2CC_NoMPAN || e.code === import_core.ZWaveErrorCodes.Security2CC_CannotDecodeMulticast) && (0, import_serialapi.containsCC)(msg)) {
      const nodeId = msg.getNodeId();
      const node = this._controller?.nodes.get(nodeId);
      if (!node)
        return false;
      await this.writeHeader(import_serial.MessageHeaders.ACK);
      this.driverLog.logMessage(msg, { direction: "inbound" });
      node.incrementStatistics("commandsDroppedRX");
      this.controllerLog.logNode(nodeId, {
        message: `Cannot decode S2 multicast command, since MPAN is not known yet. Will attempt re-sync after the next singlecast.`,
        level: "verbose"
      });
      return true;
    }
    return false;
  }
  /** Checks if a transaction failed because a node didn't respond in time */
  isMissingNodeACK(transaction, e) {
    return (
      // If the node does not acknowledge our request, it is either asleep or dead
      e.code === import_core.ZWaveErrorCodes.Controller_CallbackNOK && (transaction.message instanceof import_serialapi.SendDataRequest || transaction.message instanceof import_serialapi.SendDataBridgeRequest)
    );
  }
  /**
   * @internal
   * Handles the case that a node failed to respond in time.
   * Returns `true` if the transaction failure was handled, `false` if it needs to be rejected.
   */
  handleMissingNodeACK(transaction, error) {
    const node = this.tryGetNode(transaction.message);
    if (!node)
      return false;
    const messagePart1 = (0, import_serialapi.isSendData)(transaction.message) ? `The node did not respond after ${transaction.message.maxSendAttempts} attempts` : `The node did not respond`;
    if (!transaction.changeNodeStatusOnTimeout) {
      return false;
    } else if (node.canSleep) {
      if (node.status === import_Types2.NodeStatus.Asleep) {
        return false;
      }
      this.controllerLog.logNode(node.id, `${messagePart1}. It is probably asleep, moving its messages to the wakeup queue.`, "warn");
      const handled = this.mayMoveToWakeupQueue(transaction);
      if (handled) {
        this.queue.add(transaction);
      }
      node.markAsAsleep();
      return handled;
    } else {
      const errorMsg = `${messagePart1}, it is presumed dead`;
      this.controllerLog.logNode(node.id, errorMsg, "warn");
      node.markAsDead();
      transaction.setProgress({
        state: import_core.TransactionState.Failed,
        reason: errorMsg
      });
      transaction.abort(error);
      void this.rejectAllTransactionsForNode(node.id, errorMsg);
      return true;
    }
  }
  /**
   * @internal
   * Handles the case that the controller didn't acknowledge a command in time
   * Returns `true` if the transaction failure was handled, `false` if it needs to be rejected.
   */
  handleMissingControllerACK(transaction, error) {
    if (!this._controller || !this.mayRecoverUnresponsiveController()) {
      return false;
    }
    const recoverByReopeningSerialport = /* @__PURE__ */ __name(async () => {
      if (!this.serial)
        return;
      this.driverLog.print("Attempting to recover unresponsive controller by reopening the serial port...", "warn");
      if (this.serial.isOpen)
        await this.serial.close();
      await (0, import_async.wait)(1e3);
      await this.openSerialport();
      this.driverLog.print("Serial port reopened. Returning to normal operation and hoping for the best...", "warn");
      this._controller?.setStatus(import_core.ControllerStatus.Ready);
      this._recoveryPhase = 0;
    }, "recoverByReopeningSerialport");
    if (this._controller.status !== import_core.ControllerStatus.Unresponsive && !this.maySoftReset() || this._recoveryPhase === 2) {
      void recoverByReopeningSerialport().catch(import_shared.noop);
      return true;
    } else if (this._controller.status !== import_core.ControllerStatus.Unresponsive) {
      this.controller.setStatus(import_core.ControllerStatus.Unresponsive);
      this._recoveryPhase = 1;
      this.driverLog.print("Attempting to recover unresponsive controller by restarting it...", "warn");
      void this.softReset().then(() => {
        transaction.reset();
        this.getQueueForTransaction(transaction).add(transaction.clone());
        this._controller?.setStatus(import_core.ControllerStatus.Ready);
        this._recoveryPhase = 0;
      }).catch(() => {
        this.rejectTransaction(transaction, error);
        return recoverByReopeningSerialport();
      });
      return true;
    } else {
      return false;
    }
  }
  /**
   * @internal
   * Handles the case that the controller didn't send the callback for a SendData in time
   * Returns `true` if the transaction failure was handled, `false` if it needs to be rejected.
   */
  handleMissingSendDataResponseOrCallback(transaction, error) {
    if (!this._controller || !this.mayRecoverUnresponsiveController()) {
      return false;
    }
    if (
      // The SendData response can time out on older controllers trying to reach a dead node.
      // In this case, we do not want to reset the controller, but just mark the node as dead.
      error.context === "response" || this._recoveryPhase === 4
    ) {
      const node = this.tryGetNode(transaction.message);
      if (!node)
        return false;
      const messagePart1 = "The node is causing the controller to become unresponsive";
      let handled;
      if (node.canSleep) {
        if (node.status === import_Types2.NodeStatus.Asleep) {
          return false;
        }
        this.controllerLog.logNode(node.id, `${messagePart1}. It is probably asleep, moving its messages to the wakeup queue.`, "warn");
        handled = this.mayMoveToWakeupQueue(transaction);
        if (handled) {
          this.queue.add(transaction);
        }
        node.markAsAsleep();
      } else {
        const errorMsg = `${messagePart1}, it is presumed dead`;
        this.controllerLog.logNode(node.id, errorMsg, "warn");
        node.markAsDead();
        transaction.setProgress({
          state: import_core.TransactionState.Failed,
          reason: errorMsg
        });
        transaction.abort(error);
        void this.rejectAllTransactionsForNode(node.id, errorMsg);
        handled = true;
      }
      if (this._recoveryPhase === 4) {
        this.driverLog.print("Attempting to recover controller again...", "warn");
        void this.softResetInternal(true).catch(() => {
          this.driverLog.print("Automatic controller recovery failed. Returning to normal operation and hoping for the best.", "warn");
        }).finally(() => {
          this._recoveryPhase = 0;
          this._controller?.setStatus(import_core.ControllerStatus.Ready);
        });
      }
      return handled;
    } else if (this._controller.status !== import_core.ControllerStatus.Unresponsive) {
      if (this.maySoftReset()) {
        this.controller.setStatus(import_core.ControllerStatus.Unresponsive);
        this._recoveryPhase = 3;
        this.driverLog.print("Controller missed Send Data callback. Attempting to recover...", "warn");
        void this.softResetInternal(true).then(() => {
          transaction.reset();
          this.getQueueForTransaction(transaction).add(transaction.clone());
          this._controller?.setStatus(import_core.ControllerStatus.Ready);
          this._recoveryPhase = 4;
        }).catch(() => {
          this.rejectTransaction(transaction, error);
          this.driverLog.print("Automatic controller recovery failed. Returning to normal operation and hoping for the best.", "warn");
          this._recoveryPhase = 0;
          this._controller?.setStatus(import_core.ControllerStatus.Ready);
        });
      } else {
        this.driverLog.print("Controller missed Send Data callback. Cannot recover automatically because the soft reset feature is unsupported or disabled. Returning to normal operation and hoping for the best...", "warn");
        this.rejectTransaction(transaction, error);
      }
      return true;
    } else {
      return false;
    }
  }
  /**
   * @internal
   * Handles the case that the controller locks up and fails to transmit continuously
   */
  handleJammedController(transaction, error) {
    if (!this._controller || !this.mayRecoverUnresponsiveController()) {
      return false;
    }
    if (
      // Transmits still fail even after restarting the controller
      this._recoveryPhase === 6
    ) {
      this.driverLog.print("Automatic controller recovery failed. Returning to normal operation and hoping for the best.", "warn");
      this._recoveryPhase = 0;
      this._controller.setStatus(import_core.ControllerStatus.Ready);
      return false;
    } else if (this._controller.status === import_core.ControllerStatus.Jammed) {
      if (this.controller.sdkVersionLt("7.0")) {
        this.driverLog.print("Cannot recover jammed controller automatically. Returning to normal operation and hoping for the best...", "warn");
        this._controller?.setStatus(import_core.ControllerStatus.Ready);
        this.rejectTransaction(transaction, error);
      } else if (this.maySoftReset()) {
        this._recoveryPhase = 5;
        this.driverLog.print("Attempting to recover jammed controller...", "warn");
        void this.softReset().then(() => {
          transaction.reset();
          this.getQueueForTransaction(transaction).add(transaction.clone());
          this._recoveryPhase = 6;
        }).catch(() => {
          this.rejectTransaction(transaction, error);
          this.driverLog.print("Automatic controller recovery failed. Returning to normal operation and hoping for the best.", "warn");
          this._recoveryPhase = 0;
          this._controller?.setStatus(import_core.ControllerStatus.Ready);
        });
      } else {
        this.driverLog.print("Cannot recover jammed controller automatically because the soft reset feature is unsupported or disabled. Returning to normal operation and hoping for the best...", "warn");
        this._controller?.setStatus(import_core.ControllerStatus.Ready);
        this.rejectTransaction(transaction, error);
      }
      return true;
    } else {
      return false;
    }
  }
  shouldRequestWakeupOnDemand(node) {
    return !!node.supportsWakeUpOnDemand && node.status === import_Types2.NodeStatus.Asleep && this.hasPendingTransactions((t) => t.requestWakeUpOnDemand && t.message.getNodeId() === node.id);
  }
  partialCCSessions = /* @__PURE__ */ new Map();
  getPartialCCSession(command, createIfMissing) {
    const sessionId = command.getPartialCCSessionId();
    if (sessionId) {
      const partialSessionKey = JSON.stringify({
        nodeId: command.nodeId,
        ccId: command.ccId,
        ccCommand: command.ccCommand,
        ...sessionId
      });
      if (createIfMissing && !this.partialCCSessions.has(partialSessionKey)) {
        this.partialCCSessions.set(partialSessionKey, []);
      }
      return {
        partialSessionKey,
        session: this.partialCCSessions.get(partialSessionKey)
      };
    }
  }
  /**
   * Assembles partial CCs of in a message body. Returns `true` when the message is complete and can be handled further.
   * If the message expects another partial one, this returns `false`.
   */
  async assemblePartialCCs(msg) {
    let command = msg.command;
    while (true) {
      const { partialSessionKey, session } = this.getPartialCCSession(command, true) ?? {};
      if (session) {
        if (command.expectMoreMessages(session)) {
          session.push(command);
          if (!(0, import_cc.isTransportServiceEncapsulation)(msg.command)) {
            this.driverLog.logMessage(msg, {
              secondaryTags: ["partial"],
              direction: "inbound"
            });
          }
          return false;
        } else {
          this.partialCCSessions.delete(partialSessionKey);
          try {
            await command.mergePartialCCs(session, {
              ...this.getCCParsingContext(),
              sourceNodeId: msg.command.nodeId,
              frameType: msg.frameType
            });
            assertValidCCs(msg);
          } catch (e) {
            if ((0, import_core.isZWaveError)(e)) {
              switch (e.code) {
                case import_core.ZWaveErrorCodes.Deserialization_NotImplemented:
                case import_core.ZWaveErrorCodes.CC_NotImplemented:
                  this.driverLog.print(`Dropping message because it could not be deserialized: ${e.message}`, "warn");
                  return false;
                case import_core.ZWaveErrorCodes.PacketFormat_InvalidPayload:
                  this.driverLog.print(`Could not assemble partial CCs because the payload is invalid. Dropping them.`, "warn");
                  return false;
                case import_core.ZWaveErrorCodes.Driver_NotReady:
                  this.driverLog.print(`Could not assemble partial CCs because the driver is not ready yet. Dropping them`, "warn");
                  return false;
              }
            }
            throw e;
          }
        }
      } else {
      }
      if ((0, import_cc.isEncapsulatingCommandClass)(command)) {
        command = command.encapsulated;
      } else {
        break;
      }
    }
    return true;
  }
  /** Is called when a Transport Service command is received */
  async handleTransportServiceCommand(command) {
    const nodeSessions = this.ensureNodeSessions(command.nodeId);
    const missingSegmentTimeout = import_cc.TransportServiceTimeouts.requestMissingSegmentR2;
    const advanceTransportServiceSession = /* @__PURE__ */ __name(async (session, input) => {
      const machine = session.machine;
      const transition = machine.next(input);
      if (transition) {
        machine.transition(transition.newState);
        if (machine.state.value === "receive") {
          startMissingSegmentTimeout(session);
        } else if (machine.state.value === "requestMissing") {
          this.controllerLog.logNode(command.nodeId, {
            message: `Transport Service RX session #${command.sessionId}: Segment with offset ${machine.state.offset} missing - requesting it...`,
            level: "debug",
            direction: "outbound"
          });
          const cc = new import_cc.TransportServiceCCSegmentRequest({
            nodeId: command.nodeId,
            sessionId: command.sessionId,
            datagramOffset: machine.state.offset
          });
          await this.sendCommand(cc, {
            maxSendAttempts: 1,
            priority: import_core.MessagePriority.Immediate
          }).catch(import_shared.noop);
          startMissingSegmentTimeout(session);
        } else if (machine.state.value === "failure") {
          this.controllerLog.logNode(command.nodeId, {
            message: `Transport Service RX session #${command.sessionId} failed`,
            level: "error",
            direction: "none"
          });
          nodeSessions.transportService.delete(command.sessionId);
          if (session.timeout) {
            clearTimeout(session.timeout);
          }
        }
      }
      if (machine.state.value === "success") {
        this.controllerLog.logNode(command.nodeId, {
          message: `Transport Service RX session #${command.sessionId} complete`,
          level: "debug",
          direction: "inbound"
        });
        if (session.timeout) {
          clearTimeout(session.timeout);
        }
        const cc = new import_cc.TransportServiceCCSegmentComplete({
          nodeId: command.nodeId,
          sessionId: command.sessionId
        });
        await this.sendCommand(cc, {
          maxSendAttempts: 1,
          priority: import_core.MessagePriority.Immediate
        }).catch(import_shared.noop);
      }
    }, "advanceTransportServiceSession");
    function startMissingSegmentTimeout(session) {
      if (session.timeout) {
        clearTimeout(session.timeout);
      }
      session.timeout = setTimeout(() => {
        session.timeout = void 0;
        void advanceTransportServiceSession(session, {
          value: "timeout"
        });
      }, missingSegmentTimeout);
    }
    __name(startMissingSegmentTimeout, "startMissingSegmentTimeout");
    if (command instanceof import_cc.TransportServiceCCFirstSegment) {
      nodeSessions.transportService.clear();
      this.controllerLog.logNode(command.nodeId, {
        message: `Beginning Transport Service RX session #${command.sessionId}...`,
        level: "debug",
        direction: "inbound"
      });
      const machine = (0, import_TransportServiceMachine.createTransportServiceRXMachine)(command.datagramSize, command.partialDatagram.length);
      const session = {
        fragmentSize: command.partialDatagram.length,
        machine
      };
      nodeSessions.transportService.set(command.sessionId, session);
      startMissingSegmentTimeout(session);
    } else {
      const transportSession = nodeSessions.transportService.get(command.sessionId);
      if (transportSession) {
        await advanceTransportServiceSession(transportSession, {
          value: "segment",
          offset: command.datagramOffset,
          length: command.partialDatagram.length
        });
      } else {
        const cc = new import_cc.TransportServiceCCSegmentWait({
          nodeId: command.nodeId,
          pendingSegments: 0
        });
        await this.sendCommand(cc, {
          maxSendAttempts: 1,
          priority: import_core.MessagePriority.Immediate
        }).catch(import_shared.noop);
      }
    }
  }
  /**
   * Is called when a message is received that does not belong to any ongoing transactions
   * @param msg The decoded message
   */
  async handleUnsolicitedMessage(msg) {
    try {
      if (msg.type === import_serial.MessageType.Request) {
        await this.handleRequest(msg);
      } else {
        await this.handleResponse(msg);
      }
    } catch (e) {
      if ((0, import_core.isZWaveError)(e) && e.code === import_core.ZWaveErrorCodes.Driver_NotReady) {
        this.driverLog.print(`Cannot handle message because the driver is not ready to handle it yet.`, "warn");
      } else {
        throw e;
      }
    }
  }
  /**
   * Is called when the Serial API restart unexpectedly.
   */
  async handleSerialAPIStartedUnexpectedly(msg) {
    switch (msg.wakeUpReason) {
      // All wakeup reasons that indicate a reset of the Serial API
      // need to be handled here, so we interpret node IDs correctly.
      case import_serialapi.SerialAPIWakeUpReason.Reset:
      case import_serialapi.SerialAPIWakeUpReason.WatchdogReset:
      case import_serialapi.SerialAPIWakeUpReason.SoftwareReset:
      case import_serialapi.SerialAPIWakeUpReason.PowerUp:
      case import_serialapi.SerialAPIWakeUpReason.EmergencyWatchdogReset:
      case import_serialapi.SerialAPIWakeUpReason.BrownoutCircuit: {
        this.controllerLog.print(`Serial API restarted unexpectedly.`, "warn");
        if (this.abortSerialAPICommand) {
          this.controllerLog.print(`Currently active command will be retried...`, "warn");
          this.abortSerialAPICommand.reject(new import_core.ZWaveError("The Serial API restarted unexpectedly", import_core.ZWaveErrorCodes.Controller_Reset));
        }
        if (this.options.features.watchdog) {
          await this._controller?.startWatchdog();
        }
        if (this._controller?.nodeIdType === import_core.NodeIDType.Long) {
          this._controller.nodeIdType = import_core.NodeIDType.Short;
          await this._controller.trySetNodeIDType(import_core.NodeIDType.Long);
        }
        return true;
      }
    }
    return false;
  }
  /**
   * Registers a handler for messages that are not handled by the driver as part of a message exchange.
   * The handler function needs to return a boolean indicating if the message has been handled.
   * Registered handlers are called in sequence until a handler returns `true`.
   *
   * @param fnType The function type to register the handler for
   * @param handler The request handler callback
   * @param oneTime Whether the handler should be removed after its first successful invocation
   */
  registerRequestHandler(fnType, handler, oneTime = false) {
    const handlers = this.requestHandlers.has(fnType) ? this.requestHandlers.get(fnType) : [];
    const entry = { invoke: handler, oneTime };
    handlers.push(entry);
    this.driverLog.print(`added${oneTime ? " one-time" : ""} request handler for ${import_serial.FunctionType[fnType]} (${(0, import_shared.num2hex)(fnType)})...
${handlers.length} registered`);
    this.requestHandlers.set(fnType, handlers);
  }
  /**
   * Unregisters a message handler that has been added with `registerRequestHandler`
   * @param fnType The function type to unregister the handler for
   * @param handler The previously registered request handler callback
   */
  unregisterRequestHandler(fnType, handler) {
    const handlers = this.requestHandlers.has(fnType) ? this.requestHandlers.get(fnType) : [];
    for (let i = 0, entry = handlers[i]; i < handlers.length; i++) {
      if (entry.invoke === handler) {
        handlers.splice(i, 1);
        break;
      }
    }
    this.driverLog.print(`removed request handler for ${import_serial.FunctionType[fnType]} (${fnType})...
${handlers.length} left`);
    this.requestHandlers.set(fnType, handlers);
  }
  /**
   * Checks whether a CC has a lower than expected security level and needs to be discarded
   */
  isSecurityLevelTooLow(cc) {
    const node = this._controller?.nodes.get(cc.nodeId);
    if (!node) {
      this.controllerLog.logNode(cc.nodeId, `is unknown - discarding received command...`, "warn");
      return true;
    }
    if (cc instanceof import_cc.TransportServiceCC)
      return false;
    if (cc instanceof import_cc.CRC16CCCommandEncapsulation) {
      return this.isSecurityLevelTooLow(cc.encapsulated);
    }
    const secClass = node.getHighestSecurityClass();
    if (secClass === import_core.SecurityClass.None || secClass === import_core.SecurityClass.Temporary) {
      return false;
    }
    const expectedSecurityCC = (0, import_core.securityClassIsS2)(secClass) ? import_core.CommandClasses["Security 2"] : secClass === import_core.SecurityClass.S0_Legacy ? import_core.CommandClasses.Security : void 0;
    const isCCConsideredSecure = /* @__PURE__ */ __name((cmd) => {
      if (cmd instanceof import_cc.SecurityCC) {
        switch (cmd.ccCommand) {
          // Cannot be sent encapsulated:
          case import_cc.SecurityCommand.NonceGet:
          case import_cc.SecurityCommand.NonceReport:
          case import_cc.SecurityCommand.SchemeGet:
          case import_cc.SecurityCommand.SchemeReport:
            return true;
        }
        if (cmd instanceof import_cc.SecurityCCCommandEncapsulation) {
          if (cmd.encapsulated instanceof import_cc.SecurityCCCommandsSupportedReport || cmd.encapsulated instanceof import_cc.SecurityCCCommandsSupportedGet) {
            return true;
          }
          return secClass === import_core.SecurityClass.S0_Legacy;
        }
      } else if (cmd instanceof import_cc.Security2CC) {
        if (cmd instanceof import_cc.Security2CCMessageEncapsulation) {
          if (cmd.encapsulated instanceof import_cc.Security2CCCommandsSupportedReport) {
            return true;
          }
          if (cmd.encapsulated instanceof import_cc.Security2CCCommandsSupportedGet) {
            return true;
          }
          if (cmd.getMulticastGroupId() != void 0)
            return true;
          if (cmd.securityClass == void 0)
            return false;
          return cmd.securityClass === secClass;
        }
      }
      return cmd.ccId === expectedSecurityCC;
    }, "isCCConsideredSecure");
    let requiresSecurity = (0, import_core.securityClassIsS2)(secClass);
    const isSecure = isCCConsideredSecure(cc);
    while (true) {
      if ((0, import_cc.isEncapsulatingCommandClass)(cc)) {
        cc = cc.encapsulated;
      } else if ((0, import_cc.isMultiEncapsulatingCommandClass)(cc)) {
        requiresSecurity ||= cc.encapsulated.some((cmd) => node.isCCSecure(cmd.ccId));
        break;
      } else {
        requiresSecurity ||= node.isCCSecure(cc.ccId) && cc.ccId !== import_core.CommandClasses.Security && cc.ccId !== import_core.CommandClasses["Security 2"];
        break;
      }
    }
    if (requiresSecurity && !isSecure) {
      this.controllerLog.logNode(cc.nodeId, `command was received at a lower security level than expected - discarding it...`, "warn");
      return true;
    }
    return false;
  }
  /** Checks whether a CC should be discarded */
  shouldDiscardCC(cc) {
    if ((0, import_cc.isEncapsulatingCommandClass)(cc)) {
      return this.shouldDiscardCC(cc.encapsulated);
    }
    const node = this._controller?.nodes.get(cc.nodeId);
    if (!node) {
      this.controllerLog.logNode(cc.nodeId, `is unknown - discarding received command...`, "warn");
      return true;
    }
    if (cc.constructor.name.endsWith("Get") && (cc.frameType === "multicast" || cc.frameType === "broadcast")) {
      this.controllerLog.logNode(cc.nodeId, `received GET-type command via ${cc.frameType} - discarding...`, "warn");
      return true;
    }
    if (cc.ccId === import_core.CommandClasses.Meter || cc.ccId === import_core.CommandClasses["Multilevel Sensor"]) {
      const endpoint = node.getEndpoint(cc.endpointIndex) ?? node;
      if (!endpoint.supportsCC(cc.ccId) && !endpoint.controlsCC(cc.ccId)) {
        this.controllerLog.logNode(cc.nodeId, `${cc.endpointIndex > 0 ? `Endpoint ${cc.endpointIndex} ` : ""}does not support CC ${(0, import_core.getCCName)(cc.ccId)} - discarding received command...`, "warn");
        return true;
      }
    }
    return false;
  }
  /**
   * Is called when a Response-type message was received
   */
  handleResponse(msg) {
    for (const entry of this.awaitedMessages) {
      if (entry.predicate(msg)) {
        entry.handler(msg);
        return Promise.resolve();
      }
    }
    this.driverLog.transactionResponse(msg, void 0, "unexpected");
    this.driverLog.print("unexpected response, discarding...", "warn");
    return Promise.resolve();
  }
  /**
   * Is called when a Request-type message was received
   */
  async handleRequest(msg) {
    let handlers;
    if ((0, import_serial.hasNodeId)(msg) || (0, import_serialapi.containsCC)(msg)) {
      const node = this.tryGetNode(msg);
      if (node) {
        if (node.status === import_Types2.NodeStatus.Dead) {
          node.markAsAlive();
        }
      }
    }
    for (const entry of this.awaitedMessages) {
      if (entry.predicate(msg)) {
        entry.handler(msg);
        return;
      }
    }
    if ((0, import_serialapi.isCommandRequest)(msg) && (0, import_serialapi.containsCC)(msg)) {
      const nodeId = msg.getNodeId();
      const currentTransaction = this.queue.currentTransaction;
      const currentMessage = currentTransaction?.getCurrentMessage();
      const isS2NonceReportSOS = msg.command instanceof import_cc.Security2CCNonceReport && msg.command.SOS && !!msg.command.receiverEI;
      const isS0NonceReport = msg.command instanceof import_cc.SecurityCCNonceReport;
      const isNonceReport = isS0NonceReport || isS2NonceReportSOS;
      if (currentMessage && currentMessage.expectsNodeUpdate(this) && currentMessage.isExpectedNodeUpdate(this, msg)) {
        if (isNonceReport) {
          currentMessage.prematureNodeUpdate = msg;
        }
        if ((0, import_serialapi.isSendData)(currentMessage)) {
          this.controllerLog.logNode(msg.getNodeId(), {
            message: `received expected response prematurely, aborting ongoing transmission...`,
            level: "verbose",
            direction: "inbound"
          });
          void this.abortSendData();
        }
        if (!isNonceReport)
          currentTransaction.abort(msg);
        return;
      }
      this.unwrapCommands(msg);
      if (this._controller == void 0) {
        this.driverLog.print(`  the controller is not ready yet, discarding...`, "warn");
        return;
      } else if (!this.controller.nodes.has(nodeId)) {
        this.driverLog.print(`  the node is unknown or not initialized yet, discarding...`, "warn");
        return;
      }
      const node = this.controller.nodes.get(nodeId);
      const nodeSessions = this.nodeSessions.get(nodeId);
      if (msg.command instanceof import_cc.SecurityCCNonceGet) {
        return this.handleSecurityNonceGet(node);
      }
      if (msg.command instanceof import_cc.SecurityCCNonceReport) {
        return this.handleSecurityNonceReport(node, msg.command);
      }
      if (msg.command instanceof import_cc.SecurityCCCommandsSupportedGet) {
        return this.handleSecurityCommandsSupportedGet(node, msg.command);
      }
      if (msg.command instanceof import_cc.Security2CCNonceGet) {
        return this.handleSecurity2NonceGet(node);
      }
      if (msg.command instanceof import_cc.Security2CCCommandsSupportedGet) {
        return this.handleSecurity2CommandsSupportedGet(node, msg.command);
      }
      if (msg.command.ccId === import_core.CommandClasses.Supervision && msg.command instanceof import_cc.SupervisionCCReport && nodeSessions?.supervision.has(msg.command.sessionId)) {
        this.controllerLog.logNode(msg.command.nodeId, {
          message: `Received update for a Supervision session`,
          direction: "inbound"
        });
        nodeSessions.supervision.get(msg.command.sessionId)({
          status: msg.command.status,
          remainingDuration: msg.command.duration
        });
        if (!msg.command.moreUpdatesFollow) {
          nodeSessions.supervision.delete(msg.command.sessionId);
        }
        return;
      }
      const supervisionSessionId = import_cc.SupervisionCC.getSessionId(msg.command);
      const s2MulticastOutOfSync = this.mustReplyWithSecurityS2MOS(msg);
      const encapsulationFlags = msg.command.encapsulationFlags;
      let reply;
      if (supervisionSessionId != void 0) {
        const endpoint = node.getEndpoint(msg.command.endpointIndex) ?? node;
        reply = /* @__PURE__ */ __name((status) => endpoint.createAPI(import_core.CommandClasses.Supervision, false).withOptions({ s2MulticastOutOfSync }).sendReport({
          sessionId: supervisionSessionId,
          moreUpdatesFollow: false,
          status,
          requestWakeUpOnDemand: this.shouldRequestWakeupOnDemand(node),
          encapsulationFlags,
          lowPriority: this.shouldUseLowPriorityForSupervisionReport(node, encapsulationFlags)
        }), "reply");
      } else {
        reply = /* @__PURE__ */ __name(() => Promise.resolve(), "reply");
      }
      const trySupervised = /* @__PURE__ */ __name(async (action) => {
        try {
          await action();
          await reply(import_core.SupervisionStatus.Success);
        } catch (e) {
          let handled = false;
          if ((0, import_core.isZWaveError)(e)) {
            if (e.code === import_core.ZWaveErrorCodes.CC_OperationFailed) {
              await reply(import_core.SupervisionStatus.Fail);
              handled = true;
            } else if (e.code === import_core.ZWaveErrorCodes.CC_NotSupported) {
              await reply(import_core.SupervisionStatus.NoSupport);
              handled = true;
            }
          }
          if (!handled) {
            await reply(import_core.SupervisionStatus.Fail);
            throw e;
          }
        }
      }, "trySupervised");
      if (supervisionSessionId == void 0 && s2MulticastOutOfSync) {
        node.commandClasses["Security 2"].sendMOS().catch(() => {
        });
      }
      for (const entry of this.awaitedCommands) {
        if (entry.predicate(msg.command)) {
          entry.handler(msg.command);
          await reply(import_core.SupervisionStatus.Success);
          return;
        }
      }
      if (msg.command instanceof import_cc.Security2CCNonceReport) {
        return this.handleSecurity2NonceReport(node, msg.command);
      }
      if (msg.command instanceof import_cc.Security2CCMessageEncapsulation && msg.command.encapsulated == void 0) {
        await reply(import_core.SupervisionStatus.Success);
        return;
      }
      if (msg.command instanceof import_cc.InclusionControllerCCInitiate) {
        const command = msg.command;
        if (msg.command.step === import_cc.InclusionControllerStep.ProxyInclusion) {
          await trySupervised(() => this.controller.handleInclusionControllerCCInitiateProxyInclusion(command));
          return;
        } else if (msg.command.step === import_cc.InclusionControllerStep.ProxyInclusionReplace) {
          await trySupervised(() => this.controller.handleInclusionControllerCCInitiateReplace(command));
        }
      }
      await trySupervised(() => node.handleCommand(msg.command));
      return;
    } else if (msg instanceof import_serialapi.ApplicationUpdateRequest) {
      this.ensureReady(true);
      return this.controller.handleApplicationUpdateRequest(msg);
    } else if (msg instanceof import_serialapi.SerialAPIStartedRequest) {
      if (await this.handleSerialAPIStartedUnexpectedly(msg)) {
        return;
      }
    } else {
      if (msg.functionType >= import_serial.FunctionType.Proprietary_F0 && msg.functionType <= import_serial.FunctionType.Proprietary_FE && await this._controller?.handleUnsolictedProprietaryCommand(msg)) {
        return;
      }
      this.driverLog.print(`handling request ${import_serial.FunctionType[msg.functionType]} (${msg.functionType})`);
      handlers = this.requestHandlers.get(msg.functionType);
    }
    if (handlers != void 0 && handlers.length > 0) {
      this.driverLog.print(`  ${handlers.length} handler${handlers.length !== 1 ? "s" : ""} registered!`);
      for (let i = 0; i < handlers.length; i++) {
        this.driverLog.print(`  invoking handler #${i}`);
        const handler = handlers[i];
        let handlerResult = handler.invoke(msg);
        if (handlerResult instanceof Promise) {
          handlerResult = await handlerResult;
        }
        if (handlerResult) {
          this.driverLog.print(`    the message was handled`);
          if (handler.oneTime) {
            this.driverLog.print("  one-time handler was successfully called, removing it...");
            handlers.splice(i, 1);
          }
          break;
        }
      }
    } else {
      this.driverLog.print("  no handlers registered!", "warn");
    }
  }
  hasLoggedNoNetworkKey = false;
  async handleSecurityNonceGet(node) {
    if (!this.securityManager) {
      if (!this.hasLoggedNoNetworkKey) {
        this.hasLoggedNoNetworkKey = true;
        this.controllerLog.logNode(node.id, {
          message: `cannot reply to NonceGet because no network key was configured!`,
          direction: "inbound",
          level: "warn"
        });
      }
      return;
    }
    node.addCC(import_core.CommandClasses.Security, {
      isSupported: true,
      version: 1,
      // Security CC is always secure
      secure: true
    });
    const isNonceReport = /* @__PURE__ */ __name((t) => t.message.getNodeId() === node.id && (0, import_serialapi.containsCC)(t.message) && t.message.command instanceof import_cc.SecurityCCNonceReport, "isNonceReport");
    if (this.hasPendingTransactions(isNonceReport)) {
      this.controllerLog.logNode(node.id, {
        message: "in the process of replying to a NonceGet, won't send another NonceReport",
        level: "warn"
      });
      return;
    }
    this.securityManager.deleteAllNoncesForReceiver(node.id);
    try {
      await node.commandClasses.Security.sendNonce();
    } catch (e) {
      this.controllerLog.logNode(node.id, {
        message: `failed to send nonce: ${(0, import_shared.getErrorMessage)(e)}`,
        direction: "inbound"
      });
    }
  }
  /**
   * Is called when a nonce report is received that does not belong to any transaction.
   * The received nonce reports are stored as "free" nonces
   */
  handleSecurityNonceReport(node, command) {
    const secMan = this.securityManager;
    if (!secMan)
      return;
    secMan.setNonce({
      issuer: node.id,
      nonceId: secMan.getNonceId(command.nonce)
    }, {
      nonce: command.nonce,
      receiver: this.controller.ownNodeId
    }, { free: true });
  }
  async handleSecurityCommandsSupportedGet(node, command) {
    const endpoint = node.getEndpoint(command.endpointIndex) ?? node;
    if (this.getHighestSecurityClass(node.id) === import_core.SecurityClass.S0_Legacy) {
      const { supportedCCs } = (0, import_NodeInformationFrame.determineNIF)();
      await endpoint.commandClasses.Security.reportSupportedCommands(
        supportedCCs,
        // We don't report controlled CCs
        []
      );
    } else {
      await endpoint.commandClasses.Security.reportSupportedCommands([], []);
    }
  }
  /** Handles a nonce request for S2 */
  async handleSecurity2NonceGet(node) {
    if (!this.getSecurityManager2(node.id)) {
      if (!this.hasLoggedNoNetworkKey) {
        this.hasLoggedNoNetworkKey = true;
        this.controllerLog.logNode(node.id, {
          message: `cannot reply to NonceGet (S2) because no network key was configured!`,
          direction: "inbound",
          level: "warn"
        });
      }
      return;
    }
    node.addCC(import_core.CommandClasses["Security 2"], {
      isSupported: true,
      version: 1,
      // Security 2 CC is always secure
      secure: true
    });
    const isNonceReport = /* @__PURE__ */ __name((t) => t.message.getNodeId() === node.id && (0, import_serialapi.containsCC)(t.message) && t.message.command instanceof import_cc.Security2CCNonceReport, "isNonceReport");
    if (this.hasPendingTransactions(isNonceReport)) {
      this.controllerLog.logNode(node.id, {
        message: "in the process of replying to a NonceGet, won't send another NonceReport",
        level: "warn"
      });
      return;
    }
    try {
      await node.commandClasses["Security 2"].sendNonce();
    } catch (e) {
      this.controllerLog.logNode(node.id, {
        message: `failed to send nonce: ${(0, import_shared.getErrorMessage)(e)}`,
        direction: "inbound"
      });
    }
  }
  /**
   * Is called when a nonce report is received that does not belong to any transaction.
   */
  handleSecurity2NonceReport(node, _command) {
    this.controllerLog.logNode(node.id, {
      message: `received S2 nonce without an active transaction, not sure what to do with it`,
      level: "warn",
      direction: "inbound"
    });
  }
  async handleSecurity2CommandsSupportedGet(node, command) {
    const endpoint = node.getEndpoint(command.endpointIndex) ?? node;
    const highestSecurityClass = this.getHighestSecurityClass(node.id);
    const actualSecurityClass = command.getEncapsulatingCC(import_core.CommandClasses["Security 2"], import_cc.Security2Command.MessageEncapsulation)?.securityClass;
    if (highestSecurityClass !== void 0 && highestSecurityClass === actualSecurityClass) {
      const implementedCCs = new Set(import_core.allCCs.filter((cc) => (0, import_cc.getImplementedVersion)(cc) > 0));
      const implementedEncapsulationCCs = import_core.encapsulationCCs.filter((cc) => implementedCCs.has(cc) && cc !== import_core.CommandClasses["Multi Channel"]);
      const supportedCCs = /* @__PURE__ */ new Set([
        // DT:00.11.0004.1
        // All Root Devices or nodes MUST support:
        // - Association, version 2
        // - Association Group Information
        // - Device Reset Locally
        // - Firmware Update Meta Data, version 5
        // - Indicator, version 3
        // - Manufacturer Specific
        // - Multi Channel Association, version 3
        // - Powerlevel
        // - Security 2
        // - Supervision
        // - Transport Service, version 2
        // - Version, version 2
        // - Z-Wave Plus Info, version 2
        import_core.CommandClasses.Association,
        import_core.CommandClasses["Association Group Information"],
        import_core.CommandClasses["Device Reset Locally"],
        import_core.CommandClasses["Firmware Update Meta Data"],
        import_core.CommandClasses.Indicator,
        import_core.CommandClasses["Manufacturer Specific"],
        import_core.CommandClasses["Multi Channel Association"],
        import_core.CommandClasses.Powerlevel,
        import_core.CommandClasses.Version,
        import_core.CommandClasses["Z-Wave Plus Info"],
        // Generic Controller device type has no additional support requirements,
        // but we also support the following command classes:
        import_core.CommandClasses["Inclusion Controller"],
        // plus encapsulation CCs, which are part of the above requirement
        ...implementedEncapsulationCCs.filter((cc) => (
          // CC:009F.01.0E.11.00F
          // The Security 0 and Security 2 Command Class MUST NOT be advertised in this command
          // The Transport Service Command Class MUST NOT be advertised in this command.
          cc !== import_core.CommandClasses.Security && cc !== import_core.CommandClasses["Security 2"] && cc !== import_core.CommandClasses["Transport Service"]
        ))
      ]);
      const commandsInNIF = new Set((0, import_NodeInformationFrame.determineNIF)().supportedCCs);
      const supportedCommandsNotInNIF = [...supportedCCs].filter((cc) => !commandsInNIF.has(cc));
      await endpoint.commandClasses["Security 2"].reportSupportedCommands(supportedCommandsNotInNIF);
    } else if ((0, import_core.securityClassIsS2)(actualSecurityClass)) {
      await endpoint.commandClasses["Security 2"].withOptions({
        s2OverrideSecurityClass: actualSecurityClass
      }).reportSupportedCommands([]);
    } else {
    }
  }
  /**
   * Returns the next callback ID. Callback IDs are used to correlate requests
   * to the controller/nodes with its response
   */
  getNextCallbackId = (0, import_shared.createWrappingCounter)(255);
  supervisionSessionIDs = /* @__PURE__ */ new Map();
  /**
   * Returns the next session ID for Supervision CC
   */
  getNextSupervisionSessionId(nodeId) {
    if (!this.supervisionSessionIDs.has(nodeId)) {
      this.supervisionSessionIDs.set(nodeId, (0, import_shared.createWrappingCounter)(import_core.MAX_SUPERVISION_SESSION_ID, true));
    }
    return this.supervisionSessionIDs.get(nodeId)();
  }
  /**
   * Returns the next session ID for Transport Service CC
   */
  getNextTransportServiceSessionId = (0, import_shared.createWrappingCounter)(import_core.MAX_TRANSPORT_SERVICE_SESSION_ID, true);
  encapsulateCommands(cmd, options = {}) {
    if (import_cc.SupervisionCC.requiresEncapsulation(cmd)) {
      cmd = import_cc.SupervisionCC.encapsulate(cmd, this.getNextSupervisionSessionId(cmd.nodeId));
    }
    if (import_cc.MultiChannelCC.requiresEncapsulation(cmd)) {
      const multiChannelCCVersion = this.getSupportedCCVersion(import_core.CommandClasses["Multi Channel"], cmd.nodeId);
      cmd = multiChannelCCVersion === 1 ? import_cc.MultiChannelCC.encapsulateV1(cmd) : import_cc.MultiChannelCC.encapsulate(cmd);
    }
    if (import_cc.CRC16CC.requiresEncapsulation(cmd)) {
      cmd = import_cc.CRC16CC.encapsulate(cmd);
    } else {
      let maybeS2 = false;
      const node = cmd.getNode(this);
      if (node?.supportsCC(import_core.CommandClasses["Security 2"])) {
        const nodeSecClass = node.getHighestSecurityClass();
        const securityManager = this.getSecurityManager2(node.id);
        maybeS2 = (0, import_core.securityClassIsS2)(nodeSecClass) || !!securityManager?.tempKeys.has(node.id);
      } else if (options.s2MulticastGroupId != void 0) {
        maybeS2 = true;
      }
      if (maybeS2 && import_cc.Security2CC.requiresEncapsulation(cmd)) {
        cmd = import_cc.Security2CC.encapsulate(cmd, this.ownNodeId, this, {
          securityClass: options.s2OverrideSecurityClass,
          multicastOutOfSync: !!options.s2MulticastOutOfSync,
          multicastGroupId: options.s2MulticastGroupId,
          verifyDelivery: options.s2VerifyDelivery
        });
      }
      if (import_cc.SecurityCC.requiresEncapsulation(cmd)) {
        cmd = import_cc.SecurityCC.encapsulate(this.ownNodeId, this.securityManager, cmd);
      }
    }
    return cmd;
  }
  unwrapCommands(msg) {
    while ((0, import_cc.isEncapsulatingCommandClass)(msg.command) || (0, import_cc.isMultiEncapsulatingCommandClass)(msg.command)) {
      const unwrapped = msg.command.encapsulated;
      if ((0, import_typeguards.isArray)(unwrapped)) {
        for (const cmd of unwrapped) {
          cmd.toggleEncapsulationFlag(msg.command.encapsulationFlags, true);
        }
        return;
      }
      unwrapped.encapsulationFlags = msg.command.encapsulationFlags;
      switch (msg.command.ccId) {
        case import_core.CommandClasses.Supervision:
          unwrapped.toggleEncapsulationFlag(import_core.EncapsulationFlags.Supervision, true);
          break;
        case import_core.CommandClasses["Security 2"]:
        case import_core.CommandClasses.Security:
          unwrapped.toggleEncapsulationFlag(import_core.EncapsulationFlags.Security, true);
          break;
        case import_core.CommandClasses["CRC-16 Encapsulation"]:
          unwrapped.toggleEncapsulationFlag(import_core.EncapsulationFlags.CRC16, true);
          break;
      }
      msg.command = unwrapped;
    }
  }
  shouldPersistCCValues(cc) {
    if ((0, import_core.isEncapsulationCC)(cc.ccId))
      return true;
    const endpoint = this.tryGetEndpoint(cc);
    const node = endpoint?.tryGetNode();
    if (!node)
      return false;
    if (endpoint?.wasCCRemovedViaConfig(cc.ccId))
      return false;
    const compatConfig = node?.deviceConfig?.compat;
    if (cc.endpointIndex === 0 && cc.constructor.name.endsWith("Report") && node.getEndpointCount() >= 1 && compatConfig?.mapRootReportsToEndpoint != void 0) {
      const targetEndpoint = node.getEndpoint(compatConfig.mapRootReportsToEndpoint);
      if (targetEndpoint?.supportsCC(cc.ccId))
        return false;
    }
    return true;
  }
  /** Persists the values contained in a Command Class in the corresponding nodes's value DB */
  persistCCValues(cc) {
    if (this.shouldPersistCCValues(cc)) {
      cc.persistValues(this);
    }
    if ((0, import_cc.isEncapsulatingCommandClass)(cc)) {
      this.persistCCValues(cc.encapsulated);
    } else if ((0, import_cc.isMultiEncapsulatingCommandClass)(cc)) {
      for (const encapsulated of cc.encapsulated) {
        this.persistCCValues(encapsulated);
      }
    }
  }
  /**
   * Gets called whenever any Serial API command succeeded or a SendData command had a negative callback.
   */
  handleSerialAPICommandResult(msg, options, result) {
    const node = this.tryGetNode(msg);
    let success = true;
    if ((0, import_serialapi.isSendData)(msg) || (0, import_serial.hasNodeId)(msg)) {
      if (!node)
        return;
      if ((0, import_serialapi.isTransmitReport)(result)) {
        if (!result.isOK()) {
          success = false;
          node.incrementStatistics("commandsDroppedTX");
        } else {
          node.incrementStatistics("commandsTX");
          node.updateRTT(msg);
          node.lastSeen = /* @__PURE__ */ new Date();
        }
        if ((0, import_serialapi.hasTXReport)(result)) {
          options.onTXReport?.(result.txReport);
          node.updateRouteStatistics(result.txReport);
        }
      }
      if (success) {
        if (node.canSleep) {
          if (options.priority !== import_core.MessagePriority.Immediate) {
            if (!node.keepAwake) {
              setImmediate(() => this.debounceSendNodeToSleep(node));
            }
            node.markAsAwake();
          }
        } else if (node.status !== import_Types2.NodeStatus.Alive) {
          node.markAsAlive();
        }
      }
    } else {
      this._controller?.incrementStatistics("messagesTX");
    }
  }
  shouldUseLowPriorityForSupervisionReport(targetNode, encapsulationFlags) {
    const currentNormalMsg = this.queue.currentTransaction?.message;
    if (currentNormalMsg?.getNodeId() !== targetNode.id) {
      return false;
    }
    if (!(0, import_serialapi.containsCC)(currentNormalMsg)) {
      return false;
    }
    if (!(0, import_core.securityClassIsS2)(targetNode.getHighestSecurityClass())) {
      return false;
    }
    const currentMsgIsSecure = currentNormalMsg.command instanceof import_cc.Security2CCMessageEncapsulation;
    const reportIsSecure = !!(encapsulationFlags & import_core.EncapsulationFlags.Security);
    if (!currentMsgIsSecure || !reportIsSecure) {
      return false;
    }
    this.controllerLog.logNode(targetNode.id, {
      message: "S2 collision detected, reducing priority for Supervision report",
      level: "debug"
    });
    return true;
  }
  mayStartTransaction(transaction) {
    if (this.queuePaused || this.controller.status === import_core.ControllerStatus.Unresponsive) {
      return false;
    }
    const message = transaction.message;
    const targetNode = message.tryGetNode(this);
    if (!targetNode)
      return true;
    if (messageIsPing(message))
      return true;
    return targetNode.status !== import_Types2.NodeStatus.Asleep || !targetNode.supportsCC(import_core.CommandClasses["Wake Up"]) && targetNode.interviewStage >= import_Types2.InterviewStage.NodeInfo;
  }
  markQueueBusy(queue, busy) {
    const index = this.queues.indexOf(queue);
    if (busy) {
      this._queuesBusyFlags |= 1 << index;
    } else {
      this._queuesBusyFlags &= ~(1 << index);
    }
    this.queueIdle = this._queuesBusyFlags === 0;
  }
  async drainTransactionQueue(queue) {
    let setIdleTimer;
    for await (const transaction of queue) {
      if (setIdleTimer) {
        clearImmediate(setIdleTimer);
        setIdleTimer = void 0;
      }
      this.markQueueBusy(queue, true);
      let error;
      try {
        await this.executeTransaction(transaction);
      } catch (e) {
        error = e;
      } finally {
        queue.finalizeTransaction();
      }
      if (error) {
        this.handleFailedTransaction(transaction, error);
      }
      setIdleTimer = setImmediate(() => {
        this.markQueueBusy(queue, false);
      });
    }
  }
  /** Steps through the message generator of a transaction. Throws an error if the transaction should fail. */
  async executeTransaction(transaction) {
    let prevResult;
    let msg;
    transaction.start();
    transaction.setProgress({ state: import_core.TransactionState.Active });
    const maxJammedAttempts = this._recoveryPhase === 6 ? 1 : this.options.attempts.sendDataJammed;
    while (msg = await transaction.generateNextMessage(prevResult)) {
      let jammedAttempts = 0;
      let queueAttempts = 0;
      let commandAttempts = 0;
      attemptMessage: for (let attemptNumber = 1; ; attemptNumber++) {
        try {
          prevResult = await this.queueSerialAPICommand(msg, transaction.stack);
          if ((0, import_serialapi.isTransmitReport)(prevResult)) {
            if (prevResult.transmitStatus === import_core.TransmitStatus.Fail && "txReport" in prevResult && prevResult.txReport?.txTicks === 0) {
              jammedAttempts++;
              attemptNumber--;
              if (jammedAttempts < maxJammedAttempts) {
                this.controller.setStatus(import_core.ControllerStatus.Jammed);
                await (0, import_async.wait)(this.options.timeouts.retryJammed, true);
                continue attemptMessage;
              } else {
                throw new import_core.ZWaveError(`Failed to send the command after ${jammedAttempts} attempts`, import_core.ZWaveErrorCodes.Controller_MessageDropped, prevResult, transaction.stack);
              }
            }
            if (this.controller.status === import_core.ControllerStatus.Jammed) {
              this.controller.setStatus(import_core.ControllerStatus.Ready);
            }
            if (this._recoveryPhase === 6) {
              this._recoveryPhase = 0;
            }
            if (!prevResult.isOK()) {
              throw new import_core.ZWaveError("The node did not acknowledge the command", import_core.ZWaveErrorCodes.Controller_CallbackNOK, prevResult, transaction.stack);
            }
          }
          break attemptMessage;
        } catch (e) {
          let zwError;
          if (!(0, import_core.isZWaveError)(e)) {
            zwError = (0, import_StateMachineShared.createMessageDroppedUnexpectedError)(e);
          } else {
            if ((0, import_serialapi.isSendData)(msg) && (0, import_core.isMissingControllerCallback)(e)) {
              throw e;
            } else if ((0, import_core.isMissingControllerACK)(e)) {
              commandAttempts++;
              attemptNumber--;
              if (commandAttempts < this.options.attempts.controller) {
                continue attemptMessage;
              } else {
                throw e;
              }
            } else if ((0, import_core.wasControllerReset)(e)) {
              throw e;
            } else if ((0, import_serialapi.isAnySendDataResponse)(e.context) && !e.context.wasSent) {
              queueAttempts++;
              attemptNumber--;
              if (queueAttempts < 3) {
                await (0, import_async.wait)(500, true);
                continue attemptMessage;
              }
              throw e;
            } else if (e.code === import_core.ZWaveErrorCodes.Controller_MessageDropped) {
              throw e;
            }
            if (msg.prematureNodeUpdate) {
              break attemptMessage;
            }
            if (this.mayRetrySerialAPICommand(msg, attemptNumber, e)) {
              continue attemptMessage;
            }
            zwError = e;
          }
          throw zwError;
        }
      }
    }
    transaction.setProgress({ state: import_core.TransactionState.Completed });
  }
  /**
   * Provides access to the result Promise for the currently executed serial API command
   */
  _currentSerialAPICommandPromise;
  /** Handles sequencing of queued Serial API commands */
  async drainSerialAPIQueue() {
    for await (const item of this.serialAPIQueue) {
      const { msg, transactionSource, result } = item;
      this._currentSerialAPICommandPromise = result;
      attempts: for (let attempt = 1; ; attempt++) {
        try {
          const ret = await this.executeSerialAPICommand(msg, transactionSource);
          result.resolve(ret);
        } catch (e) {
          if ((0, import_core.isZWaveError)(e) && e.code === import_core.ZWaveErrorCodes.Controller_MessageDropped && e.context === "CAN" && attempt < 3) {
            await (0, import_async.wait)(100);
            continue;
          }
          result.reject(e);
        } finally {
          this._currentSerialAPICommandPromise = void 0;
        }
        break attempts;
      }
    }
  }
  triggerQueues() {
    for (const queue of this.queues) {
      if (!queue)
        return;
    }
    for (const queue of this.queues) {
      queue.trigger();
    }
  }
  /** Puts a message on the serial API queue and returns or throws the command result */
  queueSerialAPICommand(msg, transactionSource) {
    const result = (0, import_deferred_promise.createDeferredPromise)();
    this.serialAPIQueue.add({
      msg,
      transactionSource,
      result,
      [Symbol.dispose]: () => {
        result.reject(new import_core.ZWaveError("The message has been removed from the queue", import_core.ZWaveErrorCodes.Controller_MessageDropped, void 0, transactionSource));
      }
    });
    return result;
  }
  mayRetrySerialAPICommand(msg, attemptNumber, error) {
    if (!(0, import_serialapi.isSendData)(msg))
      return false;
    if (error.code === import_core.ZWaveErrorCodes.Controller_Timeout && error.context === "response") {
      return false;
    }
    if ((msg instanceof import_serialapi.SendDataMulticastRequest || msg instanceof import_serialapi.SendDataMulticastBridgeRequest) && error.code === import_core.ZWaveErrorCodes.Controller_CallbackNOK) {
      return false;
    }
    return attemptNumber < msg.maxSendAttempts;
  }
  /**
   * Executes a Serial API command and returns or throws the result.
   * This method should not be called outside of {@link drainSerialAPIQueue}.
   */
  async executeSerialAPICommand(msg, transactionSource) {
    if (msg.needsCallbackId() && !msg.hasCallbackId()) {
      msg.callbackId = this.getNextCallbackId();
    }
    if (msg.functionType === import_serial.FunctionType.SoftReset && this.controller.sdkVersionGte("7.19.0")) {
      this.serial?.ignoreAckHighNibbleOnce();
    }
    const machine = (0, import_SerialAPICommandMachine.createSerialAPICommandMachine)(msg);
    this.abortSerialAPICommand = (0, import_deferred_promise.createDeferredPromise)();
    const abortController = new AbortController();
    let nextInput = {
      value: "start"
    };
    try {
      while (!machine.done) {
        if (nextInput == void 0) {
          throw new Error("Serial API Command machine is in an invalid state: no input provided");
        }
        const transition = machine.next(nextInput);
        if (transition == void 0) {
          throw new Error("Serial API Command machine is in an invalid state: no transition taken");
        }
        nextInput = void 0;
        machine.transition(transition.newState);
        switch (machine.state.value) {
          case "initial":
            throw new Error("Serial API Command machine is in an invalid state: transitioned to initial state");
          case "sending": {
            this.driverLog.logMessage(msg, {
              direction: "outbound"
            });
            msg.markAsSent();
            const data = await msg.serialize(this.getEncodingContext());
            await this.writeSerial(data);
            nextInput = { value: "message sent" };
            break;
          }
          case "waitingForACK": {
            const controlFlow = await this.waitForMessageHeader(() => true, this.options.timeouts.ack).catch(() => "timeout");
            if (controlFlow === "timeout") {
              nextInput = { value: "timeout" };
            } else if (controlFlow === import_serial.MessageHeaders.ACK) {
              nextInput = { value: "ACK" };
            } else if (controlFlow === import_serial.MessageHeaders.CAN) {
              nextInput = { value: "CAN" };
            } else if (controlFlow === import_serial.MessageHeaders.NAK) {
              nextInput = { value: "NAK" };
            }
            break;
          }
          case "waitingForResponse": {
            const response = await Promise.race([
              this.abortSerialAPICommand?.catch((e) => e),
              this.waitForMessage((resp) => msg.isExpectedResponse(resp), msg.getResponseTimeout() ?? this.options.timeouts.response, void 0, abortController.signal).catch(() => "timeout")
            ]);
            if (response instanceof Error) {
              abortController.abort();
              throw response;
            }
            if (response === "timeout") {
              if ((0, import_serialapi.isSendData)(msg)) {
                void this.abortSendData();
              }
              nextInput = { value: "timeout" };
            } else if ((0, import_serial.isSuccessIndicator)(response) && !response.isOK()) {
              nextInput = { value: "response NOK", response };
            } else {
              nextInput = { value: "response", response };
            }
            break;
          }
          case "waitingForCallback": {
            let sendDataAbortTimeout;
            if ((0, import_serialapi.isSendData)(msg)) {
              sendDataAbortTimeout = (0, import_shared.setTimer)(() => {
                void this.abortSendData();
              }, this.options.timeouts.sendDataAbort).unref();
            }
            const callback = await Promise.race([
              this.abortSerialAPICommand?.catch((e) => e),
              this.waitForMessage((resp) => msg.isExpectedCallback(resp), msg.getCallbackTimeout() ?? this.options.timeouts.sendDataCallback, void 0, abortController.signal).catch(() => "timeout")
            ]);
            sendDataAbortTimeout?.clear();
            if (callback instanceof Error) {
              abortController.abort();
              throw callback;
            }
            if (callback === "timeout") {
              nextInput = { value: "timeout" };
            } else if ((0, import_serial.isSuccessIndicator)(callback) && !callback.isOK()) {
              nextInput = { value: "callback NOK", callback };
            } else {
              nextInput = { value: "callback", callback };
            }
            break;
          }
          case "success": {
            return machine.state.result;
          }
          case "failure": {
            const { reason, result } = machine.state;
            if (reason === "callback NOK" && ((0, import_serialapi.isSendData)(msg) || (0, import_serialapi.isTransmitReport)(result))) {
              return result;
            } else {
              throw (0, import_StateMachineShared.serialAPICommandErrorToZWaveError)(reason, msg, result, transactionSource);
            }
          }
        }
      }
    } finally {
      this.abortSerialAPICommand = void 0;
    }
  }
  getQueueForTransaction(t) {
    if (t.priority === import_core.MessagePriority.Immediate || t.priority === import_core.MessagePriority.ControllerImmediate) {
      return this.immediateQueue;
    } else {
      return this.queue;
    }
  }
  /**
   * Sends a message to the Z-Wave stick.
   * @param msg The message to send
   * @param options (optional) Options regarding the message transmission
   */
  async sendMessage(msg, options = {}) {
    this.ensureReady();
    let node;
    if ((0, import_serial.hasNodeId)(msg) || (0, import_serialapi.containsCC)(msg)) {
      node = this.tryGetNode(msg);
    }
    if (options.priority == void 0) {
      options.priority = (0, import_serial.getDefaultPriority)(msg);
    }
    if (options.priority == void 0) {
      const className = msg.constructor.name;
      const msgTypeName = import_serial.FunctionType[msg.functionType];
      throw new import_core.ZWaveError(`No default priority has been defined for ${className} (${msgTypeName}), so you have to provide one for your message`, import_core.ZWaveErrorCodes.Driver_NoPriority);
    }
    if (options.supportCheck == void 0)
      options.supportCheck = true;
    if (options.supportCheck && this._controller != void 0 && !this._controller.isFunctionSupported(msg.functionType)) {
      throw new import_core.ZWaveError(`Your hardware does not support the ${import_serial.FunctionType[msg.functionType]} function`, import_core.ZWaveErrorCodes.Driver_NotSupported);
    }
    if (!!node && !messageIsPing(msg) && node.canSleep && (node.supportsCC(import_core.CommandClasses["Wake Up"]) || node.interviewStage < import_Types2.InterviewStage.NodeInfo) && !(msg instanceof import_serialapi.SendDataMulticastRequest) && !(msg instanceof import_serialapi.SendDataMulticastBridgeRequest) && options.priority !== import_core.MessagePriority.Immediate) {
      if (options.priority === import_core.MessagePriority.NodeQuery) {
        options.tag = "interview";
      }
      options.priority = import_core.MessagePriority.WakeUp;
    }
    const { generator, resultPromise } = (0, import_MessageGenerators.createMessageGenerator)(this, this.getEncodingContext(), msg, (msg2, _result) => {
      this.handleSerialAPICommandResult(msg2, options, _result);
    });
    const transaction = new import_Transaction.Transaction(this, {
      message: msg,
      priority: options.priority,
      parts: generator,
      promise: resultPromise,
      listener: options.onProgress
    });
    if (options.changeNodeStatusOnMissingACK != void 0) {
      transaction.changeNodeStatusOnTimeout = options.changeNodeStatusOnMissingACK;
    }
    if (options.pauseSendThread === true) {
      transaction.pauseSendThread = true;
    }
    transaction.requestWakeUpOnDemand = !!options.requestWakeUpOnDemand;
    transaction.tag = options.tag;
    this.getQueueForTransaction(transaction).add(transaction);
    transaction.setProgress({ state: import_core.TransactionState.Queued });
    let expirationTimeout;
    if (options.expire) {
      expirationTimeout = (0, import_shared.setTimer)(() => {
        void this.reduceQueues((t, _source) => {
          if (t === transaction) {
            return {
              type: "reject",
              message: `The message has expired`,
              code: import_core.ZWaveErrorCodes.Controller_MessageExpired
            };
          }
          return { type: "keep" };
        });
      }, options.expire).unref();
    }
    try {
      const result = await resultPromise;
      let maybeSendToSleep;
      if ((0, import_serialapi.isSendData)(msg)) {
        maybeSendToSleep = options.priority !== import_core.MessagePriority.Immediate && result && (result.functionType === import_serial.FunctionType.BridgeApplicationCommand || result.functionType === import_serial.FunctionType.ApplicationCommand || (0, import_serialapi.isSendDataTransmitReport)(result) && result.isOK());
      } else {
        maybeSendToSleep = (0, import_serial.hasNodeId)(msg) && result && (0, import_serial.isSuccessIndicator)(result) && result.isOK();
      }
      if (maybeSendToSleep && node && node.canSleep && !node.keepAwake) {
        setImmediate(() => this.debounceSendNodeToSleep(node));
      }
      transaction.setProgress({ state: import_core.TransactionState.Completed });
      return result;
    } catch (e) {
      if ((0, import_core.isZWaveError)(e)) {
        if (
          // If a controller command failed (that is not SendData), pass the response/callback through
          (e.code === import_core.ZWaveErrorCodes.Controller_ResponseNOK || e.code === import_core.ZWaveErrorCodes.Controller_CallbackNOK) && e.context instanceof import_serial.Message && e.context.functionType !== import_serial.FunctionType.SendData && e.context.functionType !== import_serial.FunctionType.SendDataMulticast && e.context.functionType !== import_serial.FunctionType.SendDataBridge && e.context.functionType !== import_serial.FunctionType.SendDataMulticastBridge
        ) {
          this._controller?.incrementStatistics("messagesDroppedTX");
          return e.context;
        } else if (e.code === import_core.ZWaveErrorCodes.Controller_NodeTimeout) {
          node?.incrementStatistics("timeoutResponse");
        }
        if (!e.transactionSource) {
          throw new import_core.ZWaveError(e.message, e.code, e.context, transaction.stack);
        }
      }
      throw e;
    } finally {
      expirationTimeout?.clear();
    }
  }
  /** Wraps a CC in the correct SendData message to use for sending */
  createSendDataMessage(command, options = {}) {
    if (options.autoEncapsulate !== false) {
      command = this.encapsulateCommands(command, options);
    }
    let msg;
    if (command.isSinglecast() || command.isBroadcast()) {
      if (this.controller.isFunctionSupported(import_serial.FunctionType.SendDataBridge)) {
        msg = new import_serialapi.SendDataBridgeRequest({
          sourceNodeId: this.ownNodeId,
          command,
          maxSendAttempts: this._options.attempts.sendData
        });
      } else {
        msg = new import_serialapi.SendDataRequest({
          command,
          maxSendAttempts: this._options.attempts.sendData
        });
      }
    } else if (command.isMulticast()) {
      if (this.controller.isFunctionSupported(import_serial.FunctionType.SendDataMulticastBridge)) {
        msg = new import_serialapi.SendDataMulticastBridgeRequest({
          sourceNodeId: this.ownNodeId,
          command,
          maxSendAttempts: this._options.attempts.sendData
        });
      } else {
        msg = new import_serialapi.SendDataMulticastRequest({
          command,
          maxSendAttempts: this._options.attempts.sendData
        });
      }
    } else {
      throw new import_core.ZWaveError(`A CC must either be singlecast or multicast`, import_core.ZWaveErrorCodes.Argument_Invalid);
    }
    if (options.maxSendAttempts != void 0) {
      msg.maxSendAttempts = options.maxSendAttempts;
    }
    if (options.transmitOptions != void 0) {
      msg.transmitOptions = options.transmitOptions;
    }
    if (!!options.reportTimeoutMs) {
      msg.nodeUpdateTimeout = options.reportTimeoutMs;
    }
    return msg;
  }
  /**
   * Sends a command to a Z-Wave node. If the node returns a command in response, that command will be the return value.
   * If the command expects no response **or** the response times out, nothing will be returned
   * @param command The command to send. It will be encapsulated in a SendData[Multicast]Request.
   * @param options (optional) Options regarding the message transmission
   */
  async sendCommandInternal(command, options = {}) {
    const msg = this.createSendDataMessage(command, options);
    try {
      const resp = await this.sendMessage(msg, options);
      if ((0, import_serialapi.containsCC)(resp)) {
        this.unwrapCommands(resp);
        return resp.command;
      }
    } catch (e) {
      if ((0, import_core.isZWaveError)(e) && e.code === import_core.ZWaveErrorCodes.Controller_NodeTimeout) {
        if (command.isSinglecast()) {
          this.controllerLog.logNode(command.nodeId, e.message, "warn");
        }
      } else {
        throw e;
      }
    }
  }
  /**
   * Sends a supervised command to a Z-Wave node. When status updates are requested, the passed callback will be executed for every non-final update.
   * @param command The command to send
   * @param options (optional) Options regarding the message transmission
   */
  async sendSupervisedCommand(command, options = {
    requestStatusUpdates: false
  }) {
    const sessionId = this.getNextSupervisionSessionId(command.nodeId);
    command = import_cc.SupervisionCC.encapsulate(command, sessionId, options.requestStatusUpdates);
    const resp = await this.sendCommandInternal(command, options);
    if (!resp)
      return;
    if (options.requestStatusUpdates && resp.moreUpdatesFollow) {
      this.ensureNodeSessions(command.nodeId).supervision.set(command.sessionId, options.onUpdate);
    }
    return resp.toSupervisionResult();
  }
  /**
   * Sends a command to a Z-Wave node. The return value depends on several factors:
   * * If the node returns a command in response, that command will be the return value.
   * * If the command is a SET-type command and Supervision CC can and should be used, a {@link SupervisionResult} will be returned.
   * * If the command expects no response **or** the response times out, nothing will be returned.
   *
   * @param command The command to send. It will be encapsulated in a SendData[Multicast]Request.
   * @param options (optional) Options regarding the message transmission
   */
  async sendCommand(command, options) {
    if (options?.encapsulationFlags != void 0) {
      command.encapsulationFlags = options.encapsulationFlags;
    }
    if (this.isCCSecure(command.ccId, command.nodeId, command.endpointIndex) || options?.s2MulticastGroupId != void 0) {
      command.toggleEncapsulationFlag(import_core.EncapsulationFlags.Security, true);
    }
    if (
      // ... not disabled
      options?.useSupervision !== false && import_cc.SupervisionCC.mayUseSupervision(this, command)
    ) {
      const result2 = await this.sendSupervisedCommand(command, options);
      if (result2?.status !== import_core.SupervisionStatus.NoSupport) {
        return result2;
      }
      import_cc.SupervisionCC.setCCSupportedWithSupervision(this, command.getEndpoint(this), command.ccId, false);
    }
    const result = await this.sendCommandInternal(command, options);
    if (result instanceof import_cc.ApplicationStatusCCRejectedRequest) {
      return {
        status: import_core.SupervisionStatus.Fail,
        remainingDuration: void 0
      };
    }
    if (options?.s2MulticastGroupId != void 0 && result instanceof import_cc.SupervisionCCReport) {
      return result.toSupervisionResult();
    }
    return result;
  }
  /** @internal */
  async sendZWaveProtocolCC(command, options = {}) {
    await this.sendCommandInternal(command, {
      priority: import_core.MessagePriority.Controller,
      // No shenanigans, just send the raw command
      autoEncapsulate: false,
      useSupervision: false,
      changeNodeStatusOnMissingACK: options.changeNodeStatusOnMissingACK ?? false,
      maxSendAttempts: options.maxSendAttempts || 1,
      transmitOptions: import_core.TransmitOptions.AutoRoute | import_core.TransmitOptions.ACK
    });
  }
  async abortSendData() {
    try {
      const abort = new import_serialapi.SendDataAbort();
      await this.writeSerial(await abort.serialize(this.getEncodingContext()));
      this.driverLog.logMessage(abort, {
        direction: "outbound"
      });
      await this.waitForMessageHeader(() => true, 500).catch(import_shared.noop);
    } catch {
    }
  }
  /**
   * Sends a low-level message like ACK, NAK or CAN immediately
   * @param header The low-level message to send
   */
  writeHeader(header) {
    return this.writeSerial(Uint8Array.from([header]));
  }
  /** Sends a raw datagram to the serialport (if that is open) */
  async writeSerial(data) {
    return this.serial?.writeAsync(data);
  }
  /**
   * Waits until a matching message header is received or an optional timeout has elapsed. Returns the received message.
   *
   * @param timeout The number of milliseconds to wait. If the timeout elapses, the returned promise will be rejected
   * @param predicate A predicate function to test all incoming message headers.
   */
  waitForMessageHeader(predicate, timeout, abortSignal) {
    return new Promise((resolve, reject) => {
      const promise = (0, import_deferred_promise.createDeferredPromise)();
      const entry = {
        predicate,
        handler: /* @__PURE__ */ __name((msg) => promise.resolve(msg), "handler"),
        timeout: void 0
      };
      this.awaitedMessageHeaders.push(entry);
      const removeEntry = /* @__PURE__ */ __name(() => {
        entry.timeout?.clear();
        abortSignal?.removeEventListener("abort", removeEntry);
        const index = this.awaitedMessageHeaders.indexOf(entry);
        if (index !== -1)
          this.awaitedMessageHeaders.splice(index, 1);
      }, "removeEntry");
      if (timeout) {
        entry.timeout = (0, import_shared.setTimer)(() => {
          removeEntry();
          reject(new import_core.ZWaveError(`Received no matching serial frame within the provided timeout!`, import_core.ZWaveErrorCodes.Controller_Timeout));
        }, timeout);
      }
      void promise.then((cc) => {
        removeEntry();
        resolve(cc);
      });
      abortSignal?.addEventListener("abort", removeEntry);
    });
  }
  /**
   * Waits until an unsolicited serial message is received or an optional timeout has elapsed. Returns the received message.
   *
   * **Note:** To wait for a certain CommandClass, better use {@link waitForCommand}.
   * @param timeout The number of milliseconds to wait. If the timeout elapses, the returned promise will be rejected.
   * @param predicate A predicate function to test all incoming messages.
   * @param refreshPredicate A predicate function to test partial messages. If this returns `true` for a message, the timer will be restarted.
   */
  waitForMessage(predicate, timeout, refreshPredicate, abortSignal) {
    return new Promise((resolve, reject) => {
      const promise = (0, import_deferred_promise.createDeferredPromise)();
      const entry = {
        predicate,
        refreshPredicate,
        handler: /* @__PURE__ */ __name((msg) => promise.resolve(msg), "handler"),
        timeout: void 0
      };
      this.awaitedMessages.push(entry);
      const removeEntry = /* @__PURE__ */ __name(() => {
        entry.timeout?.clear();
        abortSignal?.removeEventListener("abort", removeEntry);
        const index = this.awaitedMessages.indexOf(entry);
        if (index !== -1)
          this.awaitedMessages.splice(index, 1);
      }, "removeEntry");
      if (timeout) {
        entry.timeout = (0, import_shared.setTimer)(() => {
          removeEntry();
          reject(new import_core.ZWaveError(`Received no matching message within the provided timeout!`, import_core.ZWaveErrorCodes.Controller_Timeout));
        }, timeout);
      }
      void promise.then((cc) => {
        removeEntry();
        resolve(cc);
      });
      abortSignal?.addEventListener("abort", removeEntry);
    });
  }
  /**
   * Waits until a CommandClass is received or an optional timeout has elapsed. Returns the received command.
   * @param timeout The number of milliseconds to wait. If the timeout elapses, the returned promise will be rejected
   * @param predicate A predicate function to test all incoming command classes
   */
  waitForCommand(predicate, timeout, abortSignal) {
    return new Promise((resolve, reject) => {
      const promise = (0, import_deferred_promise.createDeferredPromise)();
      const entry = {
        predicate,
        handler: /* @__PURE__ */ __name((cc) => promise.resolve(cc), "handler"),
        timeout: void 0
      };
      this.awaitedCommands.push(entry);
      const removeEntry = /* @__PURE__ */ __name(() => {
        entry.timeout?.clear();
        abortSignal?.removeEventListener("abort", removeEntry);
        const index = this.awaitedCommands.indexOf(entry);
        if (index !== -1)
          this.awaitedCommands.splice(index, 1);
      }, "removeEntry");
      if (timeout) {
        entry.timeout = (0, import_shared.setTimer)(() => {
          removeEntry();
          reject(new import_core.ZWaveError(`Received no matching command within the provided timeout!`, import_core.ZWaveErrorCodes.Controller_NodeTimeout));
        }, timeout);
      }
      void promise.then((cc) => {
        removeEntry();
        resolve(cc);
      });
      abortSignal?.addEventListener("abort", removeEntry);
    });
  }
  /**
   * Waits until the driver queues become idle or an optional timeout has elapsed.
   * @param timeout The number of milliseconds to wait. If the timeout elapses, the returned promise will be rejected
   * @param abortSignal An optional abort signal to cancel the wait
   */
  waitForIdle(timeout, abortSignal) {
    return new Promise((resolve, reject) => {
      if (this.queueIdle) {
        resolve();
        return;
      }
      const promise = (0, import_deferred_promise.createDeferredPromise)();
      const entry = {
        handler: /* @__PURE__ */ __name(() => promise.resolve(), "handler"),
        timeout: void 0
      };
      this.awaitedIdle.push(entry);
      const removeEntry = /* @__PURE__ */ __name(() => {
        entry.timeout?.clear();
        abortSignal?.removeEventListener("abort", removeEntry);
        const index = this.awaitedIdle.indexOf(entry);
        if (index !== -1)
          this.awaitedIdle.splice(index, 1);
      }, "removeEntry");
      if (timeout) {
        entry.timeout = (0, import_shared.setTimer)(() => {
          removeEntry();
          reject(new import_core.ZWaveError(`The queues did not become idle within the provided timeout!`, import_core.ZWaveErrorCodes.Controller_NodeTimeout));
        }, timeout);
      }
      void promise.then(() => {
        removeEntry();
        resolve();
      });
      abortSignal?.addEventListener("abort", removeEntry);
    });
  }
  /**
   * Calls the given handler function every time a CommandClass is received that matches the given predicate.
   * @param predicate A predicate function to test all incoming command classes
   */
  registerCommandHandler(predicate, handler) {
    const entry = {
      predicate,
      handler: /* @__PURE__ */ __name((cc) => handler(cc), "handler"),
      timeout: void 0
    };
    this.awaitedCommands.push(entry);
    const removeEntry = /* @__PURE__ */ __name(() => {
      entry.timeout?.clear();
      const index = this.awaitedCommands.indexOf(entry);
      if (index !== -1)
        this.awaitedCommands.splice(index, 1);
    }, "removeEntry");
    return {
      unregister: removeEntry
    };
  }
  handleFailedTransaction(transaction, error) {
    if (this.isMissingNodeACK(transaction, error)) {
      if (this.handleMissingNodeACK(transaction, error))
        return;
    } else if ((0, import_core.isMissingControllerACK)(error)) {
      if (this.handleMissingControllerACK(transaction, error))
        return;
    } else if (
      // 700/800 series controllers can be jammed due to a bug,
      // which a soft-reset is supposed to work around
      (0, import_serialapi.isSendData)(transaction.message) && this.controller.status === import_core.ControllerStatus.Jammed
    ) {
      if (this.handleJammedController(transaction, error))
        return;
    } else if ((0, import_serialapi.isSendData)(transaction.message) && ((0, import_core.isMissingControllerResponse)(error) || (0, import_core.isMissingControllerCallback)(error))) {
      if (this.handleMissingSendDataResponseOrCallback(transaction, error))
        return;
    } else if ((0, import_core.wasControllerReset)(error)) {
      transaction.reset();
      this.getQueueForTransaction(transaction).add(transaction.clone());
      return;
    }
    this.rejectTransaction(transaction, error);
  }
  rejectTransaction(transaction, error) {
    transaction.setProgress({
      state: import_core.TransactionState.Failed,
      reason: error.message
    });
    transaction.abort(error);
  }
  resolveTransaction(transaction, result) {
    transaction.abort(result);
  }
  /** Checks if a message is allowed to go into the wakeup queue */
  mayMoveToWakeupQueue(transaction) {
    const msg = transaction.message;
    switch (true) {
      // Pings, nonces and Supervision Reports will block the send queue until wakeup, so they must be dropped
      case messageIsPing(msg):
      case transaction.priority === import_core.MessagePriority.Immediate:
      // We also don't want to immediately send the node to sleep when it wakes up
      case ((0, import_serialapi.containsCC)(msg) && msg.command instanceof import_cc.WakeUpCCNoMoreInformation):
      // compat queries because they will be recreated when the node wakes up
      case transaction.tag === "compat":
        return false;
    }
    return true;
  }
  /** Moves all messages for a given node into the wakeup queue */
  moveMessagesToWakeupQueue(nodeId) {
    const reject = {
      type: "reject",
      message: `The node is asleep`,
      code: import_core.ZWaveErrorCodes.Controller_MessageDropped
    };
    const requeue = {
      type: "requeue",
      priority: import_core.MessagePriority.WakeUp,
      // Reset the transaction so it doesn't simply resolve to `undefined` when we attempt to continue it
      reset: true
    };
    const requeueAndTagAsInterview = {
      ...requeue,
      tag: "interview"
    };
    void this.reduceQueues((transaction, _source) => {
      const msg = transaction.message;
      if (msg.getNodeId() !== nodeId)
        return { type: "keep" };
      return this.mayMoveToWakeupQueue(transaction) ? transaction.priority === import_core.MessagePriority.NodeQuery ? requeueAndTagAsInterview : requeue : reject;
    });
  }
  /**
   * @internal
   * Rejects all pending transactions that match a predicate and removes them from the send queue
   */
  rejectTransactions(predicate, errorMsg = `The message has been removed from the queue`, errorCode = import_core.ZWaveErrorCodes.Controller_MessageDropped) {
    return this.reduceQueues((transaction, _source) => {
      if (predicate(transaction)) {
        return {
          type: "reject",
          message: errorMsg,
          code: errorCode
        };
      } else {
        return { type: "keep" };
      }
    });
  }
  /**
   * @internal
   * Rejects all pending transactions for a node and removes them from the send queue
   */
  rejectAllTransactionsForNode(nodeId, errorMsg = `The node is dead`, errorCode = import_core.ZWaveErrorCodes.Controller_MessageDropped) {
    return this.rejectTransactions((t) => t.message.getNodeId() === nodeId, errorMsg, errorCode);
  }
  /**
   * @internal
   * Re-queues all pending transactions for a node after a delay
   */
  async delayTransactionsForNode(nodeId, delaySeconds) {
    const requeue = [];
    await this.reduceQueues((transaction, source) => {
      if (transaction.message.getNodeId() === nodeId && source === "queue") {
        requeue.push(transaction);
        return { type: "drop" };
      }
      return { type: "keep" };
    });
    if (requeue.length > 0) {
      if (!this.requeueTimers.has(nodeId)) {
        this.requeueTimers.set(nodeId, /* @__PURE__ */ new Set());
      }
      const timerSet = this.requeueTimers.get(nodeId);
      const timer = (0, import_shared.setTimer)(() => {
        timerSet.delete(timer);
        const requeued = requeue.map((t) => t.clone());
        for (const t of requeued) {
          this.getQueueForTransaction(t).add(t);
        }
      }, delaySeconds * 1e3).unref();
      timerSet.add(timer);
    }
  }
  /**
   * Pauses the send queue, avoiding commands to be sent to the controller
   */
  pauseSendQueue() {
    this.queuePaused = true;
  }
  /**
   * Unpauses the send queue, allowing commands to be sent to the controller again
   */
  unpauseSendQueue() {
    this.queuePaused = false;
    this.triggerQueues();
  }
  reduceQueues(reducer) {
    return Promise.all(this.queues.map((queue) => this.reduceQueue(queue, reducer))).then(import_shared.noop);
  }
  reduceQueue(queue, reducer) {
    const dropQueued = [];
    let stopActive;
    const requeue = [];
    const reduceTransaction = /* @__PURE__ */ __name((transaction, source) => {
      const reducerResult = reducer(transaction, source);
      switch (reducerResult.type) {
        case "drop":
          if (source === "queue") {
            dropQueued.push(transaction);
            transaction.setProgress({
              state: import_core.TransactionState.Failed,
              reason: "The message was dropped"
            });
          } else {
            stopActive = transaction;
          }
          break;
        case "requeue":
          if (reducerResult.priority != void 0) {
            transaction.priority = reducerResult.priority;
          }
          if (reducerResult.tag != void 0) {
            transaction.tag = reducerResult.tag;
          }
          if (reducerResult.reset) {
            transaction.reset();
          }
          if (source === "active")
            stopActive = transaction;
          requeue.push(transaction);
          break;
        case "resolve":
          this.resolveTransaction(transaction, reducerResult.message);
          if (source === "queue") {
            dropQueued.push(transaction);
          } else {
            stopActive = transaction;
          }
          break;
        case "reject":
          this.rejectTransaction(transaction, new import_core.ZWaveError(reducerResult.message, reducerResult.code, void 0, transaction.stack));
          if (source === "queue") {
            dropQueued.push(transaction);
          } else {
            stopActive = transaction;
          }
          break;
      }
    }, "reduceTransaction");
    for (const transaction of queue.transactions) {
      reduceTransaction(transaction, "queue");
    }
    if (queue.currentTransaction) {
      reduceTransaction(queue.currentTransaction, "active");
    }
    queue.remove(...dropQueued, ...requeue);
    const requeued = requeue.map((t) => t.clone());
    queue.add(...requeued);
    for (const t of requeued) {
      t.setProgress({ state: import_core.TransactionState.Queued });
    }
    if ((0, import_serialapi.isSendData)(stopActive?.message)) {
      return this.abortSendData();
    }
    return Promise.resolve();
  }
  /** @internal */
  resolvePendingPings(nodeId) {
    for (const { currentTransaction } of this.queues) {
      if (!currentTransaction)
        continue;
      const msg = currentTransaction.parts.current;
      if (!!msg && messageIsPing(msg) && msg.getNodeId() === nodeId) {
        currentTransaction.abort(void 0);
      }
    }
  }
  /**
   * @internal
   * Helper function to read and convert potentially existing values from the network cache
   */
  cacheGet(cacheKey, options) {
    let ret = this.networkCache.get(cacheKey);
    if (ret !== void 0 && typeof options?.reviver === "function") {
      try {
        ret = options.reviver(ret);
      } catch {
      }
    }
    return ret;
  }
  /**
   * @internal
   * Helper function to convert values and write them to the network cache
   */
  cacheSet(cacheKey, value, options) {
    if (value !== void 0 && typeof options?.serializer === "function") {
      value = options.serializer(value);
    }
    if (value === void 0) {
      this.networkCache.delete(cacheKey);
    } else {
      this.networkCache.set(cacheKey, value);
    }
  }
  /**
   * @internal
   * Helper function to find multiple existing values from the network cache
   */
  cacheList(prefix, options) {
    const ret = {};
    for (const entry of this.networkCache.entries()) {
      const key = entry[0];
      if (!key.startsWith(prefix))
        continue;
      let value = entry[1];
      if (value === void 0)
        continue;
      if (typeof options?.reviver === "function") {
        try {
          value = options.reviver(value);
        } catch {
          continue;
        }
      }
      ret[key] = value;
    }
    return ret;
  }
  cachePurge(prefix, except) {
    for (const key of this.networkCache.keys()) {
      if (key.startsWith(prefix) && !except?.(key)) {
        this.networkCache.delete(key);
      }
    }
  }
  /**
   * Restores a previously stored Z-Wave network state from cache to speed up the startup process
   */
  async restoreNetworkStructureFromCache() {
    if (!this._controller || !this.controller.homeId || !this._networkCache) {
      return;
    }
    if (this._networkCache.size <= 1) {
      return;
    }
    try {
      this.driverLog.print(`Cache file for homeId ${(0, import_shared.num2hex)(this.controller.homeId)} found, attempting to restore the network from cache...`);
      await this.controller.deserialize();
      this.driverLog.print(`Restoring the network from cache was successful!`);
    } catch (e) {
      const message = `Restoring the network from cache failed: ${(0, import_shared.getErrorMessage)(e, true)}`;
      this.emit("error", new import_core.ZWaveError(message, import_core.ZWaveErrorCodes.Driver_InvalidCache));
      this.driverLog.print(message, "error");
    }
  }
  sendNodeToSleepTimers = /* @__PURE__ */ new Map();
  /**
   * @internal
   * Marks a node for a later sleep command. Every call refreshes the period until the node actually goes to sleep
   */
  debounceSendNodeToSleep(node) {
    if (this.sendNodeToSleepTimers.has(node.id)) {
      this.sendNodeToSleepTimers.get(node.id)?.clear();
    }
    const sendNodeToSleep = /* @__PURE__ */ __name((node2) => {
      this.sendNodeToSleepTimers.delete(node2.id);
      if (!this.hasPendingMessages(node2)) {
        void node2.sendNoMoreInformation().catch(() => {
        });
      }
    }, "sendNodeToSleep");
    if (node.supportsCC(import_core.CommandClasses["Wake Up"]) && !this.hasPendingMessages(node)) {
      const wakeUpInterval = node.getValue(import_cc.WakeUpCCValues.wakeUpInterval.id);
      if (wakeUpInterval !== 0) {
        this.sendNodeToSleepTimers.set(node.id, (0, import_shared.setTimer)(() => sendNodeToSleep(node), this.options.timeouts.sendToSleep).unref());
      }
    }
  }
  /** Computes the maximum net CC payload size for the given CC or SendDataRequest */
  computeNetCCPayloadSize(commandOrMsg, ignoreEncapsulation = false) {
    let msg;
    if ((0, import_serialapi.isSendDataSinglecast)(commandOrMsg)) {
      msg = commandOrMsg;
    } else {
      const SendDataConstructor = this.getSendDataSinglecastConstructor();
      msg = new SendDataConstructor({
        sourceNodeId: this.ownNodeId,
        command: commandOrMsg
      });
    }
    if (!ignoreEncapsulation) {
      msg.command = this.encapsulateCommands(msg.command);
    }
    return msg.command.getMaxPayloadLength(this.getMaxPayloadLength(msg));
  }
  /** Computes the maximum payload size that can be transmitted with the given message */
  getMaxPayloadLength(msg) {
    const nodeId = msg.getNodeId();
    if (nodeId != void 0 && (0, import_core.isLongRangeNodeId)(nodeId) && this._controller?.maxPayloadSizeLR) {
      return this._controller.maxPayloadSizeLR;
    }
    const maxExplorerPayloadSinglecast = this._controller?.maxPayloadSize ?? 46;
    if ((0, import_serialapi.isSendDataSinglecast)(msg)) {
      if (msg.transmitOptions & import_core.TransmitOptions.Explore) {
        return maxExplorerPayloadSinglecast;
      }
      if (msg.transmitOptions & import_core.TransmitOptions.AutoRoute) {
        return maxExplorerPayloadSinglecast + 2;
      }
      return maxExplorerPayloadSinglecast + 8;
    } else {
      const maxExplorerPayloadMulticast = maxExplorerPayloadSinglecast - import_core.NUM_NODEMASK_BYTES;
      if (msg.transmitOptions & import_core.TransmitOptions.ACK) {
        if (msg.transmitOptions & import_core.TransmitOptions.Explore) {
          return maxExplorerPayloadMulticast;
        }
        if (msg.transmitOptions & import_core.TransmitOptions.AutoRoute) {
          return maxExplorerPayloadMulticast + 2;
        }
      }
      return maxExplorerPayloadMulticast + 8;
    }
  }
  async exceedsMaxPayloadLength(msg) {
    const serializedCC = await msg.serializeCC(this.getEncodingContext());
    return serializedCC.length > this.getMaxPayloadLength(msg);
  }
  /** Determines time in milliseconds to wait for a report from a node */
  getReportTimeout(msg) {
    const node = this.tryGetNode(msg);
    return (
      // If there's a message-specific timeout, use that
      msg.nodeUpdateTimeout ?? node?.deviceConfig?.compat?.reportTimeout ?? this._options.timeouts.report
    );
  }
  /** Returns the preferred constructor to use for singlecast SendData commands */
  getSendDataSinglecastConstructor() {
    return this._controller?.isFunctionSupported(import_serial.FunctionType.SendDataBridge) ? import_serialapi.SendDataBridgeRequest : import_serialapi.SendDataRequest;
  }
  /** Returns the preferred constructor to use for multicast SendData commands */
  getSendDataMulticastConstructor() {
    return this._controller?.isFunctionSupported(import_serial.FunctionType.SendDataMulticastBridge) ? import_serialapi.SendDataMulticastBridgeRequest : import_serialapi.SendDataMulticastRequest;
  }
  /**
   * Checks whether there is a compatible update for the currently installed config package.
   * Returns the new version if there is an update, `undefined` otherwise.
   */
  async checkForConfigUpdates(silent = false) {
    this.ensureReady();
    try {
      if (!silent) {
        this.driverLog.print("Checking for configuration updates...");
      }
      const ret = await (0, import_UpdateConfig.checkForConfigUpdates)(this.configVersion);
      if (ret) {
        if (!silent) {
          this.driverLog.print(`Configuration update available: ${ret}`);
        }
      } else {
        if (!silent) {
          this.driverLog.print("No configuration update available...");
        }
      }
      return ret;
    } catch (e) {
      this.driverLog.print((0, import_shared.getErrorMessage)(e), "error");
    }
  }
  _installConfigUpdatePromise;
  /**
   * Installs an update for the embedded configuration DB if there is a compatible one.
   * Returns `true` when an update was installed, `false` otherwise.
   *
   * **Note:** Bugfixes and changes to device configuration generally require a restart or re-interview to take effect.
   */
  async installConfigUpdate() {
    this.ensureReady();
    if (this._installConfigUpdatePromise) {
      return this._installConfigUpdatePromise;
    }
    this._installConfigUpdatePromise = this.installConfigUpdateInternal();
    try {
      return await this._installConfigUpdatePromise;
    } finally {
      this._installConfigUpdatePromise = void 0;
    }
  }
  async installConfigUpdateInternal() {
    const newVersion = await this.checkForConfigUpdates(true);
    if (!newVersion)
      return false;
    const extConfigDir = this.configManager.externalConfigDir;
    if (!this.configManager.useExternalConfig || !extConfigDir) {
      this.driverLog.print(`Cannot update configuration DB update - external config directory is not set`, "error");
      return false;
    }
    this.driverLog.print(`Installing version ${newVersion} of configuration DB...`);
    try {
      await (0, import_UpdateConfig.installConfigUpdate)(this.bindings.fs, newVersion, { configDir: extConfigDir });
    } catch (e) {
      this.driverLog.print((0, import_shared.getErrorMessage)(e), "error");
      return false;
    }
    this.driverLog.print(`Configuration DB updated to version ${newVersion}, activating...`);
    await this.configManager.loadAll();
    if (this._controller) {
      for (const node of this._controller.nodes.values()) {
        if (node.ready)
          await node["loadDeviceConfig"]();
      }
    }
    return true;
  }
  // region OTW Firmware Updates
  _otwFirmwareUpdateInProgress = false;
  /**
   * Returns whether a firmware update is in progress for the Z-Wave module.
   */
  isOTWFirmwareUpdateInProgress() {
    return this._otwFirmwareUpdateInProgress;
  }
  /**
   * Updates the firmware of the controller using the given firmware file.
   * The file can be provided as binary data or as a {@link FirmwareUpdateInfo} object as returned
   * from the firmware update service. The latter will be downloaded automatically.
   *
   * The return value indicates whether the update was successful.
   * **WARNING:** After a successful update, the Z-Wave driver will destroy itself so it can be restarted.
   *
   * **WARNING:** A failure during this process may put your controller in recovery mode, rendering it unusable until a correct firmware image is uploaded. Use at your own risk!
   */
  async firmwareUpdateOTW(data) {
    if (this._controller?.isAnyOTAFirmwareUpdateInProgress()) {
      const message = `Failed to start the update: A firmware update is already in progress on this network!`;
      this.controllerLog.print(message, "error");
      throw new import_core.ZWaveError(message, import_core.ZWaveErrorCodes.OTW_Update_Busy);
    }
    if (this.isOTWFirmwareUpdateInProgress()) {
      const message = `Failed to start the update: The controller is currently being updated!`;
      this.controllerLog.print(message, "error");
      throw new import_core.ZWaveError(message, import_core.ZWaveErrorCodes.OTW_Update_Busy);
    }
    if ((0, import_Types.isFirmwareUpdateInfo)(data)) {
      data = await this.extractOTWUpdateInfo(data);
    }
    if (this.mode === import_DriverMode.DriverMode.Bootloader) {
      return this.firmwareUpdateOTW700(data);
    } else if (this.mode === import_DriverMode.DriverMode.SerialAPI) {
      if (this.controller.sdkVersionGte("7.0")) {
        return this.firmwareUpdateOTW700(data);
      } else if (this.controller.sdkVersionGte("6.50.0") && this.controller.supportedFunctionTypes?.includes(import_serial.FunctionType.FirmwareUpdateNVM)) {
        const wasUpdated = await this.firmwareUpdateOTW500(data);
        if (wasUpdated.success) {
          this.driverLog.print("Activating new firmware and restarting driver...");
          await this.softResetAndRestart();
        }
        return wasUpdated;
      }
    } else if (this.mode === import_DriverMode.DriverMode.CLI) {
      return this.firmwareUpdateOTW700(data);
    }
    throw new import_core.ZWaveError(`Firmware updates are not supported on this Z-Wave module`, import_core.ZWaveErrorCodes.Controller_NotSupported);
  }
  /**
   * Downloads the desired firmware update from the Z-Wave JS firmware update service and extracts the firmware data.
   * @param updateInfo The desired entry from the updates array that was returned by {@link getAvailableFirmwareUpdates}.
   * Before applying the update, Z-Wave JS will check whether the device IDs, firmware version and region match.
   */
  async extractOTWUpdateInfo(updateInfo) {
    if (updateInfo.files?.length !== 1) {
      throw new import_core.ZWaveError(`Invalid number of update files for OTW firmware updates.`, import_core.ZWaveErrorCodes.Argument_Invalid);
    }
    const update = updateInfo.files[0];
    if (updateInfo.downgrade) {
      throw new import_core.ZWaveError(`Invalid update file: Downgrades are not supported!`, import_core.ZWaveErrorCodes.Argument_Invalid);
    }
    if (updateInfo.device.manufacturerId !== this.controller.manufacturerId || updateInfo.device.productType !== this.controller.productType || updateInfo.device.productId !== this.controller.productId) {
      throw new import_core.ZWaveError(`Cannot update controller firmware: The firmware update is for a different device!`, import_core.ZWaveErrorCodes.FWUpdateService_DeviceMismatch);
    } else if (updateInfo.device.firmwareVersion !== this.controller.firmwareVersion) {
      throw new import_core.ZWaveError(`Cannot update controller firmware: The update is for a different original firmware version!`, import_core.ZWaveErrorCodes.FWUpdateService_DeviceMismatch);
    }
    const loglevel = this.getLogConfig().level;
    let logMessage = `Downloading OTW firmware update...`;
    if (loglevel === "silly") {
      logMessage += `
URL:       ${update.url}
integrity: ${update.integrity}`;
    }
    this.controllerLog.print(logMessage);
    let firmware;
    try {
      firmware = await (0, import_FirmwareUpdateService.downloadFirmwareUpdate)(update);
    } catch (e) {
      let message = `Downloading the OTW firmware update failed:
`;
      if ((0, import_core.isZWaveError)(e)) {
        throw new import_core.ZWaveError(message + e.message, e.code);
      } else if (e.response) {
        if ((0, import_typeguards.isObject)(e.response.data) && typeof e.response.data.message === "string") {
          message += `${e.response.data.message} `;
        }
        message += `[${e.response.status} ${e.response.statusText}]`;
      } else if (typeof e.message === "string") {
        message += e.message;
      } else {
        message += `Failed to download firmware update!`;
      }
      throw new import_core.ZWaveError(message, import_core.ZWaveErrorCodes.FWUpdateService_RequestError);
    }
    return firmware.data;
  }
  async firmwareUpdateOTW500(data) {
    this._otwFirmwareUpdateInProgress = true;
    let turnedRadioOff = false;
    try {
      this.controllerLog.print("Beginning firmware update");
      const canUpdate = await this.controller.firmwareUpdateNVMInit();
      if (!canUpdate) {
        this.controllerLog.print("OTW update failed: This controller does not support firmware updates", "error");
        const result2 = {
          success: false,
          status: import_Types3.OTWFirmwareUpdateStatus.Error_NotSupported
        };
        this.emit("firmware update finished", result2);
        return result2;
      }
      await this.controller.toggleRF(false);
      turnedRadioOff = true;
      const BLOCK_SIZE = 64;
      const numFragments = Math.ceil(data.length / BLOCK_SIZE);
      for (let fragment = 0; fragment < numFragments; fragment++) {
        const fragmentData = data.subarray(fragment * BLOCK_SIZE, (fragment + 1) * BLOCK_SIZE);
        await this.controller.firmwareUpdateNVMWrite(fragment * BLOCK_SIZE, fragmentData);
        const progress = {
          sentFragments: fragment,
          totalFragments: numFragments,
          progress: (0, import_math.roundTo)(fragment / numFragments * 100, 2)
        };
        this.emit("firmware update progress", progress);
      }
      const isValidCRC = await this.controller.firmwareUpdateNVMIsValidCRC16();
      if (!isValidCRC) {
        this.controllerLog.print("OTW update failed: The firmware image is invalid", "error");
        const result2 = {
          success: false,
          status: import_Types3.OTWFirmwareUpdateStatus.Error_Aborted
        };
        this.emit("firmware update finished", result2);
        return result2;
      }
      this.emit("firmware update progress", {
        sentFragments: numFragments,
        totalFragments: numFragments,
        progress: 100
      });
      await this.controller.firmwareUpdateNVMSetNewImage();
      this.controllerLog.print("Firmware update succeeded");
      const result = {
        success: true,
        status: import_Types3.OTWFirmwareUpdateStatus.OK
      };
      this.emit("firmware update finished", result);
      return result;
    } finally {
      this._otwFirmwareUpdateInProgress = false;
      if (turnedRadioOff)
        await this.controller.toggleRF(true);
    }
  }
  async firmwareUpdateOTW700(data) {
    const maxAttempts = this.options.attempts.firmwareUpdateOTW;
    let result;
    for (let attempt = 1; attempt <= maxAttempts; attempt++) {
      result = await this.firmwareUpdateOTW700Internal(data);
      if (result.success)
        break;
      if (result.status === import_Types3.OTWFirmwareUpdateStatus.Error_Aborted && result.errorCode != void 0 && (result.errorCode & 240) === 32) {
        if (attempt < maxAttempts) {
          this.controllerLog.print(`Retrying firmware update after XMODEM communication error ${(0, import_shared.num2hex)(result.errorCode)}, attempt ${attempt}/${maxAttempts}...`, "warn");
          await (0, import_async.wait)(250);
          continue;
        }
        this.controllerLog.print("Maximum firmware update attempts reached, giving up.", "error");
      }
      break;
    }
    this.emit("firmware update finished", result);
    return result;
  }
  async firmwareUpdateOTW700Internal(data) {
    this._otwFirmwareUpdateInProgress = true;
    try {
      await this.enterBootloader();
      this.controllerLog.print("Beginning firmware upload");
      await this.bootloader.beginUpload();
      try {
        await this.waitForBootloaderChunk((c) => c.type === import_serial.BootloaderChunkType.Message && c.message === "begin upload", 5e3);
        await this.waitForBootloaderChunk((c) => c.type === import_serial.BootloaderChunkType.FlowControl && c.command === import_serial.XModemMessageHeaders.C, 1e3);
      } catch {
        this.controllerLog.print("OTW update failed: Expected response not received from the bootloader", "error");
        const result2 = {
          success: false,
          status: import_Types3.OTWFirmwareUpdateStatus.Error_Timeout
        };
        return result2;
      }
      const BLOCK_SIZE = 128;
      if (data.length % BLOCK_SIZE !== 0) {
        data = import_shared.Bytes.concat([
          data,
          new import_shared.Bytes(BLOCK_SIZE - data.length % BLOCK_SIZE).fill(255)
        ]);
      }
      const numFragments = Math.ceil(data.length / BLOCK_SIZE);
      let aborted = false;
      transfer: for (let fragment = 1; fragment <= numFragments; fragment++) {
        const fragmentData = data.subarray((fragment - 1) * BLOCK_SIZE, fragment * BLOCK_SIZE);
        retry: for (let retry = 0; retry < 3; retry++) {
          await this.bootloader.uploadFragment(fragment, fragmentData);
          let result3;
          try {
            result3 = await this.waitForBootloaderChunk((c) => c.type === import_serial.BootloaderChunkType.FlowControl, 1e3);
          } catch {
            this.controllerLog.print("OTW update failed: The bootloader did not acknowledge the start of transfer.", "error");
            const result4 = {
              success: false,
              status: import_Types3.OTWFirmwareUpdateStatus.Error_Timeout
            };
            return result4;
          }
          switch (result3.command) {
            case import_serial.XModemMessageHeaders.ACK: {
              const progress = {
                sentFragments: fragment,
                totalFragments: numFragments,
                progress: (0, import_math.roundTo)(fragment / numFragments * 100, 2)
              };
              this.emit("firmware update progress", progress);
              continue transfer;
            }
            case import_serial.XModemMessageHeaders.NAK:
              continue retry;
            case import_serial.XModemMessageHeaders.CAN:
              aborted = true;
              break transfer;
          }
        }
        this.controllerLog.print("OTW update failed: Maximum retry attempts reached", "error");
        const result2 = {
          success: false,
          status: import_Types3.OTWFirmwareUpdateStatus.Error_RetryLimitReached
        };
        return result2;
      }
      if (aborted) {
        const error = await this.waitForBootloaderChunk((c) => c.type === import_serial.BootloaderChunkType.Message && c.message.includes("error 0x"), 1e3).catch(() => void 0);
        await this.waitForBootloaderChunk((c) => c.type === import_serial.BootloaderChunkType.Menu, 1e3).catch(() => void 0);
        let message = `OTW update was aborted by the bootloader.`;
        let errorCode;
        if (error) {
          message += ` ${error.message}`;
          const errorMatch = error.message.match(/error 0x([0-9a-fA-F]+)/);
          if (errorMatch) {
            const errorCodeStr = errorMatch[1];
            errorCode = parseInt(errorCodeStr, 16);
          }
        }
        this.controllerLog.print(message, "error");
        const result2 = {
          success: false,
          status: import_Types3.OTWFirmwareUpdateStatus.Error_Aborted,
          errorCode
        };
        return result2;
      } else {
        await this.bootloader.finishUpload();
        try {
          await Promise.all([
            this.waitForBootloaderChunk((c) => c.type === import_serial.BootloaderChunkType.Message && c.message.includes("upload complete"), 1e3),
            this.waitForBootloaderChunk((c) => c.type === import_serial.BootloaderChunkType.Menu, 1e3)
          ]);
        } catch {
          this.controllerLog.print("OTW update failed: The bootloader did not acknowledge the end of transfer.", "error");
          const result2 = {
            success: false,
            status: import_Types3.OTWFirmwareUpdateStatus.Error_Timeout
          };
          return result2;
        }
      }
      this.controllerLog.print("Firmware update succeeded");
      const result = {
        success: true,
        status: import_Types3.OTWFirmwareUpdateStatus.OK
      };
      return result;
    } finally {
      await this.leaveBootloader();
      this._otwFirmwareUpdateInProgress = false;
    }
  }
  // region Bootloader
  _enteringBootloader = false;
  _enterBootloaderPromise;
  async enterBootloader() {
    if (this._bootloader)
      return;
    this.controllerLog.print("Entering bootloader...");
    this._enteringBootloader = true;
    try {
      if (this.mode === import_DriverMode.DriverMode.SerialAPI) {
        await this.enterBootloaderFromSerialAPI();
      } else if (this.mode === import_DriverMode.DriverMode.CLI) {
        await this.enterBootloaderFromCLI();
      }
      this._enterBootloaderPromise = (0, import_deferred_promise.createDeferredPromise)();
      const success = await Promise.race([
        this._enterBootloaderPromise.then(() => true),
        (0, import_async.wait)(5e3, true).then(() => false)
      ]);
      if (success) {
        this.controllerLog.print("Entered bootloader");
      } else {
        throw new import_core.ZWaveError("Failed to enter bootloader", import_core.ZWaveErrorCodes.Controller_Timeout);
      }
    } finally {
      this._enteringBootloader = false;
    }
  }
  async enterBootloaderFromSerialAPI() {
    const ctx = this.getEncodingContext();
    await this.destroyController();
    const msg = new import_serialapi.EnterBootloaderRequest();
    const promise = this.writeSerial(await msg.serialize(ctx));
    this.serial.mode = import_serial.ZWaveSerialMode.Bootloader;
    await promise;
  }
  async enterBootloaderFromCLI() {
    await this.cli.executeCommand("bootloader");
    this.serial.mode = void 0;
  }
  leaveBootloaderInternal() {
    const promise = this.bootloader.runApplication();
    this.serial.mode = void 0;
    this._bootloader = void 0;
    return promise;
  }
  /**
   * Leaves the bootloader by running the application.
   */
  async leaveBootloader() {
    this.controllerLog.print("Leaving bootloader...");
    await this.leaveBootloaderInternal();
    const isSerialAPI = await this.waitForMessage((msg) => msg.functionType === import_serial.FunctionType.SerialAPIStarted, 1e3).then(() => true).catch(() => false);
    if (isSerialAPI) {
      await this.initializeControllerAndNodes();
      return;
    } else if (this.mode === import_DriverMode.DriverMode.CLI) {
      await this.ensureCLIReady();
      return;
    } else if (this._bootloader) {
      return;
    }
    this.unpauseSendQueue();
    await this.ensureSerialAPI();
  }
  serialport_onBootloaderData(data) {
    switch (data.type) {
      case import_serial.BootloaderChunkType.Message: {
        this.controllerLog.print(`[BOOTLOADER] ${data.message}`, "verbose");
        break;
      }
      case import_serial.BootloaderChunkType.FlowControl: {
        if (data.command === import_serial.XModemMessageHeaders.C) {
          this.controllerLog.print(`[BOOTLOADER] awaiting input...`, "verbose");
        }
        break;
      }
    }
    for (const entry of this.awaitedBootloaderChunks) {
      if (entry.predicate(data)) {
        entry.handler(data);
        return;
      }
    }
    if (!this._bootloader && data.type === import_serial.BootloaderChunkType.Menu) {
      this._controller?.destroy();
      this._controller = void 0;
      this._cli = void 0;
      this.controllerLog.print(`[BOOTLOADER] version ${data.version}`, "verbose");
      this._bootloader = new import_Bootloader.Bootloader(this.writeSerial.bind(this), data.version, data.options);
      if (this._enterBootloaderPromise) {
        this._enterBootloaderPromise.resolve();
        this._enterBootloaderPromise = void 0;
      }
    }
  }
  /**
   * Waits until a specific chunk is received from the bootloader or an optional timeout has elapsed. Returns the received chunk.
   * @param timeout The number of milliseconds to wait. If the timeout elapses, the returned promise will be rejected
   * @param predicate A predicate function to test all incoming chunks
   */
  waitForBootloaderChunk(predicate, timeout, abortSignal) {
    return new Promise((resolve, reject) => {
      const promise = (0, import_deferred_promise.createDeferredPromise)();
      const entry = {
        predicate,
        handler: /* @__PURE__ */ __name((chunk) => promise.resolve(chunk), "handler"),
        timeout: void 0
      };
      this.awaitedBootloaderChunks.push(entry);
      const removeEntry = /* @__PURE__ */ __name(() => {
        entry.timeout?.clear();
        abortSignal?.removeEventListener("abort", removeEntry);
        const index = this.awaitedBootloaderChunks.indexOf(entry);
        if (index !== -1)
          this.awaitedBootloaderChunks.splice(index, 1);
      }, "removeEntry");
      if (timeout) {
        entry.timeout = (0, import_shared.setTimer)(() => {
          removeEntry();
          reject(new import_core.ZWaveError(`Received no matching chunk within the provided timeout!`, import_core.ZWaveErrorCodes.Controller_Timeout));
        }, timeout);
      }
      void promise.then((chunk) => {
        removeEntry();
        resolve(chunk);
      });
      abortSignal?.addEventListener("abort", removeEntry);
    });
  }
  /**
   * Waits until a specific chunk is received from the end device CLI or an optional timeout has elapsed. Returns the received chunk.
   * @param timeout The number of milliseconds to wait. If the timeout elapses, the returned promise will be rejected
   * @param predicate A predicate function to test all incoming chunks
   */
  waitForCLIChunk(predicate, timeout, abortSignal) {
    return new Promise((resolve, reject) => {
      const promise = (0, import_deferred_promise.createDeferredPromise)();
      const entry = {
        predicate,
        handler: /* @__PURE__ */ __name((chunk) => promise.resolve(chunk), "handler"),
        timeout: void 0
      };
      this.awaitedCLIChunks.push(entry);
      const removeEntry = /* @__PURE__ */ __name(() => {
        entry.timeout?.clear();
        abortSignal?.removeEventListener("abort", removeEntry);
        const index = this.awaitedCLIChunks.indexOf(entry);
        if (index !== -1)
          this.awaitedCLIChunks.splice(index, 1);
      }, "removeEntry");
      if (timeout) {
        entry.timeout = (0, import_shared.setTimer)(() => {
          removeEntry();
          reject(new import_core.ZWaveError(`Received no matching chunk within the provided timeout!`, import_core.ZWaveErrorCodes.Controller_Timeout));
        }, timeout);
      }
      void promise.then((chunk) => {
        removeEntry();
        resolve(chunk);
      });
      abortSignal?.addEventListener("abort", removeEntry);
    });
  }
  async serialport_onCLIData(data) {
    for (const entry of this.awaitedCLIChunks) {
      if (entry.predicate(data)) {
        entry.handler(data);
        return;
      }
    }
    if (!this._cli && data.type === import_serial.CLIChunkType.Prompt) {
      this._controller?.destroy();
      this._controller = void 0;
      this._bootloader = void 0;
      this._cli = new import_EndDeviceCLI.EndDeviceCLI(this.writeSerial.bind(this), (timeout) => this.waitForCLIChunk((c) => c.type === import_serial.CLIChunkType.Message, timeout ?? 1e3).then((c) => c.message).catch(() => void 0));
      if (!await this.ensureCLIReady()) {
        throw new import_core.ZWaveError("Failed to detect available CLI commands", import_core.ZWaveErrorCodes.Driver_Failed);
      }
    }
  }
  pollBackgroundRSSITimer;
  lastBackgroundRSSITimestamp = 0;
  hfBackgroundRSSIEndTimestamp = 0;
  handleQueueIdleChange(idle) {
    if (idle) {
      for (const entry of this.awaitedIdle) {
        entry.handler();
      }
    }
    if (!this.ready)
      return;
    if (this.controller.isFunctionSupported(import_serial.FunctionType.GetBackgroundRSSI)) {
      if (idle) {
        this.setBackgroundRSSITimer();
      } else {
        this.clearBackgroundRSSITimer();
      }
    }
  }
  setBackgroundRSSITimer() {
    let timeout;
    if (Date.now() < this.hfBackgroundRSSIEndTimestamp) {
      timeout = Math.max(2e3, 2e3 - (Date.now() - this.lastBackgroundRSSITimestamp));
    } else {
      timeout = Math.max(
        // Wait at least 5s
        5e3,
        // and up to 30s if we recently queried the RSSI
        3e4 - (Date.now() - this.lastBackgroundRSSITimestamp)
      );
    }
    this.pollBackgroundRSSITimer = (0, import_shared.setTimer)(async () => {
      if (!this.ready)
        return;
      this.lastBackgroundRSSITimestamp = Date.now();
      try {
        await this.controller.getBackgroundRSSI();
      } catch {
      }
    }, timeout).unref();
  }
  clearBackgroundRSSITimer() {
    this.pollBackgroundRSSITimer?.clear();
    this.pollBackgroundRSSITimer = void 0;
  }
  /** Enable frequent RSSI monitoring for the given amount of milliseconds. During this time, the background RSSI will be measured every 2 seconds. */
  enableFrequentRSSIMonitoring(durationMs) {
    if (durationMs < 1e4 || durationMs > 3600 * 1e3) {
      throw new import_core.ZWaveError(`The duration must be between 10 seconds and one hour!`, import_core.ZWaveErrorCodes.Argument_Invalid);
    }
    this.hfBackgroundRSSIEndTimestamp = Date.now() + durationMs;
    if (this.pollBackgroundRSSITimer) {
      this.clearBackgroundRSSITimer();
      this.setBackgroundRSSITimer();
    }
  }
  /** Disable frequent RSSI monitoring */
  disableFrequentRSSIMonitoring() {
    this.hfBackgroundRSSIEndTimestamp = 0;
    if (this.pollBackgroundRSSITimer) {
      this.clearBackgroundRSSITimer();
      this.setBackgroundRSSITimer();
    }
  }
  get isFrequentRSSIMonitoringEnabled() {
    return Date.now() < this.hfBackgroundRSSIEndTimestamp;
  }
  _powerlevelTestNodeContext;
  /**
   * @internal
   * Begins a powerlevel test for the given node using NOP power frames
   */
  async sendNOPPowerFrames(testNodeId, powerlevel, frameCount) {
    if (this._powerlevelTestNodeContext) {
      clearTimeout(this._powerlevelTestNodeContext.timeout);
      this._powerlevelTestNodeContext = void 0;
    }
    if (frameCount < 1)
      return 0;
    const ret = (0, import_deferred_promise.createDeferredPromise)();
    const context = {
      testNodeId,
      acknowledgedFrames: 0,
      // This is set below after defining sendFrame
      timeout: void 0
    };
    this._powerlevelTestNodeContext = context;
    const interval = 50;
    const sendFrame = /* @__PURE__ */ __name(async () => {
      const result = await this.sendTestFrame(testNodeId, powerlevel);
      if (result === import_core.TransmitStatus.OK) {
        context.acknowledgedFrames++;
      }
      frameCount--;
      if (frameCount > 0) {
        context.timeout = setTimeout(sendFrame, interval);
      } else {
        context.timeout = void 0;
        ret.resolve(context.acknowledgedFrames);
      }
    }, "sendFrame");
    context.timeout = setTimeout(sendFrame, interval);
    return ret;
  }
  /** Sends a NOP Power frame to the given node and returns the transmit status if the frame was sent */
  async sendTestFrame(nodeId, powerlevel) {
    const result = await this.sendMessage(new import_serialapi.SendTestFrameRequest({
      testNodeId: nodeId,
      powerlevel
    }));
    if (result instanceof import_serialapi.SendTestFrameTransmitReport) {
      return result.transmitStatus;
    }
  }
  /**
   * @internal
   * Returns the status of a potentially ongoing NOP power test
   */
  getNOPPowerTestStatus() {
    if (this._powerlevelTestNodeContext) {
      return {
        inProgress: !!this._powerlevelTestNodeContext.timeout,
        testNodeId: this._powerlevelTestNodeContext.testNodeId,
        acknowledgedFrames: this._powerlevelTestNodeContext.acknowledgedFrames
      };
    }
  }
  /**
   * Resets the S2 singlecast encryption state (SPAN) for the given node, which forces
   * a re-synchronization on the next communication attempt.
   */
  resetSPAN(nodeId) {
    this.getSecurityManager2(nodeId)?.deleteNonce(nodeId);
  }
  /**
   * Resets the S2 singlecast encryption state (SPAN) for all nodes, which forces
   * a re-synchronization on the next communication attempt.
   */
  resetAllSPANs() {
    for (const nodeId of this.controller.nodes.keys()) {
      this.resetSPAN(nodeId);
    }
  }
}
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  Driver,
  libName,
  libVersion
});
//# sourceMappingURL=Driver.js.map
