"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var DriverMock_exports = {};
__export(DriverMock_exports, {
  createAndStartDriverWithMockPort: () => createAndStartDriverWithMockPort,
  createAndStartTestingDriver: () => createAndStartTestingDriver
});
module.exports = __toCommonJS(DriverMock_exports);
var import_mock = require("@zwave-js/serial/mock");
var import_deferred_promise = require("alcalzone-shared/deferred-promise");
var import_node_os = require("node:os");
var import_pathe = __toESM(require("pathe"), 1);
var import_Driver = require("./Driver.js");
function createAndStartDriverWithMockPort(options = {}) {
  const { ...driverOptions } = options;
  return new Promise((resolve, reject) => {
    let driver;
    const mockPort = new import_mock.MockPort();
    const bindingFactory = mockPort.factory();
    const onSerialPortOpen = /* @__PURE__ */ __name((serial) => {
      const continuePromise = (0, import_deferred_promise.createDeferredPromise)();
      resolve({
        driver,
        mockPort,
        serial,
        continueStartup: /* @__PURE__ */ __name(() => continuePromise.resolve(), "continueStartup")
      });
      return continuePromise;
    }, "onSerialPortOpen");
    if (!driverOptions.logConfig) {
      driverOptions.logConfig = {
        enabled: false
      };
    }
    const testingHooks = {
      ...driverOptions.testingHooks,
      onSerialPortOpen
    };
    driver = new import_Driver.Driver(bindingFactory, {
      ...driverOptions,
      testingHooks
    });
    driver.start().catch(reject);
  });
}
__name(createAndStartDriverWithMockPort, "createAndStartDriverWithMockPort");
async function createAndStartTestingDriver(options = {}) {
  const { beforeStartup, skipControllerIdentification = false, skipFirmwareIdentification = true, skipNodeInterview = false, loadConfiguration = true, fs = (await import("#default_bindings/fs")).fs, ...internalOptions } = options;
  const testId = Math.round(Math.random() * 4294967295).toString(16).padStart(8, "0");
  if (skipControllerIdentification) {
    internalOptions.testingHooks ??= {};
    internalOptions.testingHooks.skipControllerIdentification = true;
  }
  if (skipNodeInterview) {
    internalOptions.testingHooks ??= {};
    internalOptions.testingHooks.skipNodeInterview = true;
  }
  if (!loadConfiguration) {
    internalOptions.testingHooks ??= {};
    internalOptions.testingHooks.loadConfiguration = false;
  }
  if (skipFirmwareIdentification) {
    internalOptions.testingHooks ??= {};
    internalOptions.testingHooks.skipFirmwareIdentification = true;
  }
  const cacheDir = import_pathe.default.join((0, import_node_os.tmpdir)(), "zwave-js-test-cache", testId);
  internalOptions.storage ??= {};
  internalOptions.storage.cacheDir = cacheDir;
  const { driver, continueStartup, mockPort, serial } = await createAndStartDriverWithMockPort(internalOptions);
  if (typeof beforeStartup === "function") {
    await beforeStartup(mockPort, serial);
  }
  const originalDestroy = driver.destroy.bind(driver);
  driver.destroy = async () => {
    await originalDestroy();
    await fs.deleteDir(cacheDir);
  };
  return new Promise((resolve) => {
    driver.once("driver ready", () => {
      resolve({ driver, mockPort, serial });
    });
    continueStartup();
  });
}
__name(createAndStartTestingDriver, "createAndStartTestingDriver");
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  createAndStartDriverWithMockPort,
  createAndStartTestingDriver
});
//# sourceMappingURL=DriverMock.js.map
