"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var EndDeviceCLI_exports = {};
__export(EndDeviceCLI_exports, {
  EndDeviceCLI: () => EndDeviceCLI
});
module.exports = __toCommonJS(EndDeviceCLI_exports);
var import_core = require("@zwave-js/core");
var import_shared = require("@zwave-js/shared");
class EndDeviceCLI {
  static {
    __name(this, "EndDeviceCLI");
  }
  constructor(writeSerial, expectMessage) {
    this.writeSerial = writeSerial;
    this.expectMessage = expectMessage;
    this._commands = /* @__PURE__ */ new Map();
  }
  writeSerial;
  expectMessage;
  _commands;
  get commands() {
    return this._commands;
  }
  async executeCommand(command) {
    if (!this.commands.has(command)) {
      throw new import_core.ZWaveError(`Unknown CLI command ${command}`, import_core.ZWaveErrorCodes.Driver_NotSupported);
    }
    const response = this.expectMessage();
    await this.writeSerial(import_shared.Bytes.from(command.trim() + "\r\n", "ascii"));
    let ret = await response;
    if (!ret)
      return;
    if (ret.startsWith(command.trim() + "\r\n")) {
      ret = ret.slice(command.length + 2);
    }
    ret = ret.trim();
    ret = ret.replace(/^\[[A-Z]\] /, "");
    return ret;
  }
  async detectCommands() {
    const response = this.expectMessage();
    await this.writeSerial(import_shared.Bytes.from("help\r\n", "ascii"));
    const commandList = await response;
    if (!commandList) {
      throw new import_core.ZWaveError("Failed to detect CLI commands", import_core.ZWaveErrorCodes.Driver_NotSupported);
    }
    const commands = commandList.trim().split("\n").map((line) => line.trim()).map((line) => line.split(/\s+/, 2).map((part) => part.trim())).filter((parts) => parts.every((part) => !!part));
    this._commands = new Map(commands);
  }
}
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  EndDeviceCLI
});
//# sourceMappingURL=EndDeviceCLI.js.map
