"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var Queue_exports = {};
__export(Queue_exports, {
  TransactionQueue: () => TransactionQueue
});
module.exports = __toCommonJS(Queue_exports);
var import_deferred_promise = require("alcalzone-shared/deferred-promise");
var import_sorted_list = require("alcalzone-shared/sorted-list");
class TransactionQueue {
  static {
    __name(this, "TransactionQueue");
  }
  constructor(options) {
    this.name = options?.name ?? "unnamed";
    this.mayStartNextTransaction = options?.mayStartNextTransaction ?? (() => true);
  }
  name;
  mayStartNextTransaction;
  transactions = new import_sorted_list.SortedList();
  currentTransaction;
  add(...items) {
    this.transactions.add(...items);
    this.trigger();
  }
  remove(...items) {
    this.transactions.remove(...items);
    this.trigger();
  }
  find(predicate) {
    return this.transactions.find(predicate);
  }
  finalizeTransaction() {
    this.currentTransaction = void 0;
  }
  get length() {
    return this.transactions.length;
  }
  /** Causes the queue to re-evaluate whether the next transaction may be started */
  trigger() {
    while (this.transactions.length > 0 && this.listeners.length > 0) {
      if (this.mayStartNextTransaction(this.transactions.peekStart())) {
        const promise = this.listeners.shift();
        const item = this.transactions.shift();
        this.currentTransaction = item;
        promise.resolve(item);
      } else {
        break;
      }
    }
  }
  // A list of Promises that are waiting to be resolved
  listeners = [];
  // Whether the queue was ended
  ended = false;
  /** Ends the queue after it has been drained */
  end() {
    this.ended = true;
  }
  /** Ends the queue and discards all pending items */
  abort() {
    this.ended = true;
    this.transactions.clear();
    this.currentTransaction = void 0;
    for (const p of this.listeners) {
      p.resolve(void 0);
    }
  }
  // Enable iterating the queue using for-await-of
  [Symbol.asyncIterator]() {
    return {
      next: /* @__PURE__ */ __name(async () => {
        let value;
        if (this.transactions.length > 0 && this.mayStartNextTransaction(this.transactions.peekStart())) {
          value = this.transactions.shift();
        } else if (!this.ended) {
          const promise = (0, import_deferred_promise.createDeferredPromise)();
          this.listeners.push(promise);
          value = await promise;
        }
        this.currentTransaction = value;
        if (value) {
          return { value, done: false };
        } else {
          return { value: void 0, done: true };
        }
      }, "next")
    };
  }
}
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  TransactionQueue
});
//# sourceMappingURL=Queue.js.map
