"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to2, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to2, key) && key !== except)
        __defProp(to2, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to2;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var SerialAPICommandMachine_exports = {};
__export(SerialAPICommandMachine_exports, {
  createSerialAPICommandMachine: () => createSerialAPICommandMachine
});
module.exports = __toCommonJS(SerialAPICommandMachine_exports);
var import_core = require("@zwave-js/core");
var import_serial = require("@zwave-js/serial");
function to(state) {
  return { newState: state };
}
__name(to, "to");
function callbackIsFinal(callback) {
  return (
    // assume callbacks without success indication to be OK
    (!(0, import_serial.isSuccessIndicator)(callback) || callback.isOK()) && (!(0, import_serial.isMultiStageCallback)(callback) || callback.isFinal())
  );
}
__name(callbackIsFinal, "callbackIsFinal");
function createSerialAPICommandMachine(message) {
  const initialState = {
    value: "initial"
  };
  const transitions = /* @__PURE__ */ __name((state) => (input) => {
    switch (state.value) {
      case "initial":
        if (input.value === "start") {
          return to({ value: "sending" });
        }
        break;
      case "sending":
        if (input.value === "message sent") {
          if (message.expectsAck()) {
            return to({ value: "waitingForACK" });
          } else {
            return to({
              value: "success",
              result: void 0,
              done: true
            });
          }
        }
        break;
      case "waitingForACK":
        switch (input.value) {
          case "ACK":
            if (message.expectsResponse()) {
              return to({ value: "waitingForResponse" });
            } else if (message.expectsCallback()) {
              return to({ value: "waitingForCallback" });
            } else {
              return to({
                value: "success",
                result: void 0,
                done: true
              });
            }
          case "CAN":
            return to({ value: "failure", reason: "CAN" });
          case "NAK":
            return to({ value: "failure", reason: "NAK" });
          case "timeout":
            return to({
              value: "failure",
              reason: "ACK timeout"
            });
        }
        break;
      case "waitingForResponse":
        switch (input.value) {
          case "response":
            if (message.expectsCallback()) {
              return to({ value: "waitingForCallback" });
            } else {
              return to({
                value: "success",
                result: input.response,
                done: true
              });
            }
          case "response NOK":
            return to({
              value: "failure",
              reason: "response NOK",
              result: input.response
            });
          case "timeout":
            if ((0, import_serial.isSendData)(message)) {
              return {
                newState: {
                  value: "waitingForCallback",
                  responseTimedOut: true
                }
              };
            } else {
              return to({
                value: "failure",
                reason: "response timeout"
              });
            }
        }
        break;
      case "waitingForCallback":
        switch (input.value) {
          case "callback":
            if (callbackIsFinal(input.callback)) {
              return to({
                value: "success",
                result: input.callback,
                done: true
              });
            } else {
              return to({ value: "waitingForCallback" });
            }
          case "callback NOK":
            if (state.responseTimedOut) {
              return to({
                value: "failure",
                reason: "response timeout"
              });
            } else {
              return to({
                value: "failure",
                reason: "callback NOK",
                result: input.callback
              });
            }
          case "timeout":
            return to({
              value: "failure",
              reason: "callback timeout"
            });
        }
        break;
    }
  }, "transitions");
  return new import_core.StateMachine(initialState, transitions);
}
__name(createSerialAPICommandMachine, "createSerialAPICommandMachine");
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  createSerialAPICommandMachine
});
//# sourceMappingURL=SerialAPICommandMachine.js.map
