"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to2, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to2, key) && key !== except)
        __defProp(to2, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to2;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var TransportServiceMachine_exports = {};
__export(TransportServiceMachine_exports, {
  createTransportServiceRXMachine: () => createTransportServiceRXMachine
});
module.exports = __toCommonJS(TransportServiceMachine_exports);
var import_core = require("@zwave-js/core");
function to(state) {
  return { newState: state };
}
__name(to, "to");
function createTransportServiceRXMachine(datagramSize, firstSegmentSize) {
  const initialState = {
    value: "receive"
  };
  const receivedBytes = [
    // When the machine is started, we've already received the first segment
    ...Array.from({ length: firstSegmentSize }).fill(true),
    // The rest of the segments are still missing
    ...Array.from({ length: datagramSize - firstSegmentSize }).fill(false)
  ];
  function markReceived(offset, length) {
    for (let i = offset; i < offset + length; i++) {
      receivedBytes[i] = true;
    }
  }
  __name(markReceived, "markReceived");
  function isComplete() {
    return receivedBytes.every(Boolean);
  }
  __name(isComplete, "isComplete");
  function hasReceivedLastSegment() {
    return receivedBytes.at(-1);
  }
  __name(hasReceivedLastSegment, "hasReceivedLastSegment");
  function hasHole() {
    return receivedBytes.lastIndexOf(true) > receivedBytes.indexOf(false);
  }
  __name(hasHole, "hasHole");
  const transitions = /* @__PURE__ */ __name((state) => (input) => {
    if (input.value === "abort") {
      if (state.value !== "success" && state.value !== "failure") {
        return to({ value: "failure", done: true });
      }
      return;
    }
    switch (state.value) {
      case "receive": {
        if (input.value === "segment") {
          markReceived(input.offset, input.length);
          if (isComplete()) {
            return to({ value: "success", done: true });
          } else if (hasReceivedLastSegment() && hasHole()) {
            return to({
              value: "requestMissing",
              offset: receivedBytes.indexOf(false)
            });
          } else {
            return to({ value: "receive" });
          }
        } else if (input.value === "timeout") {
          return to({
            value: "requestMissing",
            offset: receivedBytes.indexOf(false)
          });
        }
        break;
      }
      case "requestMissing": {
        if (input.value === "segment") {
          markReceived(input.offset, input.length);
          if (isComplete()) {
            return to({ value: "success", done: true });
          } else {
            return to({
              value: "requestMissing",
              offset: receivedBytes.indexOf(false)
            });
          }
        } else if (input.value === "timeout") {
          return to({ value: "failure", done: true });
        }
      }
    }
  }, "transitions");
  return new import_core.StateMachine(initialState, transitions);
}
__name(createTransportServiceRXMachine, "createTransportServiceRXMachine");
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  createTransportServiceRXMachine
});
//# sourceMappingURL=TransportServiceMachine.js.map
