"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var BasicCC_exports = {};
__export(BasicCC_exports, {
  handleBasicCommand: () => handleBasicCommand
});
module.exports = __toCommonJS(BasicCC_exports);
var import_cc = require("@zwave-js/cc");
var import_core = require("@zwave-js/core");
function handleBasicCommand(ctx, node, command) {
  const sourceEndpoint = node.getEndpoint(command.endpointIndex ?? 0) ?? node;
  let mappedTargetCC;
  switch (sourceEndpoint.deviceClass?.generic.key) {
    case 32:
      mappedTargetCC = sourceEndpoint.createCCInstanceUnsafe(import_core.CommandClasses["Binary Sensor"]);
      break;
    case 16:
      mappedTargetCC = sourceEndpoint.createCCInstanceUnsafe(import_core.CommandClasses["Binary Switch"]);
      break;
    case 17:
      mappedTargetCC = sourceEndpoint.createCCInstanceUnsafe(import_core.CommandClasses["Multilevel Switch"]);
      break;
    case 18:
      switch (sourceEndpoint.deviceClass.specific.key) {
        case 1:
          mappedTargetCC = sourceEndpoint.createCCInstanceUnsafe(import_core.CommandClasses["Binary Switch"]);
          break;
        case 2:
          mappedTargetCC = sourceEndpoint.createCCInstanceUnsafe(import_core.CommandClasses["Multilevel Switch"]);
          break;
      }
  }
  if (command instanceof import_cc.BasicCCReport) {
    const basicReportMapping = node.deviceConfig?.compat?.mapBasicReport ?? "auto";
    if (basicReportMapping === "Binary Sensor") {
      mappedTargetCC = sourceEndpoint.createCCInstanceUnsafe(import_core.CommandClasses["Binary Sensor"]);
      if (typeof command.currentValue === "number") {
        if (mappedTargetCC) {
          ctx.logNode(node.id, {
            endpoint: command.endpointIndex,
            message: "treating BasicCC::Report as a BinarySensorCC::Report"
          });
          mappedTargetCC.setMappedBasicValue(ctx, command.currentValue);
        } else {
          ctx.logNode(node.id, {
            endpoint: command.endpointIndex,
            message: "cannot treat BasicCC::Report as a BinarySensorCC::Report, because the Binary Sensor CC is not supported",
            level: "warn"
          });
        }
      } else {
        ctx.logNode(node.id, {
          endpoint: command.endpointIndex,
          message: "cannot map BasicCC::Report to a different CC, because the current value is unknown",
          level: "warn"
        });
      }
    } else if (basicReportMapping === "auto" || basicReportMapping === false) {
      const didSetMappedValue = typeof command.currentValue === "number" && basicReportMapping === "auto" && mappedTargetCC?.setMappedBasicValue(ctx, command.currentValue);
      if (!didSetMappedValue) {
        command.persistValues(ctx);
      }
    }
  } else if (command instanceof import_cc.BasicCCSet) {
    const basicSetMapping = node.deviceConfig?.compat?.mapBasicSet ?? "report";
    if (basicSetMapping === "event") {
      ctx.logNode(node.id, {
        endpoint: command.endpointIndex,
        message: "treating BasicCC::Set as a value event"
      });
      node.valueDB.setValue(import_cc.BasicCCValues.compatEvent.endpoint(command.endpointIndex), command.targetValue, {
        stateful: false
      });
    } else if (basicSetMapping === "Binary Sensor") {
      mappedTargetCC = sourceEndpoint.createCCInstanceUnsafe(import_core.CommandClasses["Binary Sensor"]);
      if (mappedTargetCC) {
        ctx.logNode(node.id, {
          endpoint: command.endpointIndex,
          message: "treating BasicCC::Set as a BinarySensorCC::Report"
        });
        mappedTargetCC.setMappedBasicValue(ctx, command.targetValue);
      } else {
        ctx.logNode(node.id, {
          endpoint: command.endpointIndex,
          message: "cannot treat BasicCC::Set as a BinarySensorCC::Report, because the Binary Sensor CC is not supported",
          level: "warn"
        });
      }
    } else if (!node.deviceConfig?.compat?.mapBasicSet && !!(command.encapsulationFlags & import_core.EncapsulationFlags.Supervision)) {
      if (command.encapsulationFlags & import_core.EncapsulationFlags.Supervision) {
        throw new import_core.ZWaveError("Basic CC is not supported", import_core.ZWaveErrorCodes.CC_NotSupported);
      }
    } else if (basicSetMapping === "auto" || basicSetMapping === "report") {
      ctx.logNode(node.id, {
        endpoint: command.endpointIndex,
        message: "treating BasicCC::Set as a report"
      });
      const didSetMappedValue = basicSetMapping === "auto" && !!mappedTargetCC?.setMappedBasicValue(ctx, command.targetValue);
      if (!didSetMappedValue) {
        node.valueDB.setValue(import_cc.BasicCCValues.currentValue.endpoint(command.endpointIndex), command.targetValue);
        if (!sourceEndpoint.controlsCC(import_core.CommandClasses.Basic)) {
          sourceEndpoint.addCC(import_core.CommandClasses.Basic, {
            isControlled: true
          });
        }
      }
    }
  }
}
__name(handleBasicCommand, "handleBasicCommand");
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  handleBasicCommand
});
//# sourceMappingURL=BasicCC.js.map
