"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var NodeStatistics_exports = {};
__export(NodeStatistics_exports, {
  NodeStatisticsHost: () => NodeStatisticsHost,
  routeStatisticsEquals: () => routeStatisticsEquals
});
module.exports = __toCommonJS(NodeStatistics_exports);
var import_core = require("@zwave-js/core");
var import_Statistics = require("../driver/Statistics.js");
class NodeStatisticsHost extends import_Statistics.StatisticsHost {
  static {
    __name(this, "NodeStatisticsHost");
  }
  getAdditionalEventArgs() {
    return [this];
  }
  createEmpty() {
    const stats = {
      commandsTX: 0,
      commandsRX: 0,
      commandsDroppedRX: 0,
      commandsDroppedTX: 0,
      timeoutResponse: 0
    };
    if ((0, import_core.isLongRangeNodeId)(this.id)) {
      stats.lwr = {
        protocolDataRate: import_core.ProtocolDataRate.LongRange_100k,
        repeaters: []
      };
    }
    const lastSeen = this.lastSeen;
    if (lastSeen) {
      stats.lastSeen = lastSeen;
    }
    return stats;
  }
}
function routeStatisticsEquals(r1, r2) {
  if (r1.repeaters.length !== r2.repeaters.length)
    return false;
  if (!r1.repeaters.every((node) => r2.repeaters.includes(node))) {
    return false;
  }
  return true;
}
__name(routeStatisticsEquals, "routeStatisticsEquals");
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  NodeStatisticsHost,
  routeStatisticsEquals
});
//# sourceMappingURL=NodeStatistics.js.map
