"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to2, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to2, key) && key !== except)
        __defProp(to2, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to2;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var NodeStatusMachine_exports = {};
__export(NodeStatusMachine_exports, {
  createNodeStatusMachine: () => createNodeStatusMachine,
  nodeStatusMachineStateToNodeStatus: () => nodeStatusMachineStateToNodeStatus
});
module.exports = __toCommonJS(NodeStatusMachine_exports);
var import_core = require("@zwave-js/core");
function to(state) {
  return { newState: state };
}
__name(to, "to");
const statusDict = {
  unknown: import_core.NodeStatus.Unknown,
  dead: import_core.NodeStatus.Dead,
  alive: import_core.NodeStatus.Alive,
  asleep: import_core.NodeStatus.Asleep,
  awake: import_core.NodeStatus.Awake
};
function nodeStatusMachineStateToNodeStatus(state) {
  return statusDict[state] ?? import_core.NodeStatus.Unknown;
}
__name(nodeStatusMachineStateToNodeStatus, "nodeStatusMachineStateToNodeStatus");
function createNodeStatusMachine(node) {
  const initialState = {
    value: "unknown"
  };
  const transitions = /* @__PURE__ */ __name((state) => (input) => {
    switch (state.value) {
      case "unknown": {
        switch (input.value) {
          case "DEAD":
            if (!node.canSleep)
              return to({ value: "dead" });
            break;
          case "ALIVE":
            if (!node.canSleep)
              return to({ value: "alive" });
            break;
          case "ASLEEP":
            if (node.canSleep)
              return to({ value: "asleep" });
            break;
          case "AWAKE":
            if (node.canSleep)
              return to({ value: "awake" });
            break;
        }
        break;
      }
      case "dead": {
        if (input.value === "ALIVE")
          return to({ value: "alive" });
        break;
      }
      case "alive": {
        switch (input.value) {
          case "DEAD":
            return to({ value: "dead" });
          // GH#1054 we must have a way to send a node to sleep even if
          // it was previously detected as a non-sleeping device
          case "ASLEEP": {
            if (node.canSleep)
              return to({ value: "asleep" });
            break;
          }
          case "AWAKE": {
            if (node.canSleep)
              return to({ value: "awake" });
            break;
          }
        }
        break;
      }
      case "asleep": {
        if (input.value === "AWAKE")
          return to({ value: "awake" });
        break;
      }
      case "awake": {
        if (input.value === "ASLEEP") {
          return to({ value: "asleep" });
        }
        break;
      }
    }
  }, "transitions");
  return new import_core.StateMachine(initialState, transitions);
}
__name(createNodeStatusMachine, "createNodeStatusMachine");
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  createNodeStatusMachine,
  nodeStatusMachineStateToNodeStatus
});
//# sourceMappingURL=NodeStatusMachine.js.map
