"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var Security_exports = {};
__export(Security_exports, {
  NodeSecurityMixin: () => NodeSecurityMixin
});
module.exports = __toCommonJS(Security_exports);
var import_core = require("@zwave-js/core");
var import_shared = require("@zwave-js/shared");
var import_NetworkCache = require("../../driver/NetworkCache.js");
var import_NetworkRole = require("./01_NetworkRole.js");
class NodeSecurityMixin extends import_NetworkRole.NetworkRoleMixin {
  static {
    __name(this, "NodeSecurityMixin");
  }
  constructor(nodeId, driver, index, deviceClass, supportedCCs) {
    super(nodeId, driver, index, deviceClass, supportedCCs);
    this.securityClasses = new import_core.CacheBackedMap(this.driver.networkCache, {
      prefix: import_NetworkCache.cacheKeys.node(this.id)._securityClassBaseKey + ".",
      suffixSerializer: /* @__PURE__ */ __name((value) => (0, import_shared.getEnumMemberName)(import_core.SecurityClass, value), "suffixSerializer"),
      suffixDeserializer: /* @__PURE__ */ __name((key) => {
        if (key in import_core.SecurityClass && typeof import_core.SecurityClass[key] === "number") {
          return import_core.SecurityClass[key];
        }
      }, "suffixDeserializer")
    });
  }
  /** @internal */
  // This a CacheBackedMap that's assigned in the constructor
  securityClasses;
  get isSecure() {
    const securityClass = this.getHighestSecurityClass();
    if (securityClass == void 0)
      return import_core.NOT_KNOWN;
    if (securityClass === import_core.SecurityClass.None)
      return false;
    return true;
  }
  hasSecurityClass(securityClass) {
    return this.securityClasses.get(securityClass);
  }
  setSecurityClass(securityClass, granted) {
    this.securityClasses.set(securityClass, granted);
  }
  getHighestSecurityClass() {
    if (this.securityClasses.size === 0)
      return void 0;
    let missingSome = false;
    for (const secClass of import_core.securityClassOrder) {
      if (this.securityClasses.get(secClass) === true)
        return secClass;
      if (!this.securityClasses.has(secClass)) {
        missingSome = true;
      }
    }
    return missingSome ? import_core.NOT_KNOWN : import_core.SecurityClass.None;
  }
  /**
   * Should be `true` when an S2-capable node fails to S2-bootstrap.
   * This will skip the interview process (see `Driver.interviewNodeInternal` method).
   */
  get failedS2Bootstrapping() {
    return this.driver.cacheGet(import_NetworkCache.cacheKeys.node(this.id).failedS2Bootstrapping) ?? false;
  }
  set failedS2Bootstrapping(value) {
    this.driver.cacheSet(import_NetworkCache.cacheKeys.node(this.id).failedS2Bootstrapping, value);
  }
}
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  NodeSecurityMixin
});
//# sourceMappingURL=05_Security.js.map
