"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var Status_exports = {};
__export(Status_exports, {
  NodeStatusMixin: () => NodeStatusMixin
});
module.exports = __toCommonJS(Status_exports);
var import_core = require("@zwave-js/core");
var import_NetworkCache = require("../../driver/NetworkCache.js");
var import_NodeReadyMachine = require("../NodeReadyMachine.js");
var import_NodeStatusMachine = require("../NodeStatusMachine.js");
var import_Types = require("../_Types.js");
var import_Events = require("./10_Events.js");
class NodeStatusMixin extends import_Events.NodeEventsMixin {
  static {
    __name(this, "NodeStatusMixin");
  }
  constructor(nodeId, driver, index, deviceClass, supportedCCs) {
    super(nodeId, driver, index, deviceClass, supportedCCs);
    this.statusMachine = (0, import_NodeStatusMachine.createNodeStatusMachine)(this);
    this.readyMachine = (0, import_NodeReadyMachine.createNodeReadyMachine)();
  }
  statusMachine;
  _status = import_Types.NodeStatus.Unknown;
  /**
   * Which status the node is believed to be in
   */
  get status() {
    return this._status;
  }
  restartStatusMachine() {
    this.statusMachine.restart();
    this.onStatusChange(import_Types.NodeStatus.Unknown);
  }
  updateStatusMachine(input) {
    const newState = this.statusMachine.next(input)?.newState;
    if (newState) {
      this.statusMachine.transition(newState);
      this.onStatusChange((0, import_NodeStatusMachine.nodeStatusMachineStateToNodeStatus)(newState.value));
    }
  }
  onStatusChange(newStatus) {
    if (newStatus === this._status)
      return;
    const oldStatus = this._status;
    this._status = newStatus;
    if (this._status === import_Types.NodeStatus.Asleep) {
      this._emit("sleep", this, oldStatus);
    } else if (this._status === import_Types.NodeStatus.Awake) {
      this._emit("wake up", this, oldStatus);
    } else if (this._status === import_Types.NodeStatus.Dead) {
      this._emit("dead", this, oldStatus);
    } else if (this._status === import_Types.NodeStatus.Alive) {
      this._emit("alive", this, oldStatus);
    }
    this.updateReadyMachine({
      value: this._status !== import_Types.NodeStatus.Unknown && this._status !== import_Types.NodeStatus.Dead ? "NOT_DEAD" : "MAYBE_DEAD"
    });
  }
  /**
   * @internal
   * Marks this node as dead (if applicable)
   */
  markAsDead() {
    this.updateStatusMachine({ value: "DEAD" });
  }
  /**
   * @internal
   * Marks this node as alive (if applicable)
   */
  markAsAlive() {
    this.updateStatusMachine({ value: "ALIVE" });
  }
  /**
   * @internal
   * Marks this node as asleep (if applicable)
   */
  markAsAsleep() {
    this.updateStatusMachine({ value: "ASLEEP" });
  }
  /**
   * @internal
   * Marks this node as awake (if applicable)
   */
  markAsAwake() {
    this.updateStatusMachine({ value: "AWAKE" });
  }
  // The node is only ready when the interview has been completed
  // to a certain degree
  readyMachine;
  _ready = false;
  restartReadyMachine() {
    this.readyMachine.restart();
    this.onReadyChange(false);
  }
  updateReadyMachine(input) {
    const newState = this.readyMachine.next(input)?.newState;
    if (newState) {
      this.readyMachine.transition(newState);
      this.onReadyChange(newState.value === "ready");
    }
  }
  onReadyChange(ready) {
    if (ready === this._ready)
      return;
    this._ready = ready;
    if (ready)
      this._emit("ready", this);
  }
  /**
   * Whether the node is ready to be used
   */
  get ready() {
    return this._ready;
  }
  set ready(ready) {
    this._ready = ready;
  }
  get interviewStage() {
    return this.driver.cacheGet(import_NetworkCache.cacheKeys.node(this.id).interviewStage) ?? import_core.InterviewStage.None;
  }
  set interviewStage(value) {
    this.driver.cacheSet(import_NetworkCache.cacheKeys.node(this.id).interviewStage, value);
    if (value === import_core.InterviewStage.Complete) {
      this.bootstrapped = true;
    }
  }
  get bootstrapped() {
    return this.driver.cacheGet(import_NetworkCache.cacheKeys.node(this.id).bootstrapped) ?? this.interviewStage === import_core.InterviewStage.Complete;
  }
  set bootstrapped(value) {
    this.driver.cacheSet(import_NetworkCache.cacheKeys.node(this.id).bootstrapped, value);
  }
}
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  NodeStatusMixin
});
//# sourceMappingURL=20_Status.js.map
