"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var Configuration_exports = {};
__export(Configuration_exports, {
  ConfigurationCCBehaviors: () => ConfigurationCCBehaviors
});
module.exports = __toCommonJS(Configuration_exports);
var import_ConfigurationCC = require("@zwave-js/cc/ConfigurationCC");
var import_core = require("@zwave-js/core");
const defaultCapabilities = {
  bulkSupport: false,
  parameters: []
};
const STATE_KEY_PREFIX = "Configuration_";
const StateKeys = {
  value: /* @__PURE__ */ __name((param) => `${STATE_KEY_PREFIX}value_${param}`, "value")
};
const respondToConfigurationGet = {
  handleCC(controller, self, receivedCC) {
    if (receivedCC instanceof import_ConfigurationCC.ConfigurationCCGet) {
      const capabilities = {
        ...defaultCapabilities,
        ...self.getCCCapabilities(import_core.CommandClasses.Configuration, receivedCC.endpointIndex)
      };
      const parameter = receivedCC.parameter;
      const paramInfo = capabilities.parameters.find((p) => p["#"] === parameter);
      if (!paramInfo)
        return { action: "stop" };
      const value = self.state.get(StateKeys.value(parameter)) ?? paramInfo.defaultValue ?? 0;
      const cc = new import_ConfigurationCC.ConfigurationCCReport({
        nodeId: controller.ownNodeId,
        parameter,
        value,
        valueSize: paramInfo.valueSize,
        valueFormat: paramInfo.format
      });
      return { action: "sendCC", cc };
    }
  }
};
const respondToConfigurationSet = {
  handleCC(controller, self, receivedCC) {
    if (receivedCC instanceof import_ConfigurationCC.ConfigurationCCSet) {
      const capabilities = {
        ...defaultCapabilities,
        ...self.getCCCapabilities(import_core.CommandClasses.Configuration, receivedCC.endpointIndex)
      };
      const parameter = receivedCC.parameter;
      const paramInfo = capabilities.parameters.find((p) => p["#"] === parameter);
      if (!paramInfo)
        return { action: "fail" };
      if (receivedCC.resetToDefault) {
        self.state.delete(StateKeys.value(parameter));
        return { action: "ok" };
      }
      const value = receivedCC.value;
      if (paramInfo.minValue != void 0 && value < paramInfo.minValue) {
        return { action: "fail" };
      } else if (paramInfo.maxValue != void 0 && value > paramInfo.maxValue) {
        return { action: "fail" };
      }
      self.state.set(StateKeys.value(parameter), value);
      return { action: "ok" };
    }
  }
};
const respondToConfigurationDefaultReset = {
  handleCC(controller, self, receivedCC) {
    if (receivedCC instanceof import_ConfigurationCC.ConfigurationCCDefaultReset) {
      const capabilities = {
        ...defaultCapabilities,
        ...self.getCCCapabilities(import_core.CommandClasses.Configuration, receivedCC.endpointIndex)
      };
      for (const paramInfo of capabilities.parameters) {
        self.state.delete(StateKeys.value(paramInfo["#"]));
      }
      return { action: "ok" };
    }
  }
};
const respondToConfigurationNameGet = {
  handleCC(controller, self, receivedCC) {
    if (receivedCC instanceof import_ConfigurationCC.ConfigurationCCNameGet) {
      const capabilities = {
        ...defaultCapabilities,
        ...self.getCCCapabilities(import_core.CommandClasses.Configuration, receivedCC.endpointIndex)
      };
      const parameter = receivedCC.parameter;
      const paramInfo = capabilities.parameters.find((p) => p["#"] === parameter);
      if (!paramInfo)
        return { action: "fail" };
      const cc = new import_ConfigurationCC.ConfigurationCCNameReport({
        nodeId: controller.ownNodeId,
        parameter,
        name: paramInfo.name ?? "",
        reportsToFollow: 0
      });
      return { action: "sendCC", cc };
    }
  }
};
const respondToConfigurationInfoGet = {
  handleCC(controller, self, receivedCC) {
    if (receivedCC instanceof import_ConfigurationCC.ConfigurationCCInfoGet) {
      const capabilities = {
        ...defaultCapabilities,
        ...self.getCCCapabilities(import_core.CommandClasses.Configuration, receivedCC.endpointIndex)
      };
      const parameter = receivedCC.parameter;
      const paramInfo = capabilities.parameters.find((p) => p["#"] === parameter);
      if (!paramInfo)
        return { action: "fail" };
      const cc = new import_ConfigurationCC.ConfigurationCCInfoReport({
        nodeId: controller.ownNodeId,
        parameter,
        info: paramInfo.info ?? "",
        reportsToFollow: 0
      });
      return { action: "sendCC", cc };
    }
  }
};
const respondToConfigurationPropertiesGet = {
  handleCC(controller, self, receivedCC) {
    if (receivedCC instanceof import_ConfigurationCC.ConfigurationCCPropertiesGet) {
      const capabilities = {
        ...defaultCapabilities,
        ...self.getCCCapabilities(import_core.CommandClasses.Configuration, receivedCC.endpointIndex)
      };
      const parameter = receivedCC.parameter;
      const paramIndex = capabilities.parameters.findIndex((p) => p["#"] === parameter);
      const paramInfo = capabilities.parameters[paramIndex];
      const nextParameter = capabilities.parameters[paramIndex + 1];
      let cc;
      if (!paramInfo) {
        cc = new import_ConfigurationCC.ConfigurationCCPropertiesReport({
          nodeId: controller.ownNodeId,
          parameter,
          valueFormat: 0,
          valueSize: 0,
          nextParameter: nextParameter?.["#"] ?? 0
        });
      } else {
        cc = new import_ConfigurationCC.ConfigurationCCPropertiesReport({
          nodeId: controller.ownNodeId,
          parameter,
          valueSize: paramInfo.valueSize,
          valueFormat: paramInfo.format ?? import_core.ConfigValueFormat.SignedInteger,
          minValue: paramInfo.minValue,
          maxValue: paramInfo.maxValue,
          defaultValue: paramInfo.defaultValue,
          isAdvanced: paramInfo.isAdvanced ?? false,
          altersCapabilities: paramInfo.altersCapabilities ?? false,
          isReadonly: paramInfo.readonly ?? false,
          noBulkSupport: !(capabilities.bulkSupport ?? false),
          nextParameter: nextParameter?.["#"] ?? 0
        });
      }
      return { action: "sendCC", cc };
    }
  }
};
const ConfigurationCCBehaviors = [
  respondToConfigurationGet,
  respondToConfigurationSet,
  respondToConfigurationNameGet,
  respondToConfigurationInfoGet,
  respondToConfigurationPropertiesGet,
  respondToConfigurationDefaultReset
];
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  ConfigurationCCBehaviors
});
//# sourceMappingURL=Configuration.js.map
