import type { GetDeviceConfig } from "@zwave-js/config";
import { type ControlsCC, type EndpointId, type GetEndpoint, type GetNode, type GetSupportedCCVersion, type GetValueDB, type HostIDs, type MaybeNotKnown, type NodeId, type SupportsCC, type TranslatedValueID, type ValueID } from "@zwave-js/core";
import type { ZWaveNotificationCapability } from "./_Types.js";
export declare function endpointCountIsDynamic(ctx: GetValueDB, nodeId: number): MaybeNotKnown<boolean>;
export declare function endpointsHaveIdenticalCapabilities(ctx: GetValueDB, nodeId: number): MaybeNotKnown<boolean>;
export declare function getIndividualEndpointCount(ctx: GetValueDB, nodeId: number): MaybeNotKnown<number>;
export declare function getAggregatedEndpointCount(ctx: GetValueDB, nodeId: number): MaybeNotKnown<number>;
export declare function getEndpointCount(ctx: GetValueDB, nodeId: number): number;
export declare function setIndividualEndpointCount(ctx: GetValueDB, nodeId: number, count: number): void;
export declare function setAggregatedEndpointCount(ctx: GetValueDB, nodeId: number, count: number): void;
export declare function getEndpointIndizes(ctx: GetValueDB, nodeId: number): number[];
export declare function setEndpointIndizes(ctx: GetValueDB, nodeId: number, indizes: number[]): void;
export declare function isMultiChannelInterviewComplete(ctx: GetValueDB, nodeId: number): boolean;
export declare function setMultiChannelInterviewComplete(ctx: GetValueDB, nodeId: number, complete: boolean): void;
export declare function getAllEndpoints<T extends EndpointId>(ctx: GetValueDB, node: T & GetEndpoint<EndpointId & T>): T[];
/** Determines whether the root application CC values should be hidden in favor of endpoint values */
export declare function shouldHideRootApplicationCCValues(ctx: GetValueDB & GetDeviceConfig, nodeId: number): boolean;
/**
 * Enhances a value id so it can be consumed better by applications
 */
export declare function translateValueID<T extends ValueID>(ctx: GetValueDB, endpoint: EndpointId, valueId: T): T & TranslatedValueID;
/**
 * Removes all Value IDs from an array that belong to a root endpoint and have a corresponding
 * Value ID on a non-root endpoint
 */
export declare function filterRootApplicationCCValueIDs<T extends ValueID>(allValueIds: T[]): T[];
/** Returns a list of all value names that are defined on all endpoints of this node */
export declare function getDefinedValueIDs(ctx: HostIDs & GetValueDB & GetDeviceConfig & GetSupportedCCVersion & GetNode<NodeId & GetEndpoint<EndpointId & SupportsCC & ControlsCC>>, node: NodeId & SupportsCC & ControlsCC & GetEndpoint<EndpointId & SupportsCC & ControlsCC>): TranslatedValueID[];
export declare function getSupportedNotificationEvents(ctx: GetValueDB & GetNode<NodeId & GetEndpoint<EndpointId & SupportsCC & ControlsCC>>, node: NodeId & SupportsCC & ControlsCC & GetEndpoint<EndpointId & SupportsCC & ControlsCC>): ZWaveNotificationCapability[];
//# sourceMappingURL=utils.d.ts.map