import { MockController, type MockControllerBehavior, type MockControllerOptions, MockNode, type MockNodeBehavior, type MockNodeOptions } from "@zwave-js/testing";
import type { NodeDump } from "./lib/node/Dump.js";
export type MockServerControllerOptions = Pick<MockControllerOptions, "ownNodeId" | "homeId" | "capabilities"> & {
    behaviors?: MockControllerBehavior[];
};
export type MockServerNodeOptions = Pick<MockNodeOptions, "id" | "capabilities"> & {
    behaviors?: MockNodeBehavior[];
};
export type MockServerInitHook = (controller: MockController, nodes: MockNode[]) => void;
export interface MockServerOptions {
    interface?: string;
    port?: number;
    config?: {
        controller?: MockServerControllerOptions;
        nodes?: MockServerNodeOptions[];
        onInit?: MockServerInitHook;
    };
}
export declare class MockServer {
    private options;
    constructor(options?: MockServerOptions);
    private serialport;
    private binding;
    private server;
    private responder;
    private service;
    private mockController;
    private mockNodes;
    start(): Promise<void>;
    stop(): Promise<void>;
}
export declare function createMockNodeOptionsFromDump(dump: NodeDump): MockServerNodeOptions;
//# sourceMappingURL=mockServer.d.ts.map