import { StateMachine, } from "@zwave-js/core";
function to(state) {
    return { newState: state };
}
export function createProxyInclusionMachine() {
    const initialState = {
        value: "initial",
    };
    const transitions = (state) => (input) => {
        switch (state.value) {
            case "initial": {
                switch (input.value) {
                    case "NIF": {
                        return to({
                            value: "hasNIF",
                            nodeInfo: input.nodeInfo,
                            newNode: input.newNode,
                        });
                    }
                    case "INITIATE": {
                        return to({
                            value: "hasInitiate",
                            inclusionControllerNodeId: input.inclusionControllerNodeId,
                            step: input.step,
                            includedNodeId: input.includedNodeId,
                        });
                    }
                }
                break;
            }
            case "hasNIF": {
                switch (input.value) {
                    case "INITIATE": {
                        if (input.includedNodeId === state.newNode.id) {
                            return to({
                                value: "bootstrapping",
                                inclusionControllerNodeId: input.inclusionControllerNodeId,
                                includedNodeId: input.includedNodeId,
                                nodeInfo: state.nodeInfo,
                                newNode: state.newNode,
                                step: input.step,
                                done: true,
                            });
                        }
                        // FIXME: What to do if there is a mismatch?
                        break;
                    }
                    case "INITIATE_TIMEOUT": {
                        // If no Initiate Command has been received approximately 10 seconds after
                        // a new node has been added to a network, the SIS SHOULD start interviewing
                        return to({
                            value: "interview",
                            newNode: state.newNode,
                            done: true,
                        });
                    }
                }
                break;
            }
            case "hasInitiate": {
                switch (input.value) {
                    case "NIF": {
                        if (input.newNode.id === state.includedNodeId) {
                            return to({
                                value: "bootstrapping",
                                inclusionControllerNodeId: state.inclusionControllerNodeId,
                                includedNodeId: state.includedNodeId,
                                step: state.step,
                                nodeInfo: input.nodeInfo,
                                newNode: input.newNode,
                                done: true,
                            });
                        }
                        // FIXME: What to do if there is a mismatch?
                        break;
                    }
                    case "NIF_TIMEOUT": {
                        return to({
                            value: "bootstrapping",
                            inclusionControllerNodeId: state.inclusionControllerNodeId,
                            includedNodeId: state.includedNodeId,
                            step: state.step,
                            done: true,
                        });
                    }
                }
            }
        }
    };
    return new StateMachine(initialState, transitions);
}
//# sourceMappingURL=ProxyInclusionMachine.js.map