import { Protocols, SecurityClass, ZWaveError, ZWaveErrorCodes, isValidDSK, } from "@zwave-js/core";
import { isArray, isObject } from "alcalzone-shared/typeguards";
import { ProvisioningEntryStatus, } from "./Inclusion.js";
export function assertProvisioningEntry(arg) {
    function fail(why) {
        throw new ZWaveError(`Invalid provisioning entry: ${why}`, ZWaveErrorCodes.Argument_Invalid);
    }
    if (!isObject(arg))
        fail("not an object");
    if (typeof arg.dsk !== "string")
        fail("dsk must be a string");
    else if (!isValidDSK(arg.dsk)) {
        fail("dsk does not have the correct format");
    }
    if (arg.status != undefined
        && (typeof arg.status !== "number"
            || !(arg.status in ProvisioningEntryStatus))) {
        fail("status is not a ProvisioningEntryStatus");
    }
    if (!isArray(arg.securityClasses)) {
        fail("securityClasses must be an array");
    }
    else if (!arg.securityClasses.every((sc) => typeof sc === "number" && sc in SecurityClass)) {
        fail("securityClasses contains invalid entries");
    }
    if (arg.requestedSecurityClasses != undefined) {
        if (!isArray(arg.requestedSecurityClasses)) {
            fail("requestedSecurityClasses must be an array");
        }
        else if (!arg.requestedSecurityClasses.every((sc) => typeof sc === "number" && sc in SecurityClass)) {
            {
                fail("requestedSecurityClasses contains invalid entries");
            }
        }
    }
    if (arg.protocol != undefined
        && (typeof arg.protocol !== "number" || !(arg.protocol in Protocols))) {
        fail("protocol is not a valid");
    }
    if (arg.supportedProtocols != undefined) {
        if (!isArray(arg.supportedProtocols)) {
            fail("supportedProtocols must be an array");
        }
        else if (!arg.supportedProtocols.every((p) => typeof p === "number" && p in Protocols)) {
            fail("supportedProtocols contains invalid entries");
        }
    }
}
/** Checks if a task belongs to a route rebuilding process */
export function isRebuildRoutesTask(t) {
    return t.tag?.id === "rebuild-routes"
        || t.tag?.id === "rebuild-node-routes";
}
export function getInitial500SeriesNVMBackupChunkSize(manufacturerId, productType, productId) {
    // Some 500 series controllers choke when trying to read from the NVM
    // with a chunk size that is too big.
    if (manufacturerId === 0x86
        && productType === 0x01
        && productId === 0x5a) {
        // Aeotec Z-Stick Gen5 (some revisions at least)
        return 48;
    }
    // Use the maximum chunk size the Z-Wave stack supports.
    // All other known controllers are fine with that.
    return 168;
}
//# sourceMappingURL=utils.js.map