import { type MessagePriority, ZWaveError, ZWaveErrorCodes } from "@zwave-js/core";
import type { Message } from "@zwave-js/serial";
import type { SerialAPICommandMachineFailure } from "./SerialAPICommandMachine.js";
import type { Transaction } from "./Transaction.js";
export declare function serialAPICommandErrorToZWaveError(reason: SerialAPICommandMachineFailure["reason"], sentMessage: Message, receivedMessage: Message | undefined, transactionSource: string | undefined): ZWaveError;
export declare function createMessageDroppedUnexpectedError(original: Error): ZWaveError;
export type TransactionReducerResult = {
    type: "drop";
} | {
    type: "keep";
} | {
    type: "reject";
    message: string;
    code: ZWaveErrorCodes;
} | {
    type: "resolve";
    message?: Message;
} | {
    type: "requeue";
    reset?: boolean;
    priority?: MessagePriority;
    tag?: any;
};
export type TransactionReducer = (transaction: Transaction, source: "queue" | "active") => TransactionReducerResult;
//# sourceMappingURL=StateMachineShared.d.ts.map