import { ProtocolDataRate, isLongRangeNodeId, } from "@zwave-js/core";
import { StatisticsHost } from "../driver/Statistics.js";
export class NodeStatisticsHost extends StatisticsHost {
    getAdditionalEventArgs() {
        // The node events include the node as the first argument
        return [this];
    }
    createEmpty() {
        const stats = {
            commandsTX: 0,
            commandsRX: 0,
            commandsDroppedRX: 0,
            commandsDroppedTX: 0,
            timeoutResponse: 0,
        };
        // ZWLR nodes always have a direct connection at 100 kbps
        if (isLongRangeNodeId(this.id)) {
            stats.lwr = {
                protocolDataRate: ProtocolDataRate.LongRange_100k,
                repeaters: [],
            };
        }
        // lastSeen may already be known from the cache
        const lastSeen = this.lastSeen;
        if (lastSeen) {
            stats.lastSeen = lastSeen;
        }
        return stats;
    }
}
/** Checks if the given route statistics belong to the same route */
export function routeStatisticsEquals(r1, r2) {
    if (r1.repeaters.length !== r2.repeaters.length)
        return false;
    if (!r1.repeaters.every((node) => r2.repeaters.includes(node))) {
        return false;
    }
    return true;
}
//# sourceMappingURL=NodeStatistics.js.map