import { WindowCoveringCCSupportedGet, WindowCoveringCCSupportedReport, } from "@zwave-js/cc/WindowCoveringCC";
import { CommandClasses } from "@zwave-js/core";
const defaultCapabilities = {
    supportedParameters: [],
};
const respondToWindowCoveringSupportedGet = {
    handleCC(controller, self, receivedCC) {
        if (receivedCC instanceof WindowCoveringCCSupportedGet) {
            const capabilities = {
                ...defaultCapabilities,
                ...self.getCCCapabilities(CommandClasses["Window Covering"], receivedCC.endpointIndex),
            };
            const cc = new WindowCoveringCCSupportedReport({
                nodeId: controller.ownNodeId,
                supportedParameters: capabilities.supportedParameters,
            });
            return { action: "sendCC", cc };
        }
    },
};
export const WindowCoveringCCBehaviors = [respondToWindowCoveringSupportedGet];
//# sourceMappingURL=WindowCovering.js.map