"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (g && (g = 0, op[0] && (_ = 0)), _) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var yargs_1 = __importDefault(require("yargs"));
var fs_1 = require("fs");
var path_1 = require("path");
var log_1 = require("./log");
var package_json_1 = require("../package.json");
var utils_1 = require("./utils");
function main() {
    return __awaiter(this, void 0, void 0, function () {
        var argv, shaFileContent, shaMap, _i, _a, line, lineParts, sortedShaMap, _b, _c, nodeVersion;
        return __generator(this, function (_d) {
            argv = yargs_1.default
                .option('input', { alias: 'i', default: 'shas.txt', type: 'string' })
                .version(package_json_1.version)
                .alias('v', 'version')
                .help()
                .alias('h', 'help').argv;
            shaFileContent = (0, fs_1.readFileSync)(argv.input).toString();
            shaMap = {};
            for (_i = 0, _a = shaFileContent.split('\n'); _i < _a.length; _i++) {
                line = _a[_i];
                lineParts = line.split(/\s+/);
                if (lineParts.length === 2) {
                    // eslint-disable-next-line prefer-destructuring
                    shaMap[lineParts[1]] = lineParts[0];
                }
            }
            sortedShaMap = {};
            for (_b = 0, _c = Object.keys(shaMap).sort(utils_1.nodeBinarySortFunction); _b < _c.length; _b++) {
                nodeVersion = _c[_b];
                sortedShaMap[nodeVersion] = shaMap[nodeVersion];
            }
            (0, fs_1.writeFileSync)((0, path_1.join)(__dirname, '../lib/expected-shas.json'), "".concat(JSON.stringify(sortedShaMap, null, 2), "\n"));
            return [2 /*return*/];
        });
    });
}
main().catch(function (error) {
    if (!error.wasReported)
        log_1.log.error(error);
    process.exit(2);
});
//# sourceMappingURL=generate-expected-shas.js.map