"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var BasicWindowCoveringCC_exports = {};
__export(BasicWindowCoveringCC_exports, {
  BasicWindowCoveringCC: () => BasicWindowCoveringCC,
  BasicWindowCoveringCCAPI: () => BasicWindowCoveringCCAPI,
  BasicWindowCoveringCCStartLevelChange: () => BasicWindowCoveringCCStartLevelChange,
  BasicWindowCoveringCCStopLevelChange: () => BasicWindowCoveringCCStopLevelChange,
  BasicWindowCoveringCCValues: () => import_CCValues_generated.BasicWindowCoveringCCValues
});
module.exports = __toCommonJS(BasicWindowCoveringCC_exports);
var __validateArgs = __toESM(require("./BasicWindowCoveringCC._validateArgs.js"), 1);
var import_core = require("@zwave-js/core");
var import_shared = require("@zwave-js/shared");
var import_API = require("../lib/API.js");
var import_CommandClass = require("../lib/CommandClass.js");
var import_CommandClassDecorators = require("../lib/CommandClassDecorators.js");
var import_Values = require("../lib/Values.js");
var import_Types = require("../lib/_Types.js");
var import_CCValues_generated = require("./_CCValues.generated.js");
var __runInitializers = function(thisArg, initializers, value) {
  var useValue = arguments.length > 2;
  for (var i = 0; i < initializers.length; i++) {
    value = useValue ? initializers[i].call(thisArg, value) : initializers[i].call(thisArg);
  }
  return useValue ? value : void 0;
};
var __esDecorate = function(ctor, descriptorIn, decorators, contextIn, initializers, extraInitializers) {
  function accept(f) {
    if (f !== void 0 && typeof f !== "function") throw new TypeError("Function expected");
    return f;
  }
  __name(accept, "accept");
  var kind = contextIn.kind, key = kind === "getter" ? "get" : kind === "setter" ? "set" : "value";
  var target = !descriptorIn && ctor ? contextIn["static"] ? ctor : ctor.prototype : null;
  var descriptor = descriptorIn || (target ? Object.getOwnPropertyDescriptor(target, contextIn.name) : {});
  var _, done = false;
  for (var i = decorators.length - 1; i >= 0; i--) {
    var context = {};
    for (var p in contextIn) context[p] = p === "access" ? {} : contextIn[p];
    for (var p in contextIn.access) context.access[p] = contextIn.access[p];
    context.addInitializer = function(f) {
      if (done) throw new TypeError("Cannot add initializers after decoration has completed");
      extraInitializers.push(accept(f || null));
    };
    var result = (0, decorators[i])(kind === "accessor" ? { get: descriptor.get, set: descriptor.set } : descriptor[key], context);
    if (kind === "accessor") {
      if (result === void 0) continue;
      if (result === null || typeof result !== "object") throw new TypeError("Object expected");
      if (_ = accept(result.get)) descriptor.get = _;
      if (_ = accept(result.set)) descriptor.set = _;
      if (_ = accept(result.init)) initializers.unshift(_);
    } else if (_ = accept(result)) {
      if (kind === "field") initializers.unshift(_);
      else descriptor[key] = _;
    }
  }
  if (target) Object.defineProperty(target, contextIn.name, descriptor);
  done = true;
};
const { validateArgs_BasicWindowCoveringCCAPI_startLevelChange, validateArgs_BasicWindowCoveringCCAPI_stopLevelChange } = __validateArgs;
let BasicWindowCoveringCCAPI = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.API)(import_core.CommandClasses["Basic Window Covering"])];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = import_API.CCAPI;
  let _instanceExtraInitializers = [];
  let _startLevelChange_decorators;
  let _stopLevelChange_decorators;
  var BasicWindowCoveringCCAPI2 = class extends _classSuper {
    static {
      __name(this, "BasicWindowCoveringCCAPI");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      _startLevelChange_decorators = [validateArgs_BasicWindowCoveringCCAPI_startLevelChange({ strictEnums: true })];
      _stopLevelChange_decorators = [validateArgs_BasicWindowCoveringCCAPI_stopLevelChange({ strictEnums: true })];
      __esDecorate(this, null, _startLevelChange_decorators, { kind: "method", name: "startLevelChange", static: false, private: false, access: { has: /* @__PURE__ */ __name((obj) => "startLevelChange" in obj, "has"), get: /* @__PURE__ */ __name((obj) => obj.startLevelChange, "get") }, metadata: _metadata }, null, _instanceExtraInitializers);
      __esDecorate(this, null, _stopLevelChange_decorators, { kind: "method", name: "stopLevelChange", static: false, private: false, access: { has: /* @__PURE__ */ __name((obj) => "stopLevelChange" in obj, "has"), get: /* @__PURE__ */ __name((obj) => obj.stopLevelChange, "get") }, metadata: _metadata }, null, _instanceExtraInitializers);
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      BasicWindowCoveringCCAPI2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    supportsCommand(cmd) {
      switch (cmd) {
        case import_Types.BasicWindowCoveringCommand.StartLevelChange:
        case import_Types.BasicWindowCoveringCommand.StopLevelChange:
          return true;
      }
      return super.supportsCommand(cmd);
    }
    get [import_API.SET_VALUE]() {
      return async function({ property }, value) {
        const valueId = {
          commandClass: this.ccId,
          property
        };
        if (import_CCValues_generated.BasicWindowCoveringCCValues.levelChangeUp.is(valueId) || import_CCValues_generated.BasicWindowCoveringCCValues.levelChangeDown.is(valueId)) {
          if (typeof value !== "boolean") {
            (0, import_API.throwWrongValueType)(this.ccId, property, "boolean", typeof value);
          }
          if (value) {
            const direction = import_CCValues_generated.BasicWindowCoveringCCValues.levelChangeUp.is(valueId) ? "up" : "down";
            return this.startLevelChange(direction);
          } else {
            return this.stopLevelChange();
          }
        } else {
          (0, import_API.throwUnsupportedProperty)(this.ccId, property);
        }
      };
    }
    async startLevelChange(direction) {
      this.assertSupportsCommand(import_Types.BasicWindowCoveringCommand, import_Types.BasicWindowCoveringCommand.StartLevelChange);
      const cc = new BasicWindowCoveringCCStartLevelChange({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index,
        direction
      });
      return this.host.sendCommand(cc, this.commandOptions);
    }
    async stopLevelChange() {
      this.assertSupportsCommand(import_Types.BasicWindowCoveringCommand, import_Types.BasicWindowCoveringCommand.StopLevelChange);
      const cc = new BasicWindowCoveringCCStopLevelChange({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index
      });
      return this.host.sendCommand(cc, this.commandOptions);
    }
    constructor() {
      super(...arguments);
      __runInitializers(this, _instanceExtraInitializers);
    }
  };
  return BasicWindowCoveringCCAPI2 = _classThis;
})();
let BasicWindowCoveringCC = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.commandClass)(import_core.CommandClasses["Basic Window Covering"]), (0, import_CommandClassDecorators.implementedVersion)(1), (0, import_CommandClassDecorators.ccValues)(import_CCValues_generated.BasicWindowCoveringCCValues)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = import_CommandClass.CommandClass;
  var BasicWindowCoveringCC2 = class extends _classSuper {
    static {
      __name(this, "BasicWindowCoveringCC");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      BasicWindowCoveringCC2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
  };
  return BasicWindowCoveringCC2 = _classThis;
})();
let BasicWindowCoveringCCStartLevelChange = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.BasicWindowCoveringCommand.StartLevelChange), (0, import_CommandClassDecorators.useSupervision)()];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = BasicWindowCoveringCC;
  var BasicWindowCoveringCCStartLevelChange2 = class extends _classSuper {
    static {
      __name(this, "BasicWindowCoveringCCStartLevelChange");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      BasicWindowCoveringCCStartLevelChange2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.direction = options.direction;
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length === 1);
      const direction = !!(raw.payload[0] & 64) ? "down" : "up";
      return new this({
        nodeId: ctx.sourceNodeId,
        direction
      });
    }
    direction;
    async serialize(ctx) {
      this.payload = import_shared.Bytes.from([
        this.direction === "down" ? 64 : 0
      ]);
      return super.serialize(ctx);
    }
    toLogEntry(ctx) {
      return {
        ...super.toLogEntry(ctx),
        message: {
          direction: this.direction
        }
      };
    }
  };
  return BasicWindowCoveringCCStartLevelChange2 = _classThis;
})();
let BasicWindowCoveringCCStopLevelChange = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.BasicWindowCoveringCommand.StopLevelChange), (0, import_CommandClassDecorators.useSupervision)()];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = BasicWindowCoveringCC;
  var BasicWindowCoveringCCStopLevelChange2 = class extends _classSuper {
    static {
      __name(this, "BasicWindowCoveringCCStopLevelChange");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      BasicWindowCoveringCCStopLevelChange2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
  };
  return BasicWindowCoveringCCStopLevelChange2 = _classThis;
})();
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  BasicWindowCoveringCC,
  BasicWindowCoveringCCAPI,
  BasicWindowCoveringCCStartLevelChange,
  BasicWindowCoveringCCStopLevelChange,
  BasicWindowCoveringCCValues
});
//# sourceMappingURL=BasicWindowCoveringCC.js.map
