"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var BatteryCC_exports = {};
__export(BatteryCC_exports, {
  BatteryCC: () => BatteryCC,
  BatteryCCAPI: () => BatteryCCAPI,
  BatteryCCGet: () => BatteryCCGet,
  BatteryCCHealthGet: () => BatteryCCHealthGet,
  BatteryCCHealthReport: () => BatteryCCHealthReport,
  BatteryCCReport: () => BatteryCCReport,
  BatteryCCValues: () => import_CCValues_generated.BatteryCCValues
});
module.exports = __toCommonJS(BatteryCC_exports);
var import_core = require("@zwave-js/core");
var import_shared = require("@zwave-js/shared");
var import_API = require("../lib/API.js");
var import_CommandClass = require("../lib/CommandClass.js");
var import_CommandClassDecorators = require("../lib/CommandClassDecorators.js");
var import_Values = require("../lib/Values.js");
var import_Types = require("../lib/_Types.js");
var import_NotificationCC = require("./NotificationCC.js");
var import_CCValues_generated = require("./_CCValues.generated.js");
var __esDecorate = function(ctor, descriptorIn, decorators, contextIn, initializers, extraInitializers) {
  function accept(f) {
    if (f !== void 0 && typeof f !== "function") throw new TypeError("Function expected");
    return f;
  }
  __name(accept, "accept");
  var kind = contextIn.kind, key = kind === "getter" ? "get" : kind === "setter" ? "set" : "value";
  var target = !descriptorIn && ctor ? contextIn["static"] ? ctor : ctor.prototype : null;
  var descriptor = descriptorIn || (target ? Object.getOwnPropertyDescriptor(target, contextIn.name) : {});
  var _, done = false;
  for (var i = decorators.length - 1; i >= 0; i--) {
    var context = {};
    for (var p in contextIn) context[p] = p === "access" ? {} : contextIn[p];
    for (var p in contextIn.access) context.access[p] = contextIn.access[p];
    context.addInitializer = function(f) {
      if (done) throw new TypeError("Cannot add initializers after decoration has completed");
      extraInitializers.push(accept(f || null));
    };
    var result = (0, decorators[i])(kind === "accessor" ? { get: descriptor.get, set: descriptor.set } : descriptor[key], context);
    if (kind === "accessor") {
      if (result === void 0) continue;
      if (result === null || typeof result !== "object") throw new TypeError("Object expected");
      if (_ = accept(result.get)) descriptor.get = _;
      if (_ = accept(result.set)) descriptor.set = _;
      if (_ = accept(result.init)) initializers.unshift(_);
    } else if (_ = accept(result)) {
      if (kind === "field") initializers.unshift(_);
      else descriptor[key] = _;
    }
  }
  if (target) Object.defineProperty(target, contextIn.name, descriptor);
  done = true;
};
var __runInitializers = function(thisArg, initializers, value) {
  var useValue = arguments.length > 2;
  for (var i = 0; i < initializers.length; i++) {
    value = useValue ? initializers[i].call(thisArg, value) : initializers[i].call(thisArg);
  }
  return useValue ? value : void 0;
};
let BatteryCCAPI = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.API)(import_core.CommandClasses.Battery)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = import_API.PhysicalCCAPI;
  var BatteryCCAPI2 = class extends _classSuper {
    static {
      __name(this, "BatteryCCAPI");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      BatteryCCAPI2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    supportsCommand(cmd) {
      switch (cmd) {
        case import_Types.BatteryCommand.Get:
          return true;
        // This is mandatory
        case import_Types.BatteryCommand.HealthGet:
          return this.version >= 2;
      }
      return super.supportsCommand(cmd);
    }
    get [import_API.POLL_VALUE]() {
      return async function({ property }) {
        switch (property) {
          case "level":
          case "chargingStatus":
          case "rechargeable":
          case "backup":
          case "overheating":
          case "lowFluid":
          case "rechargeOrReplace":
          case "lowTemperatureStatus":
          case "disconnected":
            return (await this.get())?.[property];
          case "maximumCapacity":
          case "temperature":
            return (await this.getHealth())?.[property];
          default:
            (0, import_API.throwUnsupportedProperty)(this.ccId, property);
        }
      };
    }
    // eslint-disable-next-line @typescript-eslint/explicit-module-boundary-types
    async get() {
      this.assertSupportsCommand(import_Types.BatteryCommand, import_Types.BatteryCommand.Get);
      const cc = new BatteryCCGet({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index
      });
      const response = await this.host.sendCommand(cc, this.commandOptions);
      if (response) {
        return (0, import_shared.pick)(response, [
          "level",
          "chargingStatus",
          "rechargeable",
          "backup",
          "overheating",
          "lowFluid",
          "rechargeOrReplace",
          "lowTemperatureStatus",
          "disconnected"
        ]);
      }
    }
    // eslint-disable-next-line @typescript-eslint/explicit-module-boundary-types
    async getHealth() {
      this.assertSupportsCommand(import_Types.BatteryCommand, import_Types.BatteryCommand.HealthGet);
      const cc = new BatteryCCHealthGet({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index
      });
      const response = await this.host.sendCommand(cc, this.commandOptions);
      if (response) {
        return (0, import_shared.pick)(response, ["maximumCapacity", "temperature"]);
      }
    }
  };
  return BatteryCCAPI2 = _classThis;
})();
let BatteryCC = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.commandClass)(import_core.CommandClasses.Battery), (0, import_CommandClassDecorators.implementedVersion)(3), (0, import_CommandClassDecorators.ccValues)(import_CCValues_generated.BatteryCCValues)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = import_CommandClass.CommandClass;
  var BatteryCC2 = class extends _classSuper {
    static {
      __name(this, "BatteryCC");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      BatteryCC2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    async interview(ctx) {
      const node = this.getNode(ctx);
      ctx.logNode(node.id, {
        endpoint: this.endpointIndex,
        message: `Interviewing ${this.ccName}...`,
        direction: "none"
      });
      await this.refreshValues(ctx);
      this.setInterviewComplete(ctx, true);
    }
    async refreshValues(ctx) {
      const node = this.getNode(ctx);
      const endpoint = this.getEndpoint(ctx);
      const api = import_API.CCAPI.create(import_core.CommandClasses.Battery, ctx, endpoint).withOptions({
        priority: import_core.MessagePriority.NodeQuery
      });
      ctx.logNode(node.id, {
        endpoint: this.endpointIndex,
        message: "querying battery status...",
        direction: "outbound"
      });
      const batteryStatus = await api.get();
      if (batteryStatus) {
        let logMessage = `received response for battery information:
level:                           ${batteryStatus.level === 255 ? "low" : batteryStatus.level + " %"}`;
        if (api.version >= 2) {
          logMessage += `
status:                          ${import_Types.BatteryChargingStatus[batteryStatus.chargingStatus]}
rechargeable:                    ${batteryStatus.rechargeable}
is backup:                       ${batteryStatus.backup}
is overheating:                  ${batteryStatus.overheating}
fluid is low:                    ${batteryStatus.lowFluid}
needs to be replaced or charged: ${import_Types.BatteryReplacementStatus[batteryStatus.rechargeOrReplace]}
is low temperature               ${batteryStatus.lowTemperatureStatus}
is disconnected:                 ${batteryStatus.disconnected}`;
        }
        ctx.logNode(node.id, {
          endpoint: this.endpointIndex,
          message: logMessage,
          direction: "inbound"
        });
      }
      if (api.version >= 2) {
        ctx.logNode(node.id, {
          endpoint: this.endpointIndex,
          message: "querying battery health...",
          direction: "outbound"
        });
        const batteryHealth = await api.getHealth();
        if (batteryHealth) {
          const logMessage = `received response for battery health:
max. capacity: ${batteryHealth.maximumCapacity} %
temperature:   ${batteryHealth.temperature} \xB0C`;
          ctx.logNode(node.id, {
            endpoint: this.endpointIndex,
            message: logMessage,
            direction: "inbound"
          });
        }
      }
    }
    shouldRefreshValues(ctx) {
      const valueDB = ctx.tryGetValueDB(this.nodeId);
      if (!valueDB)
        return true;
      const lastUpdated = valueDB.getTimestamp(import_CCValues_generated.BatteryCCValues.level.endpoint(this.endpointIndex));
      return lastUpdated == void 0 || Date.now() - lastUpdated > import_core.timespan.days(7);
    }
  };
  return BatteryCC2 = _classThis;
})();
let BatteryCCReport = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.BatteryCommand.Report), (0, import_CommandClassDecorators.ccValueProperty)("level", import_CCValues_generated.BatteryCCValues.level), (0, import_CommandClassDecorators.ccValueProperty)("chargingStatus", import_CCValues_generated.BatteryCCValues.chargingStatus), (0, import_CommandClassDecorators.ccValueProperty)("rechargeable", import_CCValues_generated.BatteryCCValues.rechargeable), (0, import_CommandClassDecorators.ccValueProperty)("backup", import_CCValues_generated.BatteryCCValues.backup), (0, import_CommandClassDecorators.ccValueProperty)("overheating", import_CCValues_generated.BatteryCCValues.overheating), (0, import_CommandClassDecorators.ccValueProperty)("lowFluid", import_CCValues_generated.BatteryCCValues.lowFluid), (0, import_CommandClassDecorators.ccValueProperty)("rechargeOrReplace", import_CCValues_generated.BatteryCCValues.rechargeOrReplace), (0, import_CommandClassDecorators.ccValueProperty)("disconnected", import_CCValues_generated.BatteryCCValues.disconnected), (0, import_CommandClassDecorators.ccValueProperty)("lowTemperatureStatus", import_CCValues_generated.BatteryCCValues.lowTemperatureStatus)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = BatteryCC;
  var BatteryCCReport2 = class extends _classSuper {
    static {
      __name(this, "BatteryCCReport");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      BatteryCCReport2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.level = typeof options.level === "number" ? options.level : 255;
      this.chargingStatus = options.chargingStatus;
      this.rechargeable = options.rechargeable;
      this.backup = options.backup;
      this.overheating = options.overheating;
      this.lowFluid = options.lowFluid;
      this.rechargeOrReplace = options.rechargeOrReplace;
      this.disconnected = options.disconnected;
      this.lowTemperatureStatus = options.lowTemperatureStatus;
    }
    static from(raw, ctx) {
      let ccOptions;
      (0, import_core.validatePayload)(raw.payload.length >= 1);
      const level = raw.payload[0];
      ccOptions = {
        level
      };
      if (raw.payload.length >= 3) {
        const chargingStatus = raw.payload[1] >>> 6;
        const rechargeable = !!(raw.payload[1] & 32);
        const backup = !!(raw.payload[1] & 16);
        const overheating = !!(raw.payload[1] & 8);
        const lowFluid = !!(raw.payload[1] & 4);
        const rechargeOrReplace = !!(raw.payload[1] & 2) ? import_Types.BatteryReplacementStatus.Now : !!(raw.payload[1] & 1) ? import_Types.BatteryReplacementStatus.Soon : import_Types.BatteryReplacementStatus.No;
        const lowTemperatureStatus = !!(raw.payload[2] & 2);
        const disconnected = !!(raw.payload[2] & 1);
        ccOptions = {
          ...ccOptions,
          chargingStatus,
          rechargeable,
          backup,
          overheating,
          lowFluid,
          rechargeOrReplace,
          lowTemperatureStatus,
          disconnected
        };
      }
      return new this({
        nodeId: ctx.sourceNodeId,
        ...ccOptions
      });
    }
    persistValues(ctx) {
      if (this.level === 255) {
        this.level = void 0;
      }
      if (!super.persistValues(ctx))
        return false;
      if (this.level === void 0) {
        this.level = 255;
      }
      if (this.level >= 90) {
        const notificationCCVersion = ctx.getSupportedCCVersion(import_core.CommandClasses.Notification, this.nodeId, this.endpointIndex);
        if (
          // supported
          notificationCCVersion > 0 && notificationCCVersion < 8
        ) {
          const batteryLevelStatusValue = import_NotificationCC.NotificationCCValues.notificationVariable("Power Management", "Battery level status");
          if (this.getValue(ctx, batteryLevelStatusValue)) {
            this.setValue(ctx, batteryLevelStatusValue, 0);
          }
        }
      }
      return true;
    }
    level;
    chargingStatus;
    rechargeable;
    backup;
    overheating;
    lowFluid;
    rechargeOrReplace;
    disconnected;
    lowTemperatureStatus;
    serialize(ctx) {
      this.payload = import_shared.Bytes.from([this.level]);
      if (this.chargingStatus != void 0) {
        this.payload = import_shared.Bytes.concat([
          this.payload,
          import_shared.Bytes.from([
            (this.chargingStatus << 6) + (this.rechargeable ? 32 : 0) + (this.backup ? 16 : 0) + (this.overheating ? 8 : 0) + (this.lowFluid ? 4 : 0) + (this.rechargeOrReplace === import_Types.BatteryReplacementStatus.Now ? 2 : this.rechargeOrReplace === import_Types.BatteryReplacementStatus.Soon ? 1 : 0),
            (this.lowTemperatureStatus ? 2 : 0) + (this.disconnected ? 1 : 0)
          ])
        ]);
      }
      return super.serialize(ctx);
    }
    toLogEntry(ctx) {
      const message = this.level === 255 ? { "is low": true } : { level: this.level };
      if (this.chargingStatus != void 0) {
        message["charging status"] = (0, import_shared.getEnumMemberName)(import_Types.BatteryChargingStatus, this.chargingStatus);
      }
      if (this.rechargeable != void 0) {
        message.rechargeable = this.rechargeable;
      }
      if (this.backup != void 0) {
        message.backup = this.backup;
      }
      if (this.overheating != void 0) {
        message.overheating = this.overheating;
      }
      if (this.lowFluid != void 0) {
        message["low fluid"] = this.lowFluid;
      }
      if (this.rechargeOrReplace != void 0) {
        message["recharge or replace"] = (0, import_shared.getEnumMemberName)(import_Types.BatteryReplacementStatus, this.rechargeOrReplace);
      }
      if (this.lowTemperatureStatus != void 0) {
        message.lowTemperatureStatus = this.lowTemperatureStatus;
      }
      if (this.disconnected != void 0) {
        message.disconnected = this.disconnected;
      }
      return {
        ...super.toLogEntry(ctx),
        message
      };
    }
  };
  return BatteryCCReport2 = _classThis;
})();
let BatteryCCGet = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.BatteryCommand.Get), (0, import_CommandClassDecorators.expectedCCResponse)(BatteryCCReport)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = BatteryCC;
  var BatteryCCGet2 = class extends _classSuper {
    static {
      __name(this, "BatteryCCGet");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      BatteryCCGet2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
  };
  return BatteryCCGet2 = _classThis;
})();
let BatteryCCHealthReport = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.BatteryCommand.HealthReport), (0, import_CommandClassDecorators.ccValueProperty)("maximumCapacity", import_CCValues_generated.BatteryCCValues.maximumCapacity), (0, import_CommandClassDecorators.ccValueProperty)("temperature", import_CCValues_generated.BatteryCCValues.temperature)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = BatteryCC;
  var BatteryCCHealthReport2 = class extends _classSuper {
    static {
      __name(this, "BatteryCCHealthReport");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      BatteryCCHealthReport2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.maximumCapacity = options.maximumCapacity;
      this.temperature = options.temperature;
      this.temperatureScale = options.temperatureScale;
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 2);
      let maximumCapacity = raw.payload[0];
      if (maximumCapacity === 255)
        maximumCapacity = void 0;
      const { value: temperature, scale: temperatureScale } = (0, import_core.parseFloatWithScale)(raw.payload.subarray(1), true);
      return new this({
        nodeId: ctx.sourceNodeId,
        maximumCapacity,
        temperature,
        temperatureScale
      });
    }
    maximumCapacity;
    temperature;
    temperatureScale;
    serialize(ctx) {
      const temperature = this.temperature != void 0 ? (0, import_core.encodeFloatWithScale)(this.temperature, this.temperatureScale ?? 0) : import_shared.Bytes.from([0]);
      this.payload = import_shared.Bytes.concat([
        [this.maximumCapacity ?? 255],
        temperature
      ]);
      return super.serialize(ctx);
    }
    toLogEntry(ctx) {
      return {
        ...super.toLogEntry(ctx),
        message: {
          temperature: this.temperature != void 0 ? this.temperature : "unknown",
          "max capacity": this.maximumCapacity != void 0 ? `${this.maximumCapacity} %` : "unknown"
        }
      };
    }
  };
  return BatteryCCHealthReport2 = _classThis;
})();
let BatteryCCHealthGet = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.BatteryCommand.HealthGet), (0, import_CommandClassDecorators.expectedCCResponse)(BatteryCCHealthReport)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = BatteryCC;
  var BatteryCCHealthGet2 = class extends _classSuper {
    static {
      __name(this, "BatteryCCHealthGet");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      BatteryCCHealthGet2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
  };
  return BatteryCCHealthGet2 = _classThis;
})();
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  BatteryCC,
  BatteryCCAPI,
  BatteryCCGet,
  BatteryCCHealthGet,
  BatteryCCHealthReport,
  BatteryCCReport,
  BatteryCCValues
});
//# sourceMappingURL=BatteryCC.js.map
