"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var CentralSceneCC_exports = {};
__export(CentralSceneCC_exports, {
  CentralSceneCC: () => CentralSceneCC,
  CentralSceneCCAPI: () => CentralSceneCCAPI,
  CentralSceneCCConfigurationGet: () => CentralSceneCCConfigurationGet,
  CentralSceneCCConfigurationReport: () => CentralSceneCCConfigurationReport,
  CentralSceneCCConfigurationSet: () => CentralSceneCCConfigurationSet,
  CentralSceneCCNotification: () => CentralSceneCCNotification,
  CentralSceneCCSupportedGet: () => CentralSceneCCSupportedGet,
  CentralSceneCCSupportedReport: () => CentralSceneCCSupportedReport,
  CentralSceneCCValues: () => import_CCValues_generated.CentralSceneCCValues
});
module.exports = __toCommonJS(CentralSceneCC_exports);
var __validateArgs = __toESM(require("./CentralSceneCC._validateArgs.js"), 1);
var import_core = require("@zwave-js/core");
var import_shared = require("@zwave-js/shared");
var import_API = require("../lib/API.js");
var import_CommandClass = require("../lib/CommandClass.js");
var import_CommandClassDecorators = require("../lib/CommandClassDecorators.js");
var import_Values = require("../lib/Values.js");
var import_Types = require("../lib/_Types.js");
var ccUtils = __toESM(require("../lib/utils.js"), 1);
var import_CCValues_generated = require("./_CCValues.generated.js");
var __runInitializers = function(thisArg, initializers, value) {
  var useValue = arguments.length > 2;
  for (var i = 0; i < initializers.length; i++) {
    value = useValue ? initializers[i].call(thisArg, value) : initializers[i].call(thisArg);
  }
  return useValue ? value : void 0;
};
var __esDecorate = function(ctor, descriptorIn, decorators, contextIn, initializers, extraInitializers) {
  function accept(f) {
    if (f !== void 0 && typeof f !== "function") throw new TypeError("Function expected");
    return f;
  }
  __name(accept, "accept");
  var kind = contextIn.kind, key = kind === "getter" ? "get" : kind === "setter" ? "set" : "value";
  var target = !descriptorIn && ctor ? contextIn["static"] ? ctor : ctor.prototype : null;
  var descriptor = descriptorIn || (target ? Object.getOwnPropertyDescriptor(target, contextIn.name) : {});
  var _, done = false;
  for (var i = decorators.length - 1; i >= 0; i--) {
    var context = {};
    for (var p in contextIn) context[p] = p === "access" ? {} : contextIn[p];
    for (var p in contextIn.access) context.access[p] = contextIn.access[p];
    context.addInitializer = function(f) {
      if (done) throw new TypeError("Cannot add initializers after decoration has completed");
      extraInitializers.push(accept(f || null));
    };
    var result = (0, decorators[i])(kind === "accessor" ? { get: descriptor.get, set: descriptor.set } : descriptor[key], context);
    if (kind === "accessor") {
      if (result === void 0) continue;
      if (result === null || typeof result !== "object") throw new TypeError("Object expected");
      if (_ = accept(result.get)) descriptor.get = _;
      if (_ = accept(result.set)) descriptor.set = _;
      if (_ = accept(result.init)) initializers.unshift(_);
    } else if (_ = accept(result)) {
      if (kind === "field") initializers.unshift(_);
      else descriptor[key] = _;
    }
  }
  if (target) Object.defineProperty(target, contextIn.name, descriptor);
  done = true;
};
const { validateArgs_CentralSceneCCAPI_setConfiguration } = __validateArgs;
let CentralSceneCCAPI = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.API)(import_core.CommandClasses["Central Scene"])];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = import_API.CCAPI;
  let _instanceExtraInitializers = [];
  let _setConfiguration_decorators;
  var CentralSceneCCAPI2 = class extends _classSuper {
    static {
      __name(this, "CentralSceneCCAPI");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(this, null, _setConfiguration_decorators, { kind: "method", name: "setConfiguration", static: false, private: false, access: { has: /* @__PURE__ */ __name((obj) => "setConfiguration" in obj, "has"), get: /* @__PURE__ */ __name((obj) => obj.setConfiguration, "get") }, metadata: _metadata }, null, _instanceExtraInitializers);
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      CentralSceneCCAPI2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    supportsCommand(cmd) {
      switch (cmd) {
        case import_Types.CentralSceneCommand.SupportedGet:
          return this.isSinglecast();
        // this is mandatory
        case import_Types.CentralSceneCommand.ConfigurationGet:
          return this.version >= 3 && this.isSinglecast();
        case import_Types.CentralSceneCommand.ConfigurationSet:
          return this.version >= 3;
      }
      return super.supportsCommand(cmd);
    }
    // eslint-disable-next-line @typescript-eslint/explicit-module-boundary-types
    async getSupported() {
      this.assertSupportsCommand(import_Types.CentralSceneCommand, import_Types.CentralSceneCommand.SupportedGet);
      const cc = new CentralSceneCCSupportedGet({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index
      });
      const response = await this.host.sendCommand(cc, this.commandOptions);
      if (response) {
        return (0, import_shared.pick)(response, [
          "sceneCount",
          "supportsSlowRefresh",
          "supportedKeyAttributes"
        ]);
      }
    }
    // eslint-disable-next-line @typescript-eslint/explicit-module-boundary-types
    async getConfiguration() {
      this.assertSupportsCommand(import_Types.CentralSceneCommand, import_Types.CentralSceneCommand.ConfigurationGet);
      const cc = new CentralSceneCCConfigurationGet({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index
      });
      const response = await this.host.sendCommand(cc, this.commandOptions);
      if (response) {
        return (0, import_shared.pick)(response, ["slowRefresh"]);
      }
    }
    async setConfiguration(slowRefresh) {
      this.assertSupportsCommand(import_Types.CentralSceneCommand, import_Types.CentralSceneCommand.ConfigurationSet);
      const cc = new CentralSceneCCConfigurationSet({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index,
        slowRefresh
      });
      return this.host.sendCommand(cc, this.commandOptions);
    }
    get [(_setConfiguration_decorators = [validateArgs_CentralSceneCCAPI_setConfiguration()], import_API.SET_VALUE)]() {
      return async function({ property }, value) {
        if (property !== "slowRefresh") {
          (0, import_API.throwUnsupportedProperty)(this.ccId, property);
        }
        if (typeof value !== "boolean") {
          (0, import_API.throwWrongValueType)(this.ccId, property, "boolean", typeof value);
        }
        return this.setConfiguration(value);
      };
    }
    get [import_API.POLL_VALUE]() {
      return async function({ property }) {
        if (property === "slowRefresh") {
          return (await this.getConfiguration())?.[property];
        }
        (0, import_API.throwUnsupportedProperty)(this.ccId, property);
      };
    }
    constructor() {
      super(...arguments);
      __runInitializers(this, _instanceExtraInitializers);
    }
  };
  return CentralSceneCCAPI2 = _classThis;
})();
let CentralSceneCC = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.commandClass)(import_core.CommandClasses["Central Scene"]), (0, import_CommandClassDecorators.implementedVersion)(3), (0, import_CommandClassDecorators.ccValues)(import_CCValues_generated.CentralSceneCCValues)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = import_CommandClass.CommandClass;
  var CentralSceneCC2 = class extends _classSuper {
    static {
      __name(this, "CentralSceneCC");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      CentralSceneCC2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    determineRequiredCCInterviews() {
      return [
        ...super.determineRequiredCCInterviews(),
        import_core.CommandClasses.Association,
        import_core.CommandClasses["Multi Channel Association"],
        import_core.CommandClasses["Association Group Information"]
      ];
    }
    skipEndpointInterview() {
      return true;
    }
    async interview(ctx) {
      const node = this.getNode(ctx);
      const endpoint = this.getEndpoint(ctx);
      const api = import_API.CCAPI.create(import_core.CommandClasses["Central Scene"], ctx, endpoint).withOptions({
        priority: import_core.MessagePriority.NodeQuery
      });
      ctx.logNode(node.id, {
        endpoint: this.endpointIndex,
        message: `Interviewing ${this.ccName}...`,
        direction: "none"
      });
      try {
        await ccUtils.assignLifelineIssueingCommand(ctx, endpoint, this.ccId, import_Types.CentralSceneCommand.Notification);
      } catch {
        ctx.logNode(node.id, {
          endpoint: endpoint.index,
          message: `Configuring associations to receive ${(0, import_core.getCCName)(this.ccId)} commands failed!`,
          level: "warn"
        });
      }
      ctx.logNode(node.id, {
        endpoint: this.endpointIndex,
        message: "Querying supported scenes...",
        direction: "outbound"
      });
      const ccSupported = await api.getSupported();
      if (ccSupported) {
        const logMessage = `received supported scenes:
# of scenes:           ${ccSupported.sceneCount}
supports slow refresh: ${ccSupported.supportsSlowRefresh}`;
        ctx.logNode(node.id, {
          endpoint: this.endpointIndex,
          message: logMessage,
          direction: "inbound"
        });
      } else {
        ctx.logNode(node.id, {
          endpoint: this.endpointIndex,
          message: "Querying supported scenes timed out, skipping interview...",
          level: "warn"
        });
        return;
      }
      if (api.version >= 3 && ccSupported?.supportsSlowRefresh) {
        ctx.logNode(node.id, {
          endpoint: this.endpointIndex,
          message: "Enabling slow refresh capability...",
          direction: "outbound"
        });
        await api.setConfiguration(true);
      }
      this.setInterviewComplete(ctx, true);
    }
  };
  return CentralSceneCC2 = _classThis;
})();
let CentralSceneCCNotification = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.CentralSceneCommand.Notification)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = CentralSceneCC;
  var CentralSceneCCNotification2 = class extends _classSuper {
    static {
      __name(this, "CentralSceneCCNotification");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      CentralSceneCCNotification2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.sequenceNumber = options.sequenceNumber;
      this.keyAttribute = options.keyAttribute;
      this.sceneNumber = options.sceneNumber;
      this.slowRefresh = options.slowRefresh;
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 3);
      const sequenceNumber = raw.payload[0];
      const keyAttribute = raw.payload[1] & 7;
      const sceneNumber = raw.payload[2];
      let slowRefresh;
      if (keyAttribute === import_Types.CentralSceneKeys.KeyHeldDown) {
        slowRefresh = !!(raw.payload[1] & 128);
      }
      return new this({
        nodeId: ctx.sourceNodeId,
        sequenceNumber,
        keyAttribute,
        sceneNumber,
        slowRefresh
      });
    }
    persistValues(ctx) {
      if (!super.persistValues(ctx))
        return false;
      const sceneValue = import_CCValues_generated.CentralSceneCCValues.scene(this.sceneNumber);
      const sceneConfig = ctx.getDeviceConfig?.(this.nodeId)?.scenes?.get(this.sceneNumber);
      if (sceneConfig) {
        this.ensureMetadata(ctx, sceneValue, {
          ...sceneValue.meta,
          label: sceneConfig.label,
          description: sceneConfig.description
        });
      } else {
        this.ensureMetadata(ctx, sceneValue);
      }
      return true;
    }
    sequenceNumber;
    keyAttribute;
    sceneNumber;
    slowRefresh;
    toLogEntry(ctx) {
      const message = {
        "sequence number": this.sequenceNumber,
        "key attribute": (0, import_shared.getEnumMemberName)(import_Types.CentralSceneKeys, this.keyAttribute),
        "scene number": this.sceneNumber
      };
      if (this.slowRefresh != void 0) {
        message["slow refresh"] = this.slowRefresh;
      }
      return {
        ...super.toLogEntry(ctx),
        message
      };
    }
  };
  return CentralSceneCCNotification2 = _classThis;
})();
let CentralSceneCCSupportedReport = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.CentralSceneCommand.SupportedReport), (0, import_CommandClassDecorators.ccValueProperty)("sceneCount", import_CCValues_generated.CentralSceneCCValues.sceneCount), (0, import_CommandClassDecorators.ccValueProperty)("supportsSlowRefresh", import_CCValues_generated.CentralSceneCCValues.supportsSlowRefresh), (0, import_CommandClassDecorators.ccValueProperty)("supportedKeyAttributes", import_CCValues_generated.CentralSceneCCValues.supportedKeyAttributes)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = CentralSceneCC;
  var CentralSceneCCSupportedReport2 = class extends _classSuper {
    static {
      __name(this, "CentralSceneCCSupportedReport");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      CentralSceneCCSupportedReport2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.sceneCount = options.sceneCount;
      this.supportsSlowRefresh = options.supportsSlowRefresh;
      for (const [scene, keys] of Object.entries(options.supportedKeyAttributes)) {
        this._supportedKeyAttributes.set(parseInt(scene), keys);
      }
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 2);
      const sceneCount = raw.payload[0];
      const supportsSlowRefresh = !!(raw.payload[1] & 128);
      const bitMaskBytes = (raw.payload[1] & 6) >>> 1;
      const identicalKeyAttributes = !!(raw.payload[1] & 1);
      const numEntries = identicalKeyAttributes ? 1 : sceneCount;
      (0, import_core.validatePayload)(raw.payload.length >= 2 + bitMaskBytes * numEntries);
      const supportedKeyAttributes = {};
      for (let i = 0; i < numEntries; i++) {
        const mask = raw.payload.subarray(2 + i * bitMaskBytes, 2 + (i + 1) * bitMaskBytes);
        supportedKeyAttributes[i + 1] = (0, import_core.parseBitMask)(mask, import_Types.CentralSceneKeys.KeyPressed);
      }
      if (identicalKeyAttributes) {
        for (let i = 2; i <= sceneCount; i++) {
          supportedKeyAttributes[i] = supportedKeyAttributes[1];
        }
      }
      return new this({
        nodeId: ctx.sourceNodeId,
        sceneCount,
        supportsSlowRefresh,
        supportedKeyAttributes
      });
    }
    persistValues(ctx) {
      if (!super.persistValues(ctx))
        return false;
      const deviceConfig = ctx.getDeviceConfig?.(this.nodeId);
      for (let i = 1; i <= this.sceneCount; i++) {
        const sceneValue = import_CCValues_generated.CentralSceneCCValues.scene(i);
        const sceneMetadata = { ...sceneValue.meta };
        const sceneConfig = deviceConfig?.scenes?.get(i);
        if (sceneConfig) {
          sceneMetadata.label = sceneConfig.label;
        }
        if (sceneConfig?.description) {
          sceneMetadata.description = sceneConfig.description;
        }
        this.setMetadata(ctx, sceneValue, {
          ...sceneMetadata,
          states: (0, import_core.enumValuesToMetadataStates)(import_Types.CentralSceneKeys, this._supportedKeyAttributes.get(i))
        });
      }
      return true;
    }
    sceneCount;
    // TODO: Only offer `slowRefresh` if this is true
    supportsSlowRefresh;
    _supportedKeyAttributes = /* @__PURE__ */ new Map();
    get supportedKeyAttributes() {
      return this._supportedKeyAttributes;
    }
    toLogEntry(ctx) {
      const message = {
        "scene count": this.sceneCount,
        "supports slow refresh": (0, import_core.maybeUnknownToString)(this.supportsSlowRefresh)
      };
      for (const [scene, keys] of this.supportedKeyAttributes) {
        message[`supported attributes (scene #${scene})`] = keys.map((k) => `
\xB7 ${(0, import_shared.getEnumMemberName)(import_Types.CentralSceneKeys, k)}`).join("");
      }
      return {
        ...super.toLogEntry(ctx),
        message
      };
    }
  };
  return CentralSceneCCSupportedReport2 = _classThis;
})();
let CentralSceneCCSupportedGet = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.CentralSceneCommand.SupportedGet), (0, import_CommandClassDecorators.expectedCCResponse)(CentralSceneCCSupportedReport)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = CentralSceneCC;
  var CentralSceneCCSupportedGet2 = class extends _classSuper {
    static {
      __name(this, "CentralSceneCCSupportedGet");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      CentralSceneCCSupportedGet2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
  };
  return CentralSceneCCSupportedGet2 = _classThis;
})();
let CentralSceneCCConfigurationReport = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.CentralSceneCommand.ConfigurationReport), (0, import_CommandClassDecorators.ccValueProperty)("slowRefresh", import_CCValues_generated.CentralSceneCCValues.slowRefresh)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = CentralSceneCC;
  var CentralSceneCCConfigurationReport2 = class extends _classSuper {
    static {
      __name(this, "CentralSceneCCConfigurationReport");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      CentralSceneCCConfigurationReport2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.slowRefresh = options.slowRefresh;
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 1);
      const slowRefresh = !!(raw.payload[0] & 128);
      return new this({
        nodeId: ctx.sourceNodeId,
        slowRefresh
      });
    }
    slowRefresh;
    toLogEntry(ctx) {
      return {
        ...super.toLogEntry(ctx),
        message: { "slow refresh": this.slowRefresh }
      };
    }
  };
  return CentralSceneCCConfigurationReport2 = _classThis;
})();
let CentralSceneCCConfigurationGet = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.CentralSceneCommand.ConfigurationGet), (0, import_CommandClassDecorators.expectedCCResponse)(CentralSceneCCConfigurationReport)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = CentralSceneCC;
  var CentralSceneCCConfigurationGet2 = class extends _classSuper {
    static {
      __name(this, "CentralSceneCCConfigurationGet");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      CentralSceneCCConfigurationGet2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
  };
  return CentralSceneCCConfigurationGet2 = _classThis;
})();
let CentralSceneCCConfigurationSet = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.CentralSceneCommand.ConfigurationSet), (0, import_CommandClassDecorators.useSupervision)()];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = CentralSceneCC;
  var CentralSceneCCConfigurationSet2 = class extends _classSuper {
    static {
      __name(this, "CentralSceneCCConfigurationSet");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      CentralSceneCCConfigurationSet2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.slowRefresh = options.slowRefresh;
    }
    static from(_raw, _ctx) {
      throw new import_core.ZWaveError(`${this.name}: deserialization not implemented`, import_core.ZWaveErrorCodes.Deserialization_NotImplemented);
    }
    slowRefresh;
    serialize(ctx) {
      this.payload = import_shared.Bytes.from([this.slowRefresh ? 128 : 0]);
      return super.serialize(ctx);
    }
    toLogEntry(ctx) {
      return {
        ...super.toLogEntry(ctx),
        message: { "slow refresh": this.slowRefresh }
      };
    }
  };
  return CentralSceneCCConfigurationSet2 = _classThis;
})();
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  CentralSceneCC,
  CentralSceneCCAPI,
  CentralSceneCCConfigurationGet,
  CentralSceneCCConfigurationReport,
  CentralSceneCCConfigurationSet,
  CentralSceneCCNotification,
  CentralSceneCCSupportedGet,
  CentralSceneCCSupportedReport,
  CentralSceneCCValues
});
//# sourceMappingURL=CentralSceneCC.js.map
