"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var DeviceResetLocallyCC_exports = {};
__export(DeviceResetLocallyCC_exports, {
  DeviceResetLocallyCC: () => DeviceResetLocallyCC,
  DeviceResetLocallyCCAPI: () => DeviceResetLocallyCCAPI,
  DeviceResetLocallyCCNotification: () => DeviceResetLocallyCCNotification
});
module.exports = __toCommonJS(DeviceResetLocallyCC_exports);
var import_core = require("@zwave-js/core");
var import_API = require("../lib/API.js");
var import_CommandClass = require("../lib/CommandClass.js");
var import_CommandClassDecorators = require("../lib/CommandClassDecorators.js");
var import_Types = require("../lib/_Types.js");
var __esDecorate = function(ctor, descriptorIn, decorators, contextIn, initializers, extraInitializers) {
  function accept(f) {
    if (f !== void 0 && typeof f !== "function") throw new TypeError("Function expected");
    return f;
  }
  __name(accept, "accept");
  var kind = contextIn.kind, key = kind === "getter" ? "get" : kind === "setter" ? "set" : "value";
  var target = !descriptorIn && ctor ? contextIn["static"] ? ctor : ctor.prototype : null;
  var descriptor = descriptorIn || (target ? Object.getOwnPropertyDescriptor(target, contextIn.name) : {});
  var _, done = false;
  for (var i = decorators.length - 1; i >= 0; i--) {
    var context = {};
    for (var p in contextIn) context[p] = p === "access" ? {} : contextIn[p];
    for (var p in contextIn.access) context.access[p] = contextIn.access[p];
    context.addInitializer = function(f) {
      if (done) throw new TypeError("Cannot add initializers after decoration has completed");
      extraInitializers.push(accept(f || null));
    };
    var result = (0, decorators[i])(kind === "accessor" ? { get: descriptor.get, set: descriptor.set } : descriptor[key], context);
    if (kind === "accessor") {
      if (result === void 0) continue;
      if (result === null || typeof result !== "object") throw new TypeError("Object expected");
      if (_ = accept(result.get)) descriptor.get = _;
      if (_ = accept(result.set)) descriptor.set = _;
      if (_ = accept(result.init)) initializers.unshift(_);
    } else if (_ = accept(result)) {
      if (kind === "field") initializers.unshift(_);
      else descriptor[key] = _;
    }
  }
  if (target) Object.defineProperty(target, contextIn.name, descriptor);
  done = true;
};
var __runInitializers = function(thisArg, initializers, value) {
  var useValue = arguments.length > 2;
  for (var i = 0; i < initializers.length; i++) {
    value = useValue ? initializers[i].call(thisArg, value) : initializers[i].call(thisArg);
  }
  return useValue ? value : void 0;
};
let DeviceResetLocallyCCAPI = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.API)(import_core.CommandClasses["Device Reset Locally"])];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = import_API.CCAPI;
  var DeviceResetLocallyCCAPI2 = class extends _classSuper {
    static {
      __name(this, "DeviceResetLocallyCCAPI");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      DeviceResetLocallyCCAPI2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    supportsCommand(cmd) {
      switch (cmd) {
        case import_Types.DeviceResetLocallyCommand.Notification:
          return true;
      }
      return super.supportsCommand(cmd);
    }
    async sendNotification() {
      this.assertSupportsCommand(import_Types.DeviceResetLocallyCommand, import_Types.DeviceResetLocallyCommand.Notification);
      const cc = new DeviceResetLocallyCCNotification({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index
      });
      try {
        await this.host.sendCommand(cc, {
          ...this.commandOptions,
          // Do not fall back to explorer frames
          transmitOptions: import_core.TransmitOptions.ACK | import_core.TransmitOptions.AutoRoute,
          // Only try sending once
          maxSendAttempts: 1,
          // We don't want failures causing us to treat the node as asleep or dead
          changeNodeStatusOnMissingACK: false
        });
      } catch {
      }
    }
  };
  return DeviceResetLocallyCCAPI2 = _classThis;
})();
let DeviceResetLocallyCC = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.commandClass)(import_core.CommandClasses["Device Reset Locally"]), (0, import_CommandClassDecorators.implementedVersion)(1)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = import_CommandClass.CommandClass;
  var DeviceResetLocallyCC2 = class extends _classSuper {
    static {
      __name(this, "DeviceResetLocallyCC");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      DeviceResetLocallyCC2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
  };
  return DeviceResetLocallyCC2 = _classThis;
})();
let DeviceResetLocallyCCNotification = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.DeviceResetLocallyCommand.Notification)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = DeviceResetLocallyCC;
  var DeviceResetLocallyCCNotification2 = class extends _classSuper {
    static {
      __name(this, "DeviceResetLocallyCCNotification");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      DeviceResetLocallyCCNotification2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    // @noLogEntry: This CC has no properties to log
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length === 0);
      return new this({
        nodeId: ctx.sourceNodeId
      });
    }
  };
  return DeviceResetLocallyCCNotification2 = _classThis;
})();
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  DeviceResetLocallyCC,
  DeviceResetLocallyCCAPI,
  DeviceResetLocallyCCNotification
});
//# sourceMappingURL=DeviceResetLocallyCC.js.map
