"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var HumidityControlModeCC_exports = {};
__export(HumidityControlModeCC_exports, {
  HumidityControlModeCC: () => HumidityControlModeCC,
  HumidityControlModeCCAPI: () => HumidityControlModeCCAPI,
  HumidityControlModeCCGet: () => HumidityControlModeCCGet,
  HumidityControlModeCCReport: () => HumidityControlModeCCReport,
  HumidityControlModeCCSet: () => HumidityControlModeCCSet,
  HumidityControlModeCCSupportedGet: () => HumidityControlModeCCSupportedGet,
  HumidityControlModeCCSupportedReport: () => HumidityControlModeCCSupportedReport,
  HumidityControlModeCCValues: () => import_CCValues_generated.HumidityControlModeCCValues
});
module.exports = __toCommonJS(HumidityControlModeCC_exports);
var __validateArgs = __toESM(require("./HumidityControlModeCC._validateArgs.js"), 1);
var import_core = require("@zwave-js/core");
var import_shared = require("@zwave-js/shared");
var import_API = require("../lib/API.js");
var import_CommandClass = require("../lib/CommandClass.js");
var import_CommandClassDecorators = require("../lib/CommandClassDecorators.js");
var import_Values = require("../lib/Values.js");
var import_Types = require("../lib/_Types.js");
var import_CCValues_generated = require("./_CCValues.generated.js");
var __runInitializers = function(thisArg, initializers, value) {
  var useValue = arguments.length > 2;
  for (var i = 0; i < initializers.length; i++) {
    value = useValue ? initializers[i].call(thisArg, value) : initializers[i].call(thisArg);
  }
  return useValue ? value : void 0;
};
var __esDecorate = function(ctor, descriptorIn, decorators, contextIn, initializers, extraInitializers) {
  function accept(f) {
    if (f !== void 0 && typeof f !== "function") throw new TypeError("Function expected");
    return f;
  }
  __name(accept, "accept");
  var kind = contextIn.kind, key = kind === "getter" ? "get" : kind === "setter" ? "set" : "value";
  var target = !descriptorIn && ctor ? contextIn["static"] ? ctor : ctor.prototype : null;
  var descriptor = descriptorIn || (target ? Object.getOwnPropertyDescriptor(target, contextIn.name) : {});
  var _, done = false;
  for (var i = decorators.length - 1; i >= 0; i--) {
    var context = {};
    for (var p in contextIn) context[p] = p === "access" ? {} : contextIn[p];
    for (var p in contextIn.access) context.access[p] = contextIn.access[p];
    context.addInitializer = function(f) {
      if (done) throw new TypeError("Cannot add initializers after decoration has completed");
      extraInitializers.push(accept(f || null));
    };
    var result = (0, decorators[i])(kind === "accessor" ? { get: descriptor.get, set: descriptor.set } : descriptor[key], context);
    if (kind === "accessor") {
      if (result === void 0) continue;
      if (result === null || typeof result !== "object") throw new TypeError("Object expected");
      if (_ = accept(result.get)) descriptor.get = _;
      if (_ = accept(result.set)) descriptor.set = _;
      if (_ = accept(result.init)) initializers.unshift(_);
    } else if (_ = accept(result)) {
      if (kind === "field") initializers.unshift(_);
      else descriptor[key] = _;
    }
  }
  if (target) Object.defineProperty(target, contextIn.name, descriptor);
  done = true;
};
const { validateArgs_HumidityControlModeCCAPI_set } = __validateArgs;
let HumidityControlModeCCAPI = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.API)(import_core.CommandClasses["Humidity Control Mode"])];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = import_API.CCAPI;
  let _instanceExtraInitializers = [];
  let _set_decorators;
  var HumidityControlModeCCAPI2 = class extends _classSuper {
    static {
      __name(this, "HumidityControlModeCCAPI");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      _set_decorators = [validateArgs_HumidityControlModeCCAPI_set({ strictEnums: true })];
      __esDecorate(this, null, _set_decorators, { kind: "method", name: "set", static: false, private: false, access: { has: /* @__PURE__ */ __name((obj) => "set" in obj, "has"), get: /* @__PURE__ */ __name((obj) => obj.set, "get") }, metadata: _metadata }, null, _instanceExtraInitializers);
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      HumidityControlModeCCAPI2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    supportsCommand(cmd) {
      switch (cmd) {
        case import_Types.HumidityControlModeCommand.Get:
        case import_Types.HumidityControlModeCommand.SupportedGet:
          return this.isSinglecast();
        case import_Types.HumidityControlModeCommand.Set:
          return true;
      }
      return super.supportsCommand(cmd);
    }
    get [import_API.SET_VALUE]() {
      return async function({ property }, value) {
        if (property === "mode") {
          if (typeof value !== "number") {
            (0, import_API.throwWrongValueType)(this.ccId, property, "number", typeof value);
          }
        } else {
          (0, import_API.throwUnsupportedProperty)(this.ccId, property);
        }
        const result = await this.set(value);
        if (this.isSinglecast() && !(0, import_core.supervisedCommandSucceeded)(result)) {
          this.schedulePoll({ property }, value);
        }
        return result;
      };
    }
    get [import_API.POLL_VALUE]() {
      return async function({ property }) {
        switch (property) {
          case "mode":
            return this.get();
          default:
            (0, import_API.throwUnsupportedProperty)(this.ccId, property);
        }
      };
    }
    async get() {
      this.assertSupportsCommand(import_Types.HumidityControlModeCommand, import_Types.HumidityControlModeCommand.Get);
      const cc = new HumidityControlModeCCGet({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index
      });
      const response = await this.host.sendCommand(cc, this.commandOptions);
      if (response) {
        return response?.mode;
      }
    }
    async set(mode) {
      this.assertSupportsCommand(import_Types.HumidityControlModeCommand, import_Types.HumidityControlModeCommand.Set);
      const cc = new HumidityControlModeCCSet({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index,
        mode
      });
      return this.host.sendCommand(cc, this.commandOptions);
    }
    async getSupportedModes() {
      this.assertSupportsCommand(import_Types.HumidityControlModeCommand, import_Types.HumidityControlModeCommand.SupportedGet);
      const cc = new HumidityControlModeCCSupportedGet({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index
      });
      const response = await this.host.sendCommand(cc, this.commandOptions);
      return response?.supportedModes;
    }
    constructor() {
      super(...arguments);
      __runInitializers(this, _instanceExtraInitializers);
    }
  };
  return HumidityControlModeCCAPI2 = _classThis;
})();
let HumidityControlModeCC = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.commandClass)(import_core.CommandClasses["Humidity Control Mode"]), (0, import_CommandClassDecorators.implementedVersion)(1), (0, import_CommandClassDecorators.ccValues)(import_CCValues_generated.HumidityControlModeCCValues)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = import_CommandClass.CommandClass;
  var HumidityControlModeCC2 = class extends _classSuper {
    static {
      __name(this, "HumidityControlModeCC");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      HumidityControlModeCC2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    async interview(ctx) {
      const node = this.getNode(ctx);
      const endpoint = this.getEndpoint(ctx);
      const api = import_API.CCAPI.create(import_core.CommandClasses["Humidity Control Mode"], ctx, endpoint).withOptions({
        priority: import_core.MessagePriority.NodeQuery
      });
      ctx.logNode(node.id, {
        endpoint: this.endpointIndex,
        message: `Interviewing ${this.ccName}...`,
        direction: "none"
      });
      ctx.logNode(node.id, {
        endpoint: this.endpointIndex,
        message: "querying supported humidity control modes...",
        direction: "outbound"
      });
      const supportedModes = await api.getSupportedModes();
      if (supportedModes) {
        const logMessage = `received supported humidity control modes:${supportedModes.map((mode) => `
\xB7 ${(0, import_shared.getEnumMemberName)(import_Types.HumidityControlMode, mode)}`).join("")}`;
        ctx.logNode(node.id, {
          endpoint: this.endpointIndex,
          message: logMessage,
          direction: "inbound"
        });
      } else {
        ctx.logNode(node.id, {
          endpoint: this.endpointIndex,
          message: "Querying supported humidity control modes timed out, skipping interview...",
          level: "warn"
        });
        return;
      }
      await this.refreshValues(ctx);
      this.setInterviewComplete(ctx, true);
    }
    async refreshValues(ctx) {
      const node = this.getNode(ctx);
      const endpoint = this.getEndpoint(ctx);
      const api = import_API.CCAPI.create(import_core.CommandClasses["Humidity Control Mode"], ctx, endpoint).withOptions({
        priority: import_core.MessagePriority.NodeQuery
      });
      ctx.logNode(node.id, {
        endpoint: this.endpointIndex,
        message: "querying current humidity control mode...",
        direction: "outbound"
      });
      const currentMode = await api.get();
      if (currentMode) {
        ctx.logNode(node.id, {
          endpoint: this.endpointIndex,
          message: "received current humidity control mode: " + (0, import_shared.getEnumMemberName)(import_Types.HumidityControlMode, currentMode),
          direction: "inbound"
        });
      }
    }
  };
  return HumidityControlModeCC2 = _classThis;
})();
let HumidityControlModeCCSet = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.HumidityControlModeCommand.Set), (0, import_CommandClassDecorators.useSupervision)()];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = HumidityControlModeCC;
  var HumidityControlModeCCSet2 = class extends _classSuper {
    static {
      __name(this, "HumidityControlModeCCSet");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      HumidityControlModeCCSet2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.mode = options.mode;
    }
    static from(_raw, _ctx) {
      throw new import_core.ZWaveError(`${this.name}: deserialization not implemented`, import_core.ZWaveErrorCodes.Deserialization_NotImplemented);
    }
    mode;
    serialize(ctx) {
      this.payload = import_shared.Bytes.from([this.mode & 15]);
      return super.serialize(ctx);
    }
    toLogEntry(ctx) {
      return {
        ...super.toLogEntry(ctx),
        message: {
          mode: (0, import_shared.getEnumMemberName)(import_Types.HumidityControlMode, this.mode)
        }
      };
    }
  };
  return HumidityControlModeCCSet2 = _classThis;
})();
let HumidityControlModeCCReport = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.HumidityControlModeCommand.Report), (0, import_CommandClassDecorators.ccValueProperty)("mode", import_CCValues_generated.HumidityControlModeCCValues.mode)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = HumidityControlModeCC;
  var HumidityControlModeCCReport2 = class extends _classSuper {
    static {
      __name(this, "HumidityControlModeCCReport");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      HumidityControlModeCCReport2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.mode = options.mode;
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 1);
      const mode = raw.payload[0] & 15;
      return new this({
        nodeId: ctx.sourceNodeId,
        mode
      });
    }
    mode;
    toLogEntry(ctx) {
      return {
        ...super.toLogEntry(ctx),
        message: {
          mode: (0, import_shared.getEnumMemberName)(import_Types.HumidityControlMode, this.mode)
        }
      };
    }
  };
  return HumidityControlModeCCReport2 = _classThis;
})();
let HumidityControlModeCCGet = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.HumidityControlModeCommand.Get), (0, import_CommandClassDecorators.expectedCCResponse)(HumidityControlModeCCReport)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = HumidityControlModeCC;
  var HumidityControlModeCCGet2 = class extends _classSuper {
    static {
      __name(this, "HumidityControlModeCCGet");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      HumidityControlModeCCGet2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
  };
  return HumidityControlModeCCGet2 = _classThis;
})();
let HumidityControlModeCCSupportedReport = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.HumidityControlModeCommand.SupportedReport), (0, import_CommandClassDecorators.ccValueProperty)("supportedModes", import_CCValues_generated.HumidityControlModeCCValues.supportedModes)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = HumidityControlModeCC;
  var HumidityControlModeCCSupportedReport2 = class extends _classSuper {
    static {
      __name(this, "HumidityControlModeCCSupportedReport");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      HumidityControlModeCCSupportedReport2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.supportedModes = options.supportedModes;
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 1);
      const supportedModes = (0, import_core.parseBitMask)(raw.payload, import_Types.HumidityControlMode.Off);
      if (!supportedModes.includes(import_Types.HumidityControlMode.Off)) {
        supportedModes.unshift(import_Types.HumidityControlMode.Off);
      }
      return new this({
        nodeId: ctx.sourceNodeId,
        supportedModes
      });
    }
    persistValues(ctx) {
      if (!super.persistValues(ctx))
        return false;
      const modeValue = import_CCValues_generated.HumidityControlModeCCValues.mode;
      this.setMetadata(ctx, modeValue, {
        ...modeValue.meta,
        states: (0, import_core.enumValuesToMetadataStates)(import_Types.HumidityControlMode, this.supportedModes)
      });
      return true;
    }
    supportedModes;
    toLogEntry(ctx) {
      return {
        ...super.toLogEntry(ctx),
        message: {
          "supported modes": this.supportedModes.map((mode) => `
\xB7 ${(0, import_shared.getEnumMemberName)(import_Types.HumidityControlMode, mode)}`).join("")
        }
      };
    }
  };
  return HumidityControlModeCCSupportedReport2 = _classThis;
})();
let HumidityControlModeCCSupportedGet = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.HumidityControlModeCommand.SupportedGet), (0, import_CommandClassDecorators.expectedCCResponse)(HumidityControlModeCCSupportedReport)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = HumidityControlModeCC;
  var HumidityControlModeCCSupportedGet2 = class extends _classSuper {
    static {
      __name(this, "HumidityControlModeCCSupportedGet");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      HumidityControlModeCCSupportedGet2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
  };
  return HumidityControlModeCCSupportedGet2 = _classThis;
})();
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  HumidityControlModeCC,
  HumidityControlModeCCAPI,
  HumidityControlModeCCGet,
  HumidityControlModeCCReport,
  HumidityControlModeCCSet,
  HumidityControlModeCCSupportedGet,
  HumidityControlModeCCSupportedReport,
  HumidityControlModeCCValues
});
//# sourceMappingURL=HumidityControlModeCC.js.map
