"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var InclusionControllerCC_exports = {};
__export(InclusionControllerCC_exports, {
  InclusionControllerCC: () => InclusionControllerCC,
  InclusionControllerCCAPI: () => InclusionControllerCCAPI,
  InclusionControllerCCComplete: () => InclusionControllerCCComplete,
  InclusionControllerCCInitiate: () => InclusionControllerCCInitiate
});
module.exports = __toCommonJS(InclusionControllerCC_exports);
var import_core = require("@zwave-js/core");
var import_shared = require("@zwave-js/shared");
var import_API = require("../lib/API.js");
var import_CommandClass = require("../lib/CommandClass.js");
var import_CommandClassDecorators = require("../lib/CommandClassDecorators.js");
var import_Types = require("../lib/_Types.js");
var __esDecorate = function(ctor, descriptorIn, decorators, contextIn, initializers, extraInitializers) {
  function accept(f) {
    if (f !== void 0 && typeof f !== "function") throw new TypeError("Function expected");
    return f;
  }
  __name(accept, "accept");
  var kind = contextIn.kind, key = kind === "getter" ? "get" : kind === "setter" ? "set" : "value";
  var target = !descriptorIn && ctor ? contextIn["static"] ? ctor : ctor.prototype : null;
  var descriptor = descriptorIn || (target ? Object.getOwnPropertyDescriptor(target, contextIn.name) : {});
  var _, done = false;
  for (var i = decorators.length - 1; i >= 0; i--) {
    var context = {};
    for (var p in contextIn) context[p] = p === "access" ? {} : contextIn[p];
    for (var p in contextIn.access) context.access[p] = contextIn.access[p];
    context.addInitializer = function(f) {
      if (done) throw new TypeError("Cannot add initializers after decoration has completed");
      extraInitializers.push(accept(f || null));
    };
    var result = (0, decorators[i])(kind === "accessor" ? { get: descriptor.get, set: descriptor.set } : descriptor[key], context);
    if (kind === "accessor") {
      if (result === void 0) continue;
      if (result === null || typeof result !== "object") throw new TypeError("Object expected");
      if (_ = accept(result.get)) descriptor.get = _;
      if (_ = accept(result.set)) descriptor.set = _;
      if (_ = accept(result.init)) initializers.unshift(_);
    } else if (_ = accept(result)) {
      if (kind === "field") initializers.unshift(_);
      else descriptor[key] = _;
    }
  }
  if (target) Object.defineProperty(target, contextIn.name, descriptor);
  done = true;
};
var __runInitializers = function(thisArg, initializers, value) {
  var useValue = arguments.length > 2;
  for (var i = 0; i < initializers.length; i++) {
    value = useValue ? initializers[i].call(thisArg, value) : initializers[i].call(thisArg);
  }
  return useValue ? value : void 0;
};
let InclusionControllerCC = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.commandClass)(import_core.CommandClasses["Inclusion Controller"]), (0, import_CommandClassDecorators.implementedVersion)(1)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = import_CommandClass.CommandClass;
  var InclusionControllerCC2 = class extends _classSuper {
    static {
      __name(this, "InclusionControllerCC");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      InclusionControllerCC2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
  };
  return InclusionControllerCC2 = _classThis;
})();
let InclusionControllerCCAPI = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.API)(import_core.CommandClasses["Inclusion Controller"])];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = import_API.CCAPI;
  var InclusionControllerCCAPI2 = class extends _classSuper {
    static {
      __name(this, "InclusionControllerCCAPI");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      InclusionControllerCCAPI2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    supportsCommand(cmd) {
      switch (cmd) {
        case import_Types.InclusionControllerCommand.Initiate:
        case import_Types.InclusionControllerCommand.Complete:
          return true;
      }
      return super.supportsCommand(cmd);
    }
    /** Instruct the target to initiate the given inclusion step for the given node */
    async initiateStep(nodeId, step) {
      this.assertSupportsCommand(import_Types.InclusionControllerCommand, import_Types.InclusionControllerCommand.Initiate);
      const cc = new InclusionControllerCCInitiate({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index,
        includedNodeId: nodeId,
        step
      });
      await this.host.sendCommand(cc, this.commandOptions);
    }
    /** Indicate to the other node that the given inclusion step has been completed */
    async completeStep(step, status) {
      this.assertSupportsCommand(import_Types.InclusionControllerCommand, import_Types.InclusionControllerCommand.Complete);
      const cc = new InclusionControllerCCComplete({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index,
        step,
        status
      });
      await this.host.sendCommand(cc, this.commandOptions);
    }
  };
  return InclusionControllerCCAPI2 = _classThis;
})();
let InclusionControllerCCComplete = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.InclusionControllerCommand.Complete)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = InclusionControllerCC;
  var InclusionControllerCCComplete2 = class extends _classSuper {
    static {
      __name(this, "InclusionControllerCCComplete");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      InclusionControllerCCComplete2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.step = options.step;
      this.status = options.status;
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 2);
      const step = raw.payload[0];
      import_core.validatePayload.withReason("Invalid inclusion controller step")(step in import_Types.InclusionControllerStep);
      const status = raw.payload[1];
      return new this({
        nodeId: ctx.sourceNodeId,
        step,
        status
      });
    }
    step;
    status;
    serialize(ctx) {
      this.payload = import_shared.Bytes.from([this.step, this.status]);
      return super.serialize(ctx);
    }
    toLogEntry(ctx) {
      return {
        ...super.toLogEntry(ctx),
        message: {
          step: (0, import_shared.getEnumMemberName)(import_Types.InclusionControllerStep, this.step),
          status: (0, import_shared.getEnumMemberName)(import_Types.InclusionControllerStatus, this.status)
        }
      };
    }
  };
  return InclusionControllerCCComplete2 = _classThis;
})();
let InclusionControllerCCInitiate = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.InclusionControllerCommand.Initiate)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = InclusionControllerCC;
  var InclusionControllerCCInitiate2 = class extends _classSuper {
    static {
      __name(this, "InclusionControllerCCInitiate");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      InclusionControllerCCInitiate2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.includedNodeId = options.includedNodeId;
      this.step = options.step;
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 2);
      const includedNodeId = raw.payload[0];
      const step = raw.payload[1];
      import_core.validatePayload.withReason("Invalid inclusion controller step")(step in import_Types.InclusionControllerStep);
      return new this({
        nodeId: ctx.sourceNodeId,
        includedNodeId,
        step
      });
    }
    includedNodeId;
    step;
    serialize(ctx) {
      this.payload = import_shared.Bytes.from([this.includedNodeId, this.step]);
      return super.serialize(ctx);
    }
    toLogEntry(ctx) {
      return {
        ...super.toLogEntry(ctx),
        message: {
          "included node id": this.includedNodeId,
          step: (0, import_shared.getEnumMemberName)(import_Types.InclusionControllerStep, this.step)
        }
      };
    }
  };
  return InclusionControllerCCInitiate2 = _classThis;
})();
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  InclusionControllerCC,
  InclusionControllerCCAPI,
  InclusionControllerCCComplete,
  InclusionControllerCCInitiate
});
//# sourceMappingURL=InclusionControllerCC.js.map
