"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var SceneActuatorConfigurationCC_exports = {};
__export(SceneActuatorConfigurationCC_exports, {
  SceneActuatorConfigurationCC: () => SceneActuatorConfigurationCC,
  SceneActuatorConfigurationCCAPI: () => SceneActuatorConfigurationCCAPI,
  SceneActuatorConfigurationCCGet: () => SceneActuatorConfigurationCCGet,
  SceneActuatorConfigurationCCReport: () => SceneActuatorConfigurationCCReport,
  SceneActuatorConfigurationCCSet: () => SceneActuatorConfigurationCCSet,
  SceneActuatorConfigurationCCValues: () => import_CCValues_generated.SceneActuatorConfigurationCCValues
});
module.exports = __toCommonJS(SceneActuatorConfigurationCC_exports);
var __validateArgs = __toESM(require("./SceneActuatorConfigurationCC._validateArgs.js"), 1);
var import_core = require("@zwave-js/core");
var import_shared = require("@zwave-js/shared");
var import_API = require("../lib/API.js");
var import_CommandClass = require("../lib/CommandClass.js");
var import_CommandClassDecorators = require("../lib/CommandClassDecorators.js");
var import_Values = require("../lib/Values.js");
var import_Types = require("../lib/_Types.js");
var import_CCValues_generated = require("./_CCValues.generated.js");
var __runInitializers = function(thisArg, initializers, value) {
  var useValue = arguments.length > 2;
  for (var i = 0; i < initializers.length; i++) {
    value = useValue ? initializers[i].call(thisArg, value) : initializers[i].call(thisArg);
  }
  return useValue ? value : void 0;
};
var __esDecorate = function(ctor, descriptorIn, decorators, contextIn, initializers, extraInitializers) {
  function accept(f) {
    if (f !== void 0 && typeof f !== "function") throw new TypeError("Function expected");
    return f;
  }
  __name(accept, "accept");
  var kind = contextIn.kind, key = kind === "getter" ? "get" : kind === "setter" ? "set" : "value";
  var target = !descriptorIn && ctor ? contextIn["static"] ? ctor : ctor.prototype : null;
  var descriptor = descriptorIn || (target ? Object.getOwnPropertyDescriptor(target, contextIn.name) : {});
  var _, done = false;
  for (var i = decorators.length - 1; i >= 0; i--) {
    var context = {};
    for (var p in contextIn) context[p] = p === "access" ? {} : contextIn[p];
    for (var p in contextIn.access) context.access[p] = contextIn.access[p];
    context.addInitializer = function(f) {
      if (done) throw new TypeError("Cannot add initializers after decoration has completed");
      extraInitializers.push(accept(f || null));
    };
    var result = (0, decorators[i])(kind === "accessor" ? { get: descriptor.get, set: descriptor.set } : descriptor[key], context);
    if (kind === "accessor") {
      if (result === void 0) continue;
      if (result === null || typeof result !== "object") throw new TypeError("Object expected");
      if (_ = accept(result.get)) descriptor.get = _;
      if (_ = accept(result.set)) descriptor.set = _;
      if (_ = accept(result.init)) initializers.unshift(_);
    } else if (_ = accept(result)) {
      if (kind === "field") initializers.unshift(_);
      else descriptor[key] = _;
    }
  }
  if (target) Object.defineProperty(target, contextIn.name, descriptor);
  done = true;
};
const { validateArgs_SceneActuatorConfigurationCCAPI_set, validateArgs_SceneActuatorConfigurationCCAPI_get } = __validateArgs;
let SceneActuatorConfigurationCCAPI = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.API)(import_core.CommandClasses["Scene Actuator Configuration"])];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = import_API.CCAPI;
  let _instanceExtraInitializers = [];
  let _set_decorators;
  let _get_decorators;
  var SceneActuatorConfigurationCCAPI2 = class extends _classSuper {
    static {
      __name(this, "SceneActuatorConfigurationCCAPI");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      _set_decorators = [validateArgs_SceneActuatorConfigurationCCAPI_set()];
      _get_decorators = [validateArgs_SceneActuatorConfigurationCCAPI_get()];
      __esDecorate(this, null, _set_decorators, { kind: "method", name: "set", static: false, private: false, access: { has: /* @__PURE__ */ __name((obj) => "set" in obj, "has"), get: /* @__PURE__ */ __name((obj) => obj.set, "get") }, metadata: _metadata }, null, _instanceExtraInitializers);
      __esDecorate(this, null, _get_decorators, { kind: "method", name: "get", static: false, private: false, access: { has: /* @__PURE__ */ __name((obj) => "get" in obj, "has"), get: /* @__PURE__ */ __name((obj) => obj.get, "get") }, metadata: _metadata }, null, _instanceExtraInitializers);
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      SceneActuatorConfigurationCCAPI2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    supportsCommand(cmd) {
      switch (cmd) {
        case import_Types.SceneActuatorConfigurationCommand.Get:
          return this.isSinglecast();
        case import_Types.SceneActuatorConfigurationCommand.Set:
          return true;
      }
      return super.supportsCommand(cmd);
    }
    get [import_API.SET_VALUE]() {
      return async function({ property, propertyKey }, value, options) {
        if (propertyKey == void 0) {
          (0, import_API.throwMissingPropertyKey)(this.ccId, property);
        } else if (typeof propertyKey !== "number") {
          (0, import_API.throwUnsupportedPropertyKey)(this.ccId, property, propertyKey);
        }
        if (property === "level") {
          if (typeof value !== "number") {
            (0, import_API.throwWrongValueType)(this.ccId, property, "number", typeof value);
          }
          const dimmingDuration = import_core.Duration.from(options?.transitionDuration) ?? this.tryGetValueDB()?.getValue(import_CCValues_generated.SceneActuatorConfigurationCCValues.dimmingDuration(propertyKey).endpoint(this.endpoint.index));
          return this.set(propertyKey, dimmingDuration, value);
        } else if (property === "dimmingDuration") {
          if (typeof value !== "string" && !import_core.Duration.isDuration(value)) {
            (0, import_API.throwWrongValueType)(this.ccId, property, "duration", typeof value);
          }
          const dimmingDuration = import_core.Duration.from(value);
          if (dimmingDuration == void 0) {
            throw new import_core.ZWaveError(`${(0, import_core.getCCName)(this.ccId)}: "${property}" could not be set. ${JSON.stringify(value)} is not a valid duration.`, import_core.ZWaveErrorCodes.Argument_Invalid);
          }
          const level = this.tryGetValueDB()?.getValue(import_CCValues_generated.SceneActuatorConfigurationCCValues.level(propertyKey).endpoint(this.endpoint.index));
          return this.set(propertyKey, dimmingDuration, level);
        } else {
          (0, import_API.throwUnsupportedProperty)(this.ccId, property);
        }
      };
    }
    get [import_API.POLL_VALUE]() {
      return async function({ property, propertyKey }) {
        switch (property) {
          case "level":
          case "dimmingDuration": {
            if (propertyKey == void 0) {
              (0, import_API.throwMissingPropertyKey)(this.ccId, property);
            } else if (typeof propertyKey !== "number") {
              (0, import_API.throwUnsupportedPropertyKey)(this.ccId, property, propertyKey);
            }
            return (await this.get(propertyKey))?.[property];
          }
          default:
            (0, import_API.throwUnsupportedProperty)(this.ccId, property);
        }
      };
    }
    async set(sceneId, dimmingDuration, level) {
      this.assertSupportsCommand(import_Types.SceneActuatorConfigurationCommand, import_Types.SceneActuatorConfigurationCommand.Set);
      const cc = new SceneActuatorConfigurationCCSet({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index,
        sceneId,
        dimmingDuration: import_core.Duration.from(dimmingDuration) ?? new import_core.Duration(0, "seconds"),
        level
      });
      return this.host.sendCommand(cc, this.commandOptions);
    }
    async getActive() {
      this.assertSupportsCommand(import_Types.SceneActuatorConfigurationCommand, import_Types.SceneActuatorConfigurationCommand.Get);
      const cc = new SceneActuatorConfigurationCCGet({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index,
        sceneId: 0
      });
      const response = await this.host.sendCommand(cc, this.commandOptions);
      if (response) {
        return (0, import_shared.pick)(response, ["sceneId", "level", "dimmingDuration"]);
      }
    }
    async get(sceneId) {
      this.assertSupportsCommand(import_Types.SceneActuatorConfigurationCommand, import_Types.SceneActuatorConfigurationCommand.Get);
      if (sceneId === 0) {
        throw new import_core.ZWaveError(`Invalid scene ID 0. To get the currently active scene, use getActive() instead.`, import_core.ZWaveErrorCodes.Argument_Invalid);
      }
      const cc = new SceneActuatorConfigurationCCGet({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index,
        sceneId
      });
      const response = await this.host.sendCommand(cc, this.commandOptions);
      if (response) {
        return (0, import_shared.pick)(response, ["level", "dimmingDuration"]);
      }
    }
    constructor() {
      super(...arguments);
      __runInitializers(this, _instanceExtraInitializers);
    }
  };
  return SceneActuatorConfigurationCCAPI2 = _classThis;
})();
let SceneActuatorConfigurationCC = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.commandClass)(import_core.CommandClasses["Scene Actuator Configuration"]), (0, import_CommandClassDecorators.implementedVersion)(1), (0, import_CommandClassDecorators.ccValues)(import_CCValues_generated.SceneActuatorConfigurationCCValues)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = import_CommandClass.CommandClass;
  var SceneActuatorConfigurationCC2 = class extends _classSuper {
    static {
      __name(this, "SceneActuatorConfigurationCC");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      SceneActuatorConfigurationCC2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    // eslint-disable-next-line @typescript-eslint/require-await
    async interview(ctx) {
      const node = this.getNode(ctx);
      ctx.logNode(node.id, {
        message: `${this.constructor.name}: setting metadata`,
        direction: "none"
      });
      for (let sceneId = 1; sceneId <= 255; sceneId++) {
        const levelValue = import_CCValues_generated.SceneActuatorConfigurationCCValues.level(sceneId);
        this.ensureMetadata(ctx, levelValue);
        const dimmingDurationValue = import_CCValues_generated.SceneActuatorConfigurationCCValues.dimmingDuration(sceneId);
        this.ensureMetadata(ctx, dimmingDurationValue);
      }
      this.setInterviewComplete(ctx, true);
    }
  };
  return SceneActuatorConfigurationCC2 = _classThis;
})();
let SceneActuatorConfigurationCCSet = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.SceneActuatorConfigurationCommand.Set), (0, import_CommandClassDecorators.useSupervision)()];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = SceneActuatorConfigurationCC;
  var SceneActuatorConfigurationCCSet2 = class extends _classSuper {
    static {
      __name(this, "SceneActuatorConfigurationCCSet");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      SceneActuatorConfigurationCCSet2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      if (options.sceneId < 1 || options.sceneId > 255) {
        throw new import_core.ZWaveError(`The scene id ${options.sceneId} must be between 1 and 255!`, import_core.ZWaveErrorCodes.Argument_Invalid);
      }
      this.sceneId = options.sceneId;
      this.dimmingDuration = options.dimmingDuration;
      this.level = options.level;
    }
    static from(_raw, _ctx) {
      throw new import_core.ZWaveError(`${this.name}: deserialization not implemented`, import_core.ZWaveErrorCodes.Deserialization_NotImplemented);
    }
    sceneId;
    dimmingDuration;
    level;
    serialize(ctx) {
      this.payload = import_shared.Bytes.from([
        this.sceneId,
        this.dimmingDuration.serializeSet(),
        this.level != void 0 ? 128 : 0,
        this.level ?? 255
      ]);
      return super.serialize(ctx);
    }
    toLogEntry(ctx) {
      const message = {
        sceneId: this.sceneId,
        dimmingDuration: this.dimmingDuration.toString()
      };
      if (this.level != void 0) {
        message.level = this.level;
      }
      return {
        ...super.toLogEntry(ctx),
        message
      };
    }
  };
  return SceneActuatorConfigurationCCSet2 = _classThis;
})();
let SceneActuatorConfigurationCCReport = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.SceneActuatorConfigurationCommand.Report)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = SceneActuatorConfigurationCC;
  var SceneActuatorConfigurationCCReport2 = class extends _classSuper {
    static {
      __name(this, "SceneActuatorConfigurationCCReport");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      SceneActuatorConfigurationCCReport2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.sceneId = options.sceneId;
      this.level = options.level;
      this.dimmingDuration = options.dimmingDuration;
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 3);
      const sceneId = raw.payload[0];
      let level;
      let dimmingDuration;
      if (sceneId !== 0) {
        level = raw.payload[1];
        dimmingDuration = import_core.Duration.parseReport(raw.payload[2]) ?? import_core.Duration.unknown();
      }
      return new this({
        nodeId: ctx.sourceNodeId,
        sceneId,
        level,
        dimmingDuration
      });
    }
    sceneId;
    level;
    dimmingDuration;
    persistValues(ctx) {
      if (!super.persistValues(ctx))
        return false;
      if (this.sceneId === 0 || this.level == void 0 || this.dimmingDuration == void 0) {
        return false;
      }
      const levelValue = import_CCValues_generated.SceneActuatorConfigurationCCValues.level(this.sceneId);
      this.ensureMetadata(ctx, levelValue);
      const dimmingDurationValue = import_CCValues_generated.SceneActuatorConfigurationCCValues.dimmingDuration(this.sceneId);
      this.ensureMetadata(ctx, dimmingDurationValue);
      this.setValue(ctx, levelValue, this.level);
      this.setValue(ctx, dimmingDurationValue, this.dimmingDuration);
      return true;
    }
    toLogEntry(ctx) {
      const message = {
        sceneId: this.sceneId
      };
      if (this.dimmingDuration != void 0) {
        message.dimmingDuration = this.dimmingDuration.toString();
      }
      if (this.level != void 0) {
        message.level = this.level;
      }
      return {
        ...super.toLogEntry(ctx),
        message
      };
    }
  };
  return SceneActuatorConfigurationCCReport2 = _classThis;
})();
function testResponseForSceneActuatorConfigurationGet(sent, received) {
  return sent.sceneId === 0 || received.sceneId === sent.sceneId;
}
__name(testResponseForSceneActuatorConfigurationGet, "testResponseForSceneActuatorConfigurationGet");
let SceneActuatorConfigurationCCGet = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.SceneActuatorConfigurationCommand.Get), (0, import_CommandClassDecorators.expectedCCResponse)(SceneActuatorConfigurationCCReport, testResponseForSceneActuatorConfigurationGet)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = SceneActuatorConfigurationCC;
  var SceneActuatorConfigurationCCGet2 = class extends _classSuper {
    static {
      __name(this, "SceneActuatorConfigurationCCGet");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      SceneActuatorConfigurationCCGet2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.sceneId = options.sceneId;
    }
    static from(_raw, _ctx) {
      throw new import_core.ZWaveError(`${this.name}: deserialization not implemented`, import_core.ZWaveErrorCodes.Deserialization_NotImplemented);
    }
    sceneId;
    serialize(ctx) {
      this.payload = import_shared.Bytes.from([this.sceneId]);
      return super.serialize(ctx);
    }
    toLogEntry(ctx) {
      return {
        ...super.toLogEntry(ctx),
        message: { "scene id": this.sceneId }
      };
    }
  };
  return SceneActuatorConfigurationCCGet2 = _classThis;
})();
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  SceneActuatorConfigurationCC,
  SceneActuatorConfigurationCCAPI,
  SceneActuatorConfigurationCCGet,
  SceneActuatorConfigurationCCReport,
  SceneActuatorConfigurationCCSet,
  SceneActuatorConfigurationCCValues
});
//# sourceMappingURL=SceneActuatorConfigurationCC.js.map
