"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var VersionCC_exports = {};
__export(VersionCC_exports, {
  VersionCC: () => VersionCC,
  VersionCCAPI: () => VersionCCAPI,
  VersionCCCapabilitiesGet: () => VersionCCCapabilitiesGet,
  VersionCCCapabilitiesReport: () => VersionCCCapabilitiesReport,
  VersionCCCommandClassGet: () => VersionCCCommandClassGet,
  VersionCCCommandClassReport: () => VersionCCCommandClassReport,
  VersionCCGet: () => VersionCCGet,
  VersionCCReport: () => VersionCCReport,
  VersionCCValues: () => import_CCValues_generated.VersionCCValues,
  VersionCCZWaveSoftwareGet: () => VersionCCZWaveSoftwareGet,
  VersionCCZWaveSoftwareReport: () => VersionCCZWaveSoftwareReport
});
module.exports = __toCommonJS(VersionCC_exports);
var __validateArgs = __toESM(require("./VersionCC._validateArgs.js"), 1);
var import_core = require("@zwave-js/core");
var import_shared = require("@zwave-js/shared");
var import_API = require("../lib/API.js");
var import_CommandClass = require("../lib/CommandClass.js");
var import_CommandClassDecorators = require("../lib/CommandClassDecorators.js");
var import_Values = require("../lib/Values.js");
var import_Types = require("../lib/_Types.js");
var import_CCValues_generated = require("./_CCValues.generated.js");
var __runInitializers = function(thisArg, initializers, value) {
  var useValue = arguments.length > 2;
  for (var i = 0; i < initializers.length; i++) {
    value = useValue ? initializers[i].call(thisArg, value) : initializers[i].call(thisArg);
  }
  return useValue ? value : void 0;
};
var __esDecorate = function(ctor, descriptorIn, decorators, contextIn, initializers, extraInitializers) {
  function accept(f) {
    if (f !== void 0 && typeof f !== "function") throw new TypeError("Function expected");
    return f;
  }
  __name(accept, "accept");
  var kind = contextIn.kind, key = kind === "getter" ? "get" : kind === "setter" ? "set" : "value";
  var target = !descriptorIn && ctor ? contextIn["static"] ? ctor : ctor.prototype : null;
  var descriptor = descriptorIn || (target ? Object.getOwnPropertyDescriptor(target, contextIn.name) : {});
  var _, done = false;
  for (var i = decorators.length - 1; i >= 0; i--) {
    var context = {};
    for (var p in contextIn) context[p] = p === "access" ? {} : contextIn[p];
    for (var p in contextIn.access) context.access[p] = contextIn.access[p];
    context.addInitializer = function(f) {
      if (done) throw new TypeError("Cannot add initializers after decoration has completed");
      extraInitializers.push(accept(f || null));
    };
    var result = (0, decorators[i])(kind === "accessor" ? { get: descriptor.get, set: descriptor.set } : descriptor[key], context);
    if (kind === "accessor") {
      if (result === void 0) continue;
      if (result === null || typeof result !== "object") throw new TypeError("Object expected");
      if (_ = accept(result.get)) descriptor.get = _;
      if (_ = accept(result.set)) descriptor.set = _;
      if (_ = accept(result.init)) initializers.unshift(_);
    } else if (_ = accept(result)) {
      if (kind === "field") initializers.unshift(_);
      else descriptor[key] = _;
    }
  }
  if (target) Object.defineProperty(target, contextIn.name, descriptor);
  done = true;
};
const { validateArgs_VersionCCAPI_sendReport, validateArgs_VersionCCAPI_getCCVersion, validateArgs_VersionCCAPI_reportCCVersion } = __validateArgs;
function parseVersion(buffer) {
  if (buffer[0] === 0 && buffer[1] === 0 && buffer[2] === 0)
    return "unused";
  return `${buffer[0]}.${buffer[1]}.${buffer[2]}`;
}
__name(parseVersion, "parseVersion");
let VersionCCAPI = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.API)(import_core.CommandClasses.Version)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = import_API.PhysicalCCAPI;
  let _instanceExtraInitializers = [];
  let _sendReport_decorators;
  let _getCCVersion_decorators;
  let _reportCCVersion_decorators;
  var VersionCCAPI2 = class extends _classSuper {
    static {
      __name(this, "VersionCCAPI");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      _sendReport_decorators = [validateArgs_VersionCCAPI_sendReport()];
      _getCCVersion_decorators = [validateArgs_VersionCCAPI_getCCVersion()];
      _reportCCVersion_decorators = [validateArgs_VersionCCAPI_reportCCVersion()];
      __esDecorate(this, null, _sendReport_decorators, { kind: "method", name: "sendReport", static: false, private: false, access: { has: /* @__PURE__ */ __name((obj) => "sendReport" in obj, "has"), get: /* @__PURE__ */ __name((obj) => obj.sendReport, "get") }, metadata: _metadata }, null, _instanceExtraInitializers);
      __esDecorate(this, null, _getCCVersion_decorators, { kind: "method", name: "getCCVersion", static: false, private: false, access: { has: /* @__PURE__ */ __name((obj) => "getCCVersion" in obj, "has"), get: /* @__PURE__ */ __name((obj) => obj.getCCVersion, "get") }, metadata: _metadata }, null, _instanceExtraInitializers);
      __esDecorate(this, null, _reportCCVersion_decorators, { kind: "method", name: "reportCCVersion", static: false, private: false, access: { has: /* @__PURE__ */ __name((obj) => "reportCCVersion" in obj, "has"), get: /* @__PURE__ */ __name((obj) => obj.reportCCVersion, "get") }, metadata: _metadata }, null, _instanceExtraInitializers);
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      VersionCCAPI2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    supportsCommand(cmd) {
      switch (cmd) {
        case import_Types.VersionCommand.Get:
        case import_Types.VersionCommand.Report:
        case import_Types.VersionCommand.CommandClassGet:
        case import_Types.VersionCommand.CommandClassReport:
          return true;
        // This is mandatory
        case import_Types.VersionCommand.CapabilitiesGet:
        case import_Types.VersionCommand.CapabilitiesReport:
        case import_Types.VersionCommand.ZWaveSoftwareReport:
          return this.version >= 3;
        case import_Types.VersionCommand.ZWaveSoftwareGet: {
          return this.getValueDB().getValue(import_CCValues_generated.VersionCCValues.supportsZWaveSoftwareGet.endpoint(this.endpoint.index));
        }
      }
      return super.supportsCommand(cmd);
    }
    // eslint-disable-next-line @typescript-eslint/explicit-module-boundary-types
    async get() {
      this.assertSupportsCommand(import_Types.VersionCommand, import_Types.VersionCommand.Get);
      const cc = new VersionCCGet({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index
      });
      const response = await this.host.sendCommand(cc, this.commandOptions);
      if (response) {
        return (0, import_shared.pick)(response, [
          "libraryType",
          "protocolVersion",
          "firmwareVersions",
          "hardwareVersion"
        ]);
      }
    }
    async sendReport(options) {
      this.assertSupportsCommand(import_Types.VersionCommand, import_Types.VersionCommand.Report);
      const cc = new VersionCCReport({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index,
        ...options
      });
      await this.host.sendCommand(cc, this.commandOptions);
    }
    async getCCVersion(requestedCC) {
      this.assertSupportsCommand(import_Types.VersionCommand, import_Types.VersionCommand.CommandClassGet);
      const cc = new VersionCCCommandClassGet({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index,
        requestedCC
      });
      const response = await this.host.sendCommand(cc, this.commandOptions);
      return response?.ccVersion;
    }
    async reportCCVersion(requestedCC, version) {
      this.assertSupportsCommand(import_Types.VersionCommand, import_Types.VersionCommand.CommandClassReport);
      let ccVersion;
      switch (requestedCC) {
        case import_core.CommandClasses["Z-Wave Protocol"]:
        case import_core.CommandClasses["Z-Wave Long Range"]:
          ccVersion = 0;
          break;
        case import_core.CommandClasses.Hail:
        case import_core.CommandClasses["Manufacturer Proprietary"]:
          ccVersion = 0;
          break;
        default:
          ccVersion = version ?? (0, import_CommandClassDecorators.getImplementedVersion)(requestedCC);
          break;
      }
      const cc = new VersionCCCommandClassReport({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index,
        requestedCC,
        ccVersion
      });
      await this.host.sendCommand(cc, this.commandOptions);
    }
    // eslint-disable-next-line @typescript-eslint/explicit-module-boundary-types
    async getCapabilities() {
      this.assertSupportsCommand(import_Types.VersionCommand, import_Types.VersionCommand.CapabilitiesGet);
      const cc = new VersionCCCapabilitiesGet({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index
      });
      const response = await this.host.sendCommand(cc, this.commandOptions);
      if (response) {
        return (0, import_shared.pick)(response, ["supportsZWaveSoftwareGet"]);
      }
    }
    async reportCapabilities() {
      this.assertSupportsCommand(import_Types.VersionCommand, import_Types.VersionCommand.CapabilitiesReport);
      const cc = new VersionCCCapabilitiesReport({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index,
        // At this time, we do not support responding to Z-Wave Software Get
        supportsZWaveSoftwareGet: false
      });
      await this.host.sendCommand(cc, this.commandOptions);
    }
    // eslint-disable-next-line @typescript-eslint/explicit-module-boundary-types
    async getZWaveSoftware() {
      this.assertSupportsCommand(import_Types.VersionCommand, import_Types.VersionCommand.ZWaveSoftwareGet);
      const cc = new VersionCCZWaveSoftwareGet({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index
      });
      const response = await this.host.sendCommand(cc, this.commandOptions);
      if (response) {
        return (0, import_shared.pick)(response, [
          "sdkVersion",
          "applicationFrameworkAPIVersion",
          "applicationFrameworkBuildNumber",
          "hostInterfaceVersion",
          "hostInterfaceBuildNumber",
          "zWaveProtocolVersion",
          "zWaveProtocolBuildNumber",
          "applicationVersion",
          "applicationBuildNumber"
        ]);
      }
    }
    constructor() {
      super(...arguments);
      __runInitializers(this, _instanceExtraInitializers);
    }
  };
  return VersionCCAPI2 = _classThis;
})();
let VersionCC = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.commandClass)(import_core.CommandClasses.Version), (0, import_CommandClassDecorators.implementedVersion)(3), (0, import_CommandClassDecorators.ccValues)(import_CCValues_generated.VersionCCValues)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = import_CommandClass.CommandClass;
  var VersionCC2 = class extends _classSuper {
    static {
      __name(this, "VersionCC");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      VersionCC2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    determineRequiredCCInterviews() {
      return [import_core.CommandClasses["Manufacturer Specific"]];
    }
    async interview(ctx) {
      const node = this.getNode(ctx);
      const endpoint = this.getEndpoint(ctx);
      const api = import_API.CCAPI.create(import_core.CommandClasses.Version, ctx, node).withOptions({
        priority: import_core.MessagePriority.NodeQuery
      });
      ctx.logNode(node.id, {
        endpoint: this.endpointIndex,
        message: `Interviewing ${this.ccName}...`,
        direction: "none"
      });
      const queryCCVersion = /* @__PURE__ */ __name(async (cc) => {
        const maxImplemented = (0, import_CommandClassDecorators.getImplementedVersion)(cc);
        if (maxImplemented === 0) {
          ctx.logNode(node.id, `  skipping query for ${import_core.CommandClasses[cc]} (${(0, import_shared.num2hex)(cc)}) because max implemented version is ${maxImplemented}`);
          return;
        }
        ctx.logNode(node.id, {
          endpoint: this.endpointIndex,
          message: `  querying the CC version for ${(0, import_core.getCCName)(cc)}...`,
          direction: "outbound"
        });
        const supportedVersion = await api.getCCVersion(cc);
        if (supportedVersion != void 0) {
          let logMessage;
          if (supportedVersion > 0) {
            if (cc === import_core.CommandClasses.Basic) {
              endpoint.addCC(cc, { version: supportedVersion });
            } else {
              endpoint.addCC(cc, {
                isSupported: true,
                version: supportedVersion
              });
            }
            logMessage = `  supports CC ${import_core.CommandClasses[cc]} (${(0, import_shared.num2hex)(cc)}) in version ${supportedVersion}`;
          } else {
            if (cc === import_core.CommandClasses.Version || cc === import_core.CommandClasses["Manufacturer Specific"]) {
              logMessage = `  claims NOT to support CC ${import_core.CommandClasses[cc]} (${(0, import_shared.num2hex)(cc)}), but it must. Assuming the ${this.endpointIndex === 0 ? "node" : "endpoint"} supports version 1...`;
              endpoint.addCC(cc, { version: 1 });
            } else if (cc === import_core.CommandClasses.Security && node.hasSecurityClass(import_core.SecurityClass.S0_Legacy) || cc === import_core.CommandClasses["Security 2"] && import_core.securityClassOrder.some((sc) => (0, import_core.securityClassIsS2)(sc) && node.hasSecurityClass(sc))) {
              logMessage = `  claims NOT to support CC ${import_core.CommandClasses[cc]} (${(0, import_shared.num2hex)(cc)}), but it is known to support it. Assuming the ${this.endpointIndex === 0 ? "node" : "endpoint"} supports version 1...`;
              endpoint.addCC(cc, { version: 1 });
            } else {
              logMessage = `  does NOT support CC ${import_core.CommandClasses[cc]} (${(0, import_shared.num2hex)(cc)})`;
              endpoint.removeCC(cc);
            }
          }
          ctx.logNode(node.id, {
            endpoint: this.endpointIndex,
            message: logMessage
          });
        } else {
          ctx.logNode(node.id, {
            endpoint: this.endpointIndex,
            message: `CC version query for ${(0, import_core.getCCName)(cc)} timed out - assuming the ${this.endpointIndex === 0 ? "node" : "endpoint"} supports version 1...`,
            level: "warn"
          });
          endpoint.addCC(cc, { version: 1 });
        }
      }, "queryCCVersion");
      if (this.endpointIndex === 0) {
        await queryCCVersion(import_core.CommandClasses.Version);
        ctx.logNode(node.id, {
          endpoint: this.endpointIndex,
          message: "querying node versions...",
          direction: "outbound"
        });
        const versionGetResponse = await api.get();
        if (versionGetResponse) {
          let logMessage = `received response for node versions:
  library type:      ${import_core.ZWaveLibraryTypes[versionGetResponse.libraryType]} (${(0, import_shared.num2hex)(versionGetResponse.libraryType)})
  protocol version:  ${versionGetResponse.protocolVersion}
  firmware versions: ${versionGetResponse.firmwareVersions.join(", ")}`;
          if (versionGetResponse.hardwareVersion != void 0) {
            logMessage += `
  hardware version:  ${versionGetResponse.hardwareVersion}`;
          }
          ctx.logNode(node.id, {
            endpoint: this.endpointIndex,
            message: logMessage,
            direction: "inbound"
          });
        }
      }
      ctx.logNode(node.id, {
        endpoint: this.endpointIndex,
        message: "querying CC versions...",
        direction: "outbound"
      });
      {
        const cc = import_core.CommandClasses.Basic;
        if (this.endpointIndex === 0 || node.getCCVersion(cc) === 0) {
          await queryCCVersion(cc);
        }
      }
      for (const [cc] of endpoint.getCCs()) {
        if (cc === import_core.CommandClasses.Version)
          continue;
        if (cc === import_core.CommandClasses.Basic)
          continue;
        if (this.endpointIndex > 0 && node.getCCVersion(cc) > 0)
          continue;
        await queryCCVersion(cc);
      }
      if (this.endpointIndex === 0 && api.version >= 3) {
        ctx.logNode(node.id, {
          endpoint: this.endpointIndex,
          message: "querying if Z-Wave Software Get is supported...",
          direction: "outbound"
        });
        const capsResponse = await api.getCapabilities();
        if (capsResponse) {
          const { supportsZWaveSoftwareGet } = capsResponse;
          ctx.logNode(node.id, {
            endpoint: this.endpointIndex,
            message: `Z-Wave Software Get is${supportsZWaveSoftwareGet ? "" : " not"} supported`,
            direction: "inbound"
          });
          if (supportsZWaveSoftwareGet) {
            ctx.logNode(node.id, {
              endpoint: this.endpointIndex,
              message: "querying Z-Wave software versions...",
              direction: "outbound"
            });
            await api.getZWaveSoftware();
            ctx.logNode(node.id, {
              endpoint: this.endpointIndex,
              message: "received Z-Wave software versions",
              direction: "inbound"
            });
          }
        }
      }
      this.setInterviewComplete(ctx, true);
    }
  };
  return VersionCC2 = _classThis;
})();
let VersionCCReport = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.VersionCommand.Report), (0, import_CommandClassDecorators.ccValueProperty)("libraryType", import_CCValues_generated.VersionCCValues.libraryType), (0, import_CommandClassDecorators.ccValueProperty)("protocolVersion", import_CCValues_generated.VersionCCValues.protocolVersion), (0, import_CommandClassDecorators.ccValueProperty)("firmwareVersions", import_CCValues_generated.VersionCCValues.firmwareVersions), (0, import_CommandClassDecorators.ccValueProperty)("hardwareVersion", import_CCValues_generated.VersionCCValues.hardwareVersion)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = VersionCC;
  var VersionCCReport2 = class extends _classSuper {
    static {
      __name(this, "VersionCCReport");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      VersionCCReport2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      if (!/^\d+\.\d+(\.\d+)?$/.test(options.protocolVersion)) {
        throw new import_core.ZWaveError(`protocolVersion must be a string in the format "major.minor" or "major.minor.patch", received "${options.protocolVersion}"`, import_core.ZWaveErrorCodes.Argument_Invalid);
      } else if (!options.firmwareVersions.every((fw) => /^\d+\.\d+(\.\d+)?$/.test(fw))) {
        throw new import_core.ZWaveError(`firmwareVersions must be an array of strings in the format "major.minor" or "major.minor.patch", received "${JSON.stringify(options.firmwareVersions)}"`, import_core.ZWaveErrorCodes.Argument_Invalid);
      }
      this.libraryType = options.libraryType;
      this.protocolVersion = options.protocolVersion;
      this.firmwareVersions = options.firmwareVersions;
      this.hardwareVersion = options.hardwareVersion;
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 5);
      const libraryType = raw.payload[0];
      const protocolVersion = `${raw.payload[1]}.${raw.payload[2]}`;
      const firmwareVersions = [`${raw.payload[3]}.${raw.payload[4]}`];
      let hardwareVersion;
      if (raw.payload.length >= 7) {
        hardwareVersion = raw.payload[5];
        const additionalFirmwares = raw.payload[6];
        (0, import_core.validatePayload)(raw.payload.length >= 7 + 2 * additionalFirmwares);
        for (let i = 0; i < additionalFirmwares; i++) {
          firmwareVersions.push(`${raw.payload[7 + 2 * i]}.${raw.payload[7 + 2 * i + 1]}`);
        }
      }
      return new this({
        nodeId: ctx.sourceNodeId,
        libraryType,
        protocolVersion,
        firmwareVersions,
        hardwareVersion
      });
    }
    libraryType;
    protocolVersion;
    firmwareVersions;
    hardwareVersion;
    serialize(ctx) {
      this.payload = import_shared.Bytes.from([
        this.libraryType,
        ...this.protocolVersion.split(".").map((n) => parseInt(n)).slice(0, 2),
        ...this.firmwareVersions[0].split(".").map((n) => parseInt(n)).slice(0, 2),
        this.hardwareVersion ?? 0,
        this.firmwareVersions.length - 1
      ]);
      if (this.firmwareVersions.length > 1) {
        const firmwaresBuffer = new import_shared.Bytes((this.firmwareVersions.length - 1) * 2);
        for (let i = 1; i < this.firmwareVersions.length; i++) {
          const [major, minor] = this.firmwareVersions[i].split(".").map((n) => parseInt(n));
          firmwaresBuffer[2 * (i - 1)] = major;
          firmwaresBuffer[2 * (i - 1) + 1] = minor;
        }
        this.payload = import_shared.Bytes.concat([this.payload, firmwaresBuffer]);
      }
      return super.serialize(ctx);
    }
    toLogEntry(ctx) {
      const message = {
        "library type": (0, import_shared.getEnumMemberName)(import_core.ZWaveLibraryTypes, this.libraryType),
        "protocol version": this.protocolVersion,
        "firmware versions": this.firmwareVersions.join(", ")
      };
      if (this.hardwareVersion != void 0) {
        message["hardware version"] = this.hardwareVersion;
      }
      return {
        ...super.toLogEntry(ctx),
        message
      };
    }
  };
  return VersionCCReport2 = _classThis;
})();
let VersionCCGet = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.VersionCommand.Get), (0, import_CommandClassDecorators.expectedCCResponse)(VersionCCReport)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = VersionCC;
  var VersionCCGet2 = class extends _classSuper {
    static {
      __name(this, "VersionCCGet");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      VersionCCGet2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
  };
  return VersionCCGet2 = _classThis;
})();
let VersionCCCommandClassReport = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.VersionCommand.CommandClassReport)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = VersionCC;
  var VersionCCCommandClassReport2 = class extends _classSuper {
    static {
      __name(this, "VersionCCCommandClassReport");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      VersionCCCommandClassReport2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.requestedCC = options.requestedCC;
      this.ccVersion = options.ccVersion;
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 2);
      const requestedCC = raw.payload[0];
      const ccVersion = raw.payload[1];
      return new this({
        nodeId: ctx.sourceNodeId,
        requestedCC,
        ccVersion
      });
    }
    ccVersion;
    requestedCC;
    serialize(ctx) {
      this.payload = import_shared.Bytes.from([this.requestedCC, this.ccVersion]);
      return super.serialize(ctx);
    }
    toLogEntry(ctx) {
      return {
        ...super.toLogEntry(ctx),
        message: {
          CC: (0, import_core.getCCName)(this.requestedCC),
          version: this.ccVersion
        }
      };
    }
  };
  return VersionCCCommandClassReport2 = _classThis;
})();
function testResponseForVersionCommandClassGet(sent, received) {
  return sent.requestedCC === received.requestedCC;
}
__name(testResponseForVersionCommandClassGet, "testResponseForVersionCommandClassGet");
let VersionCCCommandClassGet = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.VersionCommand.CommandClassGet), (0, import_CommandClassDecorators.expectedCCResponse)(VersionCCCommandClassReport, testResponseForVersionCommandClassGet)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = VersionCC;
  var VersionCCCommandClassGet2 = class extends _classSuper {
    static {
      __name(this, "VersionCCCommandClassGet");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      VersionCCCommandClassGet2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.requestedCC = options.requestedCC;
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 1);
      const requestedCC = raw.payload[0];
      return new this({
        nodeId: ctx.sourceNodeId,
        requestedCC
      });
    }
    requestedCC;
    serialize(ctx) {
      this.payload = import_shared.Bytes.from([this.requestedCC]);
      return super.serialize(ctx);
    }
    toLogEntry(ctx) {
      return {
        ...super.toLogEntry(ctx),
        message: { CC: (0, import_core.getCCName)(this.requestedCC) }
      };
    }
  };
  return VersionCCCommandClassGet2 = _classThis;
})();
let VersionCCCapabilitiesReport = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.VersionCommand.CapabilitiesReport), (0, import_CommandClassDecorators.ccValueProperty)("supportsZWaveSoftwareGet", import_CCValues_generated.VersionCCValues.supportsZWaveSoftwareGet)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = VersionCC;
  var VersionCCCapabilitiesReport2 = class extends _classSuper {
    static {
      __name(this, "VersionCCCapabilitiesReport");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      VersionCCCapabilitiesReport2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.supportsZWaveSoftwareGet = options.supportsZWaveSoftwareGet;
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 1);
      const capabilities = raw.payload[0];
      const supportsZWaveSoftwareGet = !!(capabilities & 4);
      return new this({
        nodeId: ctx.sourceNodeId,
        supportsZWaveSoftwareGet
      });
    }
    supportsZWaveSoftwareGet;
    serialize(ctx) {
      this.payload = import_shared.Bytes.from([
        (this.supportsZWaveSoftwareGet ? 4 : 0) | 3
      ]);
      return super.serialize(ctx);
    }
    toLogEntry(ctx) {
      return {
        ...super.toLogEntry(ctx),
        message: {
          "supports Z-Wave Software Get command": this.supportsZWaveSoftwareGet
        }
      };
    }
  };
  return VersionCCCapabilitiesReport2 = _classThis;
})();
let VersionCCCapabilitiesGet = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.VersionCommand.CapabilitiesGet), (0, import_CommandClassDecorators.expectedCCResponse)(VersionCCCapabilitiesReport)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = VersionCC;
  var VersionCCCapabilitiesGet2 = class extends _classSuper {
    static {
      __name(this, "VersionCCCapabilitiesGet");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      VersionCCCapabilitiesGet2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
  };
  return VersionCCCapabilitiesGet2 = _classThis;
})();
let VersionCCZWaveSoftwareReport = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.VersionCommand.ZWaveSoftwareReport), (0, import_CommandClassDecorators.ccValueProperty)("sdkVersion", import_CCValues_generated.VersionCCValues.sdkVersion), (0, import_CommandClassDecorators.ccValueProperty)("applicationFrameworkAPIVersion", import_CCValues_generated.VersionCCValues.applicationFrameworkAPIVersion), (0, import_CommandClassDecorators.ccValueProperty)("applicationFrameworkBuildNumber", import_CCValues_generated.VersionCCValues.applicationFrameworkBuildNumber), (0, import_CommandClassDecorators.ccValueProperty)("hostInterfaceVersion", import_CCValues_generated.VersionCCValues.serialAPIVersion), (0, import_CommandClassDecorators.ccValueProperty)("hostInterfaceBuildNumber", import_CCValues_generated.VersionCCValues.serialAPIBuildNumber), (0, import_CommandClassDecorators.ccValueProperty)("zWaveProtocolVersion", import_CCValues_generated.VersionCCValues.zWaveProtocolVersion), (0, import_CommandClassDecorators.ccValueProperty)("zWaveProtocolBuildNumber", import_CCValues_generated.VersionCCValues.zWaveProtocolBuildNumber), (0, import_CommandClassDecorators.ccValueProperty)("applicationVersion", import_CCValues_generated.VersionCCValues.applicationVersion), (0, import_CommandClassDecorators.ccValueProperty)("applicationBuildNumber", import_CCValues_generated.VersionCCValues.applicationBuildNumber)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = VersionCC;
  var VersionCCZWaveSoftwareReport2 = class extends _classSuper {
    static {
      __name(this, "VersionCCZWaveSoftwareReport");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      VersionCCZWaveSoftwareReport2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.sdkVersion = options.sdkVersion;
      this.applicationFrameworkAPIVersion = options.applicationFrameworkAPIVersion;
      this.applicationFrameworkBuildNumber = options.applicationFrameworkBuildNumber;
      this.hostInterfaceVersion = options.hostInterfaceVersion;
      this.hostInterfaceBuildNumber = options.hostInterfaceBuildNumber;
      this.zWaveProtocolVersion = options.zWaveProtocolVersion;
      this.zWaveProtocolBuildNumber = options.zWaveProtocolBuildNumber;
      this.applicationVersion = options.applicationVersion;
      this.applicationBuildNumber = options.applicationBuildNumber;
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 23);
      const sdkVersion = parseVersion(raw.payload);
      const applicationFrameworkAPIVersion = parseVersion(raw.payload.subarray(3));
      let applicationFrameworkBuildNumber;
      if (applicationFrameworkAPIVersion !== "unused") {
        applicationFrameworkBuildNumber = raw.payload.readUInt16BE(6);
      } else {
        applicationFrameworkBuildNumber = 0;
      }
      const hostInterfaceVersion = parseVersion(raw.payload.subarray(8));
      let hostInterfaceBuildNumber;
      if (hostInterfaceVersion !== "unused") {
        hostInterfaceBuildNumber = raw.payload.readUInt16BE(11);
      } else {
        hostInterfaceBuildNumber = 0;
      }
      const zWaveProtocolVersion = parseVersion(raw.payload.subarray(13));
      let zWaveProtocolBuildNumber;
      if (zWaveProtocolVersion !== "unused") {
        zWaveProtocolBuildNumber = raw.payload.readUInt16BE(16);
      } else {
        zWaveProtocolBuildNumber = 0;
      }
      const applicationVersion = parseVersion(raw.payload.subarray(18));
      let applicationBuildNumber;
      if (applicationVersion !== "unused") {
        applicationBuildNumber = raw.payload.readUInt16BE(21);
      } else {
        applicationBuildNumber = 0;
      }
      return new this({
        nodeId: ctx.sourceNodeId,
        sdkVersion,
        applicationFrameworkAPIVersion,
        applicationFrameworkBuildNumber,
        hostInterfaceVersion,
        hostInterfaceBuildNumber,
        zWaveProtocolVersion,
        zWaveProtocolBuildNumber,
        applicationVersion,
        applicationBuildNumber
      });
    }
    sdkVersion;
    applicationFrameworkAPIVersion;
    applicationFrameworkBuildNumber;
    hostInterfaceVersion;
    hostInterfaceBuildNumber;
    zWaveProtocolVersion;
    zWaveProtocolBuildNumber;
    applicationVersion;
    applicationBuildNumber;
    toLogEntry(ctx) {
      const message = {
        "SDK version": this.sdkVersion
      };
      message["appl. framework API version"] = this.applicationFrameworkAPIVersion;
      if (this.applicationFrameworkAPIVersion !== "unused") {
        message["appl. framework build number"] = this.applicationFrameworkBuildNumber;
      }
      message["host interface version"] = this.hostInterfaceVersion;
      if (this.hostInterfaceVersion !== "unused") {
        message["host interface  build number"] = this.hostInterfaceBuildNumber;
      }
      message["Z-Wave protocol version"] = this.zWaveProtocolVersion;
      if (this.zWaveProtocolVersion !== "unused") {
        message["Z-Wave protocol build number"] = this.zWaveProtocolBuildNumber;
      }
      message["application version"] = this.applicationVersion;
      if (this.applicationVersion !== "unused") {
        message["application build number"] = this.applicationBuildNumber;
      }
      return {
        ...super.toLogEntry(ctx),
        message
      };
    }
  };
  return VersionCCZWaveSoftwareReport2 = _classThis;
})();
let VersionCCZWaveSoftwareGet = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.VersionCommand.ZWaveSoftwareGet), (0, import_CommandClassDecorators.expectedCCResponse)(VersionCCZWaveSoftwareReport)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = VersionCC;
  var VersionCCZWaveSoftwareGet2 = class extends _classSuper {
    static {
      __name(this, "VersionCCZWaveSoftwareGet");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      VersionCCZWaveSoftwareGet2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
  };
  return VersionCCZWaveSoftwareGet2 = _classThis;
})();
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  VersionCC,
  VersionCCAPI,
  VersionCCCapabilitiesGet,
  VersionCCCapabilitiesReport,
  VersionCCCommandClassGet,
  VersionCCCommandClassReport,
  VersionCCGet,
  VersionCCReport,
  VersionCCValues,
  VersionCCZWaveSoftwareGet,
  VersionCCZWaveSoftwareReport
});
//# sourceMappingURL=VersionCC.js.map
