"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var API_exports = {};
__export(API_exports, {
  CCAPI: () => CCAPI,
  POLL_VALUE: () => POLL_VALUE,
  PhysicalCCAPI: () => PhysicalCCAPI,
  SET_VALUE: () => SET_VALUE,
  SET_VALUE_HOOKS: () => SET_VALUE_HOOKS,
  normalizeCCNameOrId: () => normalizeCCNameOrId,
  throwMissingPropertyKey: () => throwMissingPropertyKey,
  throwUnsupportedProperty: () => throwUnsupportedProperty,
  throwUnsupportedPropertyKey: () => throwUnsupportedPropertyKey,
  throwWrongValueType: () => throwWrongValueType
});
module.exports = __toCommonJS(API_exports);
var import_core = require("@zwave-js/core");
var import_shared = require("@zwave-js/shared");
var import_typeguards = require("alcalzone-shared/typeguards");
var import_CommandClassDecorators = require("./CommandClassDecorators.js");
const SET_VALUE = Symbol.for("CCAPI_SET_VALUE");
const SET_VALUE_HOOKS = Symbol.for("CCAPI_SET_VALUE_HOOKS");
const POLL_VALUE = Symbol.for("CCAPI_POLL_VALUE");
function throwUnsupportedProperty(cc, property) {
  throw new import_core.ZWaveError(`${import_core.CommandClasses[cc]}: "${property}" is not a supported property`, import_core.ZWaveErrorCodes.Argument_Invalid);
}
__name(throwUnsupportedProperty, "throwUnsupportedProperty");
function throwUnsupportedPropertyKey(cc, property, propertyKey) {
  throw new import_core.ZWaveError(`${import_core.CommandClasses[cc]}: "${propertyKey}" is not a supported property key for property "${property}"`, import_core.ZWaveErrorCodes.Argument_Invalid);
}
__name(throwUnsupportedPropertyKey, "throwUnsupportedPropertyKey");
function throwMissingPropertyKey(cc, property) {
  throw new import_core.ZWaveError(`${import_core.CommandClasses[cc]}: property "${property}" requires a property key, but none was given`, import_core.ZWaveErrorCodes.Argument_Invalid);
}
__name(throwMissingPropertyKey, "throwMissingPropertyKey");
function throwWrongValueType(cc, property, expectedType, receivedType) {
  throw new import_core.ZWaveError(`${import_core.CommandClasses[cc]}: "${property}" must be of type "${expectedType}", received "${receivedType}"`, import_core.ZWaveErrorCodes.Argument_Invalid);
}
__name(throwWrongValueType, "throwWrongValueType");
class CCAPI {
  static {
    __name(this, "CCAPI");
  }
  host;
  endpoint;
  constructor(host, endpoint) {
    this.host = host;
    this.endpoint = endpoint;
    this.ccId = (0, import_CommandClassDecorators.getCommandClass)(this);
  }
  static create(ccId, host, endpoint, requireSupport) {
    const APIConstructor = (0, import_CommandClassDecorators.getAPI)(ccId);
    const ccName = import_core.CommandClasses[ccId];
    if (APIConstructor == void 0) {
      throw new import_core.ZWaveError(`Command Class ${ccName} (${(0, import_shared.num2hex)(ccId)}) has no associated API!`, import_core.ZWaveErrorCodes.CC_NoAPI);
    }
    const apiInstance = new APIConstructor(host, endpoint);
    requireSupport ??= !endpoint.virtual;
    if (requireSupport) {
      return new Proxy(apiInstance, {
        get: /* @__PURE__ */ __name((target, property) => {
          if (property !== "ccId" && property !== "endpoint" && property !== "isSupported" && property !== "withOptions" && property !== "commandOptions" && !target.isSupported()) {
            let messageStart;
            if (endpoint.virtual) {
              const hasNodeId = typeof endpoint.nodeId === "number" && endpoint.nodeId !== import_core.NODE_ID_BROADCAST && endpoint.nodeId !== import_core.NODE_ID_BROADCAST_LR;
              messageStart = `${hasNodeId ? "The" : "This"} virtual node${hasNodeId ? ` ${endpoint.nodeId}` : ""}`;
            } else {
              messageStart = `Node ${endpoint.nodeId}`;
            }
            throw new import_core.ZWaveError(`${messageStart}${endpoint.index === 0 ? "" : ` (endpoint ${endpoint.index})`} does not support the Command Class ${ccName}!`, import_core.ZWaveErrorCodes.CC_NotSupported);
          }
          const fallback = target[property];
          if (typeof property === "string" && !endpoint.virtual && typeof fallback === "function") {
            const overrides = host.getDeviceConfig?.(endpoint.nodeId)?.compat?.overrideQueries;
            if (overrides?.hasOverride(ccId)) {
              return overrideQueriesWrapper(host, endpoint, ccId, property, overrides, fallback);
            }
          }
          return fallback;
        }, "get")
      });
    } else {
      return apiInstance;
    }
  }
  /**
   * The identifier of the Command Class this API is for
   */
  ccId;
  get [SET_VALUE]() {
    return void 0;
  }
  /**
   * Can be used on supported CC APIs to set a CC value by property name (and optionally the property key).
   * **WARNING:** This function is NOT bound to an API instance. It must be called with the correct `this` context!
   */
  get setValue() {
    return this[SET_VALUE];
  }
  [SET_VALUE_HOOKS];
  /**
   * Can be implemented by CC APIs to influence the behavior of the setValue API in regards to Supervision and verifying values.
   */
  get setValueHooks() {
    return this[SET_VALUE_HOOKS];
  }
  /** Whether a successful setValue call should imply that the value was successfully updated */
  // eslint-disable-next-line @typescript-eslint/no-unused-vars
  isSetValueOptimistic(valueId) {
    return true;
  }
  get [POLL_VALUE]() {
    return void 0;
  }
  /**
   * Can be used on supported CC APIs to poll a CC value by property name (and optionally the property key)
   * **WARNING:** This function is NOT bound to an API instance. It must be called with the correct `this` context!
   */
  get pollValue() {
    return this[POLL_VALUE];
  }
  /**
   * Schedules a value to be polled after a given time. Schedules are deduplicated on a per-property basis.
   * @returns `true` if the poll was scheduled, `false` otherwise
   */
  schedulePoll({ property, propertyKey }, expectedValue, { duration, transition = "slow" } = {}) {
    const durationMs = duration?.toMilliseconds() ?? 0;
    const timeouts = this.host.getRefreshValueTimeouts();
    const additionalDelay = !!durationMs || transition === "fast" ? timeouts.refreshValueAfterTransition : timeouts.refreshValue;
    const timeoutMs = durationMs + additionalDelay;
    if (this.isSinglecast()) {
      const node = this.host.getNode(this.endpoint.nodeId);
      if (!node)
        return false;
      return this.host.schedulePoll(node.id, {
        commandClass: this.ccId,
        endpoint: this.endpoint.index,
        property,
        propertyKey
      }, { timeoutMs, expectedValue });
    } else if (this.isMulticast()) {
      const supportingNodes = this.endpoint.node.physicalNodes.filter((node) => node.getEndpoint(this.endpoint.index)?.supportsCC(this.ccId));
      let ret = false;
      for (const node of supportingNodes) {
        ret ||= this.host.schedulePoll(node.id, {
          commandClass: this.ccId,
          endpoint: this.endpoint.index,
          property,
          propertyKey
        }, { timeoutMs, expectedValue });
      }
      return ret;
    } else {
      return false;
    }
  }
  /**
   * Retrieves the version of the given CommandClass this endpoint implements
   */
  get version() {
    if (this.isSinglecast()) {
      return this.host.getSafeCCVersion(this.ccId, this.endpoint.nodeId, this.endpoint.index) ?? 0;
    } else {
      return (0, import_CommandClassDecorators.getImplementedVersion)(this.ccId);
    }
  }
  /** Determines if this simplified API instance may be used. */
  isSupported() {
    return (
      // NoOperation is always supported
      this.ccId === import_core.CommandClasses["No Operation"] || this.ccId === import_core.CommandClasses.Basic || this.endpoint.supportsCC(this.ccId)
    );
  }
  /**
   * Determine whether the linked node supports a specific command of this command class.
   * {@link NOT_KNOWN} (`undefined`) means that the information has not been received yet
   */
  // eslint-disable-next-line @typescript-eslint/no-unused-vars
  supportsCommand(command) {
    return import_core.NOT_KNOWN;
  }
  assertSupportsCommand(commandEnum, command) {
    if (this.supportsCommand(command) !== true) {
      throw new import_core.ZWaveError(`${this.isSinglecast() ? `Node #${this.endpoint.nodeId}` : "This virtual node"}${this.endpoint.index > 0 ? ` (Endpoint ${this.endpoint.index})` : ""} does not support the command ${(0, import_shared.getEnumMemberName)(commandEnum, command)}!`, import_core.ZWaveErrorCodes.CC_NotSupported);
    }
  }
  assertPhysicalEndpoint(endpoint) {
    if (endpoint.virtual) {
      throw new import_core.ZWaveError(`This method is not supported for virtual nodes!`, import_core.ZWaveErrorCodes.CC_NotSupported);
    }
  }
  /** Returns the command options to use for sendCommand calls */
  get commandOptions() {
    return {};
  }
  /** Creates an instance of this API, scoped to use the given options */
  withOptions(options) {
    const mergedOptions = {
      ...this.commandOptions,
      ...options
    };
    return new Proxy(this, {
      get: /* @__PURE__ */ __name((target, property) => {
        if (property === "commandOptions") {
          return mergedOptions;
        } else {
          return target[property];
        }
      }, "get")
    });
  }
  /** Creates an instance of this API which (if supported) will return TX reports along with the result. */
  withTXReport() {
    if (this.constructor === CCAPI) {
      throw new import_core.ZWaveError("The withTXReport method may only be called on specific CC API implementations.", import_core.ZWaveErrorCodes.Driver_NotSupported);
    }
    const proxiedProps = /* @__PURE__ */ new Set([
      // These are the CC-specific methods
      ...Object.getOwnPropertyNames(this.constructor.prototype),
      // as well as setValue and pollValue
      "setValue",
      "pollValue"
    ]);
    proxiedProps.delete("constructor");
    function wrapResult(result, txReport) {
      return (0, import_core.stripUndefined)({
        result,
        txReport
      });
    }
    __name(wrapResult, "wrapResult");
    return new Proxy(this, {
      get: /* @__PURE__ */ __name((target, prop) => {
        if (prop === "withTXReport")
          return void 0;
        let original = target[prop];
        if (proxiedProps.has(prop) && typeof original === "function") {
          let txReport;
          const api = target.withOptions({
            onTXReport: /* @__PURE__ */ __name((report) => {
              txReport = report;
            }, "onTXReport")
          });
          original = api[prop].bind(api);
          return (...args) => {
            let result = original(...args);
            if (result instanceof Promise) {
              result = result.then((res) => wrapResult(res, txReport));
            } else {
              result = wrapResult(result, txReport);
            }
            return result;
          };
        } else {
          return original;
        }
      }, "get")
    });
  }
  isSinglecast() {
    return !this.endpoint.virtual && typeof this.endpoint.nodeId === "number" && this.endpoint.nodeId !== import_core.NODE_ID_BROADCAST && this.endpoint.nodeId !== import_core.NODE_ID_BROADCAST_LR;
  }
  isMulticast() {
    return this.endpoint.virtual && (0, import_typeguards.isArray)(this.endpoint.nodeId);
  }
  isBroadcast() {
    return this.endpoint.virtual && (this.endpoint.nodeId === import_core.NODE_ID_BROADCAST || this.endpoint.nodeId === import_core.NODE_ID_BROADCAST_LR);
  }
  /** Returns the value DB for this CC API's node (if it can be safely accessed) */
  tryGetValueDB() {
    if (!this.isSinglecast())
      return;
    try {
      return this.host.getValueDB(this.endpoint.nodeId);
    } catch {
      return;
    }
  }
  /** Returns the value DB for this CC's node (or throws if it cannot be accessed) */
  getValueDB() {
    if (this.isSinglecast()) {
      try {
        return this.host.getValueDB(this.endpoint.nodeId);
      } catch {
        throw new import_core.ZWaveError("The node for this CC does not exist or the driver is not ready yet", import_core.ZWaveErrorCodes.Driver_NotReady);
      }
    }
    throw new import_core.ZWaveError("Cannot retrieve the value DB for non-singlecast CCs", import_core.ZWaveErrorCodes.CC_NoNodeID);
  }
}
function overrideQueriesWrapper(ctx, endpoint, ccId, method, overrides, fallback) {
  return function(...args) {
    const match = overrides.matchOverride(ccId, endpoint.index, method, args);
    if (!match)
      return fallback.call(this, ...args);
    ctx.logNode(endpoint.nodeId, {
      message: `API call ${method} for ${(0, import_core.getCCName)(ccId)} CC overridden by a compat flag.`,
      level: "debug",
      direction: "none"
    });
    const ccValues = (0, import_CommandClassDecorators.getCCValues)(ccId);
    if (ccValues) {
      const valueDB = ctx.getValueDB(endpoint.nodeId);
      const prop2value = /* @__PURE__ */ __name((prop) => {
        const argsMatch = prop.match(/^(.*)\((.*)\)$/);
        if (argsMatch) {
          const methodName = argsMatch[1];
          const methodArgs = JSON.parse(`[${argsMatch[2]}]`);
          const dynValue = ccValues[methodName];
          if (typeof dynValue === "function") {
            return dynValue(...methodArgs);
          }
        } else {
          const staticValue = ccValues[prop];
          if (typeof staticValue?.endpoint === "function") {
            return staticValue;
          }
        }
      }, "prop2value");
      if (match.persistValues) {
        for (const [prop, value] of Object.entries(match.persistValues)) {
          try {
            const ccValue = prop2value(prop);
            if (ccValue) {
              valueDB.setValue(ccValue.endpoint(endpoint.index), value);
            } else {
              ctx.logNode(endpoint.nodeId, {
                message: `Failed to persist value ${prop} during overridden API call: value does not exist`,
                level: "error",
                direction: "none"
              });
            }
          } catch (e) {
            ctx.logNode(endpoint.nodeId, {
              message: `Failed to persist value ${prop} during overridden API call: ${(0, import_shared.getErrorMessage)(e)}`,
              level: "error",
              direction: "none"
            });
          }
        }
      }
      if (match.extendMetadata) {
        for (const [prop, meta] of Object.entries(match.extendMetadata)) {
          try {
            const ccValue = prop2value(prop);
            if (ccValue) {
              valueDB.setMetadata(ccValue.endpoint(endpoint.index), {
                ...ccValue.meta,
                ...meta
              });
            } else {
              ctx.logNode(endpoint.nodeId, {
                message: `Failed to extend value metadata ${prop} during overridden API call: value does not exist`,
                level: "error",
                direction: "none"
              });
            }
          } catch (e) {
            ctx.logNode(endpoint.nodeId, {
              message: `Failed to extend value metadata ${prop} during overridden API call: ${(0, import_shared.getErrorMessage)(e)}`,
              level: "error",
              direction: "none"
            });
          }
        }
      }
    }
    return Promise.resolve(match.result);
  };
}
__name(overrideQueriesWrapper, "overrideQueriesWrapper");
class PhysicalCCAPI extends CCAPI {
  static {
    __name(this, "PhysicalCCAPI");
  }
  constructor(host, endpoint) {
    super(host, endpoint);
    this.assertPhysicalEndpoint(endpoint);
  }
}
function normalizeCCNameOrId(ccNameOrId) {
  if (!(ccNameOrId in import_core.CommandClasses))
    return void 0;
  let ret;
  if (typeof ccNameOrId === "string") {
    if (/^\d+$/.test(ccNameOrId)) {
      ret = +ccNameOrId;
    } else if (typeof import_core.CommandClasses[ccNameOrId] === "number") {
      ret = import_core.CommandClasses[ccNameOrId];
    }
  } else {
    ret = ccNameOrId;
  }
  return ret;
}
__name(normalizeCCNameOrId, "normalizeCCNameOrId");
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  CCAPI,
  POLL_VALUE,
  PhysicalCCAPI,
  SET_VALUE,
  SET_VALUE_HOOKS,
  normalizeCCNameOrId,
  throwMissingPropertyKey,
  throwUnsupportedProperty,
  throwUnsupportedPropertyKey,
  throwWrongValueType
});
//# sourceMappingURL=API.js.map
