import * as v from "@zwave-js/core/validation";
export function validateArgs_AssociationGroupInfoCCAPI_getGroupName() {
    return (__decoratedMethod, { kind }) => {
        if (kind === "method") {
            return function getGroupName(groupId) {
                v.assert(v.primitive({ kind: "parameter", name: "groupId" }, "number")(groupId));
                return __decoratedMethod.call(this, groupId);
            };
        }
    };
}
export function validateArgs_AssociationGroupInfoCCAPI_reportGroupName() {
    return (__decoratedMethod, { kind }) => {
        if (kind === "method") {
            return function reportGroupName(groupId, name) {
                v.assert(v.primitive({ kind: "parameter", name: "groupId" }, "number")(groupId), v.primitive({ kind: "parameter", name: "name" }, "string")(name));
                return __decoratedMethod.call(this, groupId, name);
            };
        }
    };
}
export function validateArgs_AssociationGroupInfoCCAPI_getGroupInfo() {
    return (__decoratedMethod, { kind }) => {
        if (kind === "method") {
            return function getGroupInfo(groupId, refreshCache) {
                v.assert(v.primitive({ kind: "parameter", name: "groupId" }, "number")(groupId), v.optional({ kind: "parameter", name: "refreshCache" }, v.primitive({ kind: "parameter", name: "refreshCache" }, "boolean"))(refreshCache));
                return __decoratedMethod.call(this, groupId, refreshCache);
            };
        }
    };
}
export function validateArgs_AssociationGroupInfoCCAPI_reportGroupInfo() {
    return (__decoratedMethod, { kind }) => {
        if (kind === "method") {
            return function reportGroupInfo(options) {
                v.assert(v.object({ kind: "parameter", name: "options" }, 'AssociationGroupInfoCCInfoReportOptions', { "isListMode": v.primitive({ kind: "property", name: "isListMode" }, "boolean"), "hasDynamicInfo": v.primitive({ kind: "property", name: "hasDynamicInfo" }, "boolean"), "groups": v.array({ kind: "property", name: "groups" }, 'AssociationGroupInfo', v.object({ kind: "item", name: "groups" }, 'AssociationGroupInfo', { "groupId": v.primitive({ kind: "property", name: "groupId" }, "number"), "mode": v.primitive({ kind: "property", name: "mode" }, "number"), "profile": v.primitive({ kind: "property", name: "profile" }, "number"), "eventCode": v.primitive({ kind: "property", name: "eventCode" }, "number") })) })(options));
                return __decoratedMethod.call(this, options);
            };
        }
    };
}
export function validateArgs_AssociationGroupInfoCCAPI_getCommands() {
    return (__decoratedMethod, { kind }) => {
        if (kind === "method") {
            return function getCommands(groupId, allowCache) {
                v.assert(v.primitive({ kind: "parameter", name: "groupId" }, "number")(groupId), v.optional({ kind: "parameter", name: "allowCache" }, v.primitive({ kind: "parameter", name: "allowCache" }, "boolean"))(allowCache));
                return __decoratedMethod.call(this, groupId, allowCache);
            };
        }
    };
}
export function validateArgs_AssociationGroupInfoCCAPI_reportCommands() {
    return (__decoratedMethod, { kind }) => {
        if (kind === "method") {
            return function reportCommands(groupId, commands) {
                v.assert(v.primitive({ kind: "parameter", name: "groupId" }, "number")(groupId), v.class({ kind: "parameter", name: "commands" }, "Map", Map)(commands));
                return __decoratedMethod.call(this, groupId, commands);
            };
        }
    };
}
//# sourceMappingURL=AssociationGroupInfoCC._validateArgs.js.map