import { Duration } from "@zwave-js/core";
import * as v from "@zwave-js/core/validation";
export function validateArgs_ColorSwitchCCAPI_get() {
    return (__decoratedMethod, { kind }) => {
        if (kind === "method") {
            return function get(component) {
                v.assert(v.enum({ kind: "parameter", name: "component" }, "ColorComponent", [0, 1, 2, 3, 4, 5, 6, 7, 8])(component));
                return __decoratedMethod.call(this, component);
            };
        }
    };
}
export function validateArgs_ColorSwitchCCAPI_set() {
    return (__decoratedMethod, { kind }) => {
        if (kind === "method") {
            return function set(options) {
                v.assert(v.oneOf({ kind: "parameter", name: "options" }, "ColorSwitchCCSetOptions", v.allOf({ kind: "parameter", name: "options" }, undefined, v.object({ kind: "parameter", name: "options" }, '<anonymous object>', {}), v.object({ kind: "parameter", name: "options" }, '<anonymous object>', { "duration": v.optional({ kind: "property", name: "duration" }, v.oneOf({ kind: "property", name: "duration" }, undefined, v.primitive({ kind: "property", name: "duration" }, "string"), v.class({ kind: "property", name: "duration" }, "Duration", Duration))) })), v.allOf({ kind: "parameter", name: "options" }, undefined, v.object({ kind: "parameter", name: "options" }, '<anonymous object>', {}), v.object({ kind: "parameter", name: "options" }, '<anonymous object>', { "duration": v.optional({ kind: "property", name: "duration" }, v.oneOf({ kind: "property", name: "duration" }, undefined, v.primitive({ kind: "property", name: "duration" }, "string"), v.class({ kind: "property", name: "duration" }, "Duration", Duration))) })), v.allOf({ kind: "parameter", name: "options" }, undefined, v.object({ kind: "parameter", name: "options" }, '<anonymous object>', { "hexColor": v.primitive({ kind: "property", name: "hexColor" }, "string") }), v.object({ kind: "parameter", name: "options" }, '<anonymous object>', { "duration": v.optional({ kind: "property", name: "duration" }, v.oneOf({ kind: "property", name: "duration" }, undefined, v.primitive({ kind: "property", name: "duration" }, "string"), v.class({ kind: "property", name: "duration" }, "Duration", Duration))) })))(options));
                return __decoratedMethod.call(this, options);
            };
        }
    };
}
export function validateArgs_ColorSwitchCCAPI_startLevelChange() {
    return (__decoratedMethod, { kind }) => {
        if (kind === "method") {
            return function startLevelChange(options) {
                v.assert(v.oneOf({ kind: "parameter", name: "options" }, "ColorSwitchCCStartLevelChangeOptions", v.allOf({ kind: "parameter", name: "options" }, undefined, v.object({ kind: "parameter", name: "options" }, '<anonymous object>', { "colorComponent": v.enum({ kind: "property", name: "colorComponent" }, "ColorComponent", [0, 1, 2, 3, 4, 5, 6, 7, 8]), "direction": v.oneOf({ kind: "property", name: "direction" }, undefined, v.literal({ kind: "property", name: "direction" }, "up"), v.literal({ kind: "property", name: "direction" }, "down")) }), v.object({ kind: "parameter", name: "options" }, '<anonymous object>', { "ignoreStartLevel": v.literal({ kind: "property", name: "ignoreStartLevel" }, true), "startLevel": v.optional({ kind: "property", name: "startLevel" }, v.primitive({ kind: "property", name: "startLevel" }, "number")) }), v.object({ kind: "parameter", name: "options" }, '<anonymous object>', { "duration": v.optional({ kind: "property", name: "duration" }, v.oneOf({ kind: "property", name: "duration" }, undefined, v.primitive({ kind: "property", name: "duration" }, "string"), v.class({ kind: "property", name: "duration" }, "Duration", Duration))) })), v.allOf({ kind: "parameter", name: "options" }, undefined, v.object({ kind: "parameter", name: "options" }, '<anonymous object>', { "colorComponent": v.enum({ kind: "property", name: "colorComponent" }, "ColorComponent", [0, 1, 2, 3, 4, 5, 6, 7, 8]), "direction": v.oneOf({ kind: "property", name: "direction" }, undefined, v.literal({ kind: "property", name: "direction" }, "up"), v.literal({ kind: "property", name: "direction" }, "down")) }), v.object({ kind: "parameter", name: "options" }, '<anonymous object>', { "ignoreStartLevel": v.literal({ kind: "property", name: "ignoreStartLevel" }, false), "startLevel": v.primitive({ kind: "property", name: "startLevel" }, "number") }), v.object({ kind: "parameter", name: "options" }, '<anonymous object>', { "duration": v.optional({ kind: "property", name: "duration" }, v.oneOf({ kind: "property", name: "duration" }, undefined, v.primitive({ kind: "property", name: "duration" }, "string"), v.class({ kind: "property", name: "duration" }, "Duration", Duration))) })))(options));
                return __decoratedMethod.call(this, options);
            };
        }
    };
}
export function validateArgs_ColorSwitchCCAPI_stopLevelChange() {
    return (__decoratedMethod, { kind }) => {
        if (kind === "method") {
            return function stopLevelChange(colorComponent) {
                v.assert(v.enum({ kind: "parameter", name: "colorComponent" }, "ColorComponent", [0, 1, 2, 3, 4, 5, 6, 7, 8])(colorComponent));
                return __decoratedMethod.call(this, colorComponent);
            };
        }
    };
}
//# sourceMappingURL=ColorSwitchCC._validateArgs.js.map