"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var Logger_exports = {};
__export(Logger_exports, {
  ConfigLogger: () => ConfigLogger
});
module.exports = __toCommonJS(Logger_exports);
var import_core = require("@zwave-js/core");
var import_Logger_safe = require("./Logger_safe.js");
class ConfigLogger extends import_core.ZWaveLoggerBase {
  static {
    __name(this, "ConfigLogger");
  }
  constructor(loggers) {
    super(loggers, import_Logger_safe.CONFIG_LABEL);
  }
  /**
   * Logs a message
   * @param msg The message to output
   */
  print(message, level) {
    const actualLevel = level || import_Logger_safe.CONFIG_LOGLEVEL;
    if (!this.container.isLoglevelVisible(actualLevel))
      return;
    this.logger.log({
      level: actualLevel,
      message,
      direction: (0, import_core.getDirectionPrefix)("none"),
      context: { source: "config" }
    });
  }
}
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  ConfigLogger
});
//# sourceMappingURL=Logger.js.map
