"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var SecurityClass_exports = {};
__export(SecurityClass_exports, {
  SecurityClass: () => SecurityClass,
  getHighestSecurityClass: () => getHighestSecurityClass,
  securityClassIsLongRange: () => securityClassIsLongRange,
  securityClassIsS2: () => securityClassIsS2,
  securityClassOrder: () => securityClassOrder
});
module.exports = __toCommonJS(SecurityClass_exports);
var SecurityClass;
(function(SecurityClass2) {
  SecurityClass2[SecurityClass2["Temporary"] = -2] = "Temporary";
  SecurityClass2[SecurityClass2["None"] = -1] = "None";
  SecurityClass2[SecurityClass2["S2_Unauthenticated"] = 0] = "S2_Unauthenticated";
  SecurityClass2[SecurityClass2["S2_Authenticated"] = 1] = "S2_Authenticated";
  SecurityClass2[SecurityClass2["S2_AccessControl"] = 2] = "S2_AccessControl";
  SecurityClass2[SecurityClass2["S0_Legacy"] = 7] = "S0_Legacy";
})(SecurityClass || (SecurityClass = {}));
function securityClassIsS2(secClass) {
  return secClass != void 0 && secClass >= SecurityClass.S2_Unauthenticated && secClass <= SecurityClass.S2_AccessControl;
}
__name(securityClassIsS2, "securityClassIsS2");
function securityClassIsLongRange(secClass) {
  return secClass === SecurityClass.S2_AccessControl || secClass === SecurityClass.S2_Authenticated;
}
__name(securityClassIsLongRange, "securityClassIsLongRange");
const securityClassOrder = [
  SecurityClass.S2_AccessControl,
  SecurityClass.S2_Authenticated,
  SecurityClass.S2_Unauthenticated,
  SecurityClass.S0_Legacy
];
function getHighestSecurityClass(securityClasses) {
  for (const cls of securityClassOrder) {
    if (securityClasses.includes(cls))
      return cls;
  }
  return SecurityClass.None;
}
__name(getHighestSecurityClass, "getHighestSecurityClass");
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  SecurityClass,
  getHighestSecurityClass,
  securityClassIsLongRange,
  securityClassIsS2,
  securityClassOrder
});
//# sourceMappingURL=SecurityClass.js.map
