"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var shared_exports = {};
__export(shared_exports, {
  CONTROL_CHAR_WIDTH: () => CONTROL_CHAR_WIDTH,
  LOG_PREFIX_WIDTH: () => LOG_PREFIX_WIDTH,
  LOG_WIDTH: () => LOG_WIDTH,
  calculateFirstLineLength: () => calculateFirstLineLength,
  channelPadding: () => channelPadding,
  directionPrefixPadding: () => directionPrefixPadding,
  getDirectionPrefix: () => getDirectionPrefix,
  getNodeTag: () => getNodeTag,
  messageFitsIntoOneLine: () => messageFitsIntoOneLine,
  messageRecordToLines: () => messageRecordToLines,
  messageToLines: () => messageToLines,
  nonUndefinedLogConfigKeys: () => nonUndefinedLogConfigKeys,
  stringToNodeList: () => stringToNodeList,
  tagify: () => tagify,
  timestampFormat: () => timestampFormat,
  timestampFormatShort: () => timestampFormatShort,
  timestampPadding: () => timestampPadding,
  timestampPaddingShort: () => timestampPaddingShort
});
module.exports = __toCommonJS(shared_exports);
const timestampFormatShort = "HH:mm:ss.SSS";
const timestampPaddingShort = " ".repeat(timestampFormatShort.length + 1);
const timestampFormat = "YYYY-MM-DD HH:mm:ss.SSS";
const timestampPadding = " ".repeat(timestampFormat.length + 1);
const channelPadding = " ".repeat(7);
function getDirectionPrefix(direction) {
  return direction === "inbound" ? "\xAB " : direction === "outbound" ? "\xBB " : "  ";
}
__name(getDirectionPrefix, "getDirectionPrefix");
const CONTROL_CHAR_WIDTH = 2;
const directionPrefixPadding = " ".repeat(CONTROL_CHAR_WIDTH);
const LOG_WIDTH = 80;
const LOG_PREFIX_WIDTH = 20;
function getNodeTag(nodeId) {
  return "Node " + nodeId.toString().padStart(3, "0");
}
__name(getNodeTag, "getNodeTag");
function stringToNodeList(nodes) {
  if (!nodes)
    return void 0;
  return nodes.split(",").map((n) => parseInt(n)).filter((n) => !Number.isNaN(n));
}
__name(stringToNodeList, "stringToNodeList");
function tagify(tags) {
  return tags.map((pfx) => `[${pfx}]`).join(" ");
}
__name(tagify, "tagify");
function calculateFirstLineLength(info, firstMessageLineLength) {
  return [
    CONTROL_CHAR_WIDTH - 1,
    firstMessageLineLength,
    (info.primaryTags || "").length,
    (info.secondaryTags || "").length
  ].filter((len) => len > 0).reduce((prev, val) => prev + (prev > 0 ? 1 : 0) + val);
}
__name(calculateFirstLineLength, "calculateFirstLineLength");
function messageFitsIntoOneLine(info, messageLength) {
  const totalLength = calculateFirstLineLength(info, messageLength);
  return totalLength <= LOG_WIDTH;
}
__name(messageFitsIntoOneLine, "messageFitsIntoOneLine");
function messageToLines(message) {
  if (typeof message === "string") {
    return message.split("\n");
  } else if (message.length > 0) {
    return message;
  } else {
    return [""];
  }
}
__name(messageToLines, "messageToLines");
function messageRecordToLines(message) {
  const entries = Object.entries(message);
  if (!entries.length)
    return [];
  const maxKeyLength = Math.max(...entries.map(([key]) => key.length));
  return entries.flatMap(([key, value]) => `${key}:${" ".repeat(Math.max(maxKeyLength - key.length + 1, 1))}${value}`.split("\n").map((line) => line.trimEnd()));
}
__name(messageRecordToLines, "messageRecordToLines");
const nonUndefinedLogConfigKeys = [
  "enabled",
  "level",
  "transports",
  "logToFile",
  "maxFiles",
  "filename",
  "forceConsole"
];
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  CONTROL_CHAR_WIDTH,
  LOG_PREFIX_WIDTH,
  LOG_WIDTH,
  calculateFirstLineLength,
  channelPadding,
  directionPrefixPadding,
  getDirectionPrefix,
  getNodeTag,
  messageFitsIntoOneLine,
  messageRecordToLines,
  messageToLines,
  nonUndefinedLogConfigKeys,
  stringToNodeList,
  tagify,
  timestampFormat,
  timestampFormatShort,
  timestampPadding,
  timestampPaddingShort
});
//# sourceMappingURL=shared.js.map
