"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var Notifications_exports = {};
__export(Notifications_exports, {
  getAllNotifications: () => getAllNotifications,
  getNotification: () => getNotification,
  getNotificationEventName: () => getNotificationEventName,
  getNotificationName: () => getNotificationName,
  getNotificationValue: () => getNotificationValue,
  getNotificationValueName: () => getNotificationValueName
});
module.exports = __toCommonJS(Notifications_exports);
var import_shared = require("@zwave-js/shared");
const notifications = Object.freeze({
  [1]: {
    name: "Smoke Alarm",
    variables: [
      {
        name: "Sensor status",
        states: {
          [1]: {
            label: "Smoke detected (location provided)",
            description: "The event parameters contain a location report"
          },
          [2]: {
            label: "Smoke detected"
          }
        }
      },
      {
        name: "Alarm status",
        states: {
          [3]: {
            label: "Smoke alarm test"
          },
          [6]: {
            label: "Alarm silenced",
            description: "This event may be issued by an alarm device to advertise that the alarm has been silenced by a local user event."
          }
        }
      },
      {
        name: "Maintenance status",
        states: {
          [4]: {
            label: "Replacement required",
            description: "This event may be issued by an alarm device to advertise that its physical components are no more reliable, e.g. because of clogged filters."
          },
          [5]: {
            label: "Replacement required, End-of-life",
            description: "This event may be issued by an alarm device to advertise that the device has reached the end of its designed lifetime. The device should no longer be used."
          }
        }
      },
      {
        name: "Periodic inspection status",
        states: {
          [7]: {
            label: "Maintenance required, planned periodic inspection",
            description: "This event may be issued by an alarm device to advertise that the device has reached the end of a designed maintenance interval. The device is should be serviced in order to stay reliable."
          }
        }
      },
      {
        name: "Dust in device status",
        states: {
          [8]: {
            label: "Maintenance required, dust in device",
            description: "This event may be issued by an alarm device to advertise that the device has detected dust in its sensor. The device is not reliable until it has been serviced."
          }
        }
      }
    ]
  },
  [2]: {
    name: "CO Alarm",
    variables: [
      {
        name: "Sensor status",
        states: {
          [1]: {
            label: "Carbon monoxide detected (location provided)",
            description: "The event parameters contain a location report"
          },
          [2]: {
            label: "Carbon monoxide detected"
          }
        }
      },
      {
        name: "Test status",
        idle: false,
        states: {
          [3]: {
            label: "Carbon monoxide test",
            parameter: {
              type: "enum",
              values: {
                [1]: "Test OK",
                [2]: "Test failed"
              }
            },
            description: "The Carbon monoxide Test event may be issued by an alarm device to advertise that the test mode of the device has been activated. The activation may be manual or via signaling.\nA receiving application SHOULD NOT activate any alarms in response to this event."
          }
        }
      },
      {
        name: "Maintenance status",
        states: {
          [4]: {
            label: "Replacement required",
            description: "This event may be issued by an alarm device to advertise that its physical components are no more reliable, e.g. because of clogged filters."
          },
          [5]: {
            label: "Replacement required, End-of-life",
            description: "This event may be issued by an alarm device to advertise that the device has reached the end of its designed lifetime. The device should no longer be used."
          }
        }
      },
      {
        name: "Alarm status",
        states: {
          [6]: {
            label: "Alarm silenced"
          }
        }
      },
      {
        name: "Periodic inspection status",
        states: {
          [7]: {
            label: "Maintenance required, planned periodic inspection"
          }
        }
      }
    ]
  },
  [3]: {
    name: "CO2 Alarm",
    variables: [
      {
        name: "Sensor status",
        states: {
          [1]: {
            label: "Carbon dioxide detected (location provided)",
            description: "The event parameters contain a location report"
          },
          [2]: {
            label: "Carbon dioxide detected"
          }
        }
      },
      {
        name: "Test status",
        idle: false,
        states: {
          [3]: {
            label: "Carbon dioxide test",
            parameter: {
              type: "enum",
              values: {
                [1]: "Test OK",
                [2]: "Test failed"
              }
            }
          }
        }
      },
      {
        name: "Maintenance status",
        states: {
          [4]: {
            label: "Replacement required",
            description: "This event may be issued by an alarm device to advertise that its physical components are no more reliable, e.g. because of clogged filters."
          },
          [5]: {
            label: "Replacement required, End-of-life",
            description: "This event may be issued by an alarm device to advertise that the device has reached the end of its designed lifetime. The device should no longer be used."
          }
        }
      },
      {
        name: "Alarm status",
        states: {
          [6]: {
            label: "Alarm silenced"
          }
        }
      },
      {
        name: "Periodic inspection status",
        states: {
          [7]: {
            label: "Maintenance required, planned periodic inspection"
          }
        }
      }
    ]
  },
  [4]: {
    name: "Heat Alarm",
    variables: [
      {
        name: "Heat sensor status",
        states: {
          [1]: {
            label: "Overheat detected (location provided)",
            description: "The event parameters contain a location report"
          },
          [2]: {
            label: "Overheat detected"
          },
          [5]: {
            label: "Underheat detected (location provided)",
            description: "The event parameters contain a location report"
          },
          [6]: {
            label: "Underheat detected"
          }
        }
      },
      {
        name: "Alarm status",
        states: {
          [7]: {
            label: "Heat alarm test",
            description: "This event may be issued by an alarm device to advertise that the local test function has been activated."
          },
          [9]: {
            label: "Alarm silenced",
            description: "This event may be issued by an alarm device to advertise that the alarm has been silenced by a local user event."
          }
        }
      },
      {
        name: "Maintenance status",
        states: {
          [8]: {
            label: "Replacement required, End-of-life",
            description: "This event may be issued by an alarm device to advertise that the device has reached the end of its designed lifetime. The device should no longer be used."
          }
        }
      },
      {
        name: "Periodic inspection status",
        states: {
          [11]: {
            label: "Maintenance required, planned periodic inspection",
            description: "This event may be issued by an alarm device to advertise that the device has reached the end of a designed maintenance interval. The device is should be serviced in order to stay reliable."
          }
        }
      },
      {
        name: "Dust in device status",
        states: {
          [10]: {
            label: "Maintenance required, dust in device",
            description: "This event may be issued by an alarm device to advertise that the device has detected dust in its sensor. The device is not reliable until it has been serviced."
          }
        }
      }
    ],
    events: {
      [3]: {
        label: "Rapid temperature rise (location provided)",
        description: "The event parameters contain a location report"
      },
      [4]: {
        label: "Rapid temperature rise"
      },
      [12]: {
        label: "Rapid temperature fall (location provided)",
        description: "The event parameters contain a location report"
      },
      [13]: {
        label: "Rapid temperature fall"
      }
    }
  },
  [5]: {
    name: "Water Alarm",
    variables: [
      {
        name: "Sensor status",
        states: {
          [1]: {
            label: "Water leak detected (location provided)",
            description: "The event parameters contain a location report"
          },
          [2]: {
            label: "Water leak detected"
          }
        }
      },
      {
        name: "Maintenance status",
        states: {
          [5]: {
            label: "Replace water filter"
          }
        }
      },
      {
        name: "Water flow alarm status",
        states: {
          [6]: {
            label: "Water flow alarm",
            parameter: {
              type: "enum",
              values: {
                [1]: "No data",
                [2]: "Below low threshold",
                [3]: "Above high threshold",
                [4]: "Max"
              },
              // Translate missing event parameter to "no data"
              default: 1
            }
          }
        }
      },
      {
        name: "Water pressure alarm status",
        states: {
          [7]: {
            label: "Water pressure alarm",
            parameter: {
              type: "enum",
              values: {
                [1]: "No data",
                [2]: "Below low threshold",
                [3]: "Above high threshold",
                [4]: "Max"
              },
              // Translate missing event parameter to "no data"
              default: 1
            }
          }
        }
      },
      {
        name: "Water temperature alarm status",
        states: {
          [8]: {
            label: "Water temperature alarm",
            parameter: {
              type: "enum",
              values: {
                [1]: "No data",
                [2]: "Below low threshold",
                [3]: "Above high threshold"
              },
              // Translate missing event parameter to "no data"
              default: 1
            }
          }
        }
      },
      {
        name: "Water level alarm status",
        states: {
          [9]: {
            label: "Water level alarm",
            parameter: {
              type: "enum",
              values: {
                [1]: "No data",
                [2]: "Below low threshold",
                [3]: "Above high threshold"
              },
              // Translate missing event parameter to "no data"
              default: 1
            }
          }
        }
      },
      {
        name: "Pump status",
        states: {
          [10]: {
            label: "Sump pump active"
          },
          [11]: {
            label: "Sump pump failure",
            description: "This state may be used to indicate that the pump does not function as expected or is disconnected"
          }
        }
      }
    ],
    events: {
      [3]: {
        label: "Water level dropped (location provided)",
        description: "The event parameters contain a location report"
      },
      [4]: {
        label: "Water level dropped"
      }
    }
  },
  [6]: {
    name: "Access Control",
    variables: [
      {
        name: "Lock state",
        states: {
          [11]: {
            label: "Lock jammed"
          }
        }
      },
      {
        name: "Keypad state",
        states: {
          [16]: {
            label: "Keypad temporary disabled"
          },
          [17]: {
            label: "Keypad busy"
          }
        }
      },
      {
        name: "Door state",
        idle: false,
        states: {
          [22]: {
            label: "Window/door is open",
            parameter: {
              type: "enum",
              values: {
                // These values extend the existing states, so they need to be named in a similar fashion
                [0]: "Window/door is open in regular position",
                [1]: "Window/door is open in tilt position"
              }
            }
          },
          [23]: {
            label: "Window/door is closed"
          }
        }
      },
      {
        name: "Door handle state",
        idle: false,
        states: {
          [24]: {
            label: "Window/door handle is open"
          },
          [25]: {
            label: "Window/door handle is closed"
          }
        }
      },
      {
        name: "Barrier performing initialization process status",
        idle: false,
        states: {
          [64]: {
            label: "Barrier performing initialization process",
            parameter: {
              type: "enum",
              values: {
                [0]: "Process completed",
                [255]: "Performing process"
              }
            }
          }
        }
      },
      {
        name: "Barrier UL disabling status",
        states: {
          [69]: {
            label: "Barrier unattended operation has been disabled per UL requirements"
          }
        }
      },
      {
        name: "Barrier vacation mode status",
        idle: false,
        states: {
          [71]: {
            label: "Barrier vacation mode",
            parameter: {
              type: "enum",
              values: {
                [0]: "Mode disabled",
                [255]: "Mode enabled"
              }
            }
          }
        }
      },
      {
        name: "Barrier safety beam obstacle status",
        idle: false,
        states: {
          [72]: {
            label: "Barrier safety beam obstacle",
            parameter: {
              type: "enum",
              values: {
                [0]: "No obstruction",
                [255]: "Obstruction"
              }
            }
          }
        }
      },
      {
        name: "Barrier sensor status",
        states: {
          [73]: {
            label: "Barrier sensor not detected / supervisory error",
            // Param contains sensor ID
            parameter: {
              type: "value",
              propertyName: "sensor ID"
            }
          }
        }
      },
      {
        name: "Barrier battery status",
        states: {
          [74]: {
            label: "Barrier sensor low battery warning",
            // Param contains sensor ID
            parameter: {
              type: "value",
              propertyName: "sensor ID"
            }
          }
        }
      },
      {
        name: "Barrier short-circuit status",
        states: {
          [75]: {
            label: "Barrier detected short in wall station wires"
          }
        }
      },
      {
        name: "Barrier control status",
        states: {
          [76]: {
            label: "Barrier associated with non Z-Wave remote control"
          }
        }
      }
    ],
    events: {
      [1]: {
        label: "Manual lock operation",
        idleVariables: [
          // Lock state - Lock jammed
          11
        ]
      },
      [2]: {
        label: "Manual unlock operation",
        idleVariables: [
          // Lock state - Lock jammed
          11
        ]
      },
      [3]: {
        label: "RF lock operation",
        idleVariables: [
          // Lock state - Lock jammed
          11
        ]
      },
      [4]: {
        label: "RF unlock operation",
        idleVariables: [
          // Lock state - Lock jammed
          11
        ]
      },
      [5]: {
        label: "Keypad lock operation",
        // parameters contain User Code Report
        parameter: {
          type: "commandclass"
        },
        idleVariables: [
          // Lock state - Lock jammed
          11,
          // Keypad state - Keypad temporary disabled
          16,
          // Keypad state - Keypad busy
          17
        ]
      },
      [6]: {
        label: "Keypad unlock operation",
        // parameters contain User Code Report
        parameter: {
          type: "commandclass"
        },
        idleVariables: [
          // Lock state - Lock jammed
          11,
          // Keypad state - Keypad temporary disabled
          16,
          // Keypad state - Keypad busy
          17
        ]
      },
      [35]: {
        label: "Credential lock/open operation",
        // parameters contain Credential Usage Data
        parameter: {
          type: "commandclass"
        },
        idleVariables: [
          // Lock state - Lock jammed
          11,
          // Keypad state - Keypad temporary disabled
          16,
          // Keypad state - Keypad busy
          17
        ]
      },
      [36]: {
        label: "Credential unlock/close operation",
        // parameters contain Credential Usage Data
        parameter: {
          type: "commandclass"
        },
        idleVariables: [
          // Lock state - Lock jammed
          11,
          // Keypad state - Keypad temporary disabled
          16,
          // Keypad state - Keypad busy
          17
        ]
      },
      [7]: {
        label: "Manual not fully locked operation"
      },
      [8]: {
        label: "RF not fully locked operation"
      },
      [9]: {
        label: "Auto lock locked operation",
        idleVariables: [
          // Lock state - Lock jammed
          11
        ]
      },
      [10]: {
        label: "Auto lock not fully locked operation"
      },
      [12]: {
        label: "All user codes deleted"
        // User Code CC
      },
      [13]: {
        label: "Single user code deleted",
        parameter: {
          // Credential Notification Report (V8)
          type: "commandclass"
        }
      },
      [14]: {
        label: "New user code added",
        parameter: {
          // Credential Notification Report (V8)
          type: "commandclass"
        }
      },
      [15]: {
        label: "New user code not added due to duplicate code",
        parameter: {
          // Credential Notification Report (V8)
          type: "commandclass"
        }
      },
      [47]: {
        label: "Valid credential access denied: User Active State set to Occupied Disabled",
        // parameters contain Credential Usage Data
        parameter: {
          type: "commandclass"
        }
      },
      [48]: {
        label: "Valid credential access denied: Schedule inactive",
        // parameters contain Credential Usage Data
        parameter: {
          type: "commandclass"
        }
      },
      [49]: {
        label: "Valid credential access denied: Not enough credentials entered"
        // parameters contain Credential Usage Data for the entered credentials
      },
      [50]: {
        label: "Invalid credential used"
      },
      [18]: {
        label: "New program code entered: unique code for lock configuration"
      },
      [19]: {
        label: "Manually enter user access code exceeds code limit"
      },
      [20]: {
        label: "Unlock by RF with invalid user code"
      },
      [21]: {
        label: "Locked by RF with invalid user code"
      },
      [32]: {
        label: "Messaging User Code entered via keypad",
        // Param contains UserCodeCC User Identifier (2 bytes)
        parameter: {
          type: "value",
          propertyName: "user ID"
        },
        idleVariables: [
          // Keypad state - Keypad temporary disabled
          16,
          // Keypad state - Keypad busy
          17
        ]
      },
      [51]: {
        label: "Non-Access credential entered via local interface",
        // parameters contain a partial User Credential Report:
        // User Unique Identifier, Credential Type, Credential Slot Number (V8)
        parameter: {
          type: "commandclass"
        }
      },
      [33]: {
        label: "Lock operation with User Code",
        // Param contains UserCodeCC User Identifier (2 bytes)
        parameter: {
          type: "value",
          propertyName: "user ID"
        },
        idleVariables: [
          // Lock state - Lock jammed
          11
        ]
      },
      [34]: {
        label: "Unlock operation with User Code",
        // Param contains UserCodeCC User Identifier (2 bytes)
        parameter: {
          type: "value",
          propertyName: "user ID"
        },
        idleVariables: [
          // Lock state - Lock jammed
          11
        ]
      },
      [65]: {
        label: "Barrier operation (open/close) force has been exceeded"
      },
      [66]: {
        label: "Barrier motor has exceeded manufacturer's operational time limit",
        parameter: {
          type: "duration"
        }
      },
      [67]: {
        label: "Barrier operation has exceeded physical mechanical limits"
      },
      [68]: {
        label: "Barrier unable to perform requested operation due to UL requirements"
      },
      [70]: {
        label: "Barrier failed to perform requested operation, device malfunction"
      }
    }
  },
  [7]: {
    name: "Home Security",
    variables: [
      {
        name: "Sensor status",
        states: {
          [1]: {
            label: "Intrusion (location provided)",
            description: "The event parameters contain a location report"
          },
          [2]: {
            label: "Intrusion"
          }
        }
      },
      {
        name: "Cover status",
        states: {
          [3]: {
            label: "Tampering, product cover removed",
            description: "This event may be issued by an alarm device to advertise that the device has detected dust in its sensor. The device is not reliable until it has been serviced."
          }
        }
      },
      {
        name: "Motion sensor status",
        states: {
          [7]: {
            label: "Motion detection (location provided)",
            description: "The event parameters contain a location report"
          },
          [8]: {
            label: "Motion detection"
          }
        }
      },
      {
        name: "Magnetic interference status",
        states: {
          [11]: {
            label: "Magnetic field interference detected",
            description: "This state is used to indicate that magnetic field disturbance have been detected and the product functionality may not work reliably."
          }
        }
      }
    ],
    events: {
      [4]: {
        label: "Tampering, invalid code"
      },
      [5]: {
        label: "Glass breakage (location provided)",
        description: "The event parameters contain a location report"
      },
      [6]: {
        label: "Glass breakage"
      },
      [9]: {
        label: "Tampering, product moved"
      },
      [10]: {
        label: "Impact detected",
        description: "This event indicates that the node has detected an excessive amount of pressure or that an impact has occurred on the product itself."
      },
      [12]: {
        label: "RF Jamming detected",
        description: "This event can be issued if the node has detected a raise in the background RSSI level.",
        // 1-byte value representing the measured RSSI over a period of time spanning between 10s and 60s.
        // TODO: The value MUST be encoded using signed representation
        parameter: {
          type: "value",
          propertyName: "RSSI"
        }
      }
    }
  },
  [8]: {
    name: "Power Management",
    variables: [
      {
        name: "Power status",
        states: {
          [1]: {
            label: "Power has been applied"
          }
        }
      },
      {
        name: "Mains status",
        idle: false,
        states: {
          [2]: {
            label: "AC mains disconnected"
          },
          [3]: {
            label: "AC mains re-connected"
          }
        }
      },
      {
        name: "Over-current status",
        states: {
          [6]: {
            label: "Over-current detected"
          }
        }
      },
      {
        name: "Over-voltage status",
        states: {
          [7]: {
            label: "Over-voltage detected"
          }
        }
      },
      {
        name: "Over-load status",
        states: {
          [8]: {
            label: "Over-load detected"
          }
        }
      },
      {
        name: "Load error status",
        states: {
          [9]: {
            label: "Load error"
          }
        }
      },
      {
        name: "Battery maintenance status",
        states: {
          [10]: {
            label: "Replace battery soon"
          },
          [11]: {
            label: "Replace battery now"
          },
          [17]: {
            label: "Battery fluid is low"
          }
        }
      },
      {
        name: "Battery load status",
        states: {
          [12]: {
            label: "Battery is charging"
          }
        }
      },
      {
        name: "Battery level status",
        states: {
          [13]: {
            label: "Battery is fully charged"
          },
          [14]: {
            label: "Charge battery soon"
          },
          [15]: {
            label: "Charge battery now"
          }
        }
      },
      {
        name: "Backup battery level status",
        states: {
          [16]: {
            label: "Back-up battery is low"
          },
          [18]: {
            label: "Back-up battery disconnected"
          }
        }
      }
    ],
    events: {
      [4]: {
        label: "Surge detected"
      },
      [5]: {
        label: "Voltage drop/drift"
      }
    }
  },
  [9]: {
    name: "System",
    variables: [
      {
        name: "Hardware status",
        states: {
          [1]: {
            label: "System hardware failure"
          },
          [3]: {
            label: "System hardware failure (with failure code)",
            description: "The event parameters contain a manufacturer proprietary failure code"
          }
        }
      },
      {
        name: "Software status",
        states: {
          [2]: {
            label: "System software failure"
          },
          [4]: {
            label: "System software failure (with failure code)",
            description: "The event parameters contain a manufacturer proprietary failure code"
          }
        }
      },
      {
        name: "Cover status",
        states: {
          [6]: {
            label: "Tampering, product cover removed"
          }
        }
      },
      {
        name: "Emergency shutoff status",
        states: {
          [7]: {
            label: "Emergency shutoff"
          }
        }
      }
    ],
    events: {
      [5]: {
        label: "Heartbeat",
        description: "The Heartbeat event may be issued by a device to advertise that the device is still alive or to notify its presence."
      }
    }
  },
  [10]: {
    name: "Emergency Alarm",
    events: {
      [1]: {
        label: "Contact police"
      },
      [2]: {
        label: "Contact fire service"
      },
      [3]: {
        label: "Contact medical service"
      }
    }
  },
  [11]: {
    name: "Clock",
    events: {
      [1]: {
        label: "Wake up alert"
      },
      [2]: {
        label: "Timer ended"
      },
      [3]: {
        label: "Time remaining"
        // TODO: The event parameter contains 3 bytes
        // Byte 1 - 0x00..0xFF: 0..255 hours
        // Byte 2 - 0x00..0xFF: 0..255 minutes
        // Byte 3 - 0x00..0xFF: 0..255 seconds
      }
    }
  },
  [12]: {
    name: "Appliance",
    variables: [
      {
        name: "Program status",
        states: {
          [1]: {
            label: "Program started"
          },
          [2]: {
            label: "Program in progress"
          },
          [3]: {
            label: "Program completed"
          }
        }
      },
      {
        name: "Maintenance status",
        states: {
          [4]: {
            label: "Replace main filter"
          }
        }
      },
      {
        name: "Appliance status",
        states: {
          [6]: {
            label: "Supplying water"
          },
          [8]: {
            label: "Boiling"
          },
          [10]: {
            label: "Washing"
          },
          [12]: {
            label: "Rinsing"
          },
          [14]: {
            label: "Draining"
          },
          [16]: {
            label: "Spinning"
          },
          [18]: {
            label: "Drying"
          }
        }
      },
      {
        name: "Target temperature failure status",
        states: {
          [5]: {
            label: "Failure to set target temperature"
          }
        }
      },
      {
        name: "Water supply failure status",
        states: {
          [7]: {
            label: "Water supply failure"
          }
        }
      },
      {
        name: "Boiling failure status",
        states: {
          [9]: {
            label: "Boiling failure"
          }
        }
      },
      {
        name: "Washing failure status",
        states: {
          [11]: {
            label: "Washing failure"
          }
        }
      },
      {
        name: "Rinsing failure status",
        states: {
          [13]: {
            label: "Rinsing failure"
          }
        }
      },
      {
        name: "Draining failure status",
        states: {
          [15]: {
            label: "Draining failure"
          }
        }
      },
      {
        name: "Spinning failure status",
        states: {
          [17]: {
            label: "Spinning failure"
          }
        }
      },
      {
        name: "Drying failure status",
        states: {
          [19]: {
            label: "Drying failure"
          }
        }
      },
      {
        name: "Fan failure status",
        states: {
          [20]: {
            label: "Fan failure"
          }
        }
      },
      {
        name: "Compressor failure status",
        states: {
          [21]: {
            label: "Compressor failure"
          }
        }
      }
    ]
  },
  [13]: {
    name: "Home Health",
    variables: [
      {
        name: "Position status",
        states: {
          [1]: {
            label: "Leaving bed"
          },
          [2]: {
            label: "Sitting on bed"
          },
          [3]: {
            label: "Lying on bed"
          },
          [5]: {
            label: "Sitting on bed edge"
          }
        }
      },
      {
        name: "VOC level status",
        idle: false,
        states: {
          [6]: {
            label: "Volatile Organic Compound level",
            parameter: {
              type: "enum",
              values: {
                [1]: "Clean",
                [2]: "Slightly polluted",
                [3]: "Moderately polluted",
                [4]: "Highly polluted"
              }
            }
          }
        }
      },
      {
        name: "Sleep apnea status",
        states: {
          [7]: {
            label: "Sleep apnea detected",
            parameter: {
              type: "enum",
              values: {
                [1]: "Low breath",
                [2]: "No breath at all"
              }
            }
          }
        }
      },
      {
        name: "Sleep stage status",
        states: {
          [8]: {
            label: "Sleep stage 0 detected (Dreaming/REM)"
          },
          [9]: {
            label: "Sleep stage 1 detected (Light sleep, non-REM 1)"
          },
          [10]: {
            label: "Sleep stage 2 detected (Medium sleep, non-REM 2)"
          },
          [11]: {
            label: "Sleep stage 3 detected (Deep sleep, non-REM 3)"
          }
        }
      }
    ],
    events: {
      [4]: {
        label: "Posture changed"
      },
      [12]: {
        label: "Fall detected",
        description: "This event is used to indicate that a person fall has been detected and medical help may be needed."
      }
    }
  },
  [14]: {
    name: "Siren",
    variables: [
      {
        name: "Siren status",
        states: {
          [1]: {
            label: "Siren active"
          }
        }
      }
    ]
  },
  [15]: {
    name: "Water Valve",
    variables: [
      {
        name: "Valve operation status",
        idle: false,
        states: {
          [1]: {
            label: "Valve operation",
            parameter: {
              type: "enum",
              values: {
                [0]: "Off / Closed",
                [1]: "On / Open"
              }
            }
          }
        }
      },
      {
        name: "Master valve operation status",
        idle: false,
        states: {
          [2]: {
            label: "Master valve operation",
            parameter: {
              type: "enum",
              values: {
                [0]: "Off / Closed",
                [1]: "On / Open"
              }
            }
          }
        }
      },
      {
        name: "Valve short circuit status",
        states: {
          [3]: {
            label: "Valve short circuit"
          }
        }
      },
      {
        name: "Master valve short circuit status",
        states: {
          [4]: {
            label: "Master valve short circuit"
          }
        }
      },
      {
        name: "Valve current alarm status",
        states: {
          [5]: {
            label: "Valve current alarm",
            parameter: {
              type: "enum",
              values: {
                [1]: "No data",
                [2]: "Below low threshold",
                [3]: "Above high threshold",
                [4]: "Max"
              },
              // Translate missing event parameter to "no data"
              default: 1
            }
          }
        }
      },
      {
        name: "Master valve current alarm status",
        states: {
          [6]: {
            label: "Master valve current alarm",
            parameter: {
              type: "enum",
              values: {
                [1]: "No data",
                [2]: "Below low threshold",
                [3]: "Above high threshold",
                [4]: "Max"
              },
              // Translate missing event parameter to "no data"
              default: 1
            }
          }
        }
      },
      {
        name: "Valve jammed status",
        states: {
          [7]: {
            label: "Valve jammed"
          }
        }
      }
    ]
  },
  [16]: {
    name: "Weather Alarm",
    variables: [
      {
        name: "Rain alarm status",
        states: {
          [1]: {
            label: "Rain alarm"
          }
        }
      },
      {
        name: "Moisture alarm status",
        states: {
          [2]: {
            label: "Moisture alarm"
          }
        }
      },
      {
        name: "Freeze alarm status",
        states: {
          [3]: {
            label: "Freeze alarm"
          }
        }
      }
    ]
  },
  [17]: {
    name: "Irrigation",
    variables: [
      {
        name: "Schedule (id) status",
        idle: false,
        states: {
          [1]: {
            label: "Schedule started",
            // Event parameter (1 byte) contains the schedule ID
            parameter: {
              type: "value",
              propertyName: "schedule ID"
            }
          },
          [2]: {
            label: "Schedule finished",
            // Event parameter (1 byte) contains the schedule ID
            parameter: {
              type: "value",
              propertyName: "schedule ID"
            }
          }
        }
      },
      {
        name: "Valve (id) run status",
        idle: false,
        states: {
          [3]: {
            label: "Valve table run started",
            // Event parameter (1 byte) contains the Valve table ID
            parameter: {
              type: "value",
              propertyName: "valve table ID"
            }
          },
          [4]: {
            label: "Valve table run finished",
            // Event parameter (1 byte) contains the Valve table ID
            parameter: {
              type: "value",
              propertyName: "valve table ID"
            }
          }
        }
      },
      {
        name: "Device configuration status",
        states: {
          [5]: {
            label: "Device is not configured"
          }
        }
      }
    ]
  },
  [18]: {
    name: "Gas alarm",
    variables: [
      {
        name: "Combustible gas status",
        states: {
          [1]: {
            label: "Combustible gas detected (location provided)",
            description: "The event parameters contain a location report"
          },
          [2]: {
            label: "Combustible gas detected"
          }
        }
      },
      {
        name: "Toxic gas status",
        states: {
          [3]: {
            label: "Toxic gas detected (location provided)",
            description: "The event parameters contain a location report"
          },
          [4]: {
            label: "Toxic gas detected"
          }
        }
      },
      {
        name: "Alarm status",
        states: {
          [5]: {
            label: "Gas alarm test"
          }
        }
      },
      {
        name: "Maintenance status",
        states: {
          [6]: {
            label: "Replacement required"
          }
        }
      }
    ]
  },
  [19]: {
    name: "Pest Control",
    variables: [
      {
        name: "Trap status",
        states: {
          [1]: {
            label: "Trap armed (location provided)",
            description: "The event parameters contain a location report"
          },
          [2]: {
            label: "Trap armed"
          },
          [3]: {
            label: "Trap re-arm required (location provided)",
            description: "The event parameters contain a location report"
          },
          [4]: {
            label: "Trap re-arm required"
          }
        }
      }
    ],
    events: {
      [5]: {
        label: "Pest detected (location provided)",
        description: "The event parameters contain a location report"
      },
      [6]: {
        label: "Pest detected"
      },
      [7]: {
        label: "Pest exterminated (location provided)",
        description: "The event parameters contain a location report"
      },
      [8]: {
        label: "Pest exterminated"
      }
    }
  },
  [20]: {
    name: "Light sensor",
    variables: [
      {
        name: "Light detection status",
        states: {
          [1]: {
            label: "Light detected"
          }
        }
      }
    ],
    events: {
      [2]: {
        label: "Light color transition detected"
      }
    }
  },
  [21]: {
    name: "Water Quality Monitoring",
    variables: [
      {
        name: "Chlorine alarm status",
        states: {
          [1]: {
            label: "Chlorine alarm",
            parameter: {
              type: "enum",
              values: {
                [1]: "Below low threshold",
                [2]: "Above high threshold"
              }
            }
          }
        }
      },
      {
        name: "Acidity (pH) status",
        states: {
          [2]: {
            label: "Acidity (pH) alarm",
            parameter: {
              type: "enum",
              values: {
                [1]: "Below low threshold",
                [2]: "Above high threshold",
                [3]: "Decreasing pH",
                [4]: "Increasing pH"
              }
            }
          }
        }
      },
      {
        name: "Water Oxidation alarm status",
        states: {
          [3]: {
            label: "Water Oxidation alarm",
            parameter: {
              type: "enum",
              values: {
                [1]: "Below low threshold",
                [2]: "Above high threshold"
              }
            }
          }
        }
      },
      {
        name: "Chlorine Sensor status",
        states: {
          [4]: {
            label: "Chlorine empty"
          }
        }
      },
      {
        name: "Acidity (pH) Sensor status",
        states: {
          [5]: {
            label: "Acidity (pH) empty"
          }
        }
      },
      {
        name: "Waterflow measuring station sensor",
        states: {
          [6]: {
            label: "Waterflow measuring station shortage detected"
          }
        }
      },
      {
        name: "Waterflow clear water sensor",
        states: {
          [7]: {
            label: "Waterflow clear water shortage detected"
          }
        }
      },
      {
        name: "Disinfection system status",
        states: {
          [8]: {
            label: "Disinfection system error detected"
            // TODO:
            // Event Parameter 1 byte bitmask=
            // - bits 0..3: represent System 1..4 disorder detected
            // - bits 4..7: represent System 1..4 salt shortage
          }
        }
      },
      {
        name: "Filter cleaning status",
        states: {
          [9]: {
            label: "Filter cleaning ongoing",
            // Event Parameter (1 byte) contains the # of the filter
            parameter: {
              type: "value",
              propertyName: "filter number"
            }
          }
        }
      },
      {
        name: "Heating status",
        states: {
          [10]: {
            label: "Heating operation ongoing"
          }
        }
      },
      {
        name: "Filter pump status",
        states: {
          [11]: {
            label: "Filter pump operation ongoing"
          }
        }
      },
      {
        name: "Freshwater flow status",
        states: {
          [12]: {
            label: "Freshwater operation ongoing"
          }
        }
      },
      {
        name: "Dry protection status",
        states: {
          [13]: {
            label: "Dry protection operation active"
          }
        }
      },
      {
        // This is defined as an event in the specs, but only makes sense as a status
        name: "Water tank status",
        idle: false,
        states: {
          [14]: {
            label: "Water tank is empty"
          },
          [15]: {
            label: "Water tank level is unknown"
          },
          [16]: {
            label: "Water tank is full"
          }
        }
      },
      {
        name: "Collective disorder status",
        states: {
          [17]: {
            label: "Collective disorder"
          }
        }
      }
    ]
  },
  [22]: {
    name: "Home monitoring",
    variables: [
      {
        name: "Home occupancy status",
        states: {
          [1]: {
            label: "Home occupied (location provided)",
            description: "The event parameters contain a location report"
          },
          [2]: {
            label: "Home occupied"
          }
        }
      }
    ]
  }
});
function getNotification(type) {
  const notification = notifications[type];
  if (!notification)
    return;
  const events = /* @__PURE__ */ new Map();
  if (notification.events) {
    for (const [key, eventDef] of Object.entries(notification.events)) {
      const value = parseInt(key);
      events.set(value, notificationEventFromDefinition(eventDef, value));
    }
  }
  return {
    type,
    name: notification.name,
    variables: notification.variables?.map(notificationVariableFromDefinition) ?? [],
    events
  };
}
__name(getNotification, "getNotification");
function getNotificationName(type) {
  const notification = getNotification(type);
  return notification?.name ?? `Unknown (${(0, import_shared.num2hex)(type)})`;
}
__name(getNotificationName, "getNotificationName");
function getAllNotifications() {
  return Object.keys(notifications).map((type) => getNotification(parseInt(type, 10)));
}
__name(getAllNotifications, "getAllNotifications");
function getNotificationValue(notification, value) {
  return notification.events.get(value) ?? notification.variables?.find((v) => v.states.has(value))?.states.get(value);
}
__name(getNotificationValue, "getNotificationValue");
function getNotificationEventName(type, event) {
  const notification = getNotification(type);
  return notification?.events.get(event)?.label ?? `Unknown (${(0, import_shared.num2hex)(event)})`;
}
__name(getNotificationEventName, "getNotificationEventName");
function getNotificationValueName(type, event) {
  const notification = getNotification(type);
  const value = notification && getNotificationValue(notification, event);
  return value?.label ?? `Unknown (${(0, import_shared.num2hex)(event)})`;
}
__name(getNotificationValueName, "getNotificationValueName");
function notificationVariableFromDefinition(def) {
  const states = /* @__PURE__ */ new Map();
  for (const [key, stateDef] of Object.entries(def.states)) {
    const value = parseInt(key);
    states.set(value, notificationStateFromDefinition(stateDef, def, value));
  }
  return {
    name: def.name,
    idle: def.idle ?? true,
    states
  };
}
__name(notificationVariableFromDefinition, "notificationVariableFromDefinition");
function notificationStateFromDefinition(def, variable, value) {
  return {
    type: "state",
    label: def.label,
    description: def.description,
    variableName: variable.name,
    idle: variable.idle ?? true,
    value,
    parameter: def.parameter ? { ...def.parameter } : void 0,
    idleVariables: def.idleVariables ? [...def.idleVariables] : []
  };
}
__name(notificationStateFromDefinition, "notificationStateFromDefinition");
function notificationEventFromDefinition(def, value) {
  return {
    type: "event",
    label: def.label,
    description: def.description,
    value,
    parameter: def.parameter ? { ...def.parameter } : void 0,
    idleVariables: def.idleVariables ? [...def.idleVariables] : []
  };
}
__name(notificationEventFromDefinition, "notificationEventFromDefinition");
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  getAllNotifications,
  getNotification,
  getNotificationEventName,
  getNotificationName,
  getNotificationValue,
  getNotificationValueName
});
//# sourceMappingURL=Notifications.js.map
