import type { JSONObject } from "@zwave-js/shared";
export type DurationUnit = "seconds" | "minutes" | "unknown" | "default";
/** An object that has the same shape as a Duration instance */
export interface DurationLike {
    value: number;
    unit: DurationUnit;
}
/** Represents a duration that is used by some command classes */
export declare class Duration {
    unit: DurationUnit;
    constructor(value: number, unit: DurationUnit);
    private _value;
    get value(): number;
    set value(v: number);
    static unknown(): Duration;
    static default(): Duration;
    static isDuration(value: any): value is DurationLike;
    /** Parses a duration as represented in Report commands */
    static parseReport(payload?: number): Duration | undefined;
    /** Parses a duration as represented in Set commands */
    static parseSet(payload?: number): Duration | undefined;
    /**
     * Parses a user-friendly duration string in the format "Xs", "Xm", "XhYm" or "XmYs", for example "10m20s".
     * If that cannot be exactly represented as a Z-Wave duration, the nearest possible representation will be used.
     */
    static parseString(text: string): Duration | undefined;
    /**
     * Takes a user-friendly duration string, a DurationLike object, or a Duration instance and returns a Duration instance
     */
    static from(input: "default"): Duration;
    static from(input?: Duration | DurationLike | string): Duration | undefined;
    /** Serializes a duration for a Set command */
    serializeSet(): number;
    /** Serializes a duration for a Report command */
    serializeReport(): number;
    toJSON(): string | JSONObject;
    toMilliseconds(): number | undefined;
    toString(): string;
}
//# sourceMappingURL=Duration.d.ts.map