import { ValueDB, ZWaveError, ZWaveErrorCodes, } from "@zwave-js/core";
import { createThrowingMap } from "@zwave-js/shared";
/** Creates a {@link TestingHost} that can be used instead of a real driver instance in tests */
export function createTestingHost(options = {}) {
    const valuesStorage = new Map();
    const metadataStorage = new Map();
    const valueDBCache = new Map();
    const nodes = createThrowingMap((nodeId) => {
        throw new ZWaveError(`Node ${nodeId} was not found!`, ZWaveErrorCodes.Controller_NodeNotFound);
    });
    const ret = {
        homeId: options.homeId ?? 0x7e570001,
        ownNodeId: options.ownNodeId ?? 1,
        getDeviceConfig: options.getDeviceConfig ?? (() => undefined),
        logNode: () => { },
        getNode(nodeId) {
            return nodes.get(nodeId);
        },
        getNodeOrThrow(nodeId) {
            return nodes.getOrThrow(nodeId);
        },
        getAllNodes() {
            return [...nodes.values()];
        },
        setNode(nodeId, node) {
            nodes.set(nodeId, node);
        },
        getSupportedCCVersion: (cc, nodeId, endpoint) => {
            return nodes.get(nodeId)?.getEndpoint(endpoint ?? 0)?.getCCVersion(cc) ?? 0;
        },
        getValueDB: (nodeId) => {
            if (!valueDBCache.has(nodeId)) {
                valueDBCache.set(nodeId, new ValueDB(nodeId, valuesStorage, metadataStorage));
            }
            return valueDBCache.get(nodeId);
        },
        tryGetValueDB: (nodeId) => {
            return ret.getValueDB(nodeId);
        },
    };
    return ret;
}
//# sourceMappingURL=mocks.js.map