import { type NVM, type NVMIO } from "./common/definitions.js";
import { PageWriteSize } from "./nvm3/consts.js";
import { type NVMSection } from "./nvm3/files/index.js";
import { type NVM3ObjectHeader } from "./nvm3/object.js";
import { type NVM3PageHeader } from "./nvm3/page.js";
export type NVM3PageInfo = NVM3PageHeader & {
    objects: NVM3ObjectHeader[];
};
export interface NVM3SectionInfo {
    pages: NVM3PageInfo[];
    /** The index of the current page */
    currentPage: number;
    /** The next byte to write in the current page */
    offsetInPage: number;
    /** A map of file IDs and page indizes in which their last copy resides */
    objectLocations: Map<number, number>;
}
export type NVM3FileSystemInfo = {
    isSharedFileSystem: true;
    sections: Record<"all", NVM3SectionInfo>;
} | {
    isSharedFileSystem: false;
    sections: Record<NVMSection, NVM3SectionInfo>;
};
export interface NVM3Meta {
    sharedFileSystem: boolean;
    pageSize: number;
    deviceFamily: number;
    writeSize: PageWriteSize;
    memoryMapped: boolean;
}
export type NVM3EraseOptions = Partial<NVM3Meta>;
export declare class NVM3 implements NVM<number, Uint8Array> {
    constructor(io: NVMIO);
    private _io;
    private _access;
    private _info;
    get info(): NVM3FileSystemInfo | undefined;
    private ensureReadable;
    private ensureWritable;
    init(): Promise<NVM3FileSystemInfo>;
    private getNVMSectionForFile;
    has(fileId: number): Promise<boolean>;
    readObjectData(object: NVM3ObjectHeader): Promise<Uint8Array>;
    get(fileId: number, section?: NVM3SectionInfo): Promise<Uint8Array | undefined>;
    private writeObjects;
    set(property: number, value: Uint8Array): Promise<void>;
    /** Writes multiple values to the NVM at once. `null` / `undefined` cause the value to be deleted */
    setMany(values: [number, Uint8Array | null | undefined][]): Promise<void>;
    delete(property: number): Promise<void>;
    erase(options?: NVM3EraseOptions): Promise<void>;
}
//# sourceMappingURL=NVM3.d.ts.map