"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var NVMFile_exports = {};
__export(NVMFile_exports, {
  NVMFile: () => NVMFile,
  getNVMFileConstructor: () => getNVMFileConstructor,
  getNVMFileID: () => getNVMFileID,
  getNVMFileIDStatic: () => getNVMFileIDStatic,
  getNVMSection: () => getNVMSection,
  getNVMSectionByFileID: () => getNVMSectionByFileID,
  getNVMSectionStatic: () => getNVMSectionStatic,
  gotDeserializationOptions: () => gotDeserializationOptions,
  nvmFileID: () => nvmFileID,
  nvmSection: () => nvmSection
});
module.exports = __toCommonJS(NVMFile_exports);
var import_core = require("@zwave-js/core");
var import_reflection = require("@zwave-js/core/reflection");
var import_shared = require("@zwave-js/shared");
var import_consts = require("../consts.js");
function gotDeserializationOptions(options) {
  return "data" in options && (0, import_shared.isUint8Array)(options.data);
}
__name(gotDeserializationOptions, "gotDeserializationOptions");
class NVMFile {
  static {
    __name(this, "NVMFile");
  }
  constructor(options) {
    this.fileVersion = options.fileVersion;
    if (gotDeserializationOptions(options)) {
      this.fileId = options.fileId;
      this.payload = options.data;
    } else {
      const fileId = options.fileId ?? getNVMFileID(this);
      if (typeof fileId === "number") {
        this.fileId = fileId;
      }
      this.payload = new import_shared.Bytes();
    }
  }
  payload;
  fileId = 0;
  fileVersion;
  /**
   * Creates an instance of the NVM file that is contained in the given NVM object
   */
  static from(fileId, data, fileVersion) {
    const Constructor = getNVMFileConstructor(fileId);
    return new Constructor({
      fileId,
      fileVersion,
      data
    });
  }
  /**
   * Serializes this NVMFile into an NVM Object
   */
  serialize() {
    if (!this.fileId) {
      throw new Error("The NVM file ID must be set before serializing");
    }
    return {
      key: this.fileId,
      data: this.payload,
      // We only support large and small data objects for now
      type: this.payload.length <= import_consts.NVM3_MAX_OBJ_SIZE_SMALL ? import_consts.ObjectType.DataSmall : import_consts.ObjectType.DataLarge,
      // By default output unfragmented objects, they will be split later
      fragmentType: import_consts.FragmentType.None
    };
  }
  toJSON() {
    return {
      "file ID": `0x${this.fileId.toString(16)} (${this.constructor.name})`
    };
  }
}
const METADATA_nvmFileID = Symbol("nvmFileID");
const METADATA_nvmFileIDMap = Symbol("nvmFileIDMap");
function nvmFileID(id) {
  return (messageClass) => {
    Reflect.defineMetadata(METADATA_nvmFileID, id, messageClass);
    const map = Reflect.getMetadata(METADATA_nvmFileIDMap, NVMFile) || /* @__PURE__ */ new Map();
    map.set(id, messageClass);
    Reflect.defineMetadata(METADATA_nvmFileIDMap, map, NVMFile);
  };
}
__name(nvmFileID, "nvmFileID");
function getNVMFileID(id) {
  const constr = id.constructor;
  const ret = id instanceof NVMFile ? Reflect.getMetadata(METADATA_nvmFileID, constr) : void 0;
  if (ret == void 0) {
    throw new import_core.ZWaveError(`No NVM file ID defined for ${constr.name}!`, import_core.ZWaveErrorCodes.CC_Invalid);
  }
  return ret;
}
__name(getNVMFileID, "getNVMFileID");
function getNVMFileConstructor(id) {
  const map = Reflect.getMetadata(METADATA_nvmFileIDMap, NVMFile);
  if (map != void 0) {
    if (map.has(id))
      return map.get(id);
    for (const [key, value] of map.entries()) {
      if (typeof key === "function" && key(id))
        return value;
    }
  }
}
__name(getNVMFileConstructor, "getNVMFileConstructor");
function getNVMFileIDStatic(classConstructor) {
  const ret = Reflect.getMetadata(METADATA_nvmFileID, classConstructor);
  if (ret == void 0) {
    throw new import_core.ZWaveError(`No NVM file ID defined for ${classConstructor.name}!`, import_core.ZWaveErrorCodes.CC_Invalid);
  }
  return ret;
}
__name(getNVMFileIDStatic, "getNVMFileIDStatic");
const nvmSectionDecorator = (0, import_reflection.createSimpleReflectionDecorator)({
  name: "nvmSection"
});
const nvmSection = nvmSectionDecorator.decorator;
const getNVMSection = nvmSectionDecorator.lookupValue;
const getNVMSectionStatic = nvmSectionDecorator.lookupValueStatic;
function getNVMSectionByFileID(fileId) {
  const File = getNVMFileConstructor(fileId);
  let ret;
  if (File) {
    ret = getNVMSectionStatic(File);
  }
  if (ret)
    return ret;
  throw new import_core.ZWaveError(`NVM section for file with ID ${(0, import_shared.num2hex)(fileId)} could not be determined`, import_core.ZWaveErrorCodes.Argument_Invalid);
}
__name(getNVMSectionByFileID, "getNVMSectionByFileID");
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  NVMFile,
  getNVMFileConstructor,
  getNVMFileID,
  getNVMFileIDStatic,
  getNVMSection,
  getNVMSectionByFileID,
  getNVMSectionStatic,
  gotDeserializationOptions,
  nvmFileID,
  nvmSection
});
//# sourceMappingURL=NVMFile.js.map
