import { Bytes } from "@zwave-js/shared";
import { type RouteCache } from "../../common/routeCache.js";
import type { NVM3Object } from "../object.js";
import { NVMFile, type NVMFileCreationOptions, type NVMFileDeserializationOptions } from "./NVMFile.js";
export declare const ROUTECACHES_PER_FILE_V1 = 8;
export interface RouteCacheFileV0Options extends NVMFileCreationOptions {
    routeCache: RouteCache;
}
export declare const RouteCacheFileV0IDBase = 328704;
export declare function nodeIdToRouteCacheFileIDV0(nodeId: number): number;
export declare class RouteCacheFileV0 extends NVMFile {
    constructor(options: NVMFileDeserializationOptions | RouteCacheFileV0Options);
    routeCache: RouteCache;
    serialize(): NVM3Object & {
        data: Bytes;
    };
    toJSON(): {
        routeCache: RouteCache;
    };
}
export interface RouteCacheFileV1Options extends NVMFileCreationOptions {
    routeCaches: RouteCache[];
}
export declare const RouteCacheFileV1IDBase = 332800;
export declare function nodeIdToRouteCacheFileIDV1(nodeId: number): number;
export declare class RouteCacheFileV1 extends NVMFile {
    constructor(options: NVMFileDeserializationOptions | RouteCacheFileV1Options);
    routeCaches: RouteCache[];
    serialize(): NVM3Object & {
        data: Bytes;
    };
    toJSON(): {
        "route caches": RouteCache[];
    };
}
//# sourceMappingURL=RouteCacheFiles.d.ts.map