"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var SUCUpdateEntriesFile_exports = {};
__export(SUCUpdateEntriesFile_exports, {
  SUCUpdateEntriesFileIDV0: () => SUCUpdateEntriesFileIDV0,
  SUCUpdateEntriesFileV0: () => SUCUpdateEntriesFileV0,
  SUCUpdateEntriesFileV5: () => SUCUpdateEntriesFileV5,
  SUCUpdateEntriesFileV5IDBase: () => SUCUpdateEntriesFileV5IDBase,
  SUCUpdateEntriesFileV5IDMax: () => SUCUpdateEntriesFileV5IDMax,
  SUC_UPDATES_PER_FILE_V5: () => SUC_UPDATES_PER_FILE_V5,
  sucUpdateIndexToSUCUpdateEntriesFileIDV5: () => sucUpdateIndexToSUCUpdateEntriesFileIDV5
});
module.exports = __toCommonJS(SUCUpdateEntriesFile_exports);
var import_shared = require("@zwave-js/shared");
var import_consts = require("../../../consts.js");
var import_sucUpdateEntry = require("../../common/sucUpdateEntry.js");
var import_NVMFile = require("./NVMFile.js");
var __esDecorate = function(ctor, descriptorIn, decorators, contextIn, initializers, extraInitializers) {
  function accept(f) {
    if (f !== void 0 && typeof f !== "function") throw new TypeError("Function expected");
    return f;
  }
  __name(accept, "accept");
  var kind = contextIn.kind, key = kind === "getter" ? "get" : kind === "setter" ? "set" : "value";
  var target = !descriptorIn && ctor ? contextIn["static"] ? ctor : ctor.prototype : null;
  var descriptor = descriptorIn || (target ? Object.getOwnPropertyDescriptor(target, contextIn.name) : {});
  var _, done = false;
  for (var i = decorators.length - 1; i >= 0; i--) {
    var context = {};
    for (var p in contextIn) context[p] = p === "access" ? {} : contextIn[p];
    for (var p in contextIn.access) context.access[p] = contextIn.access[p];
    context.addInitializer = function(f) {
      if (done) throw new TypeError("Cannot add initializers after decoration has completed");
      extraInitializers.push(accept(f || null));
    };
    var result = (0, decorators[i])(kind === "accessor" ? { get: descriptor.get, set: descriptor.set } : descriptor[key], context);
    if (kind === "accessor") {
      if (result === void 0) continue;
      if (result === null || typeof result !== "object") throw new TypeError("Object expected");
      if (_ = accept(result.get)) descriptor.get = _;
      if (_ = accept(result.set)) descriptor.set = _;
      if (_ = accept(result.init)) initializers.unshift(_);
    } else if (_ = accept(result)) {
      if (kind === "field") initializers.unshift(_);
      else descriptor[key] = _;
    }
  }
  if (target) Object.defineProperty(target, contextIn.name, descriptor);
  done = true;
};
var __runInitializers = function(thisArg, initializers, value) {
  var useValue = arguments.length > 2;
  for (var i = 0; i < initializers.length; i++) {
    value = useValue ? initializers[i].call(thisArg, value) : initializers[i].call(thisArg);
  }
  return useValue ? value : void 0;
};
const SUC_UPDATES_PER_FILE_V5 = 8;
const SUCUpdateEntriesFileIDV0 = 327683;
let SUCUpdateEntriesFileV0 = (() => {
  let _classDecorators = [(0, import_NVMFile.nvmFileID)(SUCUpdateEntriesFileIDV0), (0, import_NVMFile.nvmSection)("protocol")];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = import_NVMFile.NVMFile;
  var SUCUpdateEntriesFileV02 = class extends _classSuper {
    static {
      __name(this, "SUCUpdateEntriesFileV0");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      SUCUpdateEntriesFileV02 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      if ((0, import_NVMFile.gotDeserializationOptions)(options)) {
        this.updateEntries = [];
        for (let entry = 0; entry < import_consts.SUC_MAX_UPDATES; entry++) {
          const offset = entry * import_consts.SUC_UPDATE_ENTRY_SIZE;
          const updateEntry = (0, import_sucUpdateEntry.parseSUCUpdateEntry)(this.payload, offset);
          if (updateEntry)
            this.updateEntries.push(updateEntry);
        }
      } else {
        this.updateEntries = options.updateEntries;
      }
    }
    updateEntries;
    serialize() {
      this.payload = new import_shared.Bytes(import_consts.SUC_MAX_UPDATES * import_consts.SUC_UPDATE_ENTRY_SIZE).fill(0);
      for (let i = 0; i < this.updateEntries.length; i++) {
        const offset = i * import_consts.SUC_UPDATE_ENTRY_SIZE;
        const entry = this.updateEntries[i];
        this.payload.set((0, import_sucUpdateEntry.encodeSUCUpdateEntry)(entry), offset);
      }
      return super.serialize();
    }
    // eslint-disable-next-line @typescript-eslint/explicit-module-boundary-types
    toJSON() {
      return {
        ...super.toJSON(),
        "SUC update entries": this.updateEntries
      };
    }
  };
  return SUCUpdateEntriesFileV02 = _classThis;
})();
const SUCUpdateEntriesFileV5IDBase = 344064;
const SUCUpdateEntriesFileV5IDMax = SUCUpdateEntriesFileV5IDBase + import_consts.SUC_MAX_UPDATES / SUC_UPDATES_PER_FILE_V5 - 1;
function sucUpdateIndexToSUCUpdateEntriesFileIDV5(index) {
  return SUCUpdateEntriesFileV5IDBase + Math.floor(index / SUC_UPDATES_PER_FILE_V5);
}
__name(sucUpdateIndexToSUCUpdateEntriesFileIDV5, "sucUpdateIndexToSUCUpdateEntriesFileIDV5");
let SUCUpdateEntriesFileV5 = (() => {
  let _classDecorators = [(0, import_NVMFile.nvmFileID)((id) => id >= SUCUpdateEntriesFileV5IDBase && id <= SUCUpdateEntriesFileV5IDMax), (0, import_NVMFile.nvmSection)("protocol")];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = import_NVMFile.NVMFile;
  var SUCUpdateEntriesFileV52 = class extends _classSuper {
    static {
      __name(this, "SUCUpdateEntriesFileV5");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      SUCUpdateEntriesFileV52 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      if ((0, import_NVMFile.gotDeserializationOptions)(options)) {
        this.updateEntries = [];
        for (let entry = 0; entry < SUC_UPDATES_PER_FILE_V5; entry++) {
          const offset = entry * import_consts.SUC_UPDATE_ENTRY_SIZE;
          const updateEntry = (0, import_sucUpdateEntry.parseSUCUpdateEntry)(this.payload, offset);
          if (updateEntry)
            this.updateEntries.push(updateEntry);
        }
      } else {
        this.updateEntries = options.updateEntries;
      }
    }
    updateEntries;
    serialize() {
      this.payload = new import_shared.Bytes(SUC_UPDATES_PER_FILE_V5 * import_consts.SUC_UPDATE_ENTRY_SIZE).fill(255);
      for (let i = 0; i < this.updateEntries.length; i++) {
        const offset = i * import_consts.SUC_UPDATE_ENTRY_SIZE;
        const entry = this.updateEntries[i];
        this.payload.set((0, import_sucUpdateEntry.encodeSUCUpdateEntry)(entry), offset);
      }
      return super.serialize();
    }
    // eslint-disable-next-line @typescript-eslint/explicit-module-boundary-types
    toJSON() {
      return {
        ...super.toJSON(),
        "SUC update entries": this.updateEntries
      };
    }
  };
  return SUCUpdateEntriesFileV52 = _classThis;
})();
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  SUCUpdateEntriesFileIDV0,
  SUCUpdateEntriesFileV0,
  SUCUpdateEntriesFileV5,
  SUCUpdateEntriesFileV5IDBase,
  SUCUpdateEntriesFileV5IDMax,
  SUC_UPDATES_PER_FILE_V5,
  sucUpdateIndexToSUCUpdateEntriesFileIDV5
});
//# sourceMappingURL=SUCUpdateEntriesFile.js.map
