import { type NodeProtocolInfo } from "@zwave-js/core";
import { Bytes } from "@zwave-js/shared";
import type { NVMModuleType } from "./shared.js";
export interface NVMDescriptor {
    manufacturerID: number;
    firmwareID: number;
    productType: number;
    productID: number;
    firmwareVersion: string;
    protocolVersion: string;
}
export declare function parseNVMDescriptor(data: Uint8Array, offset?: number): NVMDescriptor;
export declare function encodeNVMDescriptor(descriptor: NVMDescriptor): Bytes;
export interface NVMModuleDescriptor {
    size: number;
    type: NVMModuleType;
    version: string;
}
export declare function parseNVMModuleDescriptor(data: Uint8Array, offset?: number): NVMModuleDescriptor;
export declare function encodeNVMModuleDescriptor(descriptior: NVMModuleDescriptor): Bytes;
export interface NVM500NodeInfo extends Omit<NodeProtocolInfo, "hasSpecificDeviceClass"> {
    genericDeviceClass: number;
    specificDeviceClass: number | null;
}
export declare function parseNVM500NodeInfo(buffer: Uint8Array, offset: number): NVM500NodeInfo;
export declare function encodeNVM500NodeInfo(nodeInfo: NVM500NodeInfo): Bytes;
//# sourceMappingURL=EntryParsers.d.ts.map