import { NVMAccess, type NVMIO } from "../common/definitions.js";
/** An implementation of NVMIO for the filesystem */
export declare class NVMFileIO implements NVMIO {
    constructor(path: string);
    private _path;
    private _handle;
    private _chunkSize;
    open(access: NVMAccess): Promise<NVMAccess>;
    private _size;
    get size(): number;
    private _accessMode;
    get accessMode(): NVMAccess;
    determineChunkSize(): Promise<number>;
    read(offset: number, length: number): Promise<{
        buffer: Uint8Array;
        endOfFile: boolean;
    }>;
    write(offset: number, data: Uint8Array): Promise<{
        bytesWritten: number;
        endOfFile: boolean;
    }>;
    close(): Promise<void>;
}
//# sourceMappingURL=NVMFileIO.d.ts.map