import { NVMAccess, type NVMIO } from "../common/definitions.js";
/** An im-memory implementation of NVMIO */
export declare class NVMMemoryIO implements NVMIO {
    constructor(buffer: Uint8Array);
    private _buffer;
    open(_access: NVMAccess.Read | NVMAccess.Write): Promise<NVMAccess>;
    get size(): number;
    get accessMode(): NVMAccess;
    determineChunkSize(): Promise<number>;
    read(offset: number, length: number): Promise<{
        buffer: Uint8Array;
        endOfFile: boolean;
    }>;
    write(offset: number, data: Uint8Array): Promise<{
        bytesWritten: number;
        endOfFile: boolean;
    }>;
    close(): Promise<void>;
}
//# sourceMappingURL=NVMMemoryIO.d.ts.map