var __esDecorate = (this && this.__esDecorate) || function (ctor, descriptorIn, decorators, contextIn, initializers, extraInitializers) {
    function accept(f) { if (f !== void 0 && typeof f !== "function") throw new TypeError("Function expected"); return f; }
    var kind = contextIn.kind, key = kind === "getter" ? "get" : kind === "setter" ? "set" : "value";
    var target = !descriptorIn && ctor ? contextIn["static"] ? ctor : ctor.prototype : null;
    var descriptor = descriptorIn || (target ? Object.getOwnPropertyDescriptor(target, contextIn.name) : {});
    var _, done = false;
    for (var i = decorators.length - 1; i >= 0; i--) {
        var context = {};
        for (var p in contextIn) context[p] = p === "access" ? {} : contextIn[p];
        for (var p in contextIn.access) context.access[p] = contextIn.access[p];
        context.addInitializer = function (f) { if (done) throw new TypeError("Cannot add initializers after decoration has completed"); extraInitializers.push(accept(f || null)); };
        var result = (0, decorators[i])(kind === "accessor" ? { get: descriptor.get, set: descriptor.set } : descriptor[key], context);
        if (kind === "accessor") {
            if (result === void 0) continue;
            if (result === null || typeof result !== "object") throw new TypeError("Object expected");
            if (_ = accept(result.get)) descriptor.get = _;
            if (_ = accept(result.set)) descriptor.set = _;
            if (_ = accept(result.init)) initializers.unshift(_);
        }
        else if (_ = accept(result)) {
            if (kind === "field") initializers.unshift(_);
            else descriptor[key] = _;
        }
    }
    if (target) Object.defineProperty(target, contextIn.name, descriptor);
    done = true;
};
var __runInitializers = (this && this.__runInitializers) || function (thisArg, initializers, value) {
    var useValue = arguments.length > 2;
    for (var i = 0; i < initializers.length; i++) {
        value = useValue ? initializers[i].call(thisArg, value) : initializers[i].call(thisArg);
    }
    return useValue ? value : void 0;
};
import { ZWaveError, ZWaveErrorCodes, stripUndefined } from "@zwave-js/core";
import { Bytes, buffer2hex } from "@zwave-js/shared";
import { NVMFile, gotDeserializationOptions, nvmFileID, nvmSection, } from "./NVMFile.js";
export const ControllerInfoFileID = 0x50004;
let ControllerInfoFile = (() => {
    let _classDecorators = [nvmFileID(ControllerInfoFileID), nvmSection("protocol")];
    let _classDescriptor;
    let _classExtraInitializers = [];
    let _classThis;
    let _classSuper = NVMFile;
    var ControllerInfoFile = class extends _classSuper {
        static { _classThis = this; }
        static {
            const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
            __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
            ControllerInfoFile = _classThis = _classDescriptor.value;
            if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
            __runInitializers(_classThis, _classExtraInitializers);
        }
        constructor(options) {
            super(options);
            if (gotDeserializationOptions(options)) {
                this.homeId = this.payload.subarray(0, 4);
                if (this.payload.length === 13) {
                    this.nodeId = this.payload[4];
                    this.lastNodeId = this.payload[5];
                    this.staticControllerNodeId = this.payload[6];
                    this.sucLastIndex = this.payload[7];
                    this.controllerConfiguration = this.payload[8];
                    this.sucAwarenessPushNeeded = this.payload[9];
                    this.maxNodeId = this.payload[10];
                    this.reservedId = this.payload[11];
                    this.systemState = this.payload[12];
                }
                else if (this.payload.length === 22) {
                    this.nodeId = this.payload.readUInt16LE(4);
                    this.staticControllerNodeId = this.payload.readUInt16LE(6);
                    this.lastNodeIdLR = this.payload.readUInt16LE(8);
                    this.lastNodeId = this.payload[10];
                    this.sucLastIndex = this.payload[11];
                    this.maxNodeIdLR = this.payload.readUInt16LE(12);
                    this.maxNodeId = this.payload[14];
                    this.controllerConfiguration = this.payload[15];
                    this.reservedIdLR = this.payload.readUInt16LE(16);
                    this.reservedId = this.payload[18];
                    this.systemState = this.payload[19];
                    this.primaryLongRangeChannelId = this.payload[20];
                    this.dcdcConfig = this.payload[21];
                }
                else {
                    throw new ZWaveError(`Unsupported payload length`, ZWaveErrorCodes.NVM_InvalidFormat);
                }
            }
            else {
                this.homeId = Bytes.view(options.homeId);
                this.nodeId = options.nodeId;
                this.lastNodeId = options.lastNodeId;
                this.staticControllerNodeId = options.staticControllerNodeId;
                this.sucLastIndex = options.sucLastIndex;
                this.controllerConfiguration = options.controllerConfiguration;
                this.maxNodeId = options.maxNodeId;
                this.reservedId = options.reservedId;
                this.systemState = options.systemState;
                if ("lastNodeIdLR" in options) {
                    this.lastNodeIdLR = options.lastNodeIdLR;
                    this.maxNodeIdLR = options.maxNodeIdLR;
                    this.reservedIdLR = options.reservedIdLR;
                    this.primaryLongRangeChannelId =
                        options.primaryLongRangeChannelId;
                    this.dcdcConfig = options.dcdcConfig;
                }
                else {
                    this.sucAwarenessPushNeeded = options.sucAwarenessPushNeeded;
                }
            }
        }
        homeId;
        nodeId;
        lastNodeId;
        staticControllerNodeId;
        sucLastIndex;
        controllerConfiguration; // TODO: Figure out what this is
        sucAwarenessPushNeeded;
        maxNodeId;
        reservedId;
        systemState;
        lastNodeIdLR;
        maxNodeIdLR;
        reservedIdLR;
        primaryLongRangeChannelId;
        dcdcConfig;
        serialize() {
            if (this.lastNodeIdLR != undefined) {
                this.payload = new Bytes(22);
                this.payload.set(this.homeId, 0);
                this.payload.writeUInt16LE(this.nodeId, 4);
                this.payload.writeUInt16LE(this.staticControllerNodeId, 6);
                this.payload.writeUInt16LE(this.lastNodeIdLR, 8);
                this.payload[10] = this.lastNodeId;
                this.payload[11] = this.sucLastIndex;
                this.payload.writeUInt16LE(this.maxNodeIdLR, 12);
                this.payload[14] = this.maxNodeId;
                this.payload[15] = this.controllerConfiguration;
                this.payload.writeUInt16LE(this.reservedIdLR, 16);
                this.payload[18] = this.reservedId;
                this.payload[19] = this.systemState;
                this.payload[20] = this.primaryLongRangeChannelId;
                this.payload[21] = this.dcdcConfig;
            }
            else {
                // V0
                this.payload = Bytes.concat([
                    this.homeId,
                    Bytes.from([
                        this.nodeId,
                        this.lastNodeId,
                        this.staticControllerNodeId,
                        this.sucLastIndex,
                        this.controllerConfiguration,
                        this.sucAwarenessPushNeeded ?? 0,
                        this.maxNodeId,
                        this.reservedId,
                        this.systemState,
                    ]),
                ]);
            }
            return super.serialize();
        }
        // eslint-disable-next-line @typescript-eslint/explicit-module-boundary-types
        toJSON() {
            return stripUndefined({
                ...super.toJSON(),
                homeId: buffer2hex(this.homeId),
                nodeId: this.nodeId,
                lastNodeId: this.lastNodeId,
                staticControllerNodeId: this.staticControllerNodeId,
                sucLastIndex: this.sucLastIndex,
                controllerConfiguration: this.controllerConfiguration,
                sucAwarenessPushNeeded: this.sucAwarenessPushNeeded,
                maxNodeId: this.maxNodeId,
                reservedId: this.reservedId,
                systemState: this.systemState,
                lastNodeIdLR: this.lastNodeIdLR,
                maxNodeIdLR: this.maxNodeIdLR,
                reservedIdLR: this.reservedIdLR,
                primaryLongRangeChannelId: this.primaryLongRangeChannelId,
                dcdcConfig: this.dcdcConfig,
            });
        }
    };
    return ControllerInfoFile = _classThis;
})();
export { ControllerInfoFile };
//# sourceMappingURL=ControllerInfoFile.js.map