"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var DeviceInfoMessages_exports = {};
__export(DeviceInfoMessages_exports, {
  DeviceInfoRequest: () => DeviceInfoRequest,
  DeviceInfoResponse: () => DeviceInfoResponse
});
module.exports = __toCommonJS(DeviceInfoMessages_exports);
var import_core = require("@zwave-js/core");
var import_shared = require("@zwave-js/shared");
var import_ESPHomeMessage = require("./ESPHomeMessage.js");
var import_ProtobufHelpers = require("./ProtobufHelpers.js");
var __esDecorate = function(ctor, descriptorIn, decorators, contextIn, initializers, extraInitializers) {
  function accept(f) {
    if (f !== void 0 && typeof f !== "function") throw new TypeError("Function expected");
    return f;
  }
  __name(accept, "accept");
  var kind = contextIn.kind, key = kind === "getter" ? "get" : kind === "setter" ? "set" : "value";
  var target = !descriptorIn && ctor ? contextIn["static"] ? ctor : ctor.prototype : null;
  var descriptor = descriptorIn || (target ? Object.getOwnPropertyDescriptor(target, contextIn.name) : {});
  var _, done = false;
  for (var i = decorators.length - 1; i >= 0; i--) {
    var context = {};
    for (var p in contextIn) context[p] = p === "access" ? {} : contextIn[p];
    for (var p in contextIn.access) context.access[p] = contextIn.access[p];
    context.addInitializer = function(f) {
      if (done) throw new TypeError("Cannot add initializers after decoration has completed");
      extraInitializers.push(accept(f || null));
    };
    var result = (0, decorators[i])(kind === "accessor" ? { get: descriptor.get, set: descriptor.set } : descriptor[key], context);
    if (kind === "accessor") {
      if (result === void 0) continue;
      if (result === null || typeof result !== "object") throw new TypeError("Object expected");
      if (_ = accept(result.get)) descriptor.get = _;
      if (_ = accept(result.set)) descriptor.set = _;
      if (_ = accept(result.init)) initializers.unshift(_);
    } else if (_ = accept(result)) {
      if (kind === "field") initializers.unshift(_);
      else descriptor[key] = _;
    }
  }
  if (target) Object.defineProperty(target, contextIn.name, descriptor);
  done = true;
};
var __runInitializers = function(thisArg, initializers, value) {
  var useValue = arguments.length > 2;
  for (var i = 0; i < initializers.length; i++) {
    value = useValue ? initializers[i].call(thisArg, value) : initializers[i].call(thisArg);
  }
  return useValue ? value : void 0;
};
let DeviceInfoRequest = (() => {
  let _classDecorators = [(0, import_ESPHomeMessage.messageType)(import_ESPHomeMessage.ESPHomeMessageType.DeviceInfoRequest)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = import_ESPHomeMessage.ESPHomeMessage;
  var DeviceInfoRequest2 = class extends _classSuper {
    static {
      __name(this, "DeviceInfoRequest");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      DeviceInfoRequest2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
  };
  return DeviceInfoRequest2 = _classThis;
})();
let DeviceInfoResponse = (() => {
  let _classDecorators = [(0, import_ESPHomeMessage.messageType)(import_ESPHomeMessage.ESPHomeMessageType.DeviceInfoResponse)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = import_ESPHomeMessage.ESPHomeMessage;
  var DeviceInfoResponse2 = class extends _classSuper {
    static {
      __name(this, "DeviceInfoResponse");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      DeviceInfoResponse2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.usesPassword = options.usesPassword ?? false;
      this.name = options.name ?? "";
      this.macAddress = options.macAddress ?? "";
      this.esphomeVersion = options.esphomeVersion ?? "";
      this.compilationTime = options.compilationTime ?? "";
      this.model = options.model ?? "";
      this.hasDeepSleep = options.hasDeepSleep ?? false;
      this.projectName = options.projectName ?? "";
      this.projectVersion = options.projectVersion ?? "";
      this.webserverPort = options.webserverPort ?? 0;
      this.manufacturer = options.manufacturer ?? "";
      this.friendlyName = options.friendlyName ?? "";
      this.suggestedArea = options.suggestedArea ?? "";
      this.bluetoothMacAddress = options.bluetoothMacAddress ?? "";
      this.apiEncryptionSupported = options.apiEncryptionSupported ?? false;
      this.zwaveProxyFeatureFlags = options.zwaveProxyFeatureFlags ?? 0;
    }
    static from(raw) {
      let usesPassword = false;
      let name = "";
      let macAddress = "";
      let esphomeVersion = "";
      let compilationTime = "";
      let model = "";
      let hasDeepSleep = false;
      let projectName = "";
      let projectVersion = "";
      let webserverPort = 0;
      let manufacturer = "";
      let friendlyName = "";
      let suggestedArea = "";
      let bluetoothMacAddress = "";
      let apiEncryptionSupported = false;
      let zwaveProxyFeatureFlags = 0;
      (0, import_ProtobufHelpers.parseProtobufMessage)(raw.payload, (fieldNumber, wireType, data, offset) => {
        switch (fieldNumber) {
          case 1:
            if (wireType !== 0) {
              throw new import_core.ZWaveError("Invalid wire type for usesPassword", import_core.ZWaveErrorCodes.Argument_Invalid);
            }
            const usesPasswordResult = (0, import_ProtobufHelpers.decodeVarInt)(data, offset);
            usesPassword = usesPasswordResult.value !== 0;
            return offset + usesPasswordResult.bytesRead;
          case 2:
            if (wireType !== 2) {
              throw new import_core.ZWaveError("Invalid wire type for name", import_core.ZWaveErrorCodes.Argument_Invalid);
            }
            const nameResult = (0, import_ProtobufHelpers.decodeStringField)(data, offset);
            name = nameResult.value;
            return offset + nameResult.bytesRead;
          case 3:
            if (wireType !== 2) {
              throw new import_core.ZWaveError("Invalid wire type for macAddress", import_core.ZWaveErrorCodes.Argument_Invalid);
            }
            const macAddressResult = (0, import_ProtobufHelpers.decodeStringField)(data, offset);
            macAddress = macAddressResult.value;
            return offset + macAddressResult.bytesRead;
          case 4:
            if (wireType !== 2) {
              throw new import_core.ZWaveError("Invalid wire type for esphomeVersion", import_core.ZWaveErrorCodes.Argument_Invalid);
            }
            const esphomeVersionResult = (0, import_ProtobufHelpers.decodeStringField)(data, offset);
            esphomeVersion = esphomeVersionResult.value;
            return offset + esphomeVersionResult.bytesRead;
          case 5:
            if (wireType !== 2) {
              throw new import_core.ZWaveError("Invalid wire type for compilationTime", import_core.ZWaveErrorCodes.Argument_Invalid);
            }
            const compilationTimeResult = (0, import_ProtobufHelpers.decodeStringField)(data, offset);
            compilationTime = compilationTimeResult.value;
            return offset + compilationTimeResult.bytesRead;
          case 6:
            if (wireType !== 2) {
              throw new import_core.ZWaveError("Invalid wire type for model", import_core.ZWaveErrorCodes.Argument_Invalid);
            }
            const modelResult = (0, import_ProtobufHelpers.decodeStringField)(data, offset);
            model = modelResult.value;
            return offset + modelResult.bytesRead;
          case 7:
            if (wireType !== 0) {
              throw new import_core.ZWaveError("Invalid wire type for hasDeepSleep", import_core.ZWaveErrorCodes.Argument_Invalid);
            }
            const hasDeepSleepResult = (0, import_ProtobufHelpers.decodeVarInt)(data, offset);
            hasDeepSleep = hasDeepSleepResult.value !== 0;
            return offset + hasDeepSleepResult.bytesRead;
          case 8:
            if (wireType !== 2) {
              throw new import_core.ZWaveError("Invalid wire type for projectName", import_core.ZWaveErrorCodes.Argument_Invalid);
            }
            const projectNameResult = (0, import_ProtobufHelpers.decodeStringField)(data, offset);
            projectName = projectNameResult.value;
            return offset + projectNameResult.bytesRead;
          case 9:
            if (wireType !== 2) {
              throw new import_core.ZWaveError("Invalid wire type for projectVersion", import_core.ZWaveErrorCodes.Argument_Invalid);
            }
            const projectVersionResult = (0, import_ProtobufHelpers.decodeStringField)(data, offset);
            projectVersion = projectVersionResult.value;
            return offset + projectVersionResult.bytesRead;
          case 10:
            if (wireType !== 0) {
              throw new import_core.ZWaveError("Invalid wire type for webserverPort", import_core.ZWaveErrorCodes.Argument_Invalid);
            }
            const webserverPortResult = (0, import_ProtobufHelpers.decodeVarInt)(data, offset);
            webserverPort = webserverPortResult.value;
            return offset + webserverPortResult.bytesRead;
          case 12:
            if (wireType !== 2) {
              throw new import_core.ZWaveError("Invalid wire type for manufacturer", import_core.ZWaveErrorCodes.Argument_Invalid);
            }
            const manufacturerResult = (0, import_ProtobufHelpers.decodeStringField)(data, offset);
            manufacturer = manufacturerResult.value;
            return offset + manufacturerResult.bytesRead;
          case 13:
            if (wireType !== 2) {
              throw new import_core.ZWaveError("Invalid wire type for friendlyName", import_core.ZWaveErrorCodes.Argument_Invalid);
            }
            const friendlyNameResult = (0, import_ProtobufHelpers.decodeStringField)(data, offset);
            friendlyName = friendlyNameResult.value;
            return offset + friendlyNameResult.bytesRead;
          case 16:
            if (wireType !== 2) {
              throw new import_core.ZWaveError("Invalid wire type for suggestedArea", import_core.ZWaveErrorCodes.Argument_Invalid);
            }
            const suggestedAreaResult = (0, import_ProtobufHelpers.decodeStringField)(data, offset);
            suggestedArea = suggestedAreaResult.value;
            return offset + suggestedAreaResult.bytesRead;
          case 18:
            if (wireType !== 2) {
              throw new import_core.ZWaveError("Invalid wire type for bluetoothMacAddress", import_core.ZWaveErrorCodes.Argument_Invalid);
            }
            const bluetoothMacAddressResult = (0, import_ProtobufHelpers.decodeStringField)(data, offset);
            bluetoothMacAddress = bluetoothMacAddressResult.value;
            return offset + bluetoothMacAddressResult.bytesRead;
          case 19:
            if (wireType !== 0) {
              throw new import_core.ZWaveError("Invalid wire type for apiEncryptionSupported", import_core.ZWaveErrorCodes.Argument_Invalid);
            }
            const apiEncryptionSupportedResult = (0, import_ProtobufHelpers.decodeVarInt)(data, offset);
            apiEncryptionSupported = apiEncryptionSupportedResult.value !== 0;
            return offset + apiEncryptionSupportedResult.bytesRead;
          case 23:
            if (wireType !== 0) {
              throw new import_core.ZWaveError("Invalid wire type for zwaveProxyFeatureFlags", import_core.ZWaveErrorCodes.Argument_Invalid);
            }
            const zwaveProxyFeatureFlagsResult = (0, import_ProtobufHelpers.decodeVarInt)(data, offset);
            zwaveProxyFeatureFlags = zwaveProxyFeatureFlagsResult.value;
            return offset + zwaveProxyFeatureFlagsResult.bytesRead;
          default:
            return (0, import_ProtobufHelpers.skipField)(data, offset, wireType);
        }
      });
      return new this({
        usesPassword,
        name,
        macAddress,
        esphomeVersion,
        compilationTime,
        model,
        hasDeepSleep,
        projectName,
        projectVersion,
        webserverPort,
        manufacturer,
        friendlyName,
        suggestedArea,
        bluetoothMacAddress,
        apiEncryptionSupported,
        zwaveProxyFeatureFlags
      });
    }
    usesPassword;
    name;
    macAddress;
    esphomeVersion;
    compilationTime;
    model;
    hasDeepSleep;
    projectName;
    projectVersion;
    webserverPort;
    manufacturer;
    friendlyName;
    suggestedArea;
    bluetoothMacAddress;
    apiEncryptionSupported;
    zwaveProxyFeatureFlags;
    /**
     * Check if Z-Wave proxy support is available
     */
    get hasZWaveProxySupport() {
      return this.zwaveProxyFeatureFlags > 0;
    }
    serialize() {
      const parts = [];
      if (this.usesPassword) {
        parts.push((0, import_ProtobufHelpers.encodeVarintField)(1, 1));
      }
      if (this.name) {
        parts.push((0, import_ProtobufHelpers.encodeStringField)(2, this.name));
      }
      if (this.macAddress) {
        parts.push((0, import_ProtobufHelpers.encodeStringField)(3, this.macAddress));
      }
      if (this.esphomeVersion) {
        parts.push((0, import_ProtobufHelpers.encodeStringField)(4, this.esphomeVersion));
      }
      if (this.compilationTime) {
        parts.push((0, import_ProtobufHelpers.encodeStringField)(5, this.compilationTime));
      }
      if (this.model) {
        parts.push((0, import_ProtobufHelpers.encodeStringField)(6, this.model));
      }
      if (this.hasDeepSleep) {
        parts.push((0, import_ProtobufHelpers.encodeVarintField)(7, 1));
      }
      if (this.projectName) {
        parts.push((0, import_ProtobufHelpers.encodeStringField)(8, this.projectName));
      }
      if (this.projectVersion) {
        parts.push((0, import_ProtobufHelpers.encodeStringField)(9, this.projectVersion));
      }
      if (this.webserverPort > 0) {
        parts.push((0, import_ProtobufHelpers.encodeVarintField)(10, this.webserverPort));
      }
      if (this.manufacturer) {
        parts.push((0, import_ProtobufHelpers.encodeStringField)(12, this.manufacturer));
      }
      if (this.friendlyName) {
        parts.push((0, import_ProtobufHelpers.encodeStringField)(13, this.friendlyName));
      }
      if (this.suggestedArea) {
        parts.push((0, import_ProtobufHelpers.encodeStringField)(16, this.suggestedArea));
      }
      if (this.bluetoothMacAddress) {
        parts.push((0, import_ProtobufHelpers.encodeStringField)(18, this.bluetoothMacAddress));
      }
      if (this.apiEncryptionSupported) {
        parts.push((0, import_ProtobufHelpers.encodeVarintField)(19, 1));
      }
      if (this.zwaveProxyFeatureFlags > 0) {
        parts.push((0, import_ProtobufHelpers.encodeVarintField)(23, this.zwaveProxyFeatureFlags));
      }
      this.payload = import_shared.Bytes.concat(parts);
      return super.serialize();
    }
  };
  return DeviceInfoResponse2 = _classThis;
})();
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  DeviceInfoRequest,
  DeviceInfoResponse
});
//# sourceMappingURL=DeviceInfoMessages.js.map
