"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var ESPHomeMessage_exports = {};
__export(ESPHomeMessage_exports, {
  ESPHomeMessage: () => ESPHomeMessage,
  ESPHomeMessageRaw: () => ESPHomeMessageRaw,
  ESPHomeMessageType: () => ESPHomeMessageType,
  messageType: () => messageType
});
module.exports = __toCommonJS(ESPHomeMessage_exports);
var import_core = require("@zwave-js/core");
var import_shared = require("@zwave-js/shared");
var import_ProtobufHelpers = require("./ProtobufHelpers.js");
var ESPHomeMessageType;
(function(ESPHomeMessageType2) {
  ESPHomeMessageType2[ESPHomeMessageType2["HelloRequest"] = 1] = "HelloRequest";
  ESPHomeMessageType2[ESPHomeMessageType2["HelloResponse"] = 2] = "HelloResponse";
  ESPHomeMessageType2[ESPHomeMessageType2["DisconnectRequest"] = 5] = "DisconnectRequest";
  ESPHomeMessageType2[ESPHomeMessageType2["DisconnectResponse"] = 6] = "DisconnectResponse";
  ESPHomeMessageType2[ESPHomeMessageType2["PingRequest"] = 7] = "PingRequest";
  ESPHomeMessageType2[ESPHomeMessageType2["PingResponse"] = 8] = "PingResponse";
  ESPHomeMessageType2[ESPHomeMessageType2["DeviceInfoRequest"] = 9] = "DeviceInfoRequest";
  ESPHomeMessageType2[ESPHomeMessageType2["DeviceInfoResponse"] = 10] = "DeviceInfoResponse";
  ESPHomeMessageType2[ESPHomeMessageType2["ZWaveProxyFrame"] = 128] = "ZWaveProxyFrame";
  ESPHomeMessageType2[ESPHomeMessageType2["ZWaveProxyRequest"] = 129] = "ZWaveProxyRequest";
})(ESPHomeMessageType || (ESPHomeMessageType = {}));
class ESPHomeMessageRaw {
  static {
    __name(this, "ESPHomeMessageRaw");
  }
  messageType;
  payload;
  constructor(messageType2, payload) {
    this.messageType = messageType2;
    this.payload = payload;
  }
  /**
   * Parses a raw ESPHome frame into a MessageRaw instance
   */
  static parse(data) {
    if (data.length < 3) {
      throw new import_core.ZWaveError("Frame too short", import_core.ZWaveErrorCodes.PacketFormat_Truncated);
    }
    let offset = 0;
    if (data[offset] !== 0) {
      throw new import_core.ZWaveError(`Invalid frame indicator: expected 0x00, got 0x${data[offset].toString(16).padStart(2, "0")}`, import_core.ZWaveErrorCodes.PacketFormat_Invalid);
    }
    offset++;
    const payloadSize = (0, import_ProtobufHelpers.decodeVarInt)(data, offset);
    offset += payloadSize.bytesRead;
    const messageType2 = (0, import_ProtobufHelpers.decodeVarInt)(data, offset);
    offset += messageType2.bytesRead;
    if (offset + payloadSize.value > data.length) {
      throw new import_core.ZWaveError("Could not deserialize the message because it was truncated", import_core.ZWaveErrorCodes.PacketFormat_Truncated);
    }
    const payload = import_shared.Bytes.view(data.slice(offset, offset + payloadSize.value));
    return new ESPHomeMessageRaw(messageType2.value, payload);
  }
}
class ESPHomeMessage {
  static {
    __name(this, "ESPHomeMessage");
  }
  constructor(options = {}) {
    const messageType2 = options.messageType ?? getMessageType(this);
    if (messageType2 == void 0) {
      throw new import_core.ZWaveError("An ESPHome message must have a given or predefined message type", import_core.ZWaveErrorCodes.Argument_Invalid);
    }
    this.messageType = messageType2;
    this.payload = options.payload ?? new import_shared.Bytes();
  }
  messageType;
  payload;
  /**
   * Parses a raw ESPHome message and returns the appropriate message instance
   */
  static parse(data) {
    const raw = ESPHomeMessageRaw.parse(data);
    const Constructor = getESPHomeMessageConstructor(raw.messageType) ?? ESPHomeMessage;
    return Constructor.from(raw);
  }
  /**
   * Creates an instance of the message that is serialized in the given raw message
   */
  static from(raw) {
    return new this({
      messageType: raw.messageType,
      payload: raw.payload
    });
  }
  /**
   * Serializes this message into an ESPHome frame
   */
  serialize() {
    return import_shared.Bytes.concat([
      import_shared.Bytes.from([0]),
      // Indicator byte
      (0, import_ProtobufHelpers.encodeVarInt)(this.payload.length),
      (0, import_ProtobufHelpers.encodeVarInt)(this.messageType),
      this.payload
    ]);
  }
}
const MESSAGE_TYPE_STORAGE = /* @__PURE__ */ new Map();
const MESSAGE_CONSTRUCTOR_STORAGE = /* @__PURE__ */ new Map();
function messageType(type) {
  return function(target) {
    MESSAGE_TYPE_STORAGE.set(target, type);
    MESSAGE_CONSTRUCTOR_STORAGE.set(type, target);
    return target;
  };
}
__name(messageType, "messageType");
function getMessageType(msg) {
  return MESSAGE_TYPE_STORAGE.get(msg.constructor);
}
__name(getMessageType, "getMessageType");
function getESPHomeMessageConstructor(messageType2) {
  return MESSAGE_CONSTRUCTOR_STORAGE.get(messageType2);
}
__name(getESPHomeMessageConstructor, "getESPHomeMessageConstructor");
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  ESPHomeMessage,
  ESPHomeMessageRaw,
  ESPHomeMessageType,
  messageType
});
//# sourceMappingURL=ESPHomeMessage.js.map
